/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.rowset;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.err.TbError;
import java.io.Serializable;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import javax.sql.RowSetMetaData;

public class TbRowSetMetaData
implements RowSetMetaData,
Serializable {
    private static final long serialVersionUID = -1910875269279117964L;
    private int columnCount;
    private boolean[] autoIncrement;
    private boolean[] caseSensitive;
    private String[] catalogName;
    private int[] columnDIsplaySize;
    private String[] columnLabel;
    private String[] columnName;
    private int[] columnType;
    private String[] columnTypeName;
    private boolean[] currency;
    private int[] nullable;
    private int[] precision;
    private int[] scale;
    private String[] schemaName;
    private boolean[] searchable;
    private boolean[] signed;
    private String[] tableName;
    private boolean[] definatelyWritable;
    private boolean[] readOnly;
    private boolean[] writable;
    private String[] columnClassName;

    public TbRowSetMetaData(ResultSetMetaData data) throws SQLException {
        this.columnCount = data.getColumnCount();
        this.autoIncrement = new boolean[this.columnCount];
        this.caseSensitive = new boolean[this.columnCount];
        this.catalogName = new String[this.columnCount];
        this.columnDIsplaySize = new int[this.columnCount];
        this.columnLabel = new String[this.columnCount];
        this.columnName = new String[this.columnCount];
        this.columnType = new int[this.columnCount];
        this.columnTypeName = new String[this.columnCount];
        this.currency = new boolean[this.columnCount];
        this.nullable = new int[this.columnCount];
        this.precision = new int[this.columnCount];
        this.precision = new int[this.columnCount];
        this.scale = new int[this.columnCount];
        this.schemaName = new String[this.columnCount];
        this.searchable = new boolean[this.columnCount];
        this.signed = new boolean[this.columnCount];
        this.tableName = new String[this.columnCount];
        this.definatelyWritable = new boolean[this.columnCount];
        this.readOnly = new boolean[this.columnCount];
        this.writable = new boolean[this.columnCount];
        this.columnClassName = new String[this.columnCount];
        for (int k = 0; k < this.columnCount; ++k) {
            this.autoIncrement[k] = data.isAutoIncrement(k + 1);
            this.caseSensitive[k] = data.isCaseSensitive(k + 1);
            this.catalogName[k] = data.getCatalogName(k + 1);
            this.columnDIsplaySize[k] = data.getColumnDisplaySize(k + 1);
            this.columnLabel[k] = data.getColumnLabel(k + 1);
            this.columnName[k] = data.getColumnName(k + 1);
            this.columnType[k] = data.getColumnType(k + 1);
            this.columnTypeName[k] = data.getColumnTypeName(k + 1);
            this.currency[k] = data.isCurrency(k + 1);
            this.nullable[k] = data.isNullable(k + 1);
            this.precision[k] = data.getPrecision(k + 1);
            this.scale[k] = data.getScale(k + 1);
            this.schemaName[k] = data.getSchemaName(k + 1);
            this.searchable[k] = data.isSearchable(k + 1);
            this.signed[k] = data.isSearchable(k + 1);
            this.tableName[k] = data.getTableName(k + 1);
            this.definatelyWritable[k] = data.isDefinitelyWritable(k + 1);
            this.readOnly[k] = data.isReadOnly(k + 1);
            this.writable[k] = data.isWritable(k + 1);
            this.columnClassName[k] = data.getColumnClassName(k + 1);
        }
    }

    public TbRowSetMetaData(int i) {
        this.columnCount = i;
        this.autoIncrement = new boolean[this.columnCount];
        this.caseSensitive = new boolean[this.columnCount];
        this.catalogName = new String[this.columnCount];
        this.columnDIsplaySize = new int[this.columnCount];
        this.columnLabel = new String[this.columnCount];
        this.columnName = new String[this.columnCount];
        this.columnType = new int[this.columnCount];
        this.columnTypeName = new String[this.columnCount];
        this.currency = new boolean[this.columnCount];
        this.nullable = new int[this.columnCount];
        this.precision = new int[this.columnCount];
        this.precision = new int[this.columnCount];
        this.scale = new int[this.columnCount];
        this.schemaName = new String[this.columnCount];
        this.searchable = new boolean[this.columnCount];
        this.signed = new boolean[this.columnCount];
        this.tableName = new String[this.columnCount];
        this.definatelyWritable = new boolean[this.columnCount];
        this.readOnly = new boolean[this.columnCount];
        this.writable = new boolean[this.columnCount];
        this.columnClassName = new String[this.columnCount];
        for (int k = 0; k < this.columnCount; ++k) {
            this.autoIncrement[k] = true;
            this.caseSensitive[k] = false;
            this.catalogName[k] = "";
            this.columnDIsplaySize[k] = 0;
            this.columnLabel[k] = "";
            this.columnName[k] = "";
            this.columnType[k] = 0;
            this.columnTypeName[k] = "";
            this.currency[k] = false;
            this.nullable[k] = 1;
            this.precision[k] = 0;
            this.scale[k] = 0;
            this.schemaName[k] = "";
            this.searchable[k] = false;
            this.signed[k] = false;
            this.tableName[k] = "";
            this.definatelyWritable[k] = false;
            this.readOnly[k] = false;
            this.writable[k] = false;
            this.columnClassName[k] = "";
        }
    }

    private void checkColumnIndex(int colIndex) throws SQLException {
        if (colIndex < 1 || colIndex > this.columnCount) {
            throw TbError.newSQLException(-90834, Integer.toString(colIndex));
        }
    }

    @Override
    public String getCatalogName(int colIndex) throws SQLException {
        this.checkColumnIndex(colIndex);
        return this.catalogName[colIndex - 1];
    }

    @Override
    public String getColumnClassName(int colIndex) throws SQLException {
        this.checkColumnIndex(colIndex);
        return this.columnClassName[colIndex - 1];
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columnCount;
    }

    @Override
    public int getColumnDisplaySize(int colIndex) throws SQLException {
        this.checkColumnIndex(colIndex);
        return this.columnDIsplaySize[colIndex - 1];
    }

    @Override
    public String getColumnLabel(int colIndex) throws SQLException {
        this.checkColumnIndex(colIndex);
        return this.columnLabel[colIndex - 1];
    }

    @Override
    public String getColumnName(int colIndex) throws SQLException {
        this.checkColumnIndex(colIndex);
        return this.columnName[colIndex - 1];
    }

    @Override
    public int getColumnType(int colIndex) throws SQLException {
        this.checkColumnIndex(colIndex);
        return this.columnType[colIndex - 1];
    }

    @Override
    public String getColumnTypeName(int colIndex) throws SQLException {
        this.checkColumnIndex(colIndex);
        return this.columnTypeName[colIndex - 1];
    }

    @Override
    public int getPrecision(int colIndex) throws SQLException {
        this.checkColumnIndex(colIndex);
        return this.precision[colIndex - 1];
    }

    @Override
    public int getScale(int colIndex) throws SQLException {
        this.checkColumnIndex(colIndex);
        return this.scale[colIndex - 1];
    }

    @Override
    public String getSchemaName(int colIndex) throws SQLException {
        this.checkColumnIndex(colIndex);
        return this.schemaName[colIndex - 1];
    }

    @Override
    public String getTableName(int colIndex) throws SQLException {
        this.checkColumnIndex(colIndex);
        return this.tableName[colIndex - 1];
    }

    @Override
    public boolean isAutoIncrement(int colIndex) throws SQLException {
        this.checkColumnIndex(colIndex);
        return this.autoIncrement[colIndex - 1];
    }

    @Override
    public boolean isCaseSensitive(int colIndex) throws SQLException {
        this.checkColumnIndex(colIndex);
        return this.caseSensitive[colIndex - 1];
    }

    @Override
    public boolean isCurrency(int colIndex) throws SQLException {
        this.checkColumnIndex(colIndex);
        return this.currency[colIndex - 1];
    }

    @Override
    public boolean isDefinitelyWritable(int colIndex) throws SQLException {
        this.checkColumnIndex(colIndex);
        return this.definatelyWritable[colIndex - 1];
    }

    @Override
    public int isNullable(int colIndex) throws SQLException {
        this.checkColumnIndex(colIndex);
        return this.nullable[colIndex - 1];
    }

    @Override
    public boolean isReadOnly(int colIndex) throws SQLException {
        this.checkColumnIndex(colIndex);
        return this.readOnly[colIndex - 1];
    }

    @Override
    public boolean isSearchable(int colIndex) throws SQLException {
        this.checkColumnIndex(colIndex);
        return this.searchable[colIndex - 1];
    }

    @Override
    public boolean isSigned(int colIndex) throws SQLException {
        this.checkColumnIndex(colIndex);
        return this.signed[colIndex - 1];
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        Debug.logMethod("TbRowSetMetaData.isWrapperFor", new Object[]{iface});
        return iface.isInstance(this);
    }

    @Override
    public boolean isWritable(int colIndex) throws SQLException {
        this.checkColumnIndex(colIndex);
        return this.writable[colIndex - 1];
    }

    @Override
    public void setAutoIncrement(int colIndex, boolean bool) throws SQLException {
        this.checkColumnIndex(colIndex);
        this.autoIncrement[colIndex - 1] = bool;
    }

    @Override
    public void setCaseSensitive(int colIndex, boolean bool) throws SQLException {
        this.checkColumnIndex(colIndex);
        this.caseSensitive[colIndex - 1] = bool;
    }

    @Override
    public void setCatalogName(int colIndex, String name) throws SQLException {
        this.checkColumnIndex(colIndex);
        this.catalogName[colIndex - 1] = name;
    }

    @Override
    public void setColumnCount(int columnCount) throws SQLException {
        this.columnCount = columnCount;
    }

    @Override
    public void setColumnDisplaySize(int colIndex, int size) throws SQLException {
        this.checkColumnIndex(colIndex);
        this.columnDIsplaySize[colIndex - 1] = size;
    }

    @Override
    public void setColumnLabel(int colIndex, String label) throws SQLException {
        this.checkColumnIndex(colIndex);
        this.columnLabel[colIndex - 1] = label;
    }

    @Override
    public void setColumnName(int colIndex, String name) throws SQLException {
        this.checkColumnIndex(colIndex);
        this.columnName[colIndex - 1] = name;
    }

    @Override
    public void setColumnType(int colIndex, int type) throws SQLException {
        this.checkColumnIndex(colIndex);
        this.columnType[colIndex - 1] = type;
    }

    @Override
    public void setColumnTypeName(int colIndex, String name) throws SQLException {
        this.checkColumnIndex(colIndex);
        this.columnTypeName[colIndex - 1] = name;
    }

    @Override
    public void setCurrency(int colIndex, boolean bool) throws SQLException {
        this.checkColumnIndex(colIndex);
        this.currency[colIndex - 1] = bool;
    }

    @Override
    public void setNullable(int colIndex, int property) throws SQLException {
        this.checkColumnIndex(colIndex);
        this.nullable[colIndex - 1] = property;
    }

    @Override
    public void setPrecision(int colIndex, int precision) throws SQLException {
        this.checkColumnIndex(colIndex);
        this.precision[colIndex - 1] = precision;
    }

    @Override
    public void setScale(int colIndex, int scale) throws SQLException {
        this.checkColumnIndex(colIndex);
        this.scale[colIndex - 1] = scale;
    }

    @Override
    public void setSchemaName(int colIndex, String name) throws SQLException {
        this.checkColumnIndex(colIndex);
        this.schemaName[colIndex - 1] = name;
    }

    @Override
    public void setSearchable(int colIndex, boolean bool) throws SQLException {
        this.checkColumnIndex(colIndex);
        this.searchable[colIndex - 1] = bool;
    }

    @Override
    public void setSigned(int colIndex, boolean bool) throws SQLException {
        this.checkColumnIndex(colIndex);
        this.signed[colIndex - 1] = bool;
    }

    @Override
    public void setTableName(int colIndex, String name) throws SQLException {
        this.checkColumnIndex(colIndex);
        this.tableName[colIndex - 1] = name;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        Debug.logMethod("TbRowSetMetaData.unwrap", new Object[]{iface});
        try {
            return iface.cast(this);
        }
        catch (ClassCastException e) {
            throw TbError.newSQLException(-90657);
        }
    }
}

