/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.ext;

import com.tmax.tibero.jdbc.ext.TbXAException;
import java.io.Serializable;
import javax.transaction.xa.Xid;

public class TbXid
implements Xid,
Serializable {
    private static final long serialVersionUID = 8653403137105513841L;
    public static int DATA_SIZE = 128;
    public static int SERIALIZED_SIZE = 24 + DATA_SIZE;
    private int formatId;
    private byte[] gtrid;
    private byte[] bqual;
    private volatile String xidAsString;

    public TbXid(int formatId, byte[] gtrid, byte[] bqual) throws TbXAException {
        if (gtrid != null && gtrid.length > 64) {
            throw new TbXAException(-4, "GTRID is null or greater than 64");
        }
        if (bqual != null && bqual.length > 64) {
            throw new TbXAException(-4, "BQUAL is null or greater than 64");
        }
        this.formatId = formatId;
        this.gtrid = gtrid;
        this.bqual = bqual;
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.gtrid;
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.bqual;
    }

    public String toString() {
        String xidAsString = this.xidAsString;
        if (xidAsString == null) {
            String str;
            int i;
            StringBuilder sb = new StringBuilder(300);
            sb.append("TbXid@").append(this.hashCode()).append("[");
            if (this.gtrid != null) {
                for (i = 0; i < this.gtrid.length; ++i) {
                    str = Integer.toHexString(this.gtrid[i] & 0xFF);
                    if (str.length() == 1) {
                        sb.append('0');
                    }
                    sb.append(str);
                }
            }
            sb.append('.');
            if (this.bqual != null) {
                for (i = 0; i < this.bqual.length; ++i) {
                    str = Integer.toHexString(this.bqual[i] & 0xFF);
                    if (str.length() == 1) {
                        sb.append('0');
                    }
                    sb.append(str);
                }
            }
            sb.append('.');
            sb.append("0x").append(Integer.toHexString(this.formatId));
            sb.append("]");
            this.xidAsString = xidAsString = sb.toString();
        }
        return xidAsString;
    }
}

