/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.ext;

import com.tmax.tibero.jdbc.TbCallableStatement;
import com.tmax.tibero.jdbc.TbPreparedStatement;
import com.tmax.tibero.jdbc.TbStatement;
import com.tmax.tibero.jdbc.data.RsetType;
import com.tmax.tibero.jdbc.ext.TbStatementCacheEntry;
import java.sql.SQLException;

public class TbStatementCache {
    public static final int ENTRY_TYPE_TBSTATEMENT = 0;
    public static final int ENTRY_TYPE_TBPREPAREDSTATEMENT = 1;
    public static final int ENTRY_TYPE_TBCALLABLESTATEMENT = 2;
    private TbStatementCacheEntry cacheEntryHead = null;
    private TbStatementCacheEntry cacheEntryTail;
    private int cacheSize;
    private int numEntry;

    public TbStatementCache(int size) {
        this.cacheSize = size;
        this.numEntry = 0;
    }

    public boolean add(TbStatement stmt, int stmtType) throws SQLException {
        if (!stmt.isPoolable() || this.contains(stmt)) {
            return false;
        }
        if (stmt instanceof TbPreparedStatement && ((TbPreparedStatement)stmt).getPPID() == null) {
            return false;
        }
        if (this.numEntry == this.cacheSize) {
            this.purgeLastEntry();
        }
        stmt.resetForCache();
        TbStatementCacheEntry newEntry = new TbStatementCacheEntry(stmtType);
        newEntry.stmt = stmt;
        newEntry.next = this.cacheEntryHead;
        if (this.cacheEntryHead != null) {
            this.cacheEntryHead.prev = newEntry;
        }
        this.cacheEntryHead = newEntry;
        if (this.cacheEntryTail == null) {
            this.cacheEntryTail = newEntry;
        }
        ++this.numEntry;
        return true;
    }

    public void clear() {
        TbStatementCacheEntry item = this.cacheEntryHead;
        while (item != null) {
            try {
                item.clear();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            item = item.next;
        }
        this.cacheEntryHead = null;
        this.numEntry = 0;
    }

    private void purgeLastEntry() throws SQLException {
        TbStatementCacheEntry purgedItem = this.cacheEntryTail;
        purgedItem.prev.next = purgedItem.next;
        purgedItem.clear();
        this.cacheEntryTail = purgedItem.prev;
        --this.numEntry;
    }

    private TbStatementCacheEntry find(String sql, int stmtType, RsetType rsetType) {
        TbStatementCacheEntry item = this.cacheEntryHead;
        while (item != null) {
            String entrySql = item.stmt.getOriginalSql();
            try {
                if (item.stmtType == stmtType && rsetType != null && item.stmt.getResultSetType() == rsetType.getType() && item.stmt.getResultSetConcurrency() == rsetType.getConcurrency() && item.stmt.getResultSetHoldability() == rsetType.getHoldability() && (sql == null || sql.equals(entrySql))) {
                    return item;
                }
            }
            catch (SQLException e) {
                // empty catch block
            }
            item = item.next;
        }
        return null;
    }

    public boolean contains(String sql, int stmtType, RsetType rsetType) {
        return this.find(sql, stmtType, rsetType) != null;
    }

    public boolean contains(TbStatement stmt) {
        int stmtType;
        String sql;
        if (stmt instanceof TbCallableStatement) {
            sql = stmt.getOriginalSql();
            stmtType = 2;
        } else if (stmt instanceof TbPreparedStatement) {
            sql = stmt.getOriginalSql();
            stmtType = 1;
        } else {
            sql = null;
            stmtType = 0;
        }
        try {
            RsetType rsetType = RsetType.getRsetType(stmt.getResultSetType(), stmt.getResultSetConcurrency());
            return this.contains(sql, stmtType, rsetType);
        }
        catch (SQLException e) {
            return false;
        }
    }

    public TbStatement get(String sql, int stmtType, RsetType rsetType) throws SQLException {
        TbStatementCacheEntry item = this.find(sql, stmtType, rsetType);
        if (item != null) {
            if (item.prev != null) {
                item.prev.next = item.next;
            }
            if (item.next != null) {
                item.next.prev = item.prev;
            }
            if (item == this.cacheEntryHead) {
                this.cacheEntryHead = item.next;
            }
            if (item == this.cacheEntryTail) {
                this.cacheEntryTail = item.prev;
            }
            if (item.stmt instanceof TbPreparedStatement) {
                ((TbPreparedStatement)item.stmt).clearParameters();
            }
            --this.numEntry;
            return item.stmt;
        }
        return null;
    }
}

