/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.ext;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.TbDriver;
import com.tmax.tibero.jdbc.data.ConnectionInfo;
import com.tmax.tibero.jdbc.data.NodeInfo;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.util.ParseException;
import com.tmax.tibero.jdbc.util.TbUrlParser;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;

public class TbDataSource
implements DataSource,
Serializable,
Referenceable {
    private static final long serialVersionUID = 6545162651851145814L;
    private TbDriver driver = null;
    protected ConnectionInfo info = null;
    private boolean isExplicitURL;
    private int maxStatements;
    private int initialPoolSize;
    private int minPoolSize;
    private int maxPoolSize;
    private int maxIdleTime;
    private int propertyCycle;
    private int loginTimeout;
    private Properties connectionProperties;
    private String connectionConfigFilePath;
    private static boolean reloadConfig;
    private static long lastModifiedTime;

    public TbDataSource() {
        Debug.logMethod("TbDataSource", null, new Object[0]);
        this.info = new ConnectionInfo();
        this.isExplicitURL = false;
        this.maxStatements = 0;
        this.initialPoolSize = 0;
        this.minPoolSize = 0;
        this.maxPoolSize = 0;
        this.maxIdleTime = 0;
        this.propertyCycle = 0;
        this.loginTimeout = 0;
        this.connectionConfigFilePath = this.getTbHomeConfigPath() + "TbJDBCConnection.properties";
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection(String user, String password) throws SQLException {
        Debug.logMethod("TbDataSource.getConnection", new String[]{"Username"}, new Object[]{user});
        if (reloadConfig) {
            this.reloadConnectionConfigFile(this.getConnectionConfigFile());
        }
        TbDataSource tbDataSource = this;
        synchronized (tbDataSource) {
            if (user != null) {
                this.info.setUser(user);
            }
            if (password != null) {
                this.info.setPassword(password);
            }
        }
        if (this.loginTimeout != 0) {
            this.info.setLoginTimeout(this.loginTimeout);
        }
        if (this.driver == null) {
            this.driver = new TbDriver();
        }
        if (!this.isExplicitURL) {
            this.info.setURL(TbUrlParser.makeURL(this.info));
        }
        Connection conn = this.driver.connect(this.info);
        return conn;
    }

    public synchronized String getDatabaseName() {
        return this.info.getDatabaseName();
    }

    public synchronized String getDataSourceName() {
        return this.info.getDataSourceName();
    }

    public synchronized String getDescription() {
        return this.info.getDescription();
    }

    public synchronized String getDriverType() {
        return this.info.getDriverType();
    }

    public synchronized int getInitialPoolSize() {
        return this.initialPoolSize;
    }

    @Override
    public synchronized int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public synchronized PrintWriter getLogWriter() throws SQLException {
        return Debug.getLogWriter();
    }

    public synchronized int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public synchronized int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public synchronized int getMaxStatements() {
        return this.maxStatements;
    }

    public synchronized int getMinPoolSize() {
        return this.minPoolSize;
    }

    public synchronized String getNetworkProtocol() {
        return this.info.getNetworkProtocol();
    }

    public synchronized boolean getNlsDatetimeFormatEnabled() {
        return this.info.getNlsDatetimeFormatEnabled();
    }

    public synchronized String getPassword() {
        return this.info.getPassword();
    }

    public synchronized int getPortNumber() {
        if (this.info.getNodeList() != null && this.info.getNodeList().size() == 1) {
            NodeInfo node = (NodeInfo)this.info.getNodeList().get(0);
            return node.getPort();
        }
        return 8629;
    }

    public synchronized String getProgramName() {
        return this.info.getProgramName();
    }

    public synchronized int getPropertyCycle() {
        return this.propertyCycle;
    }

    public synchronized int getReadTimeout() {
        return this.info.getReadTimeout();
    }

    @Override
    public synchronized Reference getReference() throws NamingException {
        String foVal;
        String programName;
        int readTimeout;
        int loginTimeout;
        String dataSourceName;
        String description;
        String networkProtocol;
        String url;
        String passwd;
        Debug.logMethod("TbDataSource.getReference", null, new Object[0]);
        Reference ref = new Reference(this.getClass().getName(), "com.tmax.tibero.jdbc.ext.TbDataSourceFactory", null);
        String user = this.info.getUser();
        if (user != null) {
            ref.add(new StringRefAddr("user", user));
        }
        if ((passwd = this.info.getPassword()) != null) {
            ref.add(new StringRefAddr("password", passwd));
        }
        if ((url = this.info.getURL()) != null && !url.equals("")) {
            ref.add(new StringRefAddr("url", url));
        }
        if ((networkProtocol = this.info.getNetworkProtocol()) != null && !networkProtocol.equals("")) {
            ref.add(new StringRefAddr("networkProtocol", networkProtocol));
        }
        int portNum = 8629;
        String serverName = null;
        if (this.info.getNodeList().size() == 1) {
            NodeInfo node = (NodeInfo)this.info.getNodeList().get(0);
            serverName = node.getAddress();
            portNum = node.getPort();
        }
        if (serverName != null && !serverName.equals("")) {
            ref.add(new StringRefAddr("serverName", serverName));
        }
        ref.add(new StringRefAddr("tdu", Integer.toString(this.info.getTDU())));
        ref.add(new StringRefAddr("portNumber", Integer.toString(portNum)));
        String databaseName = this.info.getDatabaseName();
        if (databaseName != null && !databaseName.equals("")) {
            ref.add(new StringRefAddr("databaseName", this.info.getDatabaseName()));
        }
        if ((description = this.info.getDescription()) != null && !description.equals("")) {
            ref.add(new StringRefAddr("description", description));
        }
        if ((dataSourceName = this.info.getDataSourceName()) != null && !dataSourceName.equals("")) {
            ref.add(new StringRefAddr("dataSourceName", dataSourceName));
        }
        if ((loginTimeout = this.info.getLoginTimeout()) > 0) {
            ref.add(new StringRefAddr("login_timeout", String.valueOf(loginTimeout)));
        }
        if ((readTimeout = this.info.getLoginTimeout()) > 0) {
            ref.add(new StringRefAddr("read_timeout", String.valueOf(readTimeout)));
        }
        if ((programName = this.info.getProgramName()) != null && !programName.equals("")) {
            ref.add(new StringRefAddr("program_name", programName));
        }
        switch (this.info.getFailover()) {
            case 1: {
                foVal = "SESSION";
                break;
            }
            case 3: {
                foVal = "CURSOR";
                break;
            }
            default: {
                foVal = "NONE";
            }
        }
        ref.add(new StringRefAddr("failover", foVal));
        ref.add(new StringRefAddr("load_balance", String.valueOf(this.info.isLoadBalance())));
        ref.add(new StringRefAddr("failover_retry_count", Integer.toString(this.info.getFailoverRetryCount())));
        String charset = this.info.getCharacterSet();
        if (charset != null && !charset.equals("")) {
            ref.add(new StringRefAddr("characterset", charset));
        }
        ref.add(new StringRefAddr("statement_cache", String.valueOf(this.info.isStmtCache())));
        ref.add(new StringRefAddr("statement_cache_max_size", Integer.toString(this.info.getStmtCacheMaxSize())));
        ref.add(new StringRefAddr("lobChunkMaxSize", Integer.toString(this.info.getLobMaxChunkSize())));
        ref.add(new StringRefAddr("includeSynonyms", String.valueOf(this.info.getIncludeSynonyms())));
        ref.add(new StringRefAddr("mapDateToTimestamp", String.valueOf(this.info.getMapDateToTimestamp())));
        ref.add(new StringRefAddr("defaultNChar", String.valueOf(this.info.getDefaultNChar())));
        boolean useSelfKeepAlive = this.info.useSelfKeepAlive();
        ref.add(new StringRefAddr("self_keepalive", String.valueOf(useSelfKeepAlive)));
        if (useSelfKeepAlive) {
            ref.add(new StringRefAddr("self_keepidle", Integer.toString(this.info.getSelfKeepIdle())));
            ref.add(new StringRefAddr("self_keepintvl", Integer.toString(this.info.getSelfKeepInterval())));
            ref.add(new StringRefAddr("self_keepcnt", Integer.toString(this.info.getSelfKeepCount())));
        }
        ref.add(new StringRefAddr("nls_datetime_format_enabled", String.valueOf(this.info.getNlsDatetimeFormatEnabled())));
        return ref;
    }

    public synchronized String getRoleName() {
        return "";
    }

    public synchronized String getServerName() {
        if (this.info.getNodeList() != null && this.info.getNodeList().size() == 1) {
            NodeInfo node = (NodeInfo)this.info.getNodeList().get(0);
            return node.getAddress();
        }
        return "localhost";
    }

    public synchronized boolean getSelfKeepalive() {
        return this.info.useSelfKeepAlive();
    }

    public synchronized int getSelfKeepcnt() {
        return this.info.getSelfKeepCount();
    }

    public synchronized int getSelfKeepidle() {
        return this.info.getSelfKeepIdle();
    }

    public synchronized int getSelfKeepintvl() {
        return this.info.getSelfKeepInterval();
    }

    public synchronized int getTdu() {
        return this.info.getTDU();
    }

    public synchronized String getURL() throws SQLException {
        if (!this.isExplicitURL) {
            this.info.setURL(TbUrlParser.makeURL(this.info));
        }
        return this.info.getURL();
    }

    public synchronized String getUser() {
        return this.info.getUser();
    }

    public synchronized void setDatabaseName(String databaseName) {
        Debug.logMethod("TbDataSource.setDatabaseName", new String[]{"DatabaseName"}, new Object[]{databaseName});
        this.info.setDatabaseName(databaseName);
    }

    public synchronized void setDataSourceName(String dataSourceName) {
        Debug.logMethod("TbDataSource.setDataSourceName", new String[]{"DataSourceName"}, new Object[]{dataSourceName});
        this.info.setDataSourceName(dataSourceName);
    }

    public synchronized void setDescription(String description) {
        Debug.logMethod("TbDataSource.setDescription", new String[]{"Description"}, new Object[]{description});
        this.info.setDescription(description);
    }

    public synchronized void setDriverType(String driverType) {
        this.info.setDriverType(driverType);
    }

    public synchronized void setInitialPoolSize(int poolSize) {
        this.initialPoolSize = poolSize;
    }

    @Override
    public synchronized void setLoginTimeout(int time) throws SQLException {
        this.loginTimeout = time;
    }

    @Override
    public synchronized void setLogWriter(PrintWriter writer) throws SQLException {
        Debug.setLogWriter(writer);
    }

    public synchronized void setMaxIdleTime(int idleTime) {
        this.maxIdleTime = idleTime;
    }

    public synchronized void setMaxPoolSize(int poolSize) {
        this.maxPoolSize = poolSize;
    }

    public synchronized void setMaxStatements(int maxStmts) {
        this.maxStatements = maxStmts;
    }

    public synchronized void setMinPoolSize(int poolSize) {
        this.minPoolSize = poolSize;
    }

    public synchronized void setNetworkProtocol(String networkProtocol) {
        this.info.setNetworkProtocol(networkProtocol);
    }

    public synchronized void setNlsDatetimeFormatEnabled(boolean enabled) {
        this.info.setNlsDatetimeFormatEnabled(enabled);
    }

    public synchronized void setPassword(String password) {
        this.info.setPassword(password);
    }

    public synchronized void setPortNumber(int portNumber) {
        if (this.info.getNodeList() == null) {
            Vector<NodeInfo> nodeList = new Vector<NodeInfo>();
            NodeInfo node = new NodeInfo();
            node.setPort(portNumber);
            nodeList.add(node);
            this.info.setNodeList(nodeList);
        } else {
            NodeInfo node = (NodeInfo)this.info.getNodeList().get(0);
            node.setPort(portNumber);
        }
    }

    public synchronized void setProgramName(String name) {
        this.info.setProgramName(name);
    }

    public synchronized void setPropertyCycle(int cycle) {
        this.propertyCycle = cycle;
    }

    public synchronized void setReadTimeout(int readTimeout) {
        this.info.setReadTimeout(readTimeout);
    }

    public synchronized void setRoleName(String roleName) {
    }

    public synchronized void setSelfKeepalive(String keepalive) throws SQLException {
        try {
            this.info.setSelfKeepAlive("true".equalsIgnoreCase(keepalive));
        }
        catch (Exception e) {
            throw TbError.newSQLException(-90651, "Cannot convert \"" + keepalive + "\" to boolean");
        }
    }

    public synchronized void setSelfKeepalive(boolean keepalive) {
        this.info.setSelfKeepAlive(keepalive);
    }

    public synchronized void setSelfKeepidle(String keepidle) throws SQLException {
        try {
            this.info.setSelfKeepIdle(Integer.parseInt(keepidle));
        }
        catch (Exception e) {
            throw TbError.newSQLException(-90651, "Cannot convert \"" + keepidle + "\" to integer");
        }
    }

    public synchronized void setSelfKeepidle(int keepidle) {
        this.info.setSelfKeepIdle(keepidle);
    }

    public synchronized void setSelfKeepintvl(String keepintvl) throws SQLException {
        try {
            this.info.setSelfKeepInterval(Integer.parseInt(keepintvl));
        }
        catch (Exception e) {
            throw TbError.newSQLException(-90651, "Cannot convert \"" + keepintvl + "\" to integer");
        }
    }

    public synchronized void setSelfKeepintvl(int keepintvl) {
        this.info.setSelfKeepInterval(keepintvl);
    }

    public synchronized void setSelfKeepcnt(String keepcnt) throws SQLException {
        try {
            this.info.setSelfKeepCount(Integer.parseInt(keepcnt));
        }
        catch (Exception e) {
            throw TbError.newSQLException(-90651, "Cannot convert \"" + keepcnt + "\" to integer");
        }
    }

    public synchronized void setSelfKeepcnt(int keepcnt) {
        this.info.setSelfKeepCount(keepcnt);
    }

    public synchronized void setServerName(String serverName) {
        if (this.info.getNodeList() == null) {
            Vector<NodeInfo> nodeList = new Vector<NodeInfo>();
            NodeInfo node = new NodeInfo();
            node.setAddress(serverName);
            nodeList.add(node);
            this.info.setNodeList(nodeList);
        } else {
            NodeInfo node = (NodeInfo)this.info.getNodeList().get(0);
            node.setAddress(serverName);
        }
    }

    public synchronized void setTdu(int tdu) {
        this.info.setTDU(tdu);
    }

    public synchronized void setURL(String url) throws SQLException {
        ConnectionInfo info1;
        Debug.logMethod("TbDataSource.setURL", new String[]{"URL"}, new Object[]{url});
        try {
            info1 = TbUrlParser.parseUrl(url, null);
        }
        catch (ParseException e) {
            throw TbError.newSQLException(-90605, e);
        }
        if (info1 == null) {
            throw TbError.newSQLException(-90605);
        }
        this.info.setURL(url);
        this.info.setDriverType(info1.getDriverType());
        this.info.setNodeList(info1.getNodeList());
        this.info.setDatabaseName(info1.getDatabaseName());
        this.info.setFailover(info1.getFailover());
        this.info.setLoadBalance(info1.isLoadBalance());
        this.info.setNetworkProtocol(info1.getNetworkProtocol());
        info1 = null;
        this.isExplicitURL = true;
    }

    public synchronized void setUser(String user) {
        this.info.setUser(user);
    }

    private String getTbHomeConfigPath() {
        String tbHomeStr;
        StringBuffer tbHomePath = new StringBuffer();
        try {
            tbHomeStr = System.getenv("TB_HOME");
            if (tbHomeStr != null && !tbHomeStr.equals("")) {
                tbHomePath.append(tbHomeStr);
                if (!tbHomePath.toString().endsWith(File.separator)) {
                    tbHomePath.append(File.separator);
                }
                return tbHomePath.append("client").append(File.separator).append("config").append(File.separator).toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        tbHomeStr = System.getProperty("TB_HOME");
        if (tbHomeStr != null && !tbHomeStr.equals("")) {
            tbHomePath.append(tbHomeStr);
            if (!tbHomePath.toString().endsWith(File.separator)) {
                tbHomePath.append(File.separator);
            }
            return tbHomePath.append("client").append(File.separator).append("config").append(File.separator).toString();
        }
        return tbHomePath.toString();
    }

    public void setConnectionConfigFile(String filePath) throws SQLException {
        File file;
        Debug.logMethod("TbDataSource.setConnectionPropertiesFile", new String[]{"entry name"}, new Object[]{filePath});
        if (filePath == null || filePath.equals("")) {
            file = new File(this.connectionConfigFilePath);
        } else {
            file = new File(filePath);
            this.connectionConfigFilePath = filePath;
        }
        Properties props = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            props.load(new BufferedInputStream(fis));
            this.setConfigProperties(props);
        }
        catch (IOException ioe) {
            throw TbError.newSQLException(-590707, ioe.getMessage());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void setConfigProperties(Properties props) throws SQLException {
        int portNumber;
        String serverName;
        String url;
        String password;
        reloadConfig = props.getProperty("reload_config", "false").equalsIgnoreCase("yes");
        String user = this.getUser();
        if (user != null && !user.equals("")) {
            props.put("user", user);
        }
        if ((password = this.getPassword()) != null && !password.equals("")) {
            props.put("password", password);
        }
        if ((url = this.info.getURL()) != null && !url.equals("")) {
            props.put("url", url);
        }
        if ((serverName = this.getServerName()) != null && !serverName.equals("localhost")) {
            props.put("serverName", serverName);
        }
        if ((portNumber = this.getPortNumber()) != 8629) {
            props.put("portNumber", String.valueOf(portNumber));
        }
        this.info.set(props);
        url = props.getProperty("url");
        if (url != null && !url.equals("")) {
            this.setURL(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadConnectionConfigFile(String fileName) throws SQLException {
        File file = null;
        FileInputStream fis = null;
        Properties props = null;
        try {
            file = new File(fileName);
            long currentModifiedTime = file.lastModified();
            if (lastModifiedTime >= currentModifiedTime) {
                return;
            }
            props = new Properties();
            fis = new FileInputStream(file);
            props.load(new BufferedInputStream(fis));
            this.info.update(props);
            String url = props.getProperty("url");
            if (url != null && !url.equals("")) {
                this.setURL(url);
            }
            lastModifiedTime = currentModifiedTime;
        }
        catch (IOException e) {
            TbError.newSQLException(-590700, fileName);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public String getConnectionConfigFile() {
        return this.connectionConfigFilePath;
    }

    public void setConnectionProperties(Properties properties) {
        Debug.logMethod("TbDataSource.setConnectionProperties", new String[]{"properties"}, new Object[]{properties});
        ConnectionInfo info1 = new ConnectionInfo(properties);
        if (properties.containsKey("driverType")) {
            this.info.setDriverType(info1.getDriverType());
        }
        if (properties.containsKey("serverName")) {
            this.info.setNodeList(info1.getNodeList());
        }
        if (properties.containsKey("databaseName")) {
            this.info.setDatabaseName(info1.getDatabaseName());
        }
        if (properties.containsKey("failover")) {
            this.info.setFailover(info1.getFailover());
        }
        if (properties.containsKey("failover_retry_count")) {
            this.info.setFailoverRetryCount(info1.getFailoverRetryCount());
        }
        if (properties.containsKey("load_balance")) {
            this.info.setLoadBalance(info1.isLoadBalance());
        }
        if (properties.containsKey("networkProtocol")) {
            this.info.setNetworkProtocol(info1.getNetworkProtocol());
        }
        if (properties.containsKey("description")) {
            this.info.setDescription(info1.getDescription());
        }
        if (properties.containsKey("user")) {
            this.info.setUser(info1.getUser(), false);
        }
        if (properties.containsKey("password")) {
            this.info.setPassword(info1.getPassword());
        }
        if (properties.containsKey("url")) {
            this.info.setURL(info1.getURL());
        }
        if (properties.containsKey("login_timeout")) {
            this.info.setLoginTimeout(info1.getLoginTimeout());
        }
        if (properties.containsKey("read_timeout")) {
            this.info.setReadTimeout(info1.getReadTimeout());
        }
        if (properties.containsKey("statement_cache")) {
            this.info.setStmtCache(info1.isStmtCache());
        }
        if (properties.containsKey("statement_cache_max_size")) {
            this.info.setStmtCacheMaxSize(info1.getStmtCacheMaxSize());
        }
        if (properties.containsKey("program_name")) {
            this.info.setProgramName(info1.getProgramName());
        }
        if (properties.containsKey("characterset")) {
            this.info.setCharacterSet(info1.getCharacterSet());
        }
        if (properties.containsKey("includeSynonyms")) {
            this.info.setIncludeSynonyms(info1.getIncludeSynonyms());
        }
        if (properties.containsKey("mapDateToTimestamp")) {
            this.info.setMapDateToTimestamp(info1.getMapDateToTimestamp());
        }
        if (properties.containsKey("defaultNChar")) {
            this.info.setDefaultNChar(info1.getDefaultNChar());
        }
        if (properties.containsKey("databaseProductName")) {
            this.info.setDatabaseProductName(info1.getDatabaseProductName());
        }
        if (properties.containsKey("databaseProductVersion")) {
            this.info.setDatabaseProductVersion(info1.getDatabaseProductVersion());
        }
        if (properties.containsKey("driverName")) {
            this.info.setDriverName(info1.getDriverName());
        }
        if (properties.containsKey("driverVersion")) {
            this.info.setDriverVersion(info1.getDriverVersion());
        }
        if (properties.containsKey("lobChunkMaxSize")) {
            this.info.setLobMaxChunkSize(info1.getLobMaxChunkSize());
        }
        if (properties.containsKey("self_keepalive")) {
            this.info.setSelfKeepAlive(info1.useSelfKeepAlive());
        }
        if (properties.containsKey("self_keepidle")) {
            this.info.setSelfKeepIdle(info1.getSelfKeepIdle());
        }
        if (properties.containsKey("self_keepintvl")) {
            this.info.setSelfKeepInterval(info1.getSelfKeepInterval());
        }
        if (properties.containsKey("self_keepcnt")) {
            this.info.setSelfKeepCount(info1.getSelfKeepCount());
        }
        if (properties.containsKey("nls_datetime_format_enabled")) {
            this.info.setNlsDatetimeFormatEnabled(info1.getNlsDatetimeFormatEnabled());
        }
        this.connectionProperties = properties;
    }

    public Properties getConnectionProperties() {
        return this.connectionProperties;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        Debug.logMethod("TbDataSource.isWrapperFor", new Object[]{iface});
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        Debug.logMethod("TbDataSource.unwrap", new Object[]{iface});
        try {
            return iface.cast(this);
        }
        catch (ClassCastException e) {
            throw TbError.newSQLException(-90657);
        }
    }
}

