/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.driver;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.data.ParamContainer;
import com.tmax.tibero.jdbc.data.Row;
import com.tmax.tibero.jdbc.driver.TbPreparedStatement;
import com.tmax.tibero.jdbc.driver.TbRSFwOnly;
import com.tmax.tibero.jdbc.driver.TbRSScrollable;
import com.tmax.tibero.jdbc.driver.TbStatement;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.util.TbSQLParser;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class TbRSSensitive
extends TbRSScrollable {
    protected TbPreparedStatement refetchStmt = null;
    private int[] rowIndices = null;
    private List<byte[]> refetchRowids = null;
    private int lastRowIdParamCnt = 0;
    private int startRowIndex = -1;
    private int stopRowIndex = -1;
    private static final int REFRESH_FETCH_SIZE = 1;

    protected TbRSSensitive(TbStatement stmt, int cursorId, int colCnt, int hiddenColCnt, byte[] rowChunk) throws SQLException {
        super(stmt, cursorId, colCnt, hiddenColCnt, rowChunk);
        this.rowIndices = new int[stmt.getFetchSize()];
        this.refetchRowids = new ArrayList<byte[]>(stmt.getFetchSize());
        Debug.logMethod("TbRSSensitive", new Object[]{this});
    }

    @Override
    public synchronized boolean absolute(int rowIndex) throws SQLException {
        Debug.logMethod("TbRSSensitive.absolute", new Object[]{this, Integer.toString(rowIndex)});
        if (super.absolute(rowIndex)) {
            this.refreshRow();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildRefetchStatement(int realRefetchSize) throws SQLException {
        if (this.lastRowIdParamCnt != realRefetchSize) {
            if (this.refetchStmt != null) {
                try {
                    this.refetchStmt.close();
                }
                catch (SQLException e) {
                    this.addWarning(TbError.newSQLWarning(-590708, e));
                }
                finally {
                    this.refetchStmt = null;
                }
            }
            String sql = TbSQLParser.getRowIdAddedRefetchSql(this.stmt.getSqlWithRowId(), realRefetchSize);
            this.refetchStmt = new TbPreparedStatement(this.stmt.conn, sql);
            this.lastRowIdParamCnt = realRefetchSize;
            if (this.stmt instanceof ParamContainer) {
                this.refetchStmt.impl().copyBindParamInfo((ParamContainer)((Object)this.stmt));
            }
        }
        int totalParamCnt = this.refetchStmt.getParamContainer().getParameterCnt();
        int rowIdParamStartIndex = totalParamCnt - this.lastRowIdParamCnt;
        for (int i = 0; i < this.lastRowIdParamCnt; ++i) {
            this.refetchStmt.setBytes(rowIdParamStartIndex + i + 1, 3, this.refetchRowids.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SQLException {
        Debug.logMethod("TbRSSensitive.close", new Object[]{this});
        try {
            super.close();
        }
        finally {
            if (this.refetchStmt != null) {
                try {
                    this.refetchStmt.close();
                }
                catch (Exception exception) {
                }
                finally {
                    this.refetchStmt = null;
                }
            }
        }
    }

    @Override
    protected void fetchRowsChunk() throws SQLException {
        super.fetchRowsChunk();
        if (this.currentFetchCount > 0) {
            this.stopRowIndex = this.rowsFetchedCnt - 1;
            this.startRowIndex = this.rowsFetchedCnt - this.currentFetchCount;
        }
    }

    private int fillRowIndexForRefetch(int refetchSize) throws SQLException {
        int index = 0;
        if (this.fetchDirection == 1001) {
            int stopIndex = Math.max(this.currentRowIndex - refetchSize, 0);
            int rowIndex = this.currentRowIndex;
            while (rowIndex > stopIndex) {
                this.rowIndices[index] = rowIndex;
                this.refetchRowids.add(index, this.getRowAt(rowIndex).getRawBytes(1));
                --rowIndex;
                ++index;
            }
        } else {
            int stopIndex = Math.min(this.currentRowIndex + refetchSize, this.rowsFetchedCnt);
            int rowIndex = this.currentRowIndex;
            while (rowIndex < stopIndex) {
                this.rowIndices[index] = rowIndex;
                this.refetchRowids.add(index, this.getRowAt(rowIndex).getRawBytes(1));
                ++rowIndex;
                ++index;
            }
        }
        return index;
    }

    @Override
    public synchronized boolean first() throws SQLException {
        Debug.logMethod("TbRSSensitive.first", new Object[]{this});
        if (super.first()) {
            this.refreshRow();
            return true;
        }
        return false;
    }

    private boolean isByteArrayEqual(byte[] src, byte[] dst) {
        if (src.length != dst.length) {
            return false;
        }
        for (int i = 0; i < src.length; ++i) {
            if (src[i] == dst[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean last() throws SQLException {
        Debug.logMethod("TbRSSensitive.last", new Object[]{this});
        if (super.last()) {
            this.refreshRow();
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean next() throws SQLException {
        Debug.logMethod("TbRSSensitive.next", new Object[]{this});
        if (super.next()) {
            this.refreshRow();
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean previous() throws SQLException {
        Debug.logMethod("TbRSSensitive.previous", new Object[]{this});
        if (super.previous()) {
            this.refreshRow();
            return true;
        }
        return false;
    }

    private void refreshCachedRows(int realRefetchSize) throws SQLException {
        this.refetchStmt.setFetchSize(realRefetchSize);
        TbRSFwOnly rs = (TbRSFwOnly)this.refetchStmt.executeQuery();
        block2: while (rs.next()) {
            byte[] rowid = rs.getBytes(1);
            for (int i = 0; i < realRefetchSize; ++i) {
                if (!this.isByteArrayEqual(rowid, this.refetchRowids.get(i))) continue;
                Row refreshedRow = rs.getCurrentRow();
                Row tempRow = new Row();
                tempRow.duplicate(refreshedRow);
                this.setRowAt(this.rowIndices[i], tempRow);
                continue block2;
            }
        }
        try {
            rs.close();
        }
        catch (SQLException e) {
            this.addWarning(TbError.newSQLWarning(-590708, e));
        }
    }

    protected boolean isCurrentWindow(int rowIndex) {
        return rowIndex >= this.startRowIndex && rowIndex <= this.stopRowIndex;
    }

    @Override
    public synchronized void refreshRow() throws SQLException {
        Debug.logMethod("TbResultSetBase.refreshRow", new Object[]{this});
        int realRefetchSize = this.refreshRowForced(1);
        if (this.fetchDirection == 1000) {
            this.startRowIndex = this.currentRowIndex;
            this.stopRowIndex = this.currentRowIndex + realRefetchSize - 1;
        } else {
            this.startRowIndex = this.currentRowIndex - realRefetchSize + 1;
            this.stopRowIndex = this.currentRowIndex;
        }
    }

    protected int refreshRowForced(int refetchSize) throws SQLException {
        Debug.logMethod("TbResultSetBase.refreshRowForced", new Object[]{this, Integer.toString(refetchSize)});
        if (!this.rsetType.useRowId()) {
            throw TbError.newSQLException(-590724);
        }
        try {
            int realRefetchSize = this.fillRowIndexForRefetch(refetchSize);
            this.buildRefetchStatement(realRefetchSize);
            this.refreshCachedRows(realRefetchSize);
            return realRefetchSize;
        }
        catch (SQLException sqe) {
            throw TbError.newSQLException(-90626, sqe);
        }
    }

    @Override
    public synchronized boolean relative(int row) throws SQLException {
        Debug.logMethod("TbRSSensitive.relative", new Object[]{this, Integer.toString(row)});
        if (super.relative(row)) {
            this.refreshRow();
            return true;
        }
        return false;
    }

    @Override
    protected void removeCurrentRow() throws SQLException {
        Debug.logMethod("TbRSScrollable.removeCurrentRow", new Object[]{this, new Integer(this.currentRowIndex)});
        this.checkRowIndex(this.currentRowIndex);
        this.rows.remove(this.currentRowIndex);
        if (this.currentRowIndex < this.startRowIndex) {
            --this.startRowIndex;
        }
        if (this.currentRowIndex < this.stopRowIndex) {
            --this.stopRowIndex;
        }
        --this.currentRowIndex;
        --this.rowsFetchedCnt;
    }

    @Override
    public void reset() {
        super.reset();
        this.refetchStmt = null;
    }

    @Override
    protected boolean isFoCsrEnabled() {
        return false;
    }
}

