/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.driver;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.data.BindData;
import com.tmax.tibero.jdbc.data.Row;
import com.tmax.tibero.jdbc.driver.TbPreparedStatementImpl;
import com.tmax.tibero.jdbc.driver.TbResultSetBase;
import com.tmax.tibero.jdbc.driver.TbStatement;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.util.TbSQLTypeScanner;
import java.sql.SQLException;

public class TbRSFwOnly
extends TbResultSetBase {
    private Row row;
    private int chunkOffset;
    protected int lastFetchedCnt;

    protected TbRSFwOnly(TbStatement stmt, int cursorId, int colCnt, int hiddenColCnt, byte[] rowChunk) throws SQLException {
        super(stmt, cursorId, colCnt, hiddenColCnt, rowChunk);
        this.currentRowIndex = -1;
        stmt.conn.addFOActiveResultSet(this);
        Debug.logMethod("TbRSFwOnly", new Object[]{this});
    }

    @Override
    public void buildRowTable(int rowCount, byte[] chunk) throws SQLException {
        this.chunkOffset = 1;
        if (this.rowsFetchedCnt + rowCount < 0) {
            throw TbError.newSQLException(-90613);
        }
        this.lastFetchedCnt = this.rowsFetchedCnt;
        this.rowsFetchedCnt += rowCount;
        this.currentFetchCount = rowCount;
        if (this.row == null) {
            this.row = new Row(this.columnCount);
        }
        this.rowChunk = chunk;
    }

    private void checkRowIndex(int rowIndex) throws SQLException {
        if (rowIndex < 0) {
            throw TbError.newSQLException(-90635);
        }
        if (this.stmt.getMaxRows() != 0 && rowIndex >= this.stmt.getMaxRows() || rowIndex >= this.rowsFetchedCnt && this.fetchComplete) {
            throw TbError.newSQLException(-90647);
        }
        if (rowIndex < this.lastFetchedCnt || this.stmt.getMaxRows() != 0 && rowIndex >= this.stmt.getMaxRows() || rowIndex >= this.rowsFetchedCnt) {
            throw TbError.newSQLException(-90624);
        }
    }

    @Override
    protected Row getCurrentRow() throws SQLException {
        this.checkRowIndex(this.currentRowIndex);
        return this.row;
    }

    @Override
    public synchronized boolean next() throws SQLException {
        Debug.logMethod("TbRSFwOnly.next", new Object[]{this});
        if (!super.next()) {
            this.closeCursor();
            return false;
        }
        this.chunkOffset += this.row.buildRowData(this.rowChunk, this.chunkOffset, this.cols);
        return true;
    }

    @Override
    protected void removeCurrentRow() throws SQLException {
        Debug.logMethod("TbRSFwOnly.removeCurrentRow", new Object[]{this});
    }

    @Override
    protected void recover() throws SQLException {
        Debug.logMethod("TbRSFwOnly.recover", new Object[]{this});
        this.setFOECode(0);
        if (this.stmt == null) {
            throw TbError.newSQLException(-90702, "stmt=null");
        }
        if (!TbSQLTypeScanner.isQueryStmt(this.stmt.getSqlType())) {
            throw TbError.newSQLException(-90702, "sqlType=" + this.stmt.getSqlType());
        }
        if (this.stmt.getRealRsetType().isSensitive() || this.stmt.getRealRsetType().isUpdatable()) {
            throw TbError.newSQLException(-90702, "realRsetType=" + this.stmt.getRealRsetType());
        }
        if (this.stmt.isReturnAutoGeneratedKeys()) {
            throw TbError.newSQLException(-90702, "autoGenKeys=true");
        }
        if (this.stmt instanceof TbPreparedStatementImpl) {
            TbPreparedStatementImpl pstmt = (TbPreparedStatementImpl)this.stmt;
            if (pstmt.getBatchRowCount() > 0) {
                throw TbError.newSQLException(-90702, "BatchRowCnt=" + pstmt.getBatchRowCount());
            }
            BindData bd = pstmt.getBindData();
            if (bd.getDFRParameterCnt() > 0) {
                throw TbError.newSQLException(-90702, "DFRParamCnt=" + bd.getDFRParameterCnt());
            }
            pstmt.setPPID(null);
            try {
                pstmt.conn.getTbComm().prepareExecute(pstmt, pstmt.getOriginalSql(), 0);
            }
            catch (Exception e) {
                throw TbError.newSQLException(-90701, e);
            }
        }
        try {
            this.stmt.conn.getTbComm().executeDirect(this.stmt, this.stmt.getOriginalSql());
        }
        catch (Exception e) {
            throw TbError.newSQLException(-90701, e);
        }
        if (this.stmt.currentRs == null) {
            throw TbError.newSQLException(-90702, "failoverRset=null");
        }
        if (!(this.stmt.currentRs instanceof TbRSFwOnly)) {
            throw TbError.newSQLException(-90702, "failoverRsetClass=" + this.stmt.currentRs.getClass().getName());
        }
        int rowDirOffset = 1;
        for (int i = 0; i < this.currentFetchCount; ++i) {
            rowDirOffset += this.row.buildRowData(this.rowChunk, rowDirOffset, this.cols);
        }
        long curChunkCRC = this.getCurrentChunkCRC(this.rowChunk, rowDirOffset, 0L);
        TbRSFwOnly newRs = (TbRSFwOnly)this.stmt.currentRs;
        while (newRs.currentRowIndex < this.lastFetchedCnt) {
            newRs.next();
        }
        long crcCheck = -1L;
        if (newRs.rowChunk.length > rowDirOffset) {
            crcCheck = this.getCurrentChunkCRC(newRs.rowChunk, rowDirOffset, curChunkCRC);
        }
        if (crcCheck != 0L) {
            throw TbError.newSQLException(-90702, "failoverRset invalid.");
        }
        while (newRs.currentRowIndex < this.currentRowIndex - 1) {
            newRs.next();
        }
        this.csrID = newRs.csrID;
        this.fetchComplete = newRs.fetchComplete;
        this.stmt.setResultSet(this);
        this.typeConverter = this.stmt.conn.getTypeConverter();
        newRs.reset();
        Debug.log("TbRSFwOnly.recover finished successfully. " + this);
    }

    @Override
    protected void reset() {
        super.reset();
        if (this.row != null) {
            this.row.close();
            this.row = null;
        }
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        throw TbError.newSQLException(-90620);
    }

    @Override
    public void afterLast() throws SQLException {
        throw TbError.newSQLException(-90620);
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw TbError.newSQLException(-90620);
    }

    @Override
    public boolean first() throws SQLException {
        throw TbError.newSQLException(-90620);
    }

    @Override
    public boolean isLast() throws SQLException {
        throw TbError.newSQLException(-90620);
    }

    @Override
    public boolean last() throws SQLException {
        throw TbError.newSQLException(-90620);
    }

    @Override
    public boolean previous() throws SQLException {
        throw TbError.newSQLException(-90620);
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        throw TbError.newSQLException(-90620);
    }
}

