/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import com.tmax.tibero.jdbc.data.charset.CharToByteSingleByte;
import com.tmax.tibero.jdbc.data.charset.CharsetEncoder;
import java.sql.SQLException;

public class SingleByteEncoder
implements CharsetEncoder {
    private static CharToByteSingleByte conv;
    private int maxBytePerChar;

    public SingleByteEncoder(short[] c2bIndex1, String c2bIndex2, int mask1, int mask2, int shift) {
        conv = new CharToByteSingleByte(c2bIndex1, c2bIndex2, mask1, mask2, shift);
        this.maxBytePerChar = conv.getMaxBytesPerChar();
    }

    @Override
    public int charsToBytes(char[] srcChars, int srcStart, int srcLen, byte[] destBytes, int destStart, int destLen) throws SQLException {
        return conv.convert(srcChars, srcStart, srcStart + srcLen, destBytes, destStart, destStart + destLen);
    }

    @Override
    public int charsToFixedBytes(char[] srcChars, int srcStart, int srcLen, byte[] destBytes, int destStart, int destLen) throws SQLException {
        return 0;
    }

    @Override
    public int getEndingBytePos(byte[] byteArr, int offset) {
        return offset;
    }

    @Override
    public int getLeadingBytePos(byte[] srcBytes, int offset) {
        return offset;
    }

    @Override
    public int getMaxBytesPerChar() {
        return this.maxBytePerChar;
    }

    @Override
    public boolean isEndingByte(byte[] byteArr, int offset) {
        return true;
    }

    @Override
    public boolean isLeadingByte(byte[] byteArr, int offset) {
        return true;
    }

    @Override
    public byte[] stringToBytes(String src) throws SQLException {
        byte[] temp = new byte[src.length() * this.getMaxBytesPerChar()];
        int byteLen = conv.convert(src.toCharArray(), 0, src.length(), temp, 0, temp.length);
        byte[] dest = new byte[byteLen];
        System.arraycopy(temp, 0, dest, 0, byteLen);
        return dest;
    }

    @Override
    public int stringToBytes(byte[] buf, int offset, String val) throws SQLException {
        return conv.convert(val.toCharArray(), 0, val.length(), buf, offset, buf.length);
    }
}

