/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

public class HKSCS2001ByteToCharConverter {
    private static final char[] HKSCS2001_TO_UNICODE_PAGE8C = new char[]{'\u0a3b', '\u1cfe', '\u5273', '\u37a6', '\u02c9', '\u2d8f', '\u414e', '\u1d77', '\u12f5', '\u0620', '\u45cd', 'Y', '\u4830', '\u1622', '\u4f32', '\u30a7', '\u31f6', '\u1e91', '\u1819', '\u20ba', '\u3e81', '\u5307', '\u018b', '\u3a80', '\u0610', '\u24e4', '\u2102', '\u0bae', '\u4d0f', '\u0409', '\u1a63', '\u54ba', '\u0523', '\u2c0f', '\u38fd', '\u252a', '\u5147', '\u4fea', '\u3455', '\u1d4d', '\u0c24', '\u3c7e', '\u33f4', '\u22d9', '\u4ee3', '\u37a7', '\u23dd', '\u08a3', '\u09f0', '\u0abc', '\u082f', '\u0917', '\u37a8', '\u0d34', '\u288b', '\u0f92', '\u0fd0', '\u3bb6', '\u1492', '\u1499', '\u15c2', '\u3d12', '\u178b', '\u3ff9', '\u1919', '\u1a43', '\u4063', '\u1bff', '\u38fd', '\u1f00', '\u4205', '\u208c', '\u03db', '\u4413', '\u1115', '\u21b9', '\u2e83', '\u47a4', '\u4695', '\u2593', '\u26ec', '\u27c3', '\u296c', '\u2af8', '\u2b97', '\u37a9', '\u2d90', '\u37aa', '\u2fb9', '\u37ab', '\u30cf', '\u2b5f', '\u36e0', '\u3221', '\u37ac', '\u50b9', '\u393f', '\u0471', '\u05a2', '\u101a', '\u38fd', '\u38fd', '\u38fd', '\u3568', '\u186b', '\u0576', '\u0e3d', '\u38fd', '\u2bd6', '\u437b', '\u2abf', '\u4c0d', '\u0781', '\u4a74', '\u137b', '\u4915', '\u4bbe', '\u37ad', '\u37ae', '\u1196', '\u37af', '\u38fd', '\u295b'};
    private static final int[] HKSCS2001_TO_UNICODE_PAGES = new int[]{13568, 15360, 15616, 15872, 16384, 16896, 19200, 19456, 19968, 20224, 20480, 20736, 21248, 21504, 22272, 22528, 23040, 23296, 23552, 23808, 24064, 24320, 24832, 25856, 26368, 26880, 27136, 27648, 27904, 28672, 28928, 29184, 29440, 29696, 30208, 30464, 30720, 31232, 31488, 31744, 32000, 32256, 33280, 34048, 34304, 34816, 35584, 36352, 36608, 37120, 37376, 37632, 38656, 38912, 39168, 40704, 65280, 136192, 137472, 138496, 139264, 141056, 143872, 144128, 146432, 147712, 148736, 149760, 150016, 151808, 153088, 154624, 154880, 158464, 158976, 159488, 160000, 165632, 166144, 166400, 167168, 170240, 171008, 172288, 172544};
    protected boolean subMode = true;
    protected char[] subChars = new char[]{'?'};

    public int convert(byte c1, byte c2, char[] dest, int offset) {
        if (c1 == -116 && (c2 >= 64 && c2 < 127 || c2 >= -95 && c2 < -1)) {
            int n = c2 < 0 && c2 >= 161 ? 98 : 64;
            int i = 157 * ((c1 & 0xFF) - 128) + (c2 - n);
            int wc = 65533;
            if (i < 2007) {
                short swc = (short)HKSCS2001_TO_UNICODE_PAGE8C[i - 1884];
                wc = HKSCS2001_TO_UNICODE_PAGES[swc >> 8] | swc & 0xFF;
            }
            if (wc > 65535) {
                dest[offset] = (char)(wc >> 16);
                dest[offset + 1] = (char)(wc & 0xFFFF);
                return 2;
            }
            if (wc != 65533 || wc <= 65535) {
                dest[offset] = (char)wc;
                return 0;
            }
        }
        return -1;
    }
}

