/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import com.tmax.tibero.jdbc.err.TbError;
import java.sql.SQLException;

public class CharToByteSingleByte {
    protected boolean subMode = true;
    protected byte[] subBytes = new byte[]{63};
    protected short[] index1;
    protected String index2;
    protected int mask1;
    protected int mask2;
    protected int shift;

    public CharToByteSingleByte() {
    }

    public CharToByteSingleByte(short[] index1, String index2, int mask1, int mask2, int shift) {
        this.index1 = index1;
        this.index2 = index2;
        this.mask1 = mask1;
        this.mask2 = mask2;
        this.shift = shift;
    }

    public CharToByteSingleByte(short[] index1, String index2, int mask1, int mask2, int shift, boolean subMode, byte[] subBytes) {
        this.index1 = index1;
        this.index2 = index2;
        this.mask1 = mask1;
        this.mask2 = mask2;
        this.shift = shift;
        this.subMode = subMode;
        this.subBytes = subBytes;
    }

    public boolean canConvert(char c) {
        if (this.index2.charAt(this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2)) != '\u0000') {
            return true;
        }
        return c == '\u0000';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int convert(char[] ac, int i, int j, byte[] abyte0, int k, int l) throws SQLException {
        int byte0;
        int charOff = 0;
        int byteOff = 0;
        char highHalfZoneCode = '\u0000';
        byte[] abyte2 = new byte[1];
        byteOff = k;
        if (highHalfZoneCode != '\u0000') {
            highHalfZoneCode = '\u0000';
            if (ac[i] < '\udc00' || ac[i] > '\udfff') throw TbError.newSQLException(-590743, (int)ac[i]);
            throw TbError.newSQLException(-590742, (int)ac[i]);
        }
        for (charOff = i; charOff < j; charOff += byte0) {
            byte[] abyte1 = abyte2;
            char c1 = ac[charOff];
            int i1 = 1;
            byte0 = 1;
            if (c1 >= '\ud800' && c1 <= '\udbff') {
                if (charOff + 1 >= j) {
                    highHalfZoneCode = c1;
                    return byteOff - k;
                }
                c1 = ac[charOff + 1];
                if (c1 < '\udc00' || c1 > '\udfff') throw TbError.newSQLException(-590743, (int)c1);
                if (!this.subMode) throw TbError.newSQLException(-590742, (int)c1);
                abyte1 = this.subBytes;
                i1 = this.subBytes.length;
                byte0 = 2;
            } else {
                if (c1 >= '\udc00' && c1 <= '\udfff') {
                    throw TbError.newSQLException(-590743, (int)c1);
                }
                abyte1[0] = this.getNative(c1);
                if (abyte1[0] == 0 && ac[charOff] != '\u0000') {
                    if (!this.subMode) throw TbError.newSQLException(-590742, (int)abyte1[0]);
                    abyte1 = this.subBytes;
                    i1 = this.subBytes.length;
                }
            }
            if (byteOff + i1 > l) {
                throw TbError.newSQLException(-590714, "Conversion buffer overflow");
            }
            for (int j1 = 0; j1 < i1; ++j1) {
                abyte0[byteOff++] = abyte1[j1];
            }
        }
        return byteOff - k;
    }

    public short[] getIndex1() {
        return this.index1;
    }

    public String getIndex2() {
        return this.index2;
    }

    public int getMaxBytesPerChar() {
        return 1;
    }

    public byte getNative(char c) {
        return (byte)this.index2.charAt(this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2));
    }
}

