/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.binder;

import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.data.ParamContainer;
import com.tmax.tibero.jdbc.data.TbNumber;
import com.tmax.tibero.jdbc.data.binder.Binder;
import com.tmax.tibero.jdbc.driver.TbConnection;
import java.math.BigDecimal;
import java.sql.SQLException;

public class BigDecimalBinder
extends Binder {
    @Override
    public void bind(TbConnection conn, ParamContainer bpc, TbStreamDataWriter writer, int rowIndex, int paramIndex, int length) throws SQLException {
        BigDecimal bindParam = bpc.getParamBigDecimal(rowIndex, paramIndex);
        int offset = writer.getBufferedDataSize();
        int convertedLen = 0;
        writer.makeBufferAvailable(23);
        byte[] byteBuf = writer.getStreamBuf().getRawBytes();
        convertedLen = TbNumber.fromString(byteBuf, offset + 1, bindParam.toString());
        byteBuf[offset] = (byte)convertedLen;
        writer.moveOffset(convertedLen + 1);
        writer.writePadding(convertedLen + 1);
    }

    @Override
    public void bind(TbConnection conn, ParamContainer bpc, TbStreamDataWriter writer, int rowIndex, int paramIndex, int length, boolean pad) throws SQLException {
        BigDecimal bindParam = bpc.getParamBigDecimal(rowIndex, paramIndex);
        int offset = writer.getBufferedDataSize();
        int convertedLen = 0;
        writer.makeBufferAvailable(22);
        byte[] byteBuf = writer.getStreamBuf().getRawBytes();
        convertedLen = TbNumber.fromString(byteBuf, offset, bindParam.toString());
        writer.moveOffset(convertedLen);
        if (pad) {
            writer.writePadding(convertedLen);
        }
    }

    @Override
    public void bindDFR(TbConnection conn, ParamContainer bpc, TbStreamDataWriter writer, int rowIndex, int paramIndex, long length) throws SQLException {
    }
}

