/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

import com.tmax.tibero.jdbc.util.TbCommon;
import java.util.Calendar;
import java.util.TimeZone;

public class TbTimestamp {
    static final short OFFSET_CENTURY = 0;
    static final short OFFSET_YEAR = 1;
    static final short OFFSET_MONTH = 2;
    static final short OFFSET_DAY_OF_MONTH = 3;
    static final short OFFSET_HOUR_OF_DAY = 4;
    static final short OFFSET_MINUTE = 5;
    static final short OFFSET_SECOND = 6;
    static final short OFFSET_DATE_END = 7;
    public static final char DELIMITER_DATE = '-';
    public static final char DELIMITER_TIME = ':';
    public static final char DELIMITER_MILLIS = '.';
    public static final char DELIMITER_BLANK = ' ';
    private byte[] bytes;

    public TbTimestamp(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("data should not be null");
        }
        if (data.length != 12) {
            throw new IllegalArgumentException("invalid array size");
        }
        this.bytes = data;
    }

    public TbTimestamp(int year, int month, int dayOfMonth, int hourOfDay, int minute, int second, int nano) {
        this.bytes = new byte[12];
        if (nano > 999999999 || nano < 0) {
            throw new IllegalArgumentException("nanos > 999999999 or < 0");
        }
        this.bytes[0] = (byte)(year / 100 + 100);
        this.bytes[1] = (byte)(year % 100 + 100);
        this.bytes[2] = (byte)month;
        this.bytes[3] = (byte)dayOfMonth;
        this.bytes[4] = (byte)hourOfDay;
        this.bytes[5] = (byte)minute;
        this.bytes[6] = (byte)second;
        this.bytes[7] = 0;
        TbCommon.int2Bytes(nano, this.bytes, 8, 4);
    }

    public TbTimestamp(long millis) {
        this.bytes = new byte[12];
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(millis);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int dayOfMonth = cal.get(5);
        int hourOfDay = cal.get(11);
        int minutes = cal.get(12);
        int seconds = cal.get(13);
        int nanos = (int)(millis % 1000L * 1000000L);
        if (nanos < 0) {
            nanos = 1000000000 + nanos;
        }
        this.bytes[0] = (byte)(year / 100 + 100);
        this.bytes[1] = (byte)(year % 100 + 100);
        this.bytes[2] = (byte)month;
        this.bytes[3] = (byte)dayOfMonth;
        this.bytes[4] = (byte)hourOfDay;
        this.bytes[5] = (byte)minutes;
        this.bytes[6] = (byte)seconds;
        this.bytes[7] = 0;
        TbCommon.int2Bytes(nanos, this.bytes, 8, 4);
    }

    public TbTimestamp(long millis, TimeZone timezone) {
        this.bytes = new byte[12];
        Calendar cal = Calendar.getInstance(timezone);
        cal.setTimeInMillis(millis);
        int era = cal.get(0);
        int year = cal.get(1);
        if (era == 0) {
            year = year * -1 + 1;
        }
        int month = cal.get(2) + 1;
        int dayOfMonth = cal.get(5);
        int hourOfDay = cal.get(11);
        int minutes = cal.get(12);
        int seconds = cal.get(13);
        int nanos = (int)(millis % 1000L * 1000000L);
        if (nanos < 0) {
            nanos = 1000000000 + nanos;
        }
        this.bytes[0] = (byte)(year / 100 + 100);
        this.bytes[1] = (byte)(year % 100 + 100);
        this.bytes[2] = (byte)month;
        this.bytes[3] = (byte)dayOfMonth;
        this.bytes[4] = (byte)hourOfDay;
        this.bytes[5] = (byte)minutes;
        this.bytes[6] = (byte)seconds;
        this.bytes[7] = 0;
        TbCommon.int2Bytes(nanos, this.bytes, 8, 4);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public int getYear() {
        int db_century = 0xFF & this.bytes[0];
        int db_year = 0xFF & this.bytes[1];
        int year = (db_century - 100) * 100 + (db_year - 100);
        return year;
    }

    public int getDayOfMonth() {
        int dayOfMonth = 0xFF & this.bytes[3];
        return dayOfMonth;
    }

    public int getHourOfDay() {
        int hourOfDay = 0xFF & this.bytes[4];
        return hourOfDay;
    }

    public int getMinutes() {
        int minutes = 0xFF & this.bytes[5];
        return minutes;
    }

    public int getSeconds() {
        int seconds = 0xFF & this.bytes[6];
        return seconds;
    }

    public int getMonth() {
        int month = 0xFF & this.bytes[2];
        return month;
    }

    public int getNanos() {
        int nanos = TbCommon.bytes2Int(this.bytes, 8, 4);
        return nanos;
    }

    public String toString() {
        int lastNonZeroIndex;
        char[] buffer = new char[30];
        int offset = 0;
        int year = this.getYear();
        if (year < 10000 && year >= 0) {
            offset += TbTimestamp.writeFormattedInt(buffer, offset, 4, this.getYear());
        } else {
            int i;
            String yearStr = Integer.toString(year);
            for (i = 0; i < yearStr.length(); ++i) {
                buffer[offset + i] = yearStr.charAt(i);
            }
            offset += i;
        }
        buffer[offset++] = 45;
        offset += TbTimestamp.writeFormattedInt(buffer, offset, 2, this.getMonth());
        buffer[offset++] = 45;
        offset += TbTimestamp.writeFormattedInt(buffer, offset, 2, this.getDayOfMonth());
        buffer[offset++] = 32;
        offset += TbTimestamp.writeFormattedInt(buffer, offset, 2, this.getHourOfDay());
        buffer[offset++] = 58;
        offset += TbTimestamp.writeFormattedInt(buffer, offset, 2, this.getMinutes());
        buffer[offset++] = 58;
        offset += TbTimestamp.writeFormattedInt(buffer, offset, 2, this.getSeconds());
        int nano = this.getNanos();
        if (nano < 0) {
            nano = 0;
        }
        buffer[offset++] = 46;
        String nanoStr = Integer.toString(nano);
        int nanoLen = nanoStr.length();
        for (int i = 0; i < 9; ++i) {
            buffer[offset + i] = 9 - i > nanoLen ? 48 : nanoStr.charAt(i - 9 + nanoLen);
        }
        for (lastNonZeroIndex = 8; lastNonZeroIndex > 0 && buffer[offset + lastNonZeroIndex] == '0'; --lastNonZeroIndex) {
        }
        return new String(buffer, 0, offset += lastNonZeroIndex + 1);
    }

    private static int writeFormattedInt(char[] buffer, int offset, int expectedLength, int value) {
        for (int i = offset + expectedLength - 1; i >= offset; --i) {
            int mod = value % 10;
            buffer[i] = (char)(48 + mod);
            value /= 10;
        }
        return expectedLength;
    }
}

