/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.util.TbCommon;
import java.sql.SQLException;

public class TbNrowId {
    static final int NROWID_BYTE_CNT = 8;
    static final int NEROWID_LEN = 11;
    static final int NEROWID_VAL_LAST = 10;
    static final int NEROWID_REMAINDER_BIT = 63;
    static final int NEROWID_DIVISION_SHIFT = 6;
    byte[] nrowid = new byte[8];
    static final byte[] nrowid_encoding = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private TbConnection conn = null;

    public TbNrowId(TbConnection conn) {
        this.conn = conn;
    }

    public String toString() {
        int offset = 0;
        int serverEndian = this.conn == null ? 0 : this.conn.getServerInfo().getServerEndian();
        long val = serverEndian == 1 ? TbCommon.bytes2Long(this.nrowid, offset, 8) : TbCommon.bytes2LongR(this.nrowid, offset, 8);
        byte[] nerowid = new byte[11];
        for (int n = 10; n >= 0; --n) {
            nerowid[n] = nrowid_encoding[(int)val & 0x3F];
            val >>= 6;
        }
        return new String(nerowid);
    }

    public byte[] getServerBytes(int serverEndian, String data) throws SQLException {
        int k = 0;
        long nrowidNum = 0L;
        byte[] nerowid = data.getBytes();
        byte[] nrowid = new byte[8];
        k = 1;
        int n = 10;
        while (n > 0) {
            int c = TbNrowId.makeRowIdToInt(nerowid[n]);
            if (c < 0) {
                throw TbError.newSQLException(-590753, c);
            }
            if (Long.MAX_VALUE - nrowidNum < (long)(k * c)) {
                throw TbError.newSQLException(-590753, "9223372036854775807 - " + nrowidNum + " < " + k + " * " + c);
            }
            nrowidNum += (long)(k * c);
            --n;
            k <<= 6;
        }
        if (serverEndian == 1) {
            TbCommon.long2Bytes(nrowidNum, nrowid, 0, 8);
        } else {
            TbCommon.long2BytesR(nrowidNum, nrowid, 0, 8);
        }
        return nrowid;
    }

    public int getServerBytes(byte[] buf, int offset, int serverEndian, String data) throws SQLException {
        int k = 0;
        long nrowidNum = 0L;
        byte[] nerowid = data.getBytes();
        k = 1;
        int n = 10;
        while (n > 0) {
            int c = TbNrowId.makeRowIdToInt(nerowid[n]);
            if (c < 0) {
                throw TbError.newSQLException(-590753, c);
            }
            if (Long.MAX_VALUE - nrowidNum < (long)(k * c)) {
                throw TbError.newSQLException(-590753, "9223372036854775807 - " + nrowidNum + " < " + k + " * " + c);
            }
            nrowidNum += (long)(k * c);
            --n;
            k <<= 6;
        }
        if (serverEndian == 1) {
            TbCommon.long2Bytes(nrowidNum, buf, offset, 8);
        } else {
            TbCommon.long2BytesR(nrowidNum, buf, offset, 8);
        }
        return 8;
    }

    private static int makeRowIdToInt(byte c) {
        return 65 <= c && c <= 90 ? c - 65 + 0 : (97 <= c && c <= 122 ? c - 97 + 26 : (48 <= c && c <= 57 ? c - 48 + 52 : (43 == c ? 62 : (47 == c ? 63 : -1))));
    }
}

