/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.TbClob;
import com.tmax.tibero.jdbc.TbXMLInputStream;
import com.tmax.tibero.jdbc.TbXMLOutputStream;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.sql.SQLXML;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class TbSQLXML
implements SQLData,
SQLXML {
    private TbConnection conn;
    private TbXMLInputStream contents;
    private TbXMLOutputStream outputStream;
    private Document docValue;
    private String strValue;
    private boolean isUsed;
    private boolean isFreed;

    public TbSQLXML(TbConnection conn1) {
        Debug.logMethod("TbSQLXML", new Object[]{this, conn1});
        this.conn = conn1;
        this.contents = null;
        this.outputStream = null;
        this.docValue = null;
        this.strValue = null;
        this.isUsed = false;
        this.isFreed = false;
    }

    public TbSQLXML(TbConnection conn1, TbXMLInputStream stream) {
        Debug.logMethod("TbSQLXML", new Object[]{this, conn1, stream});
        this.conn = conn1;
        this.contents = stream;
        this.outputStream = null;
        this.docValue = null;
        this.strValue = null;
        this.isUsed = false;
        this.isFreed = false;
    }

    private void checkReadStatus() throws SQLException {
        if (this.strValue != null) {
            return;
        }
        if (this.contents == null) {
            throw TbError.newSQLException(-90921);
        }
        if (this.isUsed) {
            throw TbError.newSQLException(-90922);
        }
        try {
            this.contents.checkClosed();
        }
        catch (IOException e) {
            throw TbError.newSQLException(-90920, e.getMessage());
        }
    }

    private void checkWriteStatus() throws SQLException {
        if (this.contents != null) {
            throw TbError.newSQLException(-90923);
        }
        if (this.isUsed) {
            throw TbError.newSQLException(-90924);
        }
    }

    private void checkXMLClosed() throws SQLException {
        if (this.isFreed || this.conn != null && this.conn.isClosed()) {
            throw TbError.newSQLException(-90920);
        }
    }

    @Override
    public void free() throws SQLException {
        Debug.logMethod("TbSQLXML.free", new Object[]{this});
        if (!this.isFreed) {
            this.isFreed = true;
            if (this.contents != null) {
                try {
                    this.contents.close();
                }
                catch (IOException ioe) {
                    throw TbError.newSQLException(-90925, ioe.getMessage());
                }
            }
        }
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        Debug.logMethod("TbSQLXML.getBinaryStream", new Object[]{this});
        this.checkXMLClosed();
        this.checkReadStatus();
        this.isUsed = true;
        return this.getValue();
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        Debug.logMethod("TbSQLXML.getCharacterStream", new Object[]{this});
        this.checkXMLClosed();
        this.checkReadStatus();
        this.isUsed = true;
        if (this.contents == null) {
            return new StringReader(this.strValue);
        }
        return new InputStreamReader(this.contents);
    }

    private final DOMResult getDOMResult() throws SQLException {
        Debug.logMethod("TbSQLXML.getDOMResult", new Object[]{this});
        if (this.outputStream != null) {
            throw new AssertionError();
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.docValue = builder.newDocument();
            DOMResult domresult = new DOMResult(this.docValue);
            return domresult;
        }
        catch (ParserConfigurationException pce) {
            throw TbError.newSQLException(-90926, pce.getMessage());
        }
    }

    private final DOMSource getDOMSource() throws SQLException {
        Debug.logMethod("TbSQLXML.getDOMSource", new Object[]{this});
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            try {
                document = builder.parse(this.contents);
            }
            catch (IOException ioe) {
                throw TbError.newSQLException(-90927, ioe.getMessage());
            }
            DOMSource domsource = new DOMSource(document);
            return domsource;
        }
        catch (ParserConfigurationException pce) {
            throw TbError.newSQLException(-90926, pce.getMessage());
        }
        catch (SAXException saxe) {
            throw TbError.newSQLException(-90926, saxe.getMessage());
        }
    }

    private final SAXResult getSAXResult() throws SQLException {
        Debug.logMethod("TbSQLXML.getSAXResult", new Object[]{this});
        if (this.outputStream != null) {
            throw new AssertionError();
        }
        TransformerHandler handler = null;
        try {
            SAXTransformerFactory factory = (SAXTransformerFactory)TransformerFactory.newInstance();
            handler = factory.newTransformerHandler();
        }
        catch (TransformerConfigurationException tce) {
            throw TbError.newSQLException(-90926, tce.getMessage());
        }
        catch (ClassCastException cce) {
            throw TbError.newSQLException(-90926, cce.getMessage());
        }
        this.outputStream = new TbXMLOutputStream();
        handler.setResult(new StreamResult(this.outputStream));
        SAXResult saxresult = new SAXResult(handler);
        return saxresult;
    }

    private final SAXSource getSAXSource() throws SQLException {
        Debug.logMethod("TbSQLXML.getSAXSource", new Object[]{this});
        try {
            InputSource inputsource = new InputSource(this.contents);
            XMLReader xmlreader = XMLReaderFactory.createXMLReader();
            SAXSource saxsource = new SAXSource(xmlreader, inputsource);
            return saxsource;
        }
        catch (SAXException saxe) {
            throw TbError.newSQLException(-90926, saxe.getMessage());
        }
    }

    public Source getSource(Class sourceClass) throws SQLException {
        Debug.logMethod("TbSQLXML.getSource", new Object[]{this, sourceClass});
        this.checkXMLClosed();
        this.checkReadStatus();
        if (sourceClass == null) {
            Source source = this.getSourceInternal(StreamSource.class);
            return source;
        }
        return this.getSourceInternal(sourceClass);
    }

    private Source getSourceInternal(Class<?> sourceClass) throws SQLException {
        Source source = null;
        if (sourceClass == DOMSource.class) {
            source = (Source)sourceClass.cast(this.getDOMSource());
        } else if (sourceClass == SAXSource.class) {
            source = (Source)sourceClass.cast(this.getSAXSource());
        } else if (sourceClass == StAXSource.class) {
            source = (Source)sourceClass.cast(this.getStAXSource());
        } else if (sourceClass == StreamSource.class) {
            source = (Source)sourceClass.cast(new StreamSource(this.contents));
        } else {
            throw TbError.newSQLException(-90928);
        }
        this.isUsed = true;
        return source;
    }

    private final StAXResult getStAXResult() throws SQLException {
        Debug.logMethod("TbSQLXML.getStAXResult", new Object[]{this});
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        this.outputStream = new TbXMLOutputStream();
        try {
            XMLStreamWriter writer = factory.createXMLStreamWriter(this.outputStream);
            StAXResult staxresult = new StAXResult(writer);
            return staxresult;
        }
        catch (XMLStreamException xmlse) {
            throw TbError.newSQLException(-90926, xmlse.getMessage());
        }
    }

    private final StAXSource getStAXSource() throws SQLException {
        Debug.logMethod("TbSQLXML.getStAXSource", new Object[]{this});
        XMLInputFactory xmlinputfactory = XMLInputFactory.newInstance();
        try {
            XMLStreamReader xmlstreamreader = xmlinputfactory.createXMLStreamReader(this.contents);
            StAXSource staxsource = new StAXSource(xmlstreamreader);
            return staxsource;
        }
        catch (XMLStreamException xmlse) {
            throw TbError.newSQLException(-90926, xmlse.getMessage());
        }
    }

    @Override
    public String getString() throws SQLException {
        Debug.logMethod("TbSQLXML.getString", new Object[]{this});
        this.checkXMLClosed();
        this.checkReadStatus();
        if (this.contents == null) {
            return this.strValue;
        }
        StringBuilder sb = new StringBuilder();
        try {
            int c;
            while ((c = this.contents.read()) != -1) {
                sb.append((char)c);
            }
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
        return sb.toString();
    }

    public InputStream getValue() throws SQLException {
        ByteArrayInputStream stream;
        Debug.logMethod("TbSQLXML.getValue", new Object[]{this});
        this.checkXMLClosed();
        if (!this.isUsed) {
            throw TbError.newSQLException(-90929);
        }
        if (this.outputStream != null) {
            stream = this.outputStream.getInputStream();
        } else if (this.docValue != null) {
            TbXMLOutputStream tempStream = new TbXMLOutputStream();
            try {
                TransformerFactory factory = TransformerFactory.newInstance();
                factory.newTransformer().transform(new DOMSource(this.docValue), new StreamResult(tempStream));
            }
            catch (TransformerException te) {
                throw TbError.newSQLException(-90926, te.getMessage());
            }
            stream = tempStream.getInputStream();
        } else {
            stream = new ByteArrayInputStream(this.strValue.getBytes());
        }
        this.isFreed = true;
        return stream;
    }

    @Override
    public OutputStream setBinaryStream() throws SQLException {
        Debug.logMethod("TbSQLXML.setBinaryStream", new Object[]{this});
        this.checkXMLClosed();
        this.checkWriteStatus();
        this.isUsed = true;
        this.outputStream = new TbXMLOutputStream();
        return this.outputStream;
    }

    @Override
    public Writer setCharacterStream() throws SQLException {
        Debug.logMethod("TbSQLXML.setCharacterStream", new Object[]{this});
        this.checkXMLClosed();
        this.checkWriteStatus();
        this.outputStream = new TbXMLOutputStream();
        this.isUsed = true;
        return new OutputStreamWriter(this.outputStream);
    }

    public Result setResult(Class resultClass) throws SQLException {
        Debug.logMethod("TbSQLXML.setResult", new Object[]{this, resultClass});
        this.checkXMLClosed();
        this.checkWriteStatus();
        if (resultClass == null) {
            Result result = this.setResultInternal(StreamResult.class);
            return result;
        }
        return this.setResultInternal(resultClass);
    }

    private Result setResultInternal(Class<?> resultClass) throws SQLException {
        Result result = null;
        if (resultClass == DOMResult.class) {
            result = (Result)resultClass.cast(this.getDOMResult());
        } else if (resultClass == SAXResult.class) {
            result = (Result)resultClass.cast(this.getSAXResult());
        } else if (resultClass == StAXResult.class) {
            result = (Result)resultClass.cast(this.getStAXResult());
        } else if (resultClass == StreamResult.class) {
            this.outputStream = new TbXMLOutputStream();
            result = (Result)resultClass.cast(new StreamResult(this.outputStream));
        } else {
            throw TbError.newSQLException(-90928);
        }
        this.isUsed = true;
        return result;
    }

    @Override
    public void setString(String value) throws SQLException {
        Debug.logMethod("TbSQLXML.setString", new Object[]{this});
        this.checkXMLClosed();
        this.checkWriteStatus();
        if (value == null) {
            throw TbError.newSQLException(-90930);
        }
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(value));
            try {
                document = builder.parse(is);
            }
            catch (IOException ioe) {
                throw TbError.newSQLException(-90927, ioe.getMessage());
            }
        }
        catch (ParserConfigurationException pce) {
            throw TbError.newSQLException(-90926, pce.getMessage());
        }
        catch (SAXException saxe) {
            throw TbError.newSQLException(-90926, saxe.getMessage());
        }
        this.strValue = value;
        this.docValue = document;
        this.isUsed = true;
    }

    protected TbSQLXML() {
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        return "SYS.XMLTYPE";
    }

    @Override
    public void readSQL(SQLInput stream, String typeName) throws SQLException {
        TbClob tbclob = (TbClob)stream.readClob();
        stream.readString();
        stream.readBlob();
        stream.readBytes();
        stream.readString();
        this.conn = tbclob.getConnection();
        this.contents = new TbXMLInputStream(tbclob);
        this.outputStream = null;
        this.docValue = null;
        this.strValue = null;
        this.isUsed = false;
        this.isFreed = false;
        Debug.logMethod("TbSQLXML.readObject", new Object[]{this, this.conn});
    }

    @Override
    public void writeSQL(SQLOutput stream) throws SQLException {
        TbClob tbclob = this.conn.createTbClob();
        tbclob.setString(1L, this.strValue);
        stream.writeClob(tbclob);
        stream.writeString(null);
        stream.writeBlob(null);
        stream.writeBytes(null);
        stream.writeString(null);
        Debug.logMethod("TbSQLXML.writeObject", new Object[]{this, this.conn});
    }
}

