/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.TbConnection;
import com.tmax.tibero.jdbc.TbStruct;
import com.tmax.tibero.jdbc.TbStructDescriptor;
import com.tmax.tibero.jdbc.err.TbError;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;

public class TbSQLOutput
implements SQLOutput {
    private TbStructDescriptor descriptor;
    private Object[] attributes;
    private int index;
    private TbConnection conn;

    public TbSQLOutput(TbStructDescriptor descriptor, TbConnection conn) {
        this.descriptor = descriptor;
        this.attributes = new Object[descriptor.getNumOfFields()];
        this.conn = conn;
        this.index = 0;
    }

    public TbStruct getStruct() throws SQLException {
        return new TbStruct(this.descriptor, this.conn, this.attributes);
    }

    @Override
    public void writeString(String x) throws SQLException {
        this.attributes[this.index++] = x;
    }

    @Override
    public void writeBoolean(boolean x) throws SQLException {
        this.attributes[this.index++] = new Boolean(x);
    }

    @Override
    public void writeByte(byte x) throws SQLException {
        this.attributes[this.index++] = new Integer(x);
    }

    @Override
    public void writeShort(short x) throws SQLException {
        this.attributes[this.index++] = new Integer(x);
    }

    @Override
    public void writeInt(int x) throws SQLException {
        this.attributes[this.index++] = new Integer(x);
    }

    @Override
    public void writeLong(long x) throws SQLException {
        this.attributes[this.index++] = new Long(x);
    }

    @Override
    public void writeFloat(float x) throws SQLException {
        this.attributes[this.index++] = new Float(x);
    }

    @Override
    public void writeDouble(double x) throws SQLException {
        this.attributes[this.index++] = new Double(x);
    }

    @Override
    public void writeBigDecimal(BigDecimal x) throws SQLException {
        this.attributes[this.index++] = x;
    }

    @Override
    public void writeBytes(byte[] x) throws SQLException {
        this.attributes[this.index++] = x;
    }

    @Override
    public void writeDate(Date x) throws SQLException {
        this.attributes[this.index++] = x;
    }

    @Override
    public void writeTime(Time x) throws SQLException {
        this.attributes[this.index++] = x;
    }

    @Override
    public void writeTimestamp(Timestamp x) throws SQLException {
        this.attributes[this.index++] = x;
    }

    @Override
    public void writeCharacterStream(Reader x) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public void writeAsciiStream(InputStream x) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public void writeBinaryStream(InputStream x) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public void writeObject(SQLData x) throws SQLException {
        TbStruct struct = null;
        if (x != null) {
            TbStructDescriptor descriptor = TbStructDescriptor.createDescriptor(x.getSQLTypeName(), this.conn);
            SQLOutput sqlOutput = descriptor.toSQLOutput();
            x.writeSQL(sqlOutput);
            struct = ((TbSQLOutput)sqlOutput).getStruct();
        }
        this.writeStruct(struct);
    }

    @Override
    public void writeRef(Ref x) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public void writeBlob(Blob x) throws SQLException {
        this.attributes[this.index++] = x;
    }

    @Override
    public void writeClob(Clob x) throws SQLException {
        this.attributes[this.index++] = x;
    }

    @Override
    public void writeStruct(Struct x) throws SQLException {
        this.attributes[this.index++] = x;
    }

    @Override
    public void writeArray(Array x) throws SQLException {
        this.attributes[this.index++] = x;
    }

    @Override
    public void writeURL(URL x) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public void writeNString(String x) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public void writeNClob(NClob x) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public void writeRowId(RowId x) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public void writeSQLXML(SQLXML x) throws SQLException {
        throw TbError.newSQLException(-90201);
    }
}

