/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.TbBlob;
import com.tmax.tibero.jdbc.TbClob;
import com.tmax.tibero.jdbc.TbClobBase;
import com.tmax.tibero.jdbc.TbLob;
import com.tmax.tibero.jdbc.err.TbError;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class TbLobInputStream
extends InputStream {
    private TbLob lob = null;
    private int bufOffset = 0;
    private long lobOffset = 0L;
    private int fetchedSize = 0;
    private long totalSize = 0L;
    private long totalFetchedSize = 0L;
    private char[] charBuf = null;
    private byte[] byteBuf = null;
    private boolean isBlob = false;
    private boolean opened = false;

    public TbLobInputStream(TbLob lob, long pos, long len) throws SQLException {
        Debug.logMethod("TbLobInputStream", new Object[]{this, lob, Long.toString(pos), Long.toString(len)});
        if (lob == null) {
            throw TbError.newSQLException(-590767);
        }
        this.lob = lob;
        this.bufOffset = 0;
        this.lobOffset = pos - 1L;
        this.fetchedSize = 0;
        this.totalSize = len;
        this.totalFetchedSize = 0L;
        this.opened = true;
        if (lob instanceof TbClobBase) {
            this.charBuf = new char[TbLob.getMaxChunkSize()];
            this.isBlob = false;
        } else if (lob instanceof TbBlob) {
            this.byteBuf = new byte[TbLob.getMaxChunkSize()];
            this.isBlob = true;
        } else {
            throw TbError.newSQLException(-590770, lob.toString());
        }
    }

    void checkClosed() throws IOException {
        if (!this.opened) {
            throw new IOException(TbError.getMsg(-90900));
        }
    }

    @Override
    public void close() throws IOException {
        Debug.logMethod("TbLobInputStream.close", new Object[]{this, this.lob});
        this.opened = false;
    }

    private int getRemainedBufferSize() {
        return this.fetchedSize - this.bufOffset;
    }

    public char[] getCharBuf() {
        return this.charBuf;
    }

    @Override
    public int read() throws IOException {
        Debug.logMethod("TbLobInputStream.read", new Object[]{this, this.lob});
        int c = 0;
        this.checkClosed();
        if (this.getRemainedBufferSize() == 0) {
            if (this.lob.isEndOfStream()) {
                if (this.lob.getIsTempLob() && this.lob.freeTmpLobOnEOF()) {
                    try {
                        this.lob.free();
                    }
                    catch (SQLException e) {
                        Debug.log("lob.free() (FAILED) : " + e.getMessage());
                    }
                    return -1;
                }
                return -1;
            }
            try {
                this.readNextBuffer();
                return this.read();
            }
            catch (SQLException e) {
                throw new IOException(e.getMessage());
            }
        }
        c = this.isBlob ? this.byteBuf[this.bufOffset++] : this.charBuf[this.bufOffset++];
        if (c < 0) {
            c += 256;
        }
        return c;
    }

    private void readNextBuffer() throws SQLException {
        long readCnt = 0L;
        long remainedSize = this.totalSize - this.totalFetchedSize;
        if (this.isBlob) {
            if ((long)this.byteBuf.length < remainedSize) {
                readCnt = ((TbBlob)this.lob).getBytes(this.lobOffset + 1L, this.byteBuf);
            } else {
                readCnt = ((TbBlob)this.lob).getBytes(this.lobOffset + 1L, this.byteBuf, 0L, remainedSize);
                this.lob.setEndOfStream(true);
            }
        } else {
            readCnt = ((TbClob)this.lob).getChars(this.lobOffset + 1L, this.charBuf);
        }
        this.totalFetchedSize += readCnt;
        this.fetchedSize = (int)readCnt;
        this.lobOffset += readCnt;
        this.bufOffset = 0;
    }
}

