/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.util.TbCommon;
import java.text.NumberFormat;

public class TbIntervalDts {
    private final int MID_INT = 0x40000000;
    public static final int TB_INTERVAL_DTS_SIZE = 12;
    private byte[] bytes;
    private int precision = 2;
    private int scale = 6;

    public TbIntervalDts(byte[] bytes, int precision, int scale) {
        this.bytes = bytes;
        if (precision >= 0) {
            this.precision = precision;
        }
        if (scale >= 0) {
            this.scale = scale;
        }
    }

    public TbIntervalDts(int day, int hour, int minute, int second, int fsec) {
        if (this.bytes == null) {
            this.bytes = new byte[12];
        }
        this.getBigEndianBytesFromInt(day, this.bytes, 0);
        int tsPerDay = hour * 3600 + minute * 60 + second;
        this.getBigEndianBytesFromInt(tsPerDay, this.bytes, 4);
        this.getBigEndianBytesFromInt(fsec, this.bytes, 8);
    }

    public String toString() {
        int fprec = 9;
        boolean mult = true;
        int day = this.getIntFromBigEndianBytes(this.bytes, 0);
        int ts_per_day = this.getIntFromBigEndianBytes(this.bytes, 4);
        int fsec = this.getIntFromBigEndianBytes(this.bytes, 8);
        ts_per_day = Math.abs(ts_per_day);
        int hour = ts_per_day / 3600;
        int min = (ts_per_day -= hour * 3600) / 60;
        int sec = ts_per_day -= min * 60;
        NumberFormat nfTime = NumberFormat.getInstance();
        nfTime.setMinimumIntegerDigits(2);
        NumberFormat nfFsec = NumberFormat.getInstance();
        nfFsec.setGroupingUsed(false);
        nfFsec.setMinimumIntegerDigits(9);
        fsec = Math.abs(fsec);
        String strFsec = nfFsec.format(fsec);
        strFsec = strFsec.substring(0, this.scale);
        NumberFormat nfDay = NumberFormat.getInstance();
        nfDay.setGroupingUsed(false);
        nfDay.setMinimumIntegerDigits(this.precision);
        StringBuffer sb = new StringBuffer();
        if (day >= 0) {
            sb.append("+");
        }
        sb.append(nfDay.format(day) + " " + nfTime.format(hour) + ":" + nfTime.format(min) + ":" + nfTime.format(sec) + "." + strFsec);
        return sb.toString();
    }

    private int getIntFromBigEndianBytes(byte[] bytes, int offset) {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            value |= (0xFF & bytes[offset + i]) << 8 * (3 - i);
        }
        return value -= 0x40000000;
    }

    private void getBigEndianBytesFromInt(int n, byte[] bytes, int offset) {
        TbCommon.int2Bytes(n += 0x40000000, bytes, offset, 4);
    }

    public byte[] getBytes() {
        return this.bytes;
    }
}

