/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.TbClobBase;
import com.tmax.tibero.jdbc.TbLob;
import com.tmax.tibero.jdbc.err.TbError;
import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;

public class TbClobReader
extends Reader {
    private TbClobBase clob = null;
    private int bufOffset = 0;
    private long lobOffset = 0L;
    private int fetchedSize = 0;
    private long totalSize = 0L;
    private long totalFetchedSize = 0L;
    private char[] buf = null;
    private boolean opened = false;

    public TbClobReader(TbClobBase clob, long pos, long len) throws SQLException {
        Debug.logMethod("TbClobReader", new Object[]{this, clob, Long.toString(pos), Long.toString(len)});
        if (clob == null) {
            throw TbError.newSQLException(-590767);
        }
        this.clob = clob;
        this.bufOffset = 0;
        this.lobOffset = pos - 1L;
        this.fetchedSize = 0;
        this.totalSize = len;
        this.buf = new char[TbLob.getMaxChunkSize()];
        this.opened = true;
    }

    private void checkClosed() throws IOException {
        if (!this.opened) {
            throw new IOException(TbError.getMsg(-90900));
        }
    }

    @Override
    public void close() throws IOException {
        Debug.logMethod("TbClobReader.close", new Object[]{this, this.clob});
        this.opened = false;
        this.clob = null;
        this.buf = null;
    }

    private int getRemainedInBuffer() {
        return this.fetchedSize - this.bufOffset;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        Debug.logMethod("TbClobReader.read", new Object[]{this, this.clob, cbuf, Integer.toString(off), Integer.toString(len)});
        if (cbuf == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        this.checkClosed();
        if (this.getRemainedInBuffer() == 0) {
            if (this.clob.isEndOfStream()) {
                if (this.clob.getIsTempLob() && this.clob.freeTmpLobOnEOF()) {
                    try {
                        this.clob.free();
                    }
                    catch (SQLException e) {
                        Debug.log("clob.free() (FAILED) : " + e.getMessage());
                    }
                    return -1;
                }
                return -1;
            }
            try {
                this.readNextBuffer();
            }
            catch (SQLException e) {
                throw new IOException(e.getMessage());
            }
        }
        if (this.getRemainedInBuffer() >= len) {
            System.arraycopy(this.buf, this.bufOffset, cbuf, off, len);
            this.bufOffset += len;
            return len;
        }
        int readLen = 0;
        while (len > readLen) {
            int splitLen = this.getRemainedInBuffer();
            if (splitLen > len - readLen) {
                splitLen = len - readLen;
            }
            System.arraycopy(this.buf, this.bufOffset, cbuf, off + readLen, splitLen);
            readLen += splitLen;
            this.bufOffset += splitLen;
            if (this.getRemainedInBuffer() != 0) continue;
            if (!this.clob.isEndOfStream()) {
                try {
                    this.readNextBuffer();
                    continue;
                }
                catch (SQLException e) {
                    throw new IOException(e.getMessage());
                }
            }
            return readLen;
        }
        return readLen;
    }

    private void readNextBuffer() throws SQLException {
        long readCnt = 0L;
        long remainedSize = this.totalSize - this.totalFetchedSize;
        if ((long)this.buf.length < remainedSize) {
            readCnt = this.clob.getChars(this.lobOffset + 1L, this.buf);
        } else {
            readCnt = this.clob.getChars(this.lobOffset + 1L, this.buf, 0L, remainedSize);
            this.clob.setEndOfStream(true);
        }
        this.totalFetchedSize += readCnt;
        this.fetchedSize = (int)readCnt;
        this.lobOffset += readCnt;
        this.bufOffset = 0;
    }
}

