/*
 * Decompiled with CFR 0.152.
 */
package rcc.tika.parser.hwp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import rcc.h2tlib.parser.H2TParser;
import rcc.h2tlib.parser.HWPMeta;

public class HWPParser
implements Parser {
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.application((String)"hwp"));
    public static final String HWP_MIME_TYPE = "application/hwp";

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        H2TParser parser = new H2TParser();
        HWPMeta hmeta = new HWPMeta();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        stream.mark(Integer.MAX_VALUE);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)stream, (OutputStream)baos);
        byte[] bytes = baos.toByteArray();
        stream.reset();
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        boolean hwp_flg = parser.GetText((InputStream)bais, hmeta, (OutputStream)out, 2);
        if (hwp_flg) {
            xhtml.element("p", out.toString("UTF-8"));
        } else {
            bais.close();
            bais = new ByteArrayInputStream(bytes);
            hwp_flg = parser.GetText((InputStream)bais, hmeta, (OutputStream)out, 1);
            if (hwp_flg) {
                xhtml.element("p", out.toString("UTF-8"));
            } else {
                bais.close();
                bais = new ByteArrayInputStream(bytes);
                hwp_flg = parser.GetText((InputStream)bais, hmeta, (OutputStream)out, 3);
                if (hwp_flg) {
                    xhtml.element("p", out.toString("UTF-8"));
                }
            }
        }
        bais.close();
        out.close();
        xhtml.endDocument();
        String title = hmeta.getTitle();
        String subject = hmeta.getSubject();
        String author = hmeta.getAuthor();
        String createtime = hmeta.getCreatetime();
        String keyword = hmeta.getKeyword();
        String comment = hmeta.getComment();
        if (title != null) {
            metadata.set(TikaCoreProperties.TITLE, title);
        }
        if (author != null) {
            metadata.set(TikaCoreProperties.CREATOR, author);
        }
        if (keyword != null) {
            metadata.set(TikaCoreProperties.KEYWORDS, keyword);
        }
        if (subject != null) {
            metadata.set(TikaCoreProperties.DESCRIPTION, subject);
        }
        if (comment != null) {
            metadata.set(TikaCoreProperties.COMMENTS, comment);
        }
        if (createtime != null) {
            metadata.set("hwp_create_time", createtime);
        }
        metadata.set("Content-Type", HWP_MIME_TYPE);
    }
}

