/*
 * Decompiled with CFR 0.152.
 */
package rcc.tika.detect.hwp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.tika.detect.Detector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import rcc.h2tlib.parser.H2TParser;
import rcc.h2tlib.parser.HWPMeta;

public class HWPDetector
implements Detector {
    public static final MediaType HWP = MediaType.application((String)"hwp");

    public MediaType detect(InputStream input, Metadata metadata) throws IOException {
        if (input == null) {
            return MediaType.OCTET_STREAM;
        }
        H2TParser parser = new H2TParser();
        HWPMeta hmeta = new HWPMeta();
        input.mark(Integer.MAX_VALUE);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)input, (OutputStream)baos);
        byte[] bytes = baos.toByteArray();
        input.reset();
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        boolean hwp_flg = parser.GetMeta((InputStream)bais, hmeta, 2);
        if (!hwp_flg) {
            bais.close();
            bais = new ByteArrayInputStream(bytes);
            hwp_flg = parser.GetMeta((InputStream)bais, hmeta, 1);
            if (!hwp_flg) {
                bais.close();
                bais = new ByteArrayInputStream(bytes);
                hwp_flg = parser.GetMeta((InputStream)bais, hmeta, 3);
            }
        }
        bais.close();
        String title = hmeta.getTitle();
        String subject = hmeta.getSubject();
        String author = hmeta.getAuthor();
        String createtime = hmeta.getCreatetime();
        String keyword = hmeta.getKeyword();
        String comment = hmeta.getComment();
        if (title != null) {
            metadata.set(TikaCoreProperties.TITLE, title);
        }
        if (author != null) {
            metadata.set(TikaCoreProperties.CREATOR, author);
        }
        if (keyword != null) {
            metadata.set(TikaCoreProperties.KEYWORDS, keyword);
        }
        if (subject != null) {
            metadata.set(TikaCoreProperties.DESCRIPTION, subject);
        }
        if (comment != null) {
            metadata.set(TikaCoreProperties.COMMENTS, comment);
        }
        if (createtime != null) {
            metadata.set(TikaCoreProperties.CREATED, createtime);
        }
        if (hwp_flg) {
            return HWP;
        }
        return MediaType.OCTET_STREAM;
    }
}

