/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;

public class RTimer {
    public static final int STARTED = 0;
    public static final int STOPPED = 1;
    public static final int PAUSED = 2;
    protected int state;
    protected TimerImpl timerImpl;
    protected double time = 0.0;
    protected double culmTime = 0.0;
    protected SimpleOrderedMap<RTimer> children = new SimpleOrderedMap();

    protected TimerImpl newTimerImpl() {
        return new NanoTimeTimerImpl();
    }

    protected RTimer newTimer() {
        return new RTimer();
    }

    public RTimer() {
        this.timerImpl = this.newTimerImpl();
        this.timerImpl.start();
        this.state = 0;
    }

    public double stop() {
        assert (this.state == 0 || this.state == 2);
        this.time = this.culmTime;
        if (this.state == 0) {
            this.time += this.timerImpl.elapsed();
        }
        this.state = 1;
        for (Map.Entry entry : this.children) {
            RTimer child = (RTimer)entry.getValue();
            if (child.state != 0 && child.state != 2) continue;
            child.stop();
        }
        return this.time;
    }

    public void pause() {
        assert (this.state == 0);
        this.culmTime += this.timerImpl.elapsed();
        this.state = 2;
    }

    public void resume() {
        if (this.state == 0) {
            return;
        }
        assert (this.state == 2);
        this.state = 0;
        this.timerImpl.start();
    }

    public double getTime() {
        if (this.state == 1) {
            return this.time;
        }
        if (this.state == 2) {
            return this.culmTime;
        }
        assert (this.state == 0);
        return this.culmTime + this.timerImpl.elapsed();
    }

    public RTimer sub(String desc) {
        RTimer child = (RTimer)this.children.get(desc);
        if (child == null) {
            child = this.newTimer();
            this.children.add(desc, (Object)child);
        }
        return child;
    }

    public String toString() {
        return this.asNamedList().toString();
    }

    public NamedList asNamedList() {
        SimpleOrderedMap m = new SimpleOrderedMap();
        m.add("time", (Object)this.getTime());
        if (this.children.size() > 0) {
            for (Map.Entry entry : this.children) {
                m.add((String)entry.getKey(), (Object)((RTimer)entry.getValue()).asNamedList());
            }
        }
        return m;
    }

    public SimpleOrderedMap<RTimer> getChildren() {
        return this.children;
    }

    private class NanoTimeTimerImpl
    implements TimerImpl {
        private long start;

        private NanoTimeTimerImpl() {
        }

        @Override
        public void start() {
            this.start = System.nanoTime();
        }

        @Override
        public double elapsed() {
            return TimeUnit.MILLISECONDS.convert(System.nanoTime() - this.start, TimeUnit.NANOSECONDS);
        }
    }

    protected static interface TimerImpl {
        public void start();

        public double elapsed();
    }
}

