/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.DelegatingAnalyzerWrapper;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LogMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.TieredMergePolicy;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.Version;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.Config;
import org.apache.solr.core.MapSerializable;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.update.LoggingInfoStream;
import org.apache.solr.util.SolrPluginUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class SolrIndexConfig
implements MapSerializable {
    public static final Logger log = LoggerFactory.getLogger(SolrIndexConfig.class);
    final String defaultMergePolicyClassName;
    public static final String DEFAULT_MERGE_SCHEDULER_CLASSNAME = ConcurrentMergeScheduler.class.getName();
    public final Version luceneVersion;
    private boolean effectiveUseCompoundFileSetting;
    public final int maxBufferedDocs;
    public final int maxMergeDocs;
    public final int mergeFactor;
    public final double ramBufferSizeMB;
    public final int writeLockTimeout;
    public final String lockType;
    public final PluginInfo mergePolicyInfo;
    public final PluginInfo mergeSchedulerInfo;
    public final PluginInfo mergedSegmentWarmerInfo;
    public InfoStream infoStream = InfoStream.NO_OUTPUT;
    public static final String LOCK_TYPE_SIMPLE = "simple";
    public static final String LOCK_TYPE_NATIVE = "native";
    public static final String LOCK_TYPE_SINGLE = "single";
    public static final String LOCK_TYPE_NONE = "none";

    private SolrIndexConfig(SolrConfig solrConfig) {
        this.luceneVersion = solrConfig.luceneMatchVersion;
        this.effectiveUseCompoundFileSetting = false;
        this.maxBufferedDocs = -1;
        this.maxMergeDocs = -1;
        this.mergeFactor = -1;
        this.ramBufferSizeMB = 100.0;
        this.writeLockTimeout = -1;
        this.lockType = LOCK_TYPE_NATIVE;
        this.mergePolicyInfo = null;
        this.mergeSchedulerInfo = null;
        this.defaultMergePolicyClassName = TieredMergePolicy.class.getName();
        this.mergedSegmentWarmerInfo = null;
    }

    public SolrIndexConfig(SolrConfig solrConfig, String prefix, SolrIndexConfig def) {
        if (prefix == null) {
            prefix = "indexConfig";
            log.debug("Defaulting to prefix \"" + prefix + "\" for index configuration");
        }
        if (def == null) {
            def = new SolrIndexConfig(solrConfig);
        }
        Node unused = solrConfig.getNode(prefix, false);
        this.luceneVersion = solrConfig.luceneMatchVersion;
        Config.assertWarnOrFail("The <mergeScheduler>myclass</mergeScheduler> syntax is no longer supported in solrconfig.xml. Please use syntax <mergeScheduler class=\"myclass\"/> instead.", solrConfig.getNode(prefix + "/mergeScheduler", false) == null || solrConfig.get(prefix + "/mergeScheduler/@class", null) != null, true);
        Config.assertWarnOrFail("The <mergePolicy>myclass</mergePolicy> syntax is no longer supported in solrconfig.xml. Please use syntax <mergePolicy class=\"myclass\"/> instead.", solrConfig.getNode(prefix + "/mergePolicy", false) == null || solrConfig.get(prefix + "/mergePolicy/@class", null) != null, true);
        Config.assertWarnOrFail("The <luceneAutoCommit>true|false</luceneAutoCommit> parameter is no longer valid in solrconfig.xml.", solrConfig.get(prefix + "/luceneAutoCommit", null) == null, true);
        this.defaultMergePolicyClassName = def.defaultMergePolicyClassName;
        this.effectiveUseCompoundFileSetting = solrConfig.getBool(prefix + "/useCompoundFile", def.getUseCompoundFile());
        this.maxBufferedDocs = solrConfig.getInt(prefix + "/maxBufferedDocs", def.maxBufferedDocs);
        this.maxMergeDocs = solrConfig.getInt(prefix + "/maxMergeDocs", def.maxMergeDocs);
        this.mergeFactor = solrConfig.getInt(prefix + "/mergeFactor", def.mergeFactor);
        this.ramBufferSizeMB = solrConfig.getDouble(prefix + "/ramBufferSizeMB", def.ramBufferSizeMB);
        this.writeLockTimeout = solrConfig.getInt(prefix + "/writeLockTimeout", def.writeLockTimeout);
        this.lockType = solrConfig.get(prefix + "/lockType", def.lockType);
        this.mergeSchedulerInfo = this.getPluginInfo(prefix + "/mergeScheduler", solrConfig, def.mergeSchedulerInfo);
        this.mergePolicyInfo = this.getPluginInfo(prefix + "/mergePolicy", solrConfig, def.mergePolicyInfo);
        String val = solrConfig.get(prefix + "/termIndexInterval", null);
        if (val != null) {
            throw new IllegalArgumentException("Illegal parameter 'termIndexInterval'");
        }
        boolean infoStreamEnabled = solrConfig.getBool(prefix + "/infoStream", false);
        if (infoStreamEnabled) {
            String infoStreamFile = solrConfig.get(prefix + "/infoStream/@file", null);
            if (infoStreamFile == null) {
                log.info("IndexWriter infoStream solr logging is enabled");
                this.infoStream = new LoggingInfoStream();
            } else {
                throw new IllegalArgumentException("Remove @file from <infoStream> to output messages to solr's logfile");
            }
        }
        this.mergedSegmentWarmerInfo = this.getPluginInfo(prefix + "/mergedSegmentWarmer", solrConfig, def.mergedSegmentWarmerInfo);
        Config.assertWarnOrFail("Begining with Solr 5.0, <checkIntegrityAtMerge> option is no longer supported and should be removed from solrconfig.xml (these integrity checks are now automatic)", null == solrConfig.getNode(prefix + "/checkIntegrityAtMerge", false), false);
    }

    @Override
    public Map<String, Object> toMap() {
        Map m = Utils.makeMap((Object[])new Object[]{"useCompoundFile", this.effectiveUseCompoundFileSetting, "maxBufferedDocs", this.maxBufferedDocs, "maxMergeDocs", this.maxMergeDocs, "mergeFactor", this.mergeFactor, "ramBufferSizeMB", this.ramBufferSizeMB, "writeLockTimeout", this.writeLockTimeout, "lockType", this.lockType, "infoStreamEnabled", this.infoStream != InfoStream.NO_OUTPUT});
        if (this.mergeSchedulerInfo != null) {
            m.put("mergeScheduler", this.mergeSchedulerInfo.toMap());
        }
        if (this.mergePolicyInfo != null) {
            m.put("mergePolicy", this.mergePolicyInfo.toMap());
        }
        if (this.mergedSegmentWarmerInfo != null) {
            m.put("mergedSegmentWarmer", this.mergedSegmentWarmerInfo.toMap());
        }
        return m;
    }

    private PluginInfo getPluginInfo(String path, SolrConfig solrConfig, PluginInfo def) {
        List<PluginInfo> l = solrConfig.readPluginInfos(path, false, true);
        return l.isEmpty() ? def : l.get(0);
    }

    public IndexWriterConfig toIndexWriterConfig(SolrCore core) {
        IndexSchema schema = core.getLatestSchema();
        IndexWriterConfig iwc = new IndexWriterConfig((Analyzer)new DelayedSchemaAnalyzer(core));
        if (this.maxBufferedDocs != -1) {
            iwc.setMaxBufferedDocs(this.maxBufferedDocs);
        }
        if (this.ramBufferSizeMB != -1.0) {
            iwc.setRAMBufferSizeMB(this.ramBufferSizeMB);
        }
        if (this.writeLockTimeout != -1) {
            iwc.setWriteLockTimeout((long)this.writeLockTimeout);
        }
        iwc.setSimilarity(schema.getSimilarity());
        iwc.setMergePolicy(this.buildMergePolicy(schema));
        iwc.setMergeScheduler(this.buildMergeScheduler(schema));
        iwc.setInfoStream(this.infoStream);
        iwc.setUseCompoundFile(this.getUseCompoundFile());
        if (this.mergedSegmentWarmerInfo != null) {
            IndexWriter.IndexReaderWarmer warmer = schema.getResourceLoader().newInstance(this.mergedSegmentWarmerInfo.className, IndexWriter.IndexReaderWarmer.class, null, new Class[]{InfoStream.class}, new Object[]{iwc.getInfoStream()});
            iwc.setMergedSegmentWarmer(warmer);
        }
        return iwc;
    }

    private MergePolicy buildMergePolicy(IndexSchema schema) {
        String mpClassName = this.mergePolicyInfo == null ? this.defaultMergePolicyClassName : this.mergePolicyInfo.className;
        MergePolicy policy = schema.getResourceLoader().newInstance(mpClassName, MergePolicy.class);
        if (policy instanceof LogMergePolicy) {
            LogMergePolicy logMergePolicy = (LogMergePolicy)policy;
            this.fixUseCFMergePolicyInitArg(LogMergePolicy.class);
            if (this.maxMergeDocs != -1) {
                logMergePolicy.setMaxMergeDocs(this.maxMergeDocs);
            }
            if (this.mergeFactor != -1) {
                logMergePolicy.setMergeFactor(this.mergeFactor);
            }
        } else if (policy instanceof TieredMergePolicy) {
            TieredMergePolicy tieredMergePolicy = (TieredMergePolicy)policy;
            this.fixUseCFMergePolicyInitArg(TieredMergePolicy.class);
            if (this.mergeFactor != -1) {
                tieredMergePolicy.setMaxMergeAtOnce(this.mergeFactor);
                tieredMergePolicy.setSegmentsPerTier((double)this.mergeFactor);
            }
        } else if (this.mergeFactor != -1) {
            log.warn("Use of <mergeFactor> cannot be configured if merge policy is not an instance of LogMergePolicy or TieredMergePolicy. The configured policy's defaults will be used.");
        }
        if (this.mergePolicyInfo != null) {
            SolrPluginUtils.invokeSetters(policy, this.mergePolicyInfo.initArgs);
        }
        return policy;
    }

    private MergeScheduler buildMergeScheduler(IndexSchema schema) {
        String msClassName = this.mergeSchedulerInfo == null ? DEFAULT_MERGE_SCHEDULER_CLASSNAME : this.mergeSchedulerInfo.className;
        MergeScheduler scheduler = schema.getResourceLoader().newInstance(msClassName, MergeScheduler.class);
        if (this.mergeSchedulerInfo != null) {
            if (scheduler instanceof ConcurrentMergeScheduler) {
                Integer maxThreadCount;
                NamedList args = this.mergeSchedulerInfo.initArgs.clone();
                Integer maxMergeCount = (Integer)args.remove("maxMergeCount");
                if (maxMergeCount == null) {
                    maxMergeCount = ((ConcurrentMergeScheduler)scheduler).getMaxMergeCount();
                }
                if ((maxThreadCount = (Integer)args.remove("maxThreadCount")) == null) {
                    maxThreadCount = ((ConcurrentMergeScheduler)scheduler).getMaxThreadCount();
                }
                ((ConcurrentMergeScheduler)scheduler).setMaxMergesAndThreads(maxMergeCount.intValue(), maxThreadCount.intValue());
                SolrPluginUtils.invokeSetters(scheduler, args);
            } else {
                SolrPluginUtils.invokeSetters(scheduler, this.mergeSchedulerInfo.initArgs);
            }
        }
        return scheduler;
    }

    public boolean getUseCompoundFile() {
        return this.effectiveUseCompoundFileSetting;
    }

    private void fixUseCFMergePolicyInitArg(Class c) {
        if (null == this.mergePolicyInfo || null == this.mergePolicyInfo.initArgs) {
            return;
        }
        Object useCFSArg = this.mergePolicyInfo.initArgs.remove("useCompoundFile");
        if (null != useCFSArg) {
            log.warn("Ignoring 'useCompoundFile' specified as an init arg for the <mergePolicy> since it is no directly longer supported by " + c.getSimpleName());
            if (useCFSArg instanceof Boolean) {
                boolean cfs = (Boolean)useCFSArg;
                log.warn("Please update your config to specify <useCompoundFile>" + cfs + "</useCompoundFile> directly in your <indexConfig> settings.");
                this.effectiveUseCompoundFileSetting = cfs;
            } else {
                log.error("MergePolicy's 'useCompoundFile' init arg is not a boolean, can not apply back compat logic to apply to the IndexWriterConfig: " + useCFSArg.toString());
            }
        }
    }

    private static class DelayedSchemaAnalyzer
    extends DelegatingAnalyzerWrapper {
        private final SolrCore core;

        public DelayedSchemaAnalyzer(SolrCore core) {
            super(PER_FIELD_REUSE_STRATEGY);
            this.core = core;
        }

        protected Analyzer getWrappedAnalyzer(String fieldName) {
            return this.core.getLatestSchema().getIndexAnalyzer();
        }
    }
}

