/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.Principal;
import java.security.PublicKey;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.auth.BasicUserPrincipal;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.solr.client.solrj.impl.HttpClientConfigurer;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.Base64;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthenticationPlugin;
import org.apache.solr.security.HttpClientInterceptorPlugin;
import org.apache.solr.util.CryptoKeys;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKIAuthenticationPlugin
extends AuthenticationPlugin
implements HttpClientInterceptorPlugin {
    static final Logger log = LoggerFactory.getLogger(PKIAuthenticationPlugin.class);
    private final Map<String, PublicKey> keyCache = new ConcurrentHashMap<String, PublicKey>();
    private CryptoKeys.RSAKeyPair keyPair = new CryptoKeys.RSAKeyPair();
    private final CoreContainer cores;
    private int maxValidity = 5000;
    private final String myNodeName;
    private boolean interceptorRegistered = false;
    private HttpHeaderClientConfigurer clientConfigurer = new HttpHeaderClientConfigurer();
    public static final String HEADER = "SolrAuth";
    public static final String PATH = "/admin/info/key";
    public static final String NODE_IS_USER = "$";
    private static final Principal SU = new BasicUserPrincipal("$");

    public void setInterceptorRegistered() {
        this.interceptorRegistered = true;
    }

    public boolean isInterceptorRegistered() {
        return this.interceptorRegistered;
    }

    public PKIAuthenticationPlugin(CoreContainer cores, String nodeName) {
        this.cores = cores;
        this.myNodeName = nodeName;
    }

    @Override
    public void init(Map<String, Object> pluginConfig) {
    }

    @Override
    public void doAuthenticate(ServletRequest request, ServletResponse response, FilterChain filterChain) throws Exception {
        String cipher;
        String requestURI = ((HttpServletRequest)request).getRequestURI();
        if (requestURI.endsWith(PATH)) {
            filterChain.doFilter(request, response);
            return;
        }
        long receivedTime = System.currentTimeMillis();
        String header = ((HttpServletRequest)request).getHeader(HEADER);
        if (header == null) {
            log.error("No SolrAuth header present");
            filterChain.doFilter(request, response);
            return;
        }
        List authInfo = StrUtils.splitWS((String)header, (boolean)false);
        if (authInfo.size() < 2) {
            log.error("Invalid SolrAuth Header");
            return;
        }
        String nodeName = (String)authInfo.get(0);
        byte[] decipher = this.decipherData(nodeName, cipher = (String)authInfo.get(1));
        if (decipher == null) {
            return;
        }
        String s = new String(decipher, StandardCharsets.UTF_8).trim();
        List pcs = StrUtils.splitWS((String)s, (boolean)false);
        if (pcs.size() < 2) {
            return;
        }
        String userName = (String)pcs.get(0);
        String timeStr = (String)pcs.get(1);
        try {
            long timeMillis = Long.parseLong(timeStr);
            if (receivedTime - timeMillis > (long)this.maxValidity) {
                log.error("Invalid key ");
                filterChain.doFilter(request, response);
                return;
            }
        }
        catch (NumberFormatException e) {
            log.error("Invalid time " + timeStr, (Throwable)e);
            return;
        }
        Principal principal = NODE_IS_USER.equals(userName) ? SU : new BasicUserPrincipal(userName);
        filterChain.doFilter((ServletRequest)PKIAuthenticationPlugin.getWrapper((HttpServletRequest)request, principal), response);
    }

    private static HttpServletRequestWrapper getWrapper(HttpServletRequest request, final Principal principal) {
        return new HttpServletRequestWrapper(request){

            public Principal getUserPrincipal() {
                return principal;
            }
        };
    }

    private byte[] decipherData(String nodeName, String cipherBase64) {
        boolean freshKey = false;
        PublicKey key = this.keyCache.get(nodeName);
        if (key == null) {
            key = this.getRemotePublicKey(nodeName);
            freshKey = true;
        }
        try {
            return CryptoKeys.decryptRSA(Base64.base64ToByteArray((String)cipherBase64), key);
        }
        catch (InvalidKeyException e) {
            if (!freshKey) {
                key = this.getRemotePublicKey(nodeName);
                if (key == null) {
                    return null;
                }
                try {
                    return CryptoKeys.decryptRSA(Base64.base64ToByteArray((String)cipherBase64), key);
                }
                catch (Exception e1) {
                    log.error("Error decrypting");
                    return null;
                }
            }
        }
        catch (Exception e) {
            log.error("Error decrypting");
            return null;
        }
        return null;
    }

    PublicKey getRemotePublicKey(String nodename) {
        String url = this.cores.getZkController().getZkStateReader().getBaseUrlForNodeName(nodename);
        try {
            HttpResponse rsp = this.cores.getUpdateShardHandler().getHttpClient().execute((HttpUriRequest)new HttpGet(url + PATH + "?wt=json&omitHeader=true"));
            byte[] bytes = EntityUtils.toByteArray((HttpEntity)rsp.getEntity());
            Map m = (Map)Utils.fromJSON((byte[])bytes);
            String key = (String)m.get("key");
            if (key == null) {
                log.error("No key available from " + url + PATH);
                return null;
            }
            PublicKey pubKey = CryptoKeys.deserializeX509PublicKey(key);
            this.keyCache.put(nodename, pubKey);
            return pubKey;
        }
        catch (Exception e) {
            log.error("Exception trying to get public key from : " + url, (Throwable)e);
            return null;
        }
    }

    @Override
    public HttpClientConfigurer getClientConfigurer() {
        return this.clientConfigurer;
    }

    public SolrRequestHandler getRequestHandler() {
        return new RequestHandlerBase(){

            @Override
            public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
                rsp.add("key", PKIAuthenticationPlugin.this.keyPair.getPublicKeyStr());
            }

            @Override
            public String getDescription() {
                return "Return the public key of this server";
            }
        };
    }

    public boolean needsAuthorization(HttpServletRequest req) {
        return req.getUserPrincipal() != SU;
    }

    void setHeader(HttpRequest httpRequest) {
        SolrRequestInfo reqInfo = this.getRequestInfo();
        String usr = null;
        if (reqInfo != null) {
            Principal principal = reqInfo.getReq().getUserPrincipal();
            if (principal == null) {
                return;
            }
            usr = principal.getName();
        } else {
            if (!this.isSolrThread()) {
                return;
            }
            usr = NODE_IS_USER;
        }
        String s = usr + " " + System.currentTimeMillis();
        byte[] payload = s.getBytes(StandardCharsets.UTF_8);
        byte[] payloadCipher = this.keyPair.encrypt(ByteBuffer.wrap(payload));
        String base64Cipher = Base64.byteArrayToBase64((byte[])payloadCipher);
        httpRequest.setHeader(HEADER, this.myNodeName + " " + base64Cipher);
    }

    boolean isSolrThread() {
        return ExecutorUtil.isSolrServerThread();
    }

    SolrRequestInfo getRequestInfo() {
        return SolrRequestInfo.getRequestInfo();
    }

    boolean disabled() {
        return this.cores.getAuthenticationPlugin() == null || this.cores.getAuthenticationPlugin() instanceof HttpClientInterceptorPlugin;
    }

    @Override
    public void close() throws IOException {
    }

    public String getPublicKey() {
        return this.keyPair.getPublicKeyStr();
    }

    private class HttpHeaderClientConfigurer
    extends HttpClientConfigurer
    implements HttpRequestInterceptor {
        private HttpHeaderClientConfigurer() {
        }

        public void configure(DefaultHttpClient httpClient, SolrParams config) {
            super.configure(httpClient, config);
            httpClient.addRequestInterceptor((HttpRequestInterceptor)this);
        }

        public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
            if (PKIAuthenticationPlugin.this.disabled()) {
                return;
            }
            PKIAuthenticationPlugin.this.setHeader(httpRequest);
        }
    }
}

