/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.auth.BasicUserPrincipal;
import org.apache.http.message.BasicHeader;
import org.apache.solr.common.SolrException;
import org.apache.solr.security.AuthenticationPlugin;
import org.apache.solr.security.ConfigEditablePlugin;
import org.apache.solr.security.Sha256AuthenticationProvider;
import org.apache.solr.util.CommandOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAuthPlugin
extends AuthenticationPlugin
implements ConfigEditablePlugin {
    protected static final Logger log = LoggerFactory.getLogger(BasicAuthPlugin.class);
    private AuthenticationProvider zkAuthentication;
    private static final ThreadLocal<Header> authHeader = new ThreadLocal();

    public boolean authenticate(String username, String pwd) {
        return this.zkAuthentication.authenticate(username, pwd);
    }

    @Override
    public void init(Map<String, Object> pluginConfig) {
        this.zkAuthentication = this.getAuthenticationProvider(pluginConfig);
    }

    @Override
    public Map<String, Object> edit(Map<String, Object> latestConf, List<CommandOperation> commands) {
        if (this.zkAuthentication instanceof ConfigEditablePlugin) {
            ConfigEditablePlugin editablePlugin = (ConfigEditablePlugin)((Object)this.zkAuthentication);
            return editablePlugin.edit(latestConf, commands);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "This cannot be edited");
    }

    protected AuthenticationProvider getAuthenticationProvider(Map<String, Object> pluginConfig) {
        Sha256AuthenticationProvider provider = new Sha256AuthenticationProvider();
        provider.init(pluginConfig);
        return provider;
    }

    private void authenticationFailure(HttpServletResponse response, String message) throws IOException {
        for (Map.Entry<String, String> entry : this.zkAuthentication.getPromptHeaders().entrySet()) {
            response.setHeader(entry.getKey(), entry.getValue());
        }
        response.sendError(401, message);
    }

    @Override
    public void doAuthenticate(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws Exception {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String authHeader = request.getHeader("Authorization");
        if (authHeader != null) {
            String basic;
            BasicAuthPlugin.authHeader.set((Header)new BasicHeader("Authorization", authHeader));
            StringTokenizer st = new StringTokenizer(authHeader);
            if (st.hasMoreTokens() && (basic = st.nextToken()).equalsIgnoreCase("Basic")) {
                try {
                    String credentials = new String(Base64.decodeBase64((String)st.nextToken()), "UTF-8");
                    int p = credentials.indexOf(":");
                    if (p != -1) {
                        String pwd;
                        final String username = credentials.substring(0, p).trim();
                        if (!this.authenticate(username, pwd = credentials.substring(p + 1).trim())) {
                            this.authenticationFailure(response, "Bad credentials");
                        }
                        HttpServletRequestWrapper wrapper = new HttpServletRequestWrapper(request){

                            public Principal getUserPrincipal() {
                                return new BasicUserPrincipal(username);
                            }
                        };
                        filterChain.doFilter((ServletRequest)wrapper, (ServletResponse)response);
                    }
                    this.authenticationFailure(response, "Invalid authentication token");
                }
                catch (UnsupportedEncodingException e) {
                    throw new Error("Couldn't retrieve authentication", e);
                }
            }
        } else {
            request.setAttribute(AuthenticationPlugin.class.getName(), this.zkAuthentication.getPromptHeaders());
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void closeRequest() {
        authHeader.remove();
    }

    public static interface AuthenticationProvider {
        public void init(Map<String, Object> var1);

        public boolean authenticate(String var1, String var2);

        public Map<String, String> getPromptHeaders();
    }
}

