/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.mlt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queries.mlt.MoreLikeThis;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.StringUtils;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryRequestBase;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudMLTQParser
extends QParser {
    private static final Pattern splitList = Pattern.compile(",| ");
    private static Logger log = LoggerFactory.getLogger(CloudMLTQParser.class);

    public CloudMLTQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        super(qstr, localParams, params, req);
    }

    @Override
    public Query parse() {
        String id = this.localParams.get("v");
        SolrDocument doc = this.getDocument(id);
        if (doc == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error completing MLT request. Could not fetch document with id [" + id + "]");
        }
        MoreLikeThis mlt = new MoreLikeThis((IndexReader)this.req.getSearcher().getIndexReader());
        if (this.localParams.getInt("mintf") != null) {
            mlt.setMinTermFreq(this.localParams.getInt("mintf").intValue());
        }
        mlt.setMinDocFreq(this.localParams.getInt("mindf", 0));
        if (this.localParams.get("minwl") != null) {
            mlt.setMinWordLen(this.localParams.getInt("minwl").intValue());
        }
        if (this.localParams.get("maxwl") != null) {
            mlt.setMaxWordLen(this.localParams.getInt("maxwl").intValue());
        }
        if (this.localParams.get("maxqt") != null) {
            mlt.setMaxQueryTerms(this.localParams.getInt("maxqt").intValue());
        }
        if (this.localParams.get("maxntp") != null) {
            mlt.setMaxNumTokensParsed(this.localParams.getInt("maxntp").intValue());
        }
        if (this.localParams.get("maxdf") != null) {
            mlt.setMaxDocFreq(this.localParams.getInt("maxdf").intValue());
        }
        mlt.setAnalyzer(this.req.getSchema().getIndexAnalyzer());
        String[] qf = this.localParams.getParams("qf");
        HashMap<String, Collection> filteredDocument = new HashMap<String, Collection>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        if (qf != null) {
            for (String fieldName : qf) {
                String[] strings;
                if (StringUtils.isEmpty((String)fieldName)) continue;
                for (String string : strings = splitList.split(fieldName)) {
                    if (StringUtils.isEmpty((String)string)) continue;
                    fieldNames.add(string);
                }
            }
        } else {
            Map<String, SchemaField> fields = this.req.getSchema().getFields();
            for (String field : doc.getFieldNames()) {
                if (!fields.get(field).stored() || !fields.get(field).getType().isExplicitAnalyzer()) continue;
                fieldNames.add(field);
            }
        }
        if (fieldNames.size() < 1) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "MoreLikeThis requires at least one similarity field: qf");
        }
        mlt.setFieldNames(fieldNames.toArray(new String[fieldNames.size()]));
        for (String field : fieldNames) {
            filteredDocument.put(field, doc.getFieldValues(field));
        }
        try {
            return mlt.like(filteredDocument);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Bad Request");
        }
    }

    private SolrDocument getDocument(String id) {
        SolrCore core = this.req.getCore();
        SolrQueryResponse rsp = new SolrQueryResponse();
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.add("id", new String[]{id});
        SolrQueryRequestBase request = new SolrQueryRequestBase(core, (SolrParams)params){};
        core.getRequestHandler("/get").handleRequest(request, rsp);
        NamedList response = rsp.getValues();
        return (SolrDocument)response.get("doc");
    }
}

