/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.SlotAcc;

class SpecialSlotAcc
extends SlotAcc {
    SlotAcc collectAcc;
    SlotAcc[] otherAccs;
    int collectAccSlot;
    int otherAccsSlot;
    long count;

    public SpecialSlotAcc(FacetContext fcontext, SlotAcc collectAcc, int collectAccSlot, SlotAcc[] otherAccs, int otherAccsSlot) {
        super(fcontext);
        this.collectAcc = collectAcc;
        this.collectAccSlot = collectAccSlot;
        this.otherAccs = otherAccs;
        this.otherAccsSlot = otherAccsSlot;
    }

    public int getCollectAccSlot() {
        return this.collectAccSlot;
    }

    public int getOtherAccSlot() {
        return this.otherAccsSlot;
    }

    public long getSpecialCount() {
        return this.count;
    }

    @Override
    public void collect(int doc, int slot) throws IOException {
        assert (slot != this.collectAccSlot || slot < 0);
        ++this.count;
        if (this.collectAcc != null) {
            this.collectAcc.collect(doc, this.collectAccSlot);
        }
        if (this.otherAccs != null) {
            for (SlotAcc otherAcc : this.otherAccs) {
                otherAcc.collect(doc, this.otherAccsSlot);
            }
        }
    }

    @Override
    public int compare(int slotA, int slotB) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getValue(int slotNum) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setValues(SimpleOrderedMap<Object> bucket, int slotNum) throws IOException {
        if (this.collectAcc != null) {
            this.collectAcc.setValues(bucket, this.collectAccSlot);
        }
        if (this.otherAccs != null) {
            for (SlotAcc otherAcc : this.otherAccs) {
                otherAcc.setValues(bucket, this.otherAccsSlot);
            }
        }
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resize(SlotAcc.Resizer resizer) {
        if (this.collectAccSlot >= 0) {
            this.collectAccSlot = resizer.getNewSlot(this.collectAccSlot);
        }
    }
}

