/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.DoubleDocValues;
import org.apache.lucene.queries.function.valuesource.SortedSetFieldSource;
import org.apache.lucene.search.SortedSetSelector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueDouble;
import org.apache.solr.schema.DoubleValueFieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TrieField;

public class TrieDoubleField
extends TrieField
implements DoubleValueFieldType {
    public TrieDoubleField() {
        this.type = TrieField.TrieTypes.DOUBLE;
    }

    @Override
    protected ValueSource getSingleValueSource(SortedSetSelector.Type choice, SchemaField f) {
        return new SortedSetFieldSource(f.getName(), choice){

            public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
                1 thisAsSortedSetFieldSource = this;
                SortedSetDocValues sortedSet = DocValues.getSortedSet((LeafReader)readerContext.reader(), (String)this.field);
                final SortedDocValues view = SortedSetSelector.wrap((SortedSetDocValues)sortedSet, (SortedSetSelector.Type)this.selector);
                return new DoubleDocValues((ValueSource)thisAsSortedSetFieldSource){

                    public double doubleVal(int doc) {
                        BytesRef bytes = view.get(doc);
                        return NumericUtils.sortableLongToDouble((long)NumericUtils.prefixCodedToLong((BytesRef)bytes));
                    }

                    public boolean exists(int doc) {
                        return -1 != view.getOrd(doc);
                    }

                    public FunctionValues.ValueFiller getValueFiller() {
                        return new FunctionValues.ValueFiller(){
                            private final MutableValueDouble mval = new MutableValueDouble();

                            public MutableValue getValue() {
                                return this.mval;
                            }

                            public void fillValue(int doc) {
                                this.mval.exists = this.exists(doc);
                                this.mval.value = this.mval.exists ? this.doubleVal(doc) : 0.0;
                            }
                        };
                    }
                };
            }
        };
    }
}

