/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.highlight;

import java.io.IOException;
import java.text.BreakIterator;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.postingshighlight.DefaultPassageFormatter;
import org.apache.lucene.search.postingshighlight.Passage;
import org.apache.lucene.search.postingshighlight.PassageFormatter;
import org.apache.lucene.search.postingshighlight.PassageScorer;
import org.apache.lucene.search.postingshighlight.PostingsHighlighter;
import org.apache.lucene.search.postingshighlight.WholeBreakIterator;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.highlight.SolrHighlighter;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.plugin.PluginInfoInitialized;

public class PostingsSolrHighlighter
extends SolrHighlighter
implements PluginInfoInitialized {
    @Override
    public void init(PluginInfo info) {
    }

    @Override
    public NamedList<Object> doHighlighting(DocList docs, Query query, SolrQueryRequest req, String[] defaultFields) throws IOException {
        SolrParams params = req.getParams();
        if (!this.isHighlightingEnabled(params)) {
            return null;
        }
        SolrIndexSearcher searcher = req.getSearcher();
        int[] docIDs = this.toDocIDs(docs);
        String[] keys = this.getUniqueKeys(searcher, docIDs);
        String[] fieldNames = this.getHighlightFields(query, req, defaultFields);
        int[] maxPassages = new int[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            maxPassages[i] = params.getFieldInt(fieldNames[i], "hl.snippets", 1);
        }
        PostingsHighlighter highlighter = this.getHighlighter(req);
        Map snippets = highlighter.highlightFields(fieldNames, query, (IndexSearcher)searcher, docIDs, maxPassages);
        return this.encodeSnippets(keys, fieldNames, snippets);
    }

    protected PostingsHighlighter getHighlighter(SolrQueryRequest req) {
        return new SolrExtendedPostingsHighlighter(req);
    }

    protected NamedList<Object> encodeSnippets(String[] keys, String[] fieldNames, Map<String, String[]> snippets) {
        SimpleOrderedMap list = new SimpleOrderedMap();
        for (int i = 0; i < keys.length; ++i) {
            SimpleOrderedMap summary = new SimpleOrderedMap();
            for (String field : fieldNames) {
                String snippet = snippets.get(field)[i];
                if (snippet == null) {
                    summary.add(field, (Object)new String[0]);
                    continue;
                }
                summary.add(field, (Object)new String[]{snippet});
            }
            list.add(keys[i], (Object)summary);
        }
        return list;
    }

    protected int[] toDocIDs(DocList docs) {
        int[] docIDs = new int[docs.size()];
        DocIterator iterator = docs.iterator();
        for (int i = 0; i < docIDs.length; ++i) {
            if (!iterator.hasNext()) {
                throw new AssertionError();
            }
            docIDs[i] = iterator.nextDoc();
        }
        if (iterator.hasNext()) {
            throw new AssertionError();
        }
        return docIDs;
    }

    protected String[] getUniqueKeys(SolrIndexSearcher searcher, int[] docIDs) throws IOException {
        IndexSchema schema = searcher.getSchema();
        SchemaField keyField = schema.getUniqueKeyField();
        if (keyField != null) {
            Set<String> selector = Collections.singleton(keyField.getName());
            String[] uniqueKeys = new String[docIDs.length];
            for (int i = 0; i < docIDs.length; ++i) {
                String id;
                int docid = docIDs[i];
                Document doc = searcher.doc(docid, selector);
                uniqueKeys[i] = id = schema.printableUniqueKey(doc);
            }
            return uniqueKeys;
        }
        return new String[docIDs.length];
    }

    protected BreakIterator parseBreakIterator(String type, Locale locale) {
        if (type == null || "SENTENCE".equals(type)) {
            return BreakIterator.getSentenceInstance(locale);
        }
        if ("LINE".equals(type)) {
            return BreakIterator.getLineInstance(locale);
        }
        if ("WORD".equals(type)) {
            return BreakIterator.getWordInstance(locale);
        }
        if ("CHARACTER".equals(type)) {
            return BreakIterator.getCharacterInstance(locale);
        }
        if ("WHOLE".equals(type)) {
            return new WholeBreakIterator();
        }
        throw new IllegalArgumentException("Unknown hl.bs.type: " + type);
    }

    protected Locale parseLocale(String language, String country, String variant) {
        if (language == null && country == null && variant == null) {
            return Locale.ROOT;
        }
        if (language != null && country == null && variant != null) {
            throw new IllegalArgumentException("To specify variant, country is required");
        }
        if (language != null && country != null && variant != null) {
            return new Locale(language, country, variant);
        }
        if (language != null && country != null) {
            return new Locale(language, country);
        }
        return new Locale(language);
    }

    public class SolrExtendedPostingsHighlighter
    extends PostingsHighlighter {
        protected final SolrParams params;
        protected final IndexSchema schema;

        public SolrExtendedPostingsHighlighter(SolrQueryRequest req) {
            super(req.getParams().getInt("hl.maxAnalyzedChars", 10000));
            this.params = req.getParams();
            this.schema = req.getSchema();
        }

        protected Passage[] getEmptyHighlight(String fieldName, BreakIterator bi, int maxPassages) {
            boolean defaultSummary = this.params.getFieldBool(fieldName, "hl.defaultSummary", true);
            if (defaultSummary) {
                return super.getEmptyHighlight(fieldName, bi, maxPassages);
            }
            return new Passage[0];
        }

        protected PassageFormatter getFormatter(String fieldName) {
            String preTag = this.params.getFieldParam(fieldName, "hl.tag.pre", "<em>");
            String postTag = this.params.getFieldParam(fieldName, "hl.tag.post", "</em>");
            String ellipsis = this.params.getFieldParam(fieldName, "hl.tag.ellipsis", "... ");
            String encoder = this.params.getFieldParam(fieldName, "hl.encoder", "simple");
            return new DefaultPassageFormatter(preTag, postTag, ellipsis, "html".equals(encoder));
        }

        protected PassageScorer getScorer(String fieldName) {
            float k1 = this.params.getFieldFloat(fieldName, "hl.score.k1", 1.2f);
            float b = this.params.getFieldFloat(fieldName, "hl.score.b", 0.75f);
            float pivot = this.params.getFieldFloat(fieldName, "hl.score.pivot", 87.0f);
            return new PassageScorer(k1, b, pivot);
        }

        protected BreakIterator getBreakIterator(String field) {
            String language = this.params.getFieldParam(field, "hl.bs.language");
            String country = this.params.getFieldParam(field, "hl.bs.country");
            String variant = this.params.getFieldParam(field, "hl.bs.variant");
            Locale locale = PostingsSolrHighlighter.this.parseLocale(language, country, variant);
            String type = this.params.getFieldParam(field, "hl.bs.type");
            return PostingsSolrHighlighter.this.parseBreakIterator(type, locale);
        }

        protected char getMultiValuedSeparator(String field) {
            String sep = this.params.getFieldParam(field, "hl.multiValuedSeparatorChar", " ");
            if (sep.length() != 1) {
                throw new IllegalArgumentException("hl.multiValuedSeparatorChar must be exactly one character.");
            }
            return sep.charAt(0);
        }

        protected Analyzer getIndexAnalyzer(String field) {
            if (this.params.getFieldBool(field, "hl.highlightMultiTerm", false)) {
                return this.schema.getIndexAnalyzer();
            }
            return null;
        }
    }
}

