/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.rule;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.BinaryResponseParser;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.GenericSolrRequest;
import org.apache.solr.client.solrj.response.SimpleSolrResponse;
import org.apache.solr.cloud.rule.RemoteCallback;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.update.UpdateShardHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnitchContext
implements RemoteCallback {
    static final Logger log = LoggerFactory.getLogger(SnitchContext.class);
    private final Map<String, Object> tags = new HashMap<String, Object>();
    private String node;
    final SnitchInfo snitchInfo;
    Exception exception;

    SnitchContext(SnitchInfo perSnitch, String node) {
        this.snitchInfo = perSnitch;
        this.node = node;
    }

    public SnitchInfo getSnitchInfo() {
        return this.snitchInfo;
    }

    public Map<String, Object> getTags() {
        return this.tags;
    }

    public String getNode() {
        return this.node;
    }

    public void invokeRemote(String node, ModifiableSolrParams params, String klas, RemoteCallback callback) {
        if (callback == null) {
            callback = this;
        }
        String url = this.snitchInfo.getCoreContainer().getZkController().getZkStateReader().getBaseUrlForNodeName(node);
        params.add("class", new String[]{klas});
        params.add("action", new String[]{CoreAdminParams.CoreAdminAction.INVOKE.toString()});
        try {
            SimpleSolrResponse rsp = this.invoke(this.snitchInfo.getCoreContainer().getUpdateShardHandler(), url, "/admin/cores", (SolrParams)params);
            Map returnedVal = (Map)rsp.getResponse().get(klas);
            if (this.exception != null) {
                callback.remoteCallback(this, returnedVal);
            }
            callback.remoteCallback(this, returnedVal);
        }
        catch (Exception e) {
            log.error("Unable to invoke snitch counterpart", (Throwable)e);
            this.exception = e;
        }
    }

    public SimpleSolrResponse invoke(UpdateShardHandler shardHandler, String url, String path, SolrParams params) throws IOException, SolrServerException {
        GenericSolrRequest request = new GenericSolrRequest(SolrRequest.METHOD.GET, path, params);
        try (HttpSolrClient client = new HttpSolrClient(url, shardHandler.getHttpClient(), (ResponseParser)new BinaryResponseParser());){
            NamedList rsp;
            request.response.nl = rsp = client.request((SolrRequest)request);
            SimpleSolrResponse simpleSolrResponse = request.response;
            return simpleSolrResponse;
        }
    }

    @Override
    public void remoteCallback(SnitchContext ctx, Map<String, Object> returnedVal) {
        this.tags.putAll(returnedVal);
    }

    public String getErrMsg() {
        return this.exception == null ? null : this.exception.getMessage();
    }

    public static abstract class SnitchInfo {
        private final Map<String, Object> conf;

        SnitchInfo(Map<String, Object> conf) {
            this.conf = conf;
        }

        public abstract Set<String> getTagNames();

        public abstract CoreContainer getCoreContainer();
    }
}

