/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.statistics;

import java.io.IOException;
import java.util.Locale;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.solr.analytics.statistics.StatsCollector;

public class MinMaxStatsCollector
implements StatsCollector {
    protected long missingCount = 0L;
    protected long valueCount = 0L;
    protected MutableValue max;
    protected MutableValue min;
    protected MutableValue value;
    protected final Set<String> statsList;
    protected final ValueSource source;
    protected FunctionValues function;
    protected FunctionValues.ValueFiller valueFiller;

    public MinMaxStatsCollector(ValueSource source, Set<String> statsList) {
        this.source = source;
        this.statsList = statsList;
    }

    @Override
    public void setNextReader(LeafReaderContext context) throws IOException {
        this.function = this.source.getValues(null, context);
        this.valueFiller = this.function.getValueFiller();
        this.value = this.valueFiller.getValue();
    }

    @Override
    public void collect(int doc) {
        this.valueFiller.fillValue(doc);
        if (this.value.exists) {
            ++this.valueCount;
            if (this.max == null) {
                this.max = this.value.duplicate();
            } else if (!this.max.exists || this.value.compareTo(this.max) > 0) {
                this.max.copy(this.value);
            }
            if (this.min == null) {
                this.min = this.value.duplicate();
            } else if (!this.min.exists || this.value.compareTo(this.min) < 0) {
                this.min.copy(this.value);
            }
        } else {
            ++this.missingCount;
        }
    }

    public String toString() {
        return String.format(Locale.ROOT, "<min=%s max=%s c=%d m=%d>", this.min, this.max, this.valueCount, this.missingCount);
    }

    @Override
    public Comparable getStat(String stat) {
        if (stat.equals("min") && this.min != null) {
            return (Comparable)this.min.toObject();
        }
        if (stat.equals("max") && this.max != null) {
            return (Comparable)this.max.toObject();
        }
        if (stat.equals("count")) {
            return new Long(this.valueCount);
        }
        if (stat.equals("missing")) {
            return new Long(this.missingCount);
        }
        return null;
    }

    @Override
    public Set<String> getStatsList() {
        return this.statsList;
    }

    @Override
    public void compute() {
    }

    @Override
    public MutableValue getValue() {
        return this.value;
    }

    @Override
    public FunctionValues getFunction() {
        return this.function;
    }

    @Override
    public String valueSourceString() {
        return this.source.toString();
    }

    public String statString(String stat) {
        return stat + "(" + this.valueSourceString() + ")";
    }
}

