/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pkg;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.StreamingNotSupportedException;
import org.apache.commons.compress.archivers.ar.ArArchiveInputStream;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.apache.commons.compress.archivers.dump.DumpArchiveInputStream;
import org.apache.commons.compress.archivers.jar.JarArchiveInputStream;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.ParsingEmbeddedDocumentExtractor;
import org.apache.tika.io.CloseShieldInputStream;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class PackageParser
extends AbstractParser {
    private static final long serialVersionUID = -5331043266963888708L;
    private static final MediaType ZIP = MediaType.APPLICATION_ZIP;
    private static final MediaType JAR = MediaType.application((String)"java-archive");
    private static final MediaType AR = MediaType.application((String)"x-archive");
    private static final MediaType CPIO = MediaType.application((String)"x-cpio");
    private static final MediaType DUMP = MediaType.application((String)"x-tika-unix-dump");
    private static final MediaType TAR = MediaType.application((String)"x-tar");
    private static final MediaType SEVENZ = MediaType.application((String)"x-7z-compressed");
    private static final Set<MediaType> SUPPORTED_TYPES = MediaType.set((MediaType[])new MediaType[]{ZIP, JAR, AR, CPIO, DUMP, TAR, SEVENZ});

    static MediaType getMediaType(ArchiveInputStream stream) {
        if (stream instanceof JarArchiveInputStream) {
            return JAR;
        }
        if (stream instanceof ZipArchiveInputStream) {
            return ZIP;
        }
        if (stream instanceof ArArchiveInputStream) {
            return AR;
        }
        if (stream instanceof CpioArchiveInputStream) {
            return CPIO;
        }
        if (stream instanceof DumpArchiveInputStream) {
            return DUMP;
        }
        if (stream instanceof TarArchiveInputStream) {
            return TAR;
        }
        if (stream instanceof SevenZWrapper) {
            return SEVENZ;
        }
        return MediaType.OCTET_STREAM;
    }

    static boolean isZipArchive(MediaType type) {
        return type.equals((Object)ZIP) || type.equals((Object)JAR);
    }

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        if (!TikaInputStream.isTikaInputStream((InputStream)stream)) {
            stream = new BufferedInputStream(stream);
        }
        TemporaryResources tmp = new TemporaryResources();
        ArchiveInputStream ais = null;
        try {
            ArchiveStreamFactory factory = (ArchiveStreamFactory)context.get(ArchiveStreamFactory.class, (Object)new ArchiveStreamFactory());
            ais = factory.createArchiveInputStream((InputStream)new CloseShieldInputStream(stream));
        }
        catch (StreamingNotSupportedException sne) {
            if (sne.getFormat().equals("7z")) {
                stream.reset();
                TikaInputStream tstream = TikaInputStream.get((InputStream)stream, (TemporaryResources)tmp);
                ais = new SevenZWrapper(new SevenZFile(tstream.getFile()));
            }
            tmp.close();
            throw new TikaException("Unknown non-streaming format " + sne.getFormat(), (Throwable)sne);
        }
        catch (ArchiveException e) {
            tmp.close();
            throw new TikaException("Unable to unpack document stream", (Throwable)e);
        }
        MediaType type = PackageParser.getMediaType(ais);
        if (!type.equals((Object)MediaType.OCTET_STREAM)) {
            metadata.set("Content-Type", type.toString());
        }
        EmbeddedDocumentExtractor extractor = (EmbeddedDocumentExtractor)context.get(EmbeddedDocumentExtractor.class, (Object)new ParsingEmbeddedDocumentExtractor(context));
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        try {
            ArchiveEntry entry = ais.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory()) {
                    this.parseEntry(ais, entry, extractor, xhtml);
                }
                entry = ais.getNextEntry();
            }
        }
        finally {
            ais.close();
            tmp.close();
        }
        xhtml.endDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseEntry(ArchiveInputStream archive, ArchiveEntry entry, EmbeddedDocumentExtractor extractor, XHTMLContentHandler xhtml) throws SAXException, IOException, TikaException {
        String name = entry.getName();
        if (archive.canReadEntryData(entry)) {
            Metadata entrydata = new Metadata();
            entrydata.set(TikaCoreProperties.MODIFIED, entry.getLastModifiedDate());
            entrydata.set("Content-Length", Long.toString(entry.getSize()));
            if (name != null && name.length() > 0) {
                entrydata.set("resourceName", name);
                AttributesImpl attributes = new AttributesImpl();
                attributes.addAttribute("", "class", "class", "CDATA", "embedded");
                attributes.addAttribute("", "id", "id", "CDATA", name);
                xhtml.startElement("div", attributes);
                xhtml.endElement("div");
                entrydata.set("embeddedRelationshipId", name);
            }
            if (extractor.shouldParseEmbedded(entrydata)) {
                TemporaryResources tmp = new TemporaryResources();
                try {
                    TikaInputStream tis = TikaInputStream.get((InputStream)archive, (TemporaryResources)tmp);
                    extractor.parseEmbedded((InputStream)tis, (ContentHandler)xhtml, entrydata, true);
                }
                finally {
                    tmp.dispose();
                }
            }
        } else if (name != null && name.length() > 0) {
            xhtml.element("p", name);
        }
    }

    private static class SevenZWrapper
    extends ArchiveInputStream {
        private SevenZFile file;

        private SevenZWrapper(SevenZFile file) {
            this.file = file;
        }

        public int read() throws IOException {
            return this.file.read();
        }

        public int read(byte[] b) throws IOException {
            return this.file.read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.file.read(b, off, len);
        }

        public ArchiveEntry getNextEntry() throws IOException {
            return this.file.getNextEntry();
        }

        public void close() throws IOException {
            this.file.close();
        }
    }
}

