/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.Container;
import com.googlecode.mp4parser.DataSource;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Logger;

public abstract class AbstractBoxParser
implements BoxParser {
    private static Logger LOG = Logger.getLogger(AbstractBoxParser.class.getName());
    ThreadLocal<ByteBuffer> header = new ThreadLocal<ByteBuffer>(){

        @Override
        protected ByteBuffer initialValue() {
            return ByteBuffer.allocate(32);
        }
    };

    public abstract Box createBox(String var1, byte[] var2, String var3);

    public Box parseBox(DataSource byteChannel, Container parent) throws IOException {
        long contentSize;
        this.header.get().rewind().limit(8);
        int bytesRead = 0;
        while ((bytesRead += byteChannel.read(this.header.get())) != 8) {
            if (bytesRead >= 0) continue;
            throw new EOFException();
        }
        this.header.get().rewind();
        long size = IsoTypeReader.readUInt32(this.header.get());
        if (size < 8L && size > 1L) {
            LOG.severe("Plausibility check failed: size < 8 (size = " + size + "). Stop parsing!");
            return null;
        }
        String type = IsoTypeReader.read4cc(this.header.get());
        byte[] usertype = null;
        if (size == 1L) {
            this.header.get().limit(16);
            byteChannel.read(this.header.get());
            this.header.get().position(8);
            size = IsoTypeReader.readUInt64(this.header.get());
            contentSize = size - 16L;
        } else {
            if (size == 0L) {
                size = byteChannel.size() - byteChannel.position() - 8L;
                long contentSize2 = size - 8L;
                throw new RuntimeException("'" + type + "' with '" + (parent instanceof Box ? ((Box)((Object)parent)).getType() : "IsoFile") + "' as parent has length == 0. That's not supported");
            }
            contentSize = size - 8L;
        }
        if ("uuid".equals(type)) {
            this.header.get().limit(this.header.get().limit() + 16);
            byteChannel.read(this.header.get());
            usertype = new byte[16];
            int i = this.header.get().position() - 16;
            while (i < this.header.get().position()) {
                usertype[i - (this.header.get().position() - 16)] = this.header.get().get(i);
                ++i;
            }
            contentSize -= 16L;
        }
        Box box = this.createBox(type, usertype, parent instanceof Box ? ((Box)((Object)parent)).getType() : "");
        box.setParent(parent);
        this.header.get().rewind();
        box.parse(byteChannel, this.header.get(), contentSize, this);
        return box;
    }
}

