/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.rowset;

import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.util.TbSQLParser;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetListener;

public abstract class TbRowSet
implements RowSet {
    protected String url;
    protected String dataSourceName;
    protected String username;
    protected String password;
    protected int isolation;
    protected String command;
    protected boolean isClosed;
    protected boolean readOnly;
    protected boolean showDeleted;
    protected int maxFieldSize;
    protected int maxRows;
    protected boolean escapeProcessing;
    protected int queryTimeout;
    protected int rowsetType;
    protected int concurrency;
    protected int fetchDirection;
    protected int fetchSize;
    protected Vector<RowSetListener> listeners;
    protected Map<String, Class<?>> typeMap;
    private Vector<Integer> matchColumnIndexes;
    private Vector<String> matchColumnNames;
    protected Vector<Object> params;
    protected SQLWarning warnings;
    protected String[] paramNames;
    protected RowSetEvent rowsetEvent;
    static final int PARAM_NSTRING = 0;
    static final int PARAM_ASCII = 1;
    static final int PARAM_BINARY = 2;
    static final int PARAM_CHARACTER = 3;
    static final int PARAM_NCHARACTER = 4;
    static final int PARAM_BLOB = 5;
    static final int PARAM_CLOB = 6;
    static final int PARAM_NCLOB = 7;

    public TbRowSet() {
        this.initialize();
        this.listeners = new Vector();
        this.matchColumnIndexes = new Vector(10);
        this.matchColumnNames = new Vector(10);
        this.rowsetEvent = new RowSetEvent(this);
        this.isClosed = false;
    }

    @Override
    public void addRowSetListener(RowSetListener rowSetListener) {
        this.listeners.add(rowSetListener);
    }

    public void addWarning(SQLWarning sQLWarning) {
        if (this.warnings != null) {
            this.warnings.setNextWarning(sQLWarning);
        } else {
            this.warnings = sQLWarning;
        }
    }

    protected void checkMatchColumnIndexesExist() throws SQLException {
        if (this.matchColumnIndexes.size() == 0) {
            throw TbError.newSQLException(-90860);
        }
    }

    protected void checkMatchColumnNamesExist() throws SQLException {
        if (this.matchColumnNames.size() == 0) {
            throw TbError.newSQLException(-90861);
        }
    }

    private void checkParameterIndex(int n) throws SQLException {
        if (n < 1) {
            throw TbError.newSQLException(-90844, Integer.toString(n));
        }
    }

    @Override
    public synchronized void clearParameters() throws SQLException {
        this.params = null;
        this.params = new Vector();
    }

    @Override
    public synchronized void clearWarnings() {
        this.warnings = null;
    }

    @Override
    public abstract void execute() throws SQLException;

    int findParam(String string) throws SQLException {
        int n = 0;
        for (n = 0; n < this.paramNames.length && !this.paramNames[n].equals(string); ++n) {
        }
        if (n == this.paramNames.length) {
            throw TbError.newSQLException(-90845, string);
        }
        return n + 1;
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return this.concurrency;
    }

    @Override
    public String getDataSourceName() {
        return this.dataSourceName;
    }

    @Override
    public boolean getEscapeProcessing() {
        return this.escapeProcessing;
    }

    @Override
    public int getFetchDirection() {
        return this.fetchDirection;
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    public int[] getMatchColumnIndexes() throws SQLException {
        int[] nArray;
        if (this.matchColumnIndexes.size() == 0 && this.matchColumnNames.size() == 0) {
            throw TbError.newSQLException(-90860);
        }
        if (this.matchColumnNames.size() > 0) {
            String[] stringArray = this.getMatchColumnNames();
            int n = stringArray.length;
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = this.findColumn(stringArray[i]);
            }
        } else {
            int n = this.matchColumnIndexes.size();
            nArray = new int[n];
            int n2 = -1;
            for (int i = 0; i < n; ++i) {
                try {
                    n2 = this.matchColumnIndexes.get(i);
                }
                catch (Exception exception) {
                    throw TbError.newSQLException(-90840, exception.getMessage());
                }
                if (n2 <= 0) {
                    throw TbError.newSQLException(-90840);
                }
                nArray[i] = n2;
            }
        }
        return nArray;
    }

    public String[] getMatchColumnNames() throws SQLException {
        this.checkMatchColumnNamesExist();
        int n = this.matchColumnNames.size();
        String[] stringArray = new String[n];
        String string = null;
        for (int i = 0; i < n; ++i) {
            try {
                string = this.matchColumnNames.get(i);
            }
            catch (Exception exception) {
                throw TbError.newSQLException(-90841, exception.getMessage());
            }
            if (string == null || string.equals("")) {
                throw TbError.newSQLException(-90841);
            }
            stringArray[i] = string;
        }
        return stringArray;
    }

    @Override
    public int getMaxFieldSize() {
        return this.maxFieldSize;
    }

    @Override
    public int getMaxRows() {
        return this.maxRows;
    }

    public Object[] getParams() {
        if (this.params == null) {
            return new Object[0];
        }
        return this.params.toArray();
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public boolean getShowDeleted() throws SQLException {
        return this.showDeleted;
    }

    @Override
    public int getTransactionIsolation() {
        return this.isolation;
    }

    @Override
    public int getType() {
        return this.rowsetType;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() {
        return this.typeMap;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public SQLWarning getWarnings() {
        return this.warnings;
    }

    protected void initialize() {
        this.command = null;
        this.dataSourceName = null;
        this.dataSourceName = null;
        this.escapeProcessing = true;
        this.fetchSize = 0;
        this.maxFieldSize = 0;
        this.maxRows = 0;
        this.queryTimeout = 0;
        this.readOnly = true;
        this.showDeleted = false;
        this.username = null;
        this.password = null;
        this.url = null;
        this.fetchDirection = 1002;
        this.rowsetType = 1005;
        this.concurrency = 1007;
        this.isolation = 2;
        this.params = new Vector();
        this.typeMap = new HashMap();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isShowDeleted() {
        return this.showDeleted;
    }

    protected void notifyCursorMoved() {
        Iterator<RowSetListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().cursorMoved(this.rowsetEvent);
        }
    }

    protected void notifyRowChanged() {
        Iterator<RowSetListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().rowChanged(this.rowsetEvent);
        }
    }

    protected void notifyRowSetChanged() {
        Iterator<RowSetListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().rowSetChanged(this.rowsetEvent);
        }
    }

    @Override
    public void removeRowSetListener(RowSetListener rowSetListener) {
        this.listeners.remove(rowSetListener);
    }

    @Override
    public void setArray(int n, Array array) throws SQLException {
        this.checkParameterIndex(n);
        this.params.add(n - 1, array);
    }

    public void setArray(String string, Array array) throws SQLException {
        this.setArray(this.findParam(string), array);
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.checkParameterIndex(n);
        Object[] objectArray = new Object[]{inputStream, new Integer(Integer.MAX_VALUE), new Integer(1)};
        this.params.add(n - 1, objectArray);
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkParameterIndex(n);
        Object[] objectArray = new Object[]{inputStream, new Integer(n2), new Integer(1)};
        this.params.add(n - 1, objectArray);
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream) throws SQLException {
        this.setAsciiStream(this.findParam(string), inputStream);
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.setAsciiStream(this.findParam(string), inputStream, n);
    }

    @Override
    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.checkParameterIndex(n);
        this.params.add(n - 1, bigDecimal);
    }

    @Override
    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.setBigDecimal(this.findParam(string), bigDecimal);
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.checkParameterIndex(n);
        Object[] objectArray = new Object[]{inputStream, new Integer(Integer.MAX_VALUE), new Integer(2)};
        this.params.add(n - 1, objectArray);
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkParameterIndex(n);
        Object[] objectArray = new Object[]{inputStream, new Integer(n2), new Integer(2)};
        this.params.add(n - 1, objectArray);
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream) throws SQLException {
        this.setBinaryStream(this.findParam(string), inputStream);
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.setBinaryStream(this.findParam(string), inputStream, n);
    }

    @Override
    public void setBlob(int n, Blob blob) throws SQLException {
        this.checkParameterIndex(n);
        this.params.add(n - 1, blob);
    }

    @Override
    public void setBlob(int n, InputStream inputStream) throws SQLException {
        this.checkParameterIndex(n);
        Object[] objectArray = new Object[]{inputStream, new Integer(Integer.MAX_VALUE), new Integer(5)};
        this.params.add(n - 1, objectArray);
    }

    @Override
    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        this.checkParameterIndex(n);
        Object[] objectArray = new Object[]{inputStream, new Long(l), new Integer(5)};
        this.params.add(n - 1, objectArray);
    }

    @Override
    public void setBlob(String string, Blob blob) throws SQLException {
        this.setBlob(this.findParam(string), blob);
    }

    @Override
    public void setBlob(String string, InputStream inputStream) throws SQLException {
        this.setBlob(this.findParam(string), inputStream);
    }

    @Override
    public void setBlob(String string, InputStream inputStream, long l) throws SQLException {
        this.setBlob(this.findParam(string), inputStream, l);
    }

    @Override
    public void setBoolean(int n, boolean bl) throws SQLException {
        this.checkParameterIndex(n);
        this.params.add(n - 1, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setBoolean(String string, boolean bl) throws SQLException {
        this.setBoolean(this.findParam(string), bl);
    }

    @Override
    public void setByte(int n, byte by) throws SQLException {
        this.checkParameterIndex(n);
        this.params.add(n - 1, new Byte(by));
    }

    @Override
    public void setByte(String string, byte by) throws SQLException {
        this.setByte(this.findParam(string), by);
    }

    @Override
    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.checkParameterIndex(n);
        this.params.add(n - 1, byArray);
    }

    @Override
    public void setBytes(String string, byte[] byArray) throws SQLException {
        this.setBytes(this.findParam(string), byArray);
    }

    @Override
    public void setCharacterStream(int n, Reader reader) throws SQLException {
        this.checkParameterIndex(n);
        Object[] objectArray = new Object[]{reader, new Integer(Integer.MAX_VALUE), new Integer(3)};
        this.params.add(n - 1, objectArray);
    }

    @Override
    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.checkParameterIndex(n);
        Object[] objectArray = new Object[]{reader, new Integer(n2), new Integer(3)};
        this.params.add(n - 1, objectArray);
    }

    @Override
    public void setCharacterStream(String string, Reader reader) throws SQLException {
        this.setCharacterStream(this.findParam(string), reader);
    }

    @Override
    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.setCharacterStream(this.findParam(string), reader, n);
    }

    @Override
    public void setClob(int n, Clob clob) throws SQLException {
        this.checkParameterIndex(n);
        this.params.add(n - 1, clob);
    }

    @Override
    public void setClob(int n, Reader reader) throws SQLException {
        this.checkParameterIndex(n);
        Object[] objectArray = new Object[]{reader, new Integer(Integer.MAX_VALUE), new Integer(6)};
        this.params.add(n - 1, objectArray);
    }

    @Override
    public void setClob(int n, Reader reader, long l) throws SQLException {
        this.checkParameterIndex(n);
        Object[] objectArray = new Object[]{reader, new Long(l), new Integer(6)};
        this.params.add(n - 1, objectArray);
    }

    @Override
    public void setClob(String string, Clob clob) throws SQLException {
        this.setClob(this.findParam(string), clob);
    }

    @Override
    public void setClob(String string, Reader reader) throws SQLException {
        this.setClob(this.findParam(string), reader);
    }

    @Override
    public void setClob(String string, Reader reader, long l) throws SQLException {
        this.setClob(this.findParam(string), reader, l);
    }

    @Override
    public void setCommand(String string) throws SQLException {
        this.command = string;
        this.paramNames = TbSQLParser.getParamNames(this.command);
    }

    @Override
    public void setConcurrency(int n) throws SQLException {
        switch (n) {
            case 1007: 
            case 1008: {
                this.concurrency = n;
                return;
            }
        }
        throw TbError.newSQLException(-90608);
    }

    @Override
    public void setDataSourceName(String string) throws SQLException {
        this.dataSourceName = string;
    }

    @Override
    public void setDate(int n, Date date) throws SQLException {
        this.checkParameterIndex(n);
        this.params.add(n - 1, date);
    }

    @Override
    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.checkParameterIndex(n);
        Object[] objectArray = new Object[]{date, calendar};
        this.params.add(n - 1, objectArray);
    }

    @Override
    public void setDate(String string, Date date) throws SQLException {
        this.setDate(this.findParam(string), date);
    }

    @Override
    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        this.setDate(this.findParam(string), date, calendar);
    }

    @Override
    public void setDouble(int n, double d) throws SQLException {
        this.checkParameterIndex(n);
        this.params.add(n - 1, new Double(d));
    }

    @Override
    public void setDouble(String string, double d) throws SQLException {
        this.setDouble(this.findParam(string), d);
    }

    @Override
    public void setEscapeProcessing(boolean bl) {
        this.escapeProcessing = bl;
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        this.fetchDirection = n;
    }

    @Override
    public void setFetchSize(int n) {
        this.fetchSize = n;
    }

    @Override
    public void setFloat(int n, float f) throws SQLException {
        this.checkParameterIndex(n);
        this.params.add(n - 1, new Float(f));
    }

    @Override
    public void setFloat(String string, float f) throws SQLException {
        this.setFloat(this.findParam(string), f);
    }

    @Override
    public void setInt(int n, int n2) throws SQLException {
        this.checkParameterIndex(n);
        this.params.add(n - 1, new Integer(n2));
    }

    @Override
    public void setInt(String string, int n) throws SQLException {
        this.setInt(this.findParam(string), n);
    }

    @Override
    public void setLong(int n, long l) throws SQLException {
        this.checkParameterIndex(n);
        this.params.add(n - 1, new Long(l));
    }

    @Override
    public void setLong(String string, long l) throws SQLException {
        this.setLong(this.findParam(string), l);
    }

    public void setMatchColumn(int n) throws SQLException {
        if (n <= 0) {
            throw TbError.newSQLException(-90840);
        }
        try {
            this.matchColumnIndexes.clear();
            this.matchColumnNames.clear();
            this.matchColumnIndexes.add(0, new Integer(n));
        }
        catch (Exception exception) {
            throw TbError.newSQLException(-90832);
        }
    }

    public void setMatchColumn(int[] nArray) throws SQLException {
        this.matchColumnIndexes.clear();
        this.matchColumnNames.clear();
        if (nArray == null) {
            throw TbError.newSQLException(-590762);
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= 0) {
                throw TbError.newSQLException(-90840);
            }
            try {
                this.matchColumnIndexes.add(i, new Integer(nArray[i]));
                continue;
            }
            catch (Exception exception) {
                throw TbError.newSQLException(-90832);
            }
        }
    }

    public void setMatchColumn(String string) throws SQLException {
        if (string == null || string.equals("")) {
            throw TbError.newSQLException(-90841);
        }
        try {
            this.matchColumnIndexes.clear();
            this.matchColumnNames.clear();
            this.matchColumnNames.add(0, string.trim());
        }
        catch (Exception exception) {
            throw TbError.newSQLException(-90833);
        }
    }

    public void setMatchColumn(String[] stringArray) throws SQLException {
        this.matchColumnIndexes.clear();
        this.matchColumnNames.clear();
        if (stringArray == null) {
            throw TbError.newSQLException(-590763);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || stringArray[i].equals("")) {
                throw TbError.newSQLException(-90841);
            }
            try {
                this.matchColumnNames.add(i, stringArray[i].trim());
                continue;
            }
            catch (Exception exception) {
                throw TbError.newSQLException(-90833);
            }
        }
    }

    @Override
    public void setMaxFieldSize(int n) {
        this.maxFieldSize = n;
    }

    @Override
    public void setMaxRows(int n) {
        this.maxRows = n;
    }

    @Override
    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        this.checkParameterIndex(n);
        Object[] objectArray = new Object[]{reader, new Integer(Integer.MAX_VALUE), new Integer(4)};
        this.params.add(n - 1, objectArray);
    }

    @Override
    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.checkParameterIndex(n);
        Object[] objectArray = new Object[]{reader, new Long(l), new Integer(4)};
        this.params.add(n - 1, objectArray);
    }

    @Override
    public void setNCharacterStream(String string, Reader reader) throws SQLException {
        this.setNCharacterStream(this.findParam(string), reader);
    }

    @Override
    public void setNCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.setNCharacterStream(this.findParam(string), reader, l);
    }

    @Override
    public void setNClob(int n, NClob nClob) throws SQLException {
        this.checkParameterIndex(n);
        this.params.add(n - 1, nClob);
    }

    @Override
    public void setNClob(int n, Reader reader) throws SQLException {
        this.checkParameterIndex(n);
        Object[] objectArray = new Object[]{reader, new Integer(Integer.MAX_VALUE), new Integer(7)};
        this.params.add(n - 1, objectArray);
    }

    @Override
    public void setNClob(int n, Reader reader, long l) throws SQLException {
        this.checkParameterIndex(n);
        Object[] objectArray = new Object[]{reader, new Long(l), new Integer(7)};
        this.params.add(n - 1, objectArray);
    }

    @Override
    public void setNClob(String string, NClob nClob) throws SQLException {
        this.setNClob(this.findParam(string), nClob);
    }

    @Override
    public void setNClob(String string, Reader reader) throws SQLException {
        this.setNClob(this.findParam(string), reader);
    }

    @Override
    public void setNClob(String string, Reader reader, long l) throws SQLException {
        this.setNClob(this.findParam(string), reader, l);
    }

    @Override
    public void setNString(int n, String string) throws SQLException {
        this.checkParameterIndex(n);
        Object[] objectArray = new Object[]{string, new Integer(0)};
        this.params.add(n - 1, objectArray);
    }

    @Override
    public void setNString(String string, String string2) throws SQLException {
        this.setNString(this.findParam(string), string2);
    }

    @Override
    public void setNull(int n, int n2) throws SQLException {
        this.checkParameterIndex(n);
        this.params.add(n - 1, null);
    }

    @Override
    public void setNull(int n, int n2, String string) throws SQLException {
        this.checkParameterIndex(n);
        Object[] objectArray = new Object[]{new Integer(n2), string};
        this.params.add(n - 1, objectArray);
    }

    @Override
    public void setNull(String string, int n) throws SQLException {
        this.setNull(this.findParam(string), n);
    }

    @Override
    public void setNull(String string, int n, String string2) throws SQLException {
        this.setNull(this.findParam(string), n, string2);
    }

    @Override
    public void setObject(int n, Object object) throws SQLException {
        this.checkParameterIndex(n);
        this.params.add(n - 1, object);
    }

    @Override
    public void setObject(int n, Object object, int n2) throws SQLException {
        this.checkParameterIndex(n);
        Object[] objectArray = new Object[]{object, new Integer(n2)};
        this.params.add(n - 1, objectArray);
    }

    @Override
    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.checkParameterIndex(n);
        Object[] objectArray = new Object[]{object, new Integer(n2), new Integer(n3)};
        this.params.add(n - 1, objectArray);
    }

    @Override
    public void setObject(String string, Object object) throws SQLException {
        this.setObject(this.findParam(string), object);
    }

    @Override
    public void setObject(String string, Object object, int n) throws SQLException {
        this.setObject(this.findParam(string), object, n);
    }

    @Override
    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        this.setObject(this.findParam(string), object, n, n2);
    }

    @Override
    public void setPassword(String string) {
        this.password = string;
    }

    @Override
    public void setQueryTimeout(int n) {
        this.queryTimeout = n;
    }

    @Override
    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    @Override
    public void setRef(int n, Ref ref) throws SQLException {
        this.checkParameterIndex(n);
        this.params.add(n - 1, ref);
    }

    public void setRef(String string, Ref ref) throws SQLException {
        this.setRef(this.findParam(string), ref);
    }

    @Override
    public void setRowId(int n, RowId rowId) throws SQLException {
        this.checkParameterIndex(n);
        this.params.add(n - 1, rowId);
    }

    @Override
    public void setRowId(String string, RowId rowId) throws SQLException {
        this.setRowId(this.findParam(string), rowId);
    }

    @Override
    public void setShort(int n, short s) throws SQLException {
        this.checkParameterIndex(n);
        this.params.add(n - 1, new Short(s));
    }

    @Override
    public void setShort(String string, short s) throws SQLException {
        this.setShort(this.findParam(string), s);
    }

    public void setShowDeleted(boolean bl) throws SQLException {
        this.showDeleted = bl;
    }

    @Override
    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
        this.checkParameterIndex(n);
        this.params.add(n - 1, sQLXML);
    }

    @Override
    public void setSQLXML(String string, SQLXML sQLXML) throws SQLException {
        this.setSQLXML(this.findParam(string), sQLXML);
    }

    @Override
    public void setString(int n, String string) throws SQLException {
        this.checkParameterIndex(n);
        this.params.add(n - 1, string);
    }

    @Override
    public void setString(String string, String string2) throws SQLException {
        this.setString(this.findParam(string), string2);
    }

    @Override
    public void setTime(int n, Time time) throws SQLException {
        this.checkParameterIndex(n);
        this.params.add(n - 1, time);
    }

    @Override
    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.checkParameterIndex(n);
        Object[] objectArray = new Object[]{time, calendar};
        this.params.add(n - 1, objectArray);
    }

    @Override
    public void setTime(String string, Time time) throws SQLException {
        this.setTime(this.findParam(string), time);
    }

    @Override
    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        this.setTime(this.findParam(string), time);
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.checkParameterIndex(n);
        this.params.add(n - 1, timestamp);
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.checkParameterIndex(n);
        Object[] objectArray = new Object[]{timestamp, calendar};
        this.params.add(n - 1, objectArray);
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.setTimestamp(this.findParam(string), timestamp);
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setTimestamp(this.findParam(string), timestamp, calendar);
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        switch (n) {
            case 2: 
            case 8: {
                this.isolation = n;
                break;
            }
            default: {
                throw TbError.newSQLException(-90608);
            }
        }
    }

    @Override
    public void setType(int n) throws SQLException {
        switch (n) {
            case 1003: 
            case 1004: 
            case 1005: {
                this.rowsetType = n;
                break;
            }
            default: {
                throw TbError.newSQLException(-90608);
            }
        }
    }

    public void setTypeMap(Map map) {
        this.typeMap = map;
    }

    @Override
    public void setUrl(String string) {
        this.url = string;
    }

    @Override
    public void setURL(int n, URL uRL) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public void setURL(String string, URL uRL) throws SQLException {
        this.setURL(this.findParam(string), uRL);
    }

    @Override
    public void setUsername(String string) {
        this.username = string;
    }

    public void unsetMatchColumn(int n) throws SQLException {
        this.checkMatchColumnIndexesExist();
        if (n <= 0) {
            throw TbError.newSQLException(-90840);
        }
        int n2 = -1;
        try {
            n2 = this.matchColumnIndexes.get(0);
        }
        catch (Exception exception) {
            throw TbError.newSQLException(-90860);
        }
        if (n2 != n) {
            throw TbError.newSQLException(-90866);
        }
        this.matchColumnIndexes.clear();
        this.matchColumnNames.clear();
    }

    public void unsetMatchColumn(int[] nArray) throws SQLException {
        this.checkMatchColumnIndexesExist();
        if (nArray == null) {
            throw TbError.newSQLException(-590762);
        }
        int n = -1;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= 0) {
                throw TbError.newSQLException(-90840);
            }
            try {
                n = this.matchColumnIndexes.get(i);
            }
            catch (Exception exception) {
                throw TbError.newSQLException(-90860);
            }
            if (n == nArray[i]) continue;
            throw TbError.newSQLException(-90866);
        }
        this.matchColumnIndexes.clear();
        this.matchColumnNames.clear();
    }

    public void unsetMatchColumn(String string) throws SQLException {
        this.checkMatchColumnNamesExist();
        if (string == null || string.equals("")) {
            throw TbError.newSQLException(-90841);
        }
        String string2 = null;
        try {
            string2 = this.matchColumnNames.get(0);
        }
        catch (Exception exception) {
            throw TbError.newSQLException(-90861);
        }
        if (!string2.equals(string.trim())) {
            throw TbError.newSQLException(-90867);
        }
        this.matchColumnIndexes.clear();
        this.matchColumnNames.clear();
    }

    public void unsetMatchColumn(String[] stringArray) throws SQLException {
        this.checkMatchColumnNamesExist();
        if (stringArray == null) {
            throw TbError.newSQLException(-590763);
        }
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || stringArray[i].equals("")) {
                throw TbError.newSQLException(-90841);
            }
            try {
                string = this.matchColumnNames.get(i);
            }
            catch (Exception exception) {
                throw TbError.newSQLException(-90861);
            }
            if (string.equals(stringArray[i])) continue;
            throw TbError.newSQLException(-90867);
        }
        this.matchColumnIndexes.clear();
        this.matchColumnNames.clear();
    }
}

