/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.driver;

import com.tmax.tibero.jdbc.TbArrayDescriptor;
import com.tmax.tibero.jdbc.TbNClob;
import com.tmax.tibero.jdbc.TbSQLXML;
import com.tmax.tibero.jdbc.TbTypeDescriptor;
import com.tmax.tibero.jdbc.data.Column;
import com.tmax.tibero.jdbc.data.DataType;
import com.tmax.tibero.jdbc.data.DataTypeConverter;
import com.tmax.tibero.jdbc.data.Row;
import com.tmax.tibero.jdbc.data.ServerInfo;
import com.tmax.tibero.jdbc.data.TbDate;
import com.tmax.tibero.jdbc.data.TbTimestamp;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.driver.TbResultSet;
import com.tmax.tibero.jdbc.driver.TbResultSetMetaData;
import com.tmax.tibero.jdbc.driver.TbStatement;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.util.TbCommon;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public abstract class TbResultSetBase
extends TbResultSet {
    public static final int EMPTY_CURSOR_ID = -1;
    public static final int EMPTY_RSET = -2;
    private static final long CRC_POLY = 79764919L;
    protected TbStatement stmt;
    protected int csrID = -1;
    protected DataTypeConverter typeConverter;
    protected int columnCount = -1;
    protected Column[] cols;
    protected HashMap<String, Integer> columnNameMap;
    protected int beginColumnIndex = 0;
    protected int currentRowIndex = -1;
    protected int currentFetchCount = 0;
    protected int fetchDirection = 1000;
    protected int fetchSize = 50;
    protected boolean lastColumnWasNull = false;
    protected byte[] rowChunk;
    protected boolean fetchComplete = false;
    protected boolean isRsetClosed = false;
    protected boolean isSvrCsrClosed = false;
    private boolean closeStatementOnClose = false;
    private int preparedFetchCnt = 0;
    private boolean mapDateToTimestamp = true;
    private boolean foCsrEnabled = false;
    private int foECode = 0;
    protected static final long[] CRC_TBL = new long[256];

    protected TbResultSetBase(TbStatement tbStatement, int n, int n2, int n3, byte[] byArray) throws SQLException {
        super(tbStatement.getRealRsetType());
        this.stmt = tbStatement;
        this.csrID = n;
        this.typeConverter = tbStatement.conn.getTypeConverter();
        this.columnCount = n2 + n3;
        this.fetchDirection = tbStatement.getFetchDirection();
        this.fetchSize = tbStatement.getFetchSize();
        this.closeStatementOnClose = false;
        this.foCsrEnabled = tbStatement.conn.info.isFailoverCursorEnabled();
        if (tbStatement.getRealRsetType() != null) {
            this.beginColumnIndex = n3 + (tbStatement.getRealRsetType().useRowId() ? 1 : 0);
        }
        this.makeColumnMetaArray(this.columnCount);
        this.rowChunk = byArray;
    }

    private void buildColumnNameMap() {
        this.columnNameMap = new HashMap();
        for (int i = this.getColumnCount() - 1; i >= 0; --i) {
            this.columnNameMap.put(this.cols[i + this.beginColumnIndex].getName().toUpperCase(), new Integer(i + 1));
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    void checkColumnIndex(int n) throws SQLException {
        int n2 = this.getColumnCount();
        if (n2 < 0) {
            throw TbError.newSQLException(-90607);
        }
        if (n <= 0 || n > n2) {
            throw TbError.newSQLException(-90609);
        }
    }

    protected void checkRsetAndConnClosed() throws SQLException {
        if (this.csrID == -1) {
            throw TbError.newSQLException(-90607);
        }
        if (this.isRsetClosed) {
            throw TbError.newSQLException(-90646);
        }
        if (this.isSvrCsrClosed) {
            throw TbError.newSQLException(-90647);
        }
        if (this.stmt.conn == null || this.stmt.conn.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        if (this.foECode != 0) {
            if (this.isFoCsrEnabled() && this.foECode == -90700) {
                this.recover();
                this.addWarning(TbError.newSQLWarning(-590786));
            } else {
                int n = this.foECode;
                this.reset();
                this.isRsetClosed = true;
                throw TbError.newSQLException(-90646, TbError.getMsg(n));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SQLException {
        if (this.isRsetClosed) {
            return;
        }
        try {
            this.closeCursor();
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.reset();
            this.isRsetClosed = true;
            if (this.closeStatementOnClose) {
                try {
                    this.stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public synchronized void closeCursor() throws SQLException {
        if (this.isSvrCsrClosed) {
            return;
        }
        TbConnection tbConnection = (TbConnection)this.stmt.getConnection();
        ServerInfo serverInfo = tbConnection.getServerInfo();
        if (serverInfo != null) {
            boolean bl = this.fetchComplete;
            int n = serverInfo.getProtocolMajorVersion();
            int n2 = serverInfo.getProtocolMinorVersion();
            if (n > 2 || n == 2 && n2 < 3) {
                bl &= !this.haveLocator;
            }
            if (!(this.stmt == null || bl || !tbConnection.isPooledConnection && tbConnection.isSessionClosed())) {
                tbConnection.closeCursor(this, this.csrID);
            }
        }
        tbConnection.removeFOActiveResultSet(this);
        this.isSvrCsrClosed = true;
    }

    public void closeStatementOnClose() {
        this.closeStatementOnClose = true;
    }

    @Override
    public void deleteRow() throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    protected void fetchRowsChunk() throws SQLException {
        try {
            if (this.isFoCsrEnabled() && this.foECode == -90700) {
                this.recover();
                this.addWarning(TbError.newSQLWarning(-590786));
            } else if (this.foECode != 0) {
                int n = this.foECode;
                this.reset();
                this.isRsetClosed = true;
                throw TbError.newSQLException(-90646, TbError.getMsg(n));
            }
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == -90700) {
                this.recover();
                this.addWarning(TbError.newSQLWarning(-590786));
            }
            throw sQLException;
        }
        try {
            this.stmt.fetch(this);
        }
        catch (SQLException sQLException) {
            if (this.isFoCsrEnabled() && sQLException.getErrorCode() == -90700) {
                this.recover();
                this.addWarning(TbError.newSQLWarning(-590786));
                this.stmt.fetch(this);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized int findColumn(String string) throws SQLException {
        return this.getColumnPosByName(string);
    }

    @Override
    public Array getArray(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        TbTypeDescriptor tbTypeDescriptor = this.getColumnTypeDescriptor(n);
        TbArrayDescriptor tbArrayDescriptor = tbTypeDescriptor instanceof TbArrayDescriptor ? (TbArrayDescriptor)tbTypeDescriptor : null;
        return this.typeConverter.toArray(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n), !this.getRsetType().isScrollable(), tbArrayDescriptor, this.stmt.conn.getTypeMap());
    }

    @Override
    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    @Override
    public synchronized InputStream getAsciiStream(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        return this.typeConverter.toAsciiStream(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n));
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public int getBeginColumnIndex() {
        return this.beginColumnIndex;
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        return this.typeConverter.toBigDecimal(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n));
    }

    @Override
    @Deprecated
    public synchronized BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this.getBigDecimal(n);
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    @Override
    public synchronized InputStream getBinaryStream(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        return this.typeConverter.toBinaryStream(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n));
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        return this.typeConverter.toBlob(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n), !this.stmt.getRealRsetType().isScrollable());
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    @Override
    public synchronized boolean getBoolean(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return false;
        }
        return this.typeConverter.toBoolean(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n));
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    @Override
    public synchronized byte getByte(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return 0;
        }
        return this.typeConverter.toByte(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n));
    }

    @Override
    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    @Override
    public synchronized byte[] getBytes(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        return this.typeConverter.toBytes(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n), !this.stmt.getRealRsetType().isScrollable());
    }

    @Override
    public synchronized int getBytes(int n, byte[] byArray) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            byArray[0] = 0;
            return 0;
        }
        return this.typeConverter.toBytes(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n), byArray);
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    @Override
    public synchronized Reader getCharacterStream(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        return this.typeConverter.toCharacterStream(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n));
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        return this.typeConverter.toClob(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n), !this.stmt.getRealRsetType().isScrollable());
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    @Override
    public Column[] getCols() {
        return this.cols;
    }

    int getColumnCount() {
        return this.columnCount - this.beginColumnIndex;
    }

    @Override
    protected int getColumnDataType(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.cols[n + this.beginColumnIndex - 1].getDataType();
    }

    protected TbTypeDescriptor getColumnTypeDescriptor(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.cols[n + this.beginColumnIndex - 1].getDescriptor();
    }

    private int getColumnLength(Row row, int n) {
        return row.getColumnLength(n + this.beginColumnIndex);
    }

    @Override
    protected int getColumnMaxLength(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.cols[n + this.beginColumnIndex - 1].getMaxLength();
    }

    @Override
    protected String getColumnName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.cols[n + this.beginColumnIndex - 1].getName();
    }

    @Override
    protected boolean getColumnNullable(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.cols[n + this.beginColumnIndex - 1].isNullable();
    }

    private int getColumnOffset(Row row, int n) {
        return row.getColumnOffset(n + this.beginColumnIndex);
    }

    private int getColumnPosByName(String string) throws SQLException {
        Integer n;
        if (this.cols == null || this.getColumnCount() == 0) {
            throw TbError.newSQLException(-90607);
        }
        if (this.columnNameMap == null) {
            this.buildColumnNameMap();
        }
        if ((n = this.columnNameMap.get(string != null ? string.toUpperCase() : "")) == null) {
            throw TbError.newSQLException(-90611, string);
        }
        return n;
    }

    @Override
    protected int getColumnPrecision(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.cols[n + this.beginColumnIndex - 1].getPrecision();
    }

    protected byte[] getColumnRawData(int n) throws SQLException {
        return this.getCurrentRow().getRawBytes(n + this.beginColumnIndex);
    }

    @Override
    protected int getColumnScale(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.cols[n + this.beginColumnIndex - 1].getScale();
    }

    @Override
    protected int getColumnSqlType(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.cols[n + this.beginColumnIndex - 1].getSqlType();
    }

    protected long getCurrentChunkCRC(byte[] byArray, int n, long l) {
        int n2;
        long l2 = 0L;
        for (int i = 1; i < n; ++i) {
            n2 = ((int)(l2 >> 24) ^ byArray[i]) & 0xFF;
            l2 = l2 << 8 ^ CRC_TBL[n2];
        }
        if (l != 0L) {
            byte[] byArray2 = new byte[]{(byte)(l >> 24 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l & 0xFFL)};
            for (int i = 0; i < 4; ++i) {
                n2 = ((int)(l2 >> 24) ^ byArray2[i]) & 0xFF;
                l2 = l2 << 8 ^ CRC_TBL[n2];
            }
        }
        return l2 & 0xFFFFFFFFL;
    }

    protected abstract Row getCurrentRow() throws SQLException;

    public int getCursorId() {
        return this.csrID;
    }

    @Override
    public String getCursorName() throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public synchronized Date getDate(int n) throws SQLException {
        return this.getDateInternal(n);
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        Date date = this.getDateInternal(n);
        if (calendar != null) {
            calendar.setTime(date);
            date = (Date)calendar.getTime();
        }
        return date;
    }

    @Override
    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    private Date getDateInternal(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        return this.typeConverter.toDate(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n));
    }

    @Override
    public TbDate getTbDate(int n) throws SQLException {
        return this.getTbDateInternal(n);
    }

    private TbDate getTbDateInternal(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        return this.typeConverter.toTbDate(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n));
    }

    @Override
    public synchronized double getDouble(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return 0.0;
        }
        return this.typeConverter.toDouble(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n));
    }

    @Override
    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    @Override
    public synchronized int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    @Override
    public synchronized int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public synchronized float getFloat(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return 0.0f;
        }
        return this.typeConverter.toFloat(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n));
    }

    @Override
    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    @Override
    public synchronized int getInt(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return 0;
        }
        return this.typeConverter.toInt(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n));
    }

    @Override
    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    @Override
    public synchronized long getLong(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return 0L;
        }
        return this.typeConverter.toLong(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n));
    }

    @Override
    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    @Override
    public synchronized InputStream getLongByteStream(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        return this.typeConverter.toLongRawStream(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n));
    }

    public boolean getMapDateToTimestamp() {
        return this.mapDateToTimestamp;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new TbResultSetMetaData(this.cols, this.beginColumnIndex);
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        return this.typeConverter.toCharacterStream(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n));
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        return this.getNCharacterStream(this.findColumn(string));
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        return this.getTbNClob(n);
    }

    public TbNClob getTbNClob(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        return this.typeConverter.toTbNClob(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n));
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        return this.getTbNClob(this.findColumn(string));
    }

    public TbNClob getTbNClob(String string) throws SQLException {
        return this.getTbNClob(this.findColumn(string));
    }

    @Override
    public String getNString(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        return this.typeConverter.toString(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n), this.getColumnPrecision(n), this.getColumnScale(n), !this.getRsetType().isScrollable());
    }

    @Override
    public String getNString(String string) throws SQLException {
        return this.getNString(this.findColumn(string));
    }

    @Override
    public synchronized Object getObject(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        return this.typeConverter.toObject(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n), this.getColumnSqlType(n), this.getColumnPrecision(n), this.getColumnScale(n), !this.getRsetType().isScrollable(), this.getColumnTypeDescriptor(n), null, this.stmt.conn.getTypeMap());
    }

    @Override
    public Object getObject(int n, Map<String, Class<?>> map) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        TbTypeDescriptor tbTypeDescriptor = this.getColumnTypeDescriptor(n);
        String string = null;
        Class<?> clazz = null;
        if (tbTypeDescriptor != null && (string = tbTypeDescriptor.getSQLTypeName()) != null && map != null) {
            clazz = map.get(string);
        }
        return this.typeConverter.toObject(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n), this.getColumnSqlType(n), this.getColumnPrecision(n), this.getColumnScale(n), !this.getRsetType().isScrollable(), tbTypeDescriptor, clazz, map);
    }

    @Override
    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    @Override
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    public int getPreparedFetchCnt() {
        return this.preparedFetchCnt;
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    @Override
    public synchronized int getRow() throws SQLException {
        if (this.rowsFetchedCnt == 0 || this.currentRowIndex < 0 || this.currentRowIndex >= this.rowsFetchedCnt) {
            return 0;
        }
        return this.currentRowIndex + 1;
    }

    @Override
    public byte[] getRowChunk(int n) {
        if (this.rowChunk == null || this.rowChunk.length < n) {
            this.rowChunk = new byte[n];
        }
        return this.rowChunk;
    }

    private Object getRowChunk(Row row, int n) {
        return row.getRowChunk(n + this.beginColumnIndex);
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        return this.typeConverter.toRowId(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n));
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        return this.getRowId(this.findColumn(string));
    }

    @Override
    public synchronized short getShort(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return 0;
        }
        return this.typeConverter.toShort(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n));
    }

    @Override
    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        return this.typeConverter.toSQLXML(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n), !this.stmt.getRealRsetType().isScrollable());
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        return this.getSQLXML(this.findColumn(string));
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.stmt;
    }

    @Override
    public synchronized String getString(int n) throws SQLException {
        Object object;
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        Object object2 = this.getRowChunk(row, n);
        int n2 = this.getColumnOffset(row, n);
        int n3 = this.getColumnLength(row, n);
        int n4 = this.getColumnDataType(n);
        int n5 = this.getColumnPrecision(n);
        int n6 = this.getColumnScale(n);
        boolean bl = !this.getRsetType().isScrollable();
        TbTypeDescriptor tbTypeDescriptor = this.getColumnTypeDescriptor(n);
        if (n4 == 32 && tbTypeDescriptor != null && "00000000000000000000000000000001".equals(tbTypeDescriptor.getOID()) && (object = this.typeConverter.toObject(object2, n2, n3, n4, DataType.getSqlType(n4), n5, n6, bl, tbTypeDescriptor, TbSQLXML.class, null)) instanceof TbSQLXML) {
            return ((TbSQLXML)object).getString();
        }
        return this.typeConverter.toString(object2, n2, n3, n4, n5, n6, bl);
    }

    @Override
    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    @Override
    public synchronized Time getTime(int n) throws SQLException {
        return this.getTimeInternal(n);
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        Time time = this.getTimeInternal(n);
        if (calendar != null) {
            calendar.setTime(time);
            time = (Time)calendar.getTime();
        }
        return time;
    }

    @Override
    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    private Time getTimeInternal(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        return this.typeConverter.toTime(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n));
    }

    @Override
    public synchronized Timestamp getTimestamp(int n) throws SQLException {
        return this.getTimestampInternal(n);
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        if (calendar == null) {
            return this.getTimestampInternal(n);
        }
        return this.getTimestampInternal(n, calendar);
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    private Timestamp getTimestampInternal(int n) throws SQLException {
        return this.getTimestampInternal(n, null);
    }

    private Timestamp getTimestampInternal(int n, Calendar calendar) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        return this.typeConverter.toTimestamp(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n), calendar);
    }

    @Override
    public TbTimestamp getTbTimestamp(int n) throws SQLException {
        return this.getTbTimestampInternal(n);
    }

    private TbTimestamp getTbTimestampInternal(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        return this.typeConverter.toTbTimestamp(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n));
    }

    @Override
    @Deprecated
    public synchronized InputStream getUnicodeStream(int n) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(n);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, n)) {
            return null;
        }
        return this.typeConverter.toUnicodeStream(this.getRowChunk(row, n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n), !this.getRsetType().isScrollable());
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    @Override
    public URL getURL(int n) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public URL getURL(String string) throws SQLException {
        return this.getURL(this.findColumn(string));
    }

    protected boolean hasNoResultReturned() throws SQLException {
        return this.rowsFetchedCnt > 0 ? false : this.fetchComplete;
    }

    @Override
    public void insertRow() throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public synchronized boolean isAfterLast() throws SQLException {
        if (this.stmt.getMaxRows() != 0 && this.currentRowIndex + 1 > this.stmt.getMaxRows()) {
            return true;
        }
        return !this.hasNoResultReturned() && this.fetchComplete && this.currentRowIndex + 1 > this.rowsFetchedCnt;
    }

    @Override
    public synchronized boolean isBeforeFirst() throws SQLException {
        return !this.hasNoResultReturned() && this.currentRowIndex < 0;
    }

    @Override
    public synchronized boolean isFirst() throws SQLException {
        return !this.hasNoResultReturned() && this.currentRowIndex == 0;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isRsetClosed;
    }

    public boolean isFetchComplete() {
        return this.fetchComplete;
    }

    private void makeColumnMetaArray(int n) {
        this.mapDateToTimestamp = this.stmt.conn.getMapDateToTimestamp();
        this.cols = new Column[n];
        for (int i = 0; i < n; ++i) {
            this.cols[i] = new Column(this.mapDateToTimestamp);
        }
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public synchronized boolean next() throws SQLException {
        if (this.csrID == -1) {
            throw TbError.newSQLException(-90607);
        }
        if (this.isRsetClosed) {
            throw TbError.newSQLException(-90646);
        }
        if (this.stmt.conn == null || this.stmt.conn.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        if (this.isSvrCsrClosed || this.csrID == -2) {
            return false;
        }
        this.currentRowIndex = this.currentRowIndex < 0 ? 0 : ++this.currentRowIndex;
        if (this.stmt.getMaxRows() != 0 && this.currentRowIndex >= this.stmt.getMaxRows()) {
            this.closeCursor();
            return false;
        }
        while (this.currentRowIndex >= this.rowsFetchedCnt) {
            if (this.fetchComplete) {
                return false;
            }
            this.fetchRowsChunk();
        }
        return true;
    }

    protected abstract void recover() throws SQLException;

    @Override
    public void refreshRow() throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    protected abstract void removeCurrentRow() throws SQLException;

    @Override
    protected void reset() {
        super.reset();
        if (this.columnNameMap != null) {
            this.columnNameMap.clear();
            this.columnNameMap = null;
        }
        this.stmt = null;
        this.csrID = -1;
        this.lastColumnWasNull = false;
        this.typeConverter = null;
        this.cols = null;
        this.rowChunk = null;
        this.fetchComplete = false;
        this.currentRowIndex = -1;
        this.rowsFetchedCnt = 0;
        this.fetchDirection = 1000;
        this.fetchSize = 50;
        this.isRsetClosed = false;
        this.closeStatementOnClose = false;
        this.foECode = 0;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    protected boolean isFoCsrEnabled() {
        return this.foCsrEnabled;
    }

    public void setFOECode(int n) {
        this.foECode = n;
    }

    @Override
    public synchronized void setFetchCompleted(int n) {
        this.fetchComplete = TbCommon.getBitmapAt(0, n);
    }

    @Override
    public synchronized void setFetchDirection(int n) throws SQLException {
        switch (n) {
            case 1000: 
            case 1002: {
                this.fetchDirection = 1000;
                return;
            }
            case 1001: {
                this.fetchDirection = 1001;
                break;
            }
            default: {
                throw TbError.newSQLException(-90608);
            }
        }
    }

    @Override
    public synchronized void setFetchSize(int n) throws SQLException {
        if (n == 0) {
            this.fetchSize = 50;
        } else if (n > 0) {
            this.fetchSize = n;
        } else {
            throw TbError.newSQLException(-590735);
        }
    }

    protected boolean setLastColumnIsNull(Row row, int n) throws SQLException {
        this.lastColumnWasNull = row.isNull(n + this.beginColumnIndex);
        return this.lastColumnWasNull;
    }

    public void setPreparedFetchCnt(int n) {
        this.preparedFetchCnt = n;
    }

    protected void setSaveCRCEnabled(boolean bl) {
        this.foCsrEnabled = bl;
    }

    @Override
    public void updateArray(int n, Array array) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateNClob(int n, NClob nClob) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateNString(int n, String string) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateNull(int n) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateNull(String string) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        this.updateObject(n, object, 0);
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public void updateRow() throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateRowId(int n, RowId rowId) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateSQLXML(int n, SQLXML sQLXML) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateTbTimestamp(int n, TbTimestamp tbTimestamp) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateTbTimestamp(String string, TbTimestamp tbTimestamp) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public synchronized boolean wasNull() throws SQLException {
        return this.lastColumnWasNull;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            long l = i << 24;
            for (int j = 0; j < 8; ++j) {
                if ((l & 0x80000000L) > 0L) {
                    l = l << 1 ^ 0x4C11DB7L;
                    continue;
                }
                l <<= 1;
            }
            TbResultSetBase.CRC_TBL[i] = l;
        }
    }
}

