/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

import com.tmax.tibero.jdbc.data.Column;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.util.TbCommon;
import java.sql.SQLException;

public class Row {
    private int columnCount;
    private int[] columnOffset;
    private int[] columnLength;
    private int[] columnLengthQuotient;
    private Object[] rowChunk;

    public Row() {
    }

    public Row(int n) {
        this.columnCount = n;
        this.columnOffset = new int[n];
        this.columnLength = new int[n];
        this.columnLengthQuotient = new int[n];
        this.rowChunk = new Object[n];
    }

    public int buildRowData(byte[] byArray, int n, Column[] columnArray) {
        int n2 = n + 3;
        for (int i = 0; i < this.columnCount; ++i) {
            int n3 = TbCommon.bytes2Int(byArray, n2, 1);
            if (n3 <= 250) {
                ++n2;
            } else {
                n3 = TbCommon.bytes2Int(byArray, n2 + 1, 2);
                n2 += 3;
            }
            this.rowChunk[i] = byArray;
            if (n3 > 0 && columnArray[i].getDataType() == 1) {
                this.columnOffset[i] = n2 - 1;
                this.columnLength[i] = n3 + 1;
            } else {
                this.columnOffset[i] = n2;
                this.columnLength[i] = n3;
            }
            n2 += n3 < 0 ? 0 : n3;
        }
        return n2 - n;
    }

    public void close() {
        this.columnCount = 0;
        this.columnOffset = null;
        this.columnLength = null;
        this.columnLengthQuotient = null;
        this.rowChunk = null;
    }

    public void duplicate(Row row) {
        this.columnCount = row.columnCount;
        if (this.columnLength == null) {
            this.columnLength = new int[this.columnCount];
        }
        System.arraycopy(row.columnLength, 0, this.columnLength, 0, this.columnCount);
        if (this.columnLengthQuotient == null) {
            this.columnLengthQuotient = new int[this.columnCount];
        }
        System.arraycopy(row.columnLengthQuotient, 0, this.columnLengthQuotient, 0, this.columnCount);
        if (this.columnOffset == null) {
            this.columnOffset = new int[this.columnCount];
        }
        System.arraycopy(row.columnOffset, 0, this.columnOffset, 0, this.columnCount);
        if (this.rowChunk == null) {
            this.rowChunk = new Object[this.columnCount];
        }
        System.arraycopy(row.rowChunk, 0, this.rowChunk, 0, this.columnCount);
    }

    public int getColCnt() {
        return this.columnCount;
    }

    public int getColumnLength(int n) {
        return this.columnLength[n - 1];
    }

    public int getColumnLengthQuotient(int n) {
        return this.columnLengthQuotient[n - 1];
    }

    public int getColumnOffset(int n) {
        return this.columnOffset[n - 1];
    }

    public byte[] getRawBytes(int n) throws SQLException {
        byte[] byArray = new byte[this.columnLength[n - 1]];
        Object object = this.rowChunk[n - 1];
        if (!(object instanceof byte[])) {
            throw TbError.newSQLException(-590705, object.toString());
        }
        System.arraycopy((byte[])object, this.columnOffset[n - 1], byArray, 0, this.columnLength[n - 1]);
        return byArray;
    }

    public Object getRowChunk(int n) {
        return this.rowChunk[n - 1];
    }

    public boolean isNull(int n) throws SQLException {
        return this.columnLength[n - 1] <= 0;
    }

    public void setUpdatedColumn(int n, int n2, Object object) {
        if (this.rowChunk == null) {
            this.rowChunk = new Object[this.columnCount];
        }
        this.columnOffset[n - 1] = 0;
        this.columnLength[n - 1] = n2;
        this.rowChunk[n - 1] = object;
    }
}

