/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

import com.tmax.tibero.jdbc.TbLob;
import com.tmax.tibero.jdbc.data.NodeInfo;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.util.TbCommon;
import com.tmax.tibero.jdbc.util.TbRandom;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;

public class ConnectionInfo
implements Cloneable {
    public static final String DATABASENAME = "databaseName";
    public static final String DATASOURCENAME = "dataSourceName";
    public static final String DESCRIPTION = "description";
    public static final String DRIVERTYPE = "driverType";
    public static final String NETWORKPROTOCOL = "networkProtocol";
    public static final String PASSWORD = "password";
    public static final String PORTNUMBER = "portNumber";
    public static final String SERVERNAME = "serverName";
    public static final String USER = "user";
    public static final String TDU = "tdu";
    public static final String URL = "url";
    public static final String LOGIN_TIMEOUT = "login_timeout";
    public static final String READ_TIMEOUT = "read_timeout";
    public static final String LOAD_BALANCE = "load_balance";
    public static final String FAILOVER_RETRY_CNT = "failover_retry_count";
    public static final String FAILOVER = "failover";
    public static final String BACKUP_SERVER = "backup_server";
    public static final String BACKUP_PORT = "backup_port";
    public static final String CHARACTERSET = "characterset";
    public static final String PROGNAME = "program_name";
    public static final String STATEMENT_CACHE = "statement_cache";
    public static final String STATEMENT_CACHE_MAX_SIZE = "statement_cache_max_size";
    public static final String LOB_CHUNK_MAX_SIZE = "lobChunkMaxSize";
    public static final String INCLUDE_SYNONYMS = "includeSynonyms";
    public static final String MAP_DATE_TO_TIMESTAMP = "mapDateToTimestamp";
    public static final String DEFAULT_NCHAR = "defaultNChar";
    public static final String RELOAD_CONFIG = "reload_config";
    public static final String SELF_KEEPALIVE = "self_keepalive";
    public static final String SELF_KEEPALIVE_IDLE_TIME = "self_keepidle";
    public static final String SELF_KEEPALIVE_MAX_TRY_COUNT = "self_keepcnt";
    public static final String SELF_KEEPALIVE_INTERVAL_TIME = "self_keepintvl";
    public static final String NLS_DATETIME_FORMAT_ENABLED = "nls_datetime_format_enabled";
    private static final String NEW_PASSWORD = "new_password";
    private static final String DATABASE_PRODUCT_NAME = "databaseProductName";
    private static final String DATABASE_PRODUCT_VERSION = "databaseProductVersion";
    private static final String DRIVER_NAME = "driverName";
    private static final String DRIVER_VERSION = "driverVersion";
    private static final int DEFAULT_RETRY_COUNT = 3;
    private static final int DEFAULT_STMT_CACHE_MAX_SIZE = 5;
    private static final int DEFAULT_SELF_KEEPALIVE_IDLE_TIME = 60;
    private static final int DEFAULT_SELF_KEEPALIVE_MAX_TRY_COUNT = 3;
    private static final int DEFAULT_SELF_KEEPALIVE_INTERVAL_TIME = 10;
    private int failover = 0;
    private boolean loadBalance = false;
    private boolean connectedToPrimary = false;
    private int curNodeIdx = 0;
    private int visitedNodeCount = 0;
    private boolean[] visitedNodes = null;
    private Vector nodeList = null;
    private int tryCount = 0;
    private int retryCount = 3;
    private boolean selfKeepAlive = false;
    private int selfKeepIdle = 60;
    private int selfKeepCount = 3;
    private int selfKeepInterval = 10;
    private boolean nlsDTFormatEnabled = false;
    private String user;
    private String databaseName;
    private String datasourceName;
    private String description;
    private String driverType = "thin";
    private String protocol = "tcp";
    private String password;
    private String newPassword;
    private String url;
    private String databaseProductName;
    private String databaseProductVersion;
    private String driverName;
    private String driverVersion;
    private int tdu = 4096;
    private int loginTimeout = 0;
    private int readTimeout = 0;
    private String charset = null;
    private String progname = null;
    private boolean isXA = false;
    private boolean isInternal = false;
    private boolean stmtCache = false;
    private int stmtCacheMaxSize = 5;
    private boolean includeSynonyms = false;
    private boolean mapDateToTimestamp = true;
    private boolean defaultNChar = false;
    private int lobMaxChunkSize = TbLob.getMaxChunkSize();

    public ConnectionInfo() {
    }

    public ConnectionInfo(Properties properties) {
        this.set(properties);
    }

    public ConnectionInfo(String string, String string2, String string3, int n, String string4, Properties properties) {
        string3 = TbCommon.getEmptyString(string3, "localhost");
        if (n <= 0) {
            n = 8629;
        }
        NodeInfo nodeInfo = new NodeInfo(string3, n);
        if (this.nodeList == null) {
            this.nodeList = new Vector();
        }
        this.nodeList.add(nodeInfo);
        this.setUser(string2);
        this.setDatabaseName(string4);
        this.url = string;
        if (properties != null) {
            this.datasourceName = properties.getProperty(DATASOURCENAME, "");
            this.description = properties.getProperty(DESCRIPTION, "");
            this.driverType = properties.getProperty(DRIVERTYPE, "thin");
            this.protocol = properties.getProperty(NETWORKPROTOCOL, "tcp");
            this.password = properties.getProperty(PASSWORD, "");
            this.newPassword = properties.getProperty(NEW_PASSWORD, "");
            String string5 = properties.getProperty(FAILOVER);
            this.failover = string5 == null ? 0 : ("ON".equalsIgnoreCase(string5) || "SESSION".equalsIgnoreCase(string5) ? 1 : ("CURSOR".equalsIgnoreCase(string5) ? 3 : 0));
            this.loadBalance = properties.getProperty(LOAD_BALANCE, "").equalsIgnoreCase("ON");
            try {
                this.retryCount = Integer.parseInt(properties.getProperty(FAILOVER_RETRY_CNT));
                if (this.retryCount < 1) {
                    this.retryCount = 3;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.retryCount = 3;
            }
            try {
                this.loginTimeout = Integer.parseInt(properties.getProperty(LOGIN_TIMEOUT));
            }
            catch (NumberFormatException numberFormatException) {
                this.loginTimeout = 0;
            }
            try {
                this.readTimeout = Integer.parseInt(properties.getProperty(READ_TIMEOUT));
            }
            catch (NumberFormatException numberFormatException) {
                this.readTimeout = 0;
            }
            try {
                this.tdu = Integer.parseInt(properties.getProperty(TDU));
            }
            catch (NumberFormatException numberFormatException) {
                this.tdu = 4096;
            }
            this.progname = properties.getProperty(PROGNAME);
            this.charset = properties.getProperty(CHARACTERSET);
            this.stmtCache = properties.getProperty(STATEMENT_CACHE, "OFF").equalsIgnoreCase("ON");
            try {
                this.stmtCacheMaxSize = Integer.parseInt(properties.getProperty(STATEMENT_CACHE_MAX_SIZE));
            }
            catch (NumberFormatException numberFormatException) {
                this.stmtCacheMaxSize = 5;
            }
            try {
                this.lobMaxChunkSize = Integer.parseInt(properties.getProperty(LOB_CHUNK_MAX_SIZE));
                TbLob.setMaxChunkSize(this.lobMaxChunkSize);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.includeSynonyms = properties.getProperty(INCLUDE_SYNONYMS, "false").equalsIgnoreCase("true");
            this.mapDateToTimestamp = properties.getProperty(MAP_DATE_TO_TIMESTAMP, "true").equalsIgnoreCase("true");
            this.defaultNChar = properties.getProperty(DEFAULT_NCHAR, "false").equalsIgnoreCase("true");
            this.databaseProductName = properties.getProperty(DATABASE_PRODUCT_NAME, "");
            this.databaseProductVersion = properties.getProperty(DATABASE_PRODUCT_VERSION, "");
            this.driverName = properties.getProperty(DRIVER_NAME, "");
            this.driverVersion = properties.getProperty(DRIVER_VERSION, "");
            this.selfKeepAlive = properties.getProperty(SELF_KEEPALIVE, "false").equalsIgnoreCase("true");
            try {
                this.selfKeepIdle = Integer.parseInt(properties.getProperty(SELF_KEEPALIVE_IDLE_TIME));
            }
            catch (NumberFormatException numberFormatException) {
                this.selfKeepIdle = 60;
            }
            try {
                this.selfKeepInterval = Integer.parseInt(properties.getProperty(SELF_KEEPALIVE_INTERVAL_TIME));
            }
            catch (NumberFormatException numberFormatException) {
                this.selfKeepInterval = 10;
            }
            try {
                this.selfKeepCount = Integer.parseInt(properties.getProperty(SELF_KEEPALIVE_MAX_TRY_COUNT));
            }
            catch (NumberFormatException numberFormatException) {
                this.selfKeepCount = 3;
            }
            this.nlsDTFormatEnabled = properties.getProperty(NLS_DATETIME_FORMAT_ENABLED, "false").equalsIgnoreCase("true");
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            throw new RuntimeException("ConnectionInfo clone() failed:" + exception.getMessage());
        }
    }

    public String getCharacterSet() {
        return this.charset;
    }

    public NodeInfo getClusterNode() throws SQLException {
        if (this.connectedToPrimary) {
            return this.getSecondaryNode();
        }
        return this.getPrimaryNode();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getDataSourceName() {
        return this.datasourceName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDriverType() {
        return this.driverType;
    }

    public int getFailover() {
        return this.failover;
    }

    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    public String getNetworkProtocol() {
        return this.protocol;
    }

    public Vector getNodeList() {
        return this.nodeList;
    }

    public String getPassword() {
        return this.password;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public int getFailoverRetryCount() {
        return this.retryCount;
    }

    public boolean getIncludeSynonyms() {
        return this.includeSynonyms;
    }

    public void setIncludeSynonyms(boolean bl) {
        this.includeSynonyms = bl;
    }

    public boolean getMapDateToTimestamp() {
        return this.mapDateToTimestamp;
    }

    public void setMapDateToTimestamp(boolean bl) {
        this.mapDateToTimestamp = bl;
    }

    public boolean getDefaultNChar() {
        return this.defaultNChar;
    }

    public void setDefaultNChar(boolean bl) {
        this.defaultNChar = bl;
    }

    public void setFailoverRetryCount(int n) {
        this.retryCount = this.retryCount < 1 ? 3 : n;
    }

    public boolean isStmtCache() {
        return this.stmtCache;
    }

    public void setStmtCache(boolean bl) {
        this.stmtCache = bl;
    }

    public int getStmtCacheMaxSize() {
        return this.stmtCacheMaxSize;
    }

    public void setStmtCacheMaxSize(int n) {
        this.stmtCacheMaxSize = n;
    }

    private synchronized NodeInfo getPrimaryNode() throws SQLException {
        NodeInfo nodeInfo = null;
        if (this.nodeList == null || this.nodeList.size() == 0) {
            throw TbError.newSQLException(-90400, "Node list is empty");
        }
        this.visitedNodes = new boolean[this.nodeList.size()];
        this.curNodeIdx = 0;
        if (this.loadBalance) {
            this.curNodeIdx = TbRandom.nextInt(this.nodeList.size());
        } else if (this.isFailoverSessionEnabled()) {
            for (int i = 0; i < this.nodeList.size(); ++i) {
                nodeInfo = (NodeInfo)this.nodeList.get(i);
                if (nodeInfo.getNodeType() != 1) continue;
                this.curNodeIdx = i;
                break;
            }
        }
        this.visitedNodeCount = 1;
        this.visitedNodes[this.curNodeIdx] = true;
        this.connectedToPrimary = true;
        return (NodeInfo)this.nodeList.get(this.curNodeIdx);
    }

    public String getProgramName() {
        return this.progname;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public synchronized NodeInfo getSecondaryNode() {
        int n = 0;
        NodeInfo nodeInfo = null;
        if (this.nodeList == null || this.nodeList.size() <= 1 || !this.isFailoverSessionEnabled()) {
            return null;
        }
        if (this.visitedNodeCount == this.nodeList.size()) {
            if (++this.tryCount == this.retryCount) {
                return null;
            }
            for (n = 0; n < this.nodeList.size(); ++n) {
                this.visitedNodes[n] = false;
            }
            this.visitedNodeCount = 0;
        }
        for (n = 0; n < this.nodeList.size(); ++n) {
            nodeInfo = (NodeInfo)this.nodeList.get(n);
            if (nodeInfo.getNodeType() != 2) continue;
            this.curNodeIdx = n;
            ++this.visitedNodeCount;
            this.visitedNodes[this.curNodeIdx] = true;
            return nodeInfo;
        }
        do {
            int n2 = this.curNodeIdx = this.curNodeIdx + 1 >= this.nodeList.size() ? 0 : this.curNodeIdx + 1;
        } while (this.visitedNodes[this.curNodeIdx]);
        ++this.visitedNodeCount;
        this.visitedNodes[this.curNodeIdx] = true;
        return (NodeInfo)this.nodeList.get(this.curNodeIdx);
    }

    public int getTDU() {
        return this.tdu;
    }

    public String getURL() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    private String getUserName(String string) {
        if (string.length() >= 2 && string.startsWith("\"") && string.endsWith("\"")) {
            return string.substring(1, string.length() - 1);
        }
        return string.toUpperCase();
    }

    public boolean isFailoverSessionEnabled() {
        return (this.failover & 1) > 0;
    }

    public boolean isFailoverCursorEnabled() {
        return (this.failover & 2) > 0;
    }

    public boolean isInternal() {
        return this.isInternal;
    }

    public boolean isLoadBalance() {
        return this.loadBalance;
    }

    public boolean isXA() {
        return this.isXA;
    }

    public void set(Properties properties) {
        int n;
        if (properties == null) {
            return;
        }
        this.databaseName = properties.getProperty(DATABASENAME, "");
        this.datasourceName = properties.getProperty(DATASOURCENAME, "");
        this.description = properties.getProperty(DESCRIPTION, "");
        this.setUser(properties.getProperty(USER, ""));
        this.password = properties.getProperty(PASSWORD, "");
        this.newPassword = properties.getProperty(NEW_PASSWORD, "");
        this.url = properties.getProperty(URL, "");
        this.driverType = properties.getProperty(DRIVERTYPE, "thin");
        this.protocol = properties.getProperty(NETWORKPROTOCOL, "tcp");
        String string = properties.getProperty(SERVERNAME, "localhost");
        String string2 = properties.getProperty(PORTNUMBER, "");
        try {
            n = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            n = 8629;
        }
        if (this.nodeList == null) {
            this.nodeList = new Vector();
        }
        NodeInfo nodeInfo = new NodeInfo(string, n);
        this.nodeList.add(nodeInfo);
        String string3 = properties.getProperty(FAILOVER);
        this.failover = string3 == null ? 0 : ("ON".equalsIgnoreCase(string3) || "SESSION".equalsIgnoreCase(string3) ? 1 : ("CURSOR".equalsIgnoreCase(string3) ? 3 : 0));
        this.loadBalance = properties.getProperty(LOAD_BALANCE, "").equalsIgnoreCase("ON");
        try {
            this.retryCount = Integer.parseInt(properties.getProperty(FAILOVER_RETRY_CNT));
            if (this.retryCount < 1) {
                this.retryCount = 3;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.retryCount = 3;
        }
        try {
            this.loginTimeout = Integer.parseInt(properties.getProperty(LOGIN_TIMEOUT));
        }
        catch (NumberFormatException numberFormatException) {
            this.loginTimeout = 0;
        }
        try {
            this.readTimeout = Integer.parseInt(properties.getProperty(READ_TIMEOUT));
        }
        catch (NumberFormatException numberFormatException) {
            this.readTimeout = 0;
        }
        try {
            this.tdu = Integer.parseInt(properties.getProperty(TDU));
        }
        catch (Exception exception) {
            this.tdu = 4096;
        }
        this.progname = properties.getProperty(PROGNAME);
        this.charset = properties.getProperty(CHARACTERSET);
        this.stmtCache = properties.getProperty(STATEMENT_CACHE, "OFF").equalsIgnoreCase("ON");
        try {
            this.stmtCacheMaxSize = Integer.parseInt(properties.getProperty(STATEMENT_CACHE_MAX_SIZE));
        }
        catch (NumberFormatException numberFormatException) {
            this.stmtCacheMaxSize = 5;
        }
        try {
            this.lobMaxChunkSize = Integer.parseInt(properties.getProperty(LOB_CHUNK_MAX_SIZE));
            TbLob.setMaxChunkSize(this.lobMaxChunkSize);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.includeSynonyms = properties.getProperty(INCLUDE_SYNONYMS, "false").equalsIgnoreCase("true");
        this.mapDateToTimestamp = properties.getProperty(MAP_DATE_TO_TIMESTAMP, "true").equalsIgnoreCase("true");
        this.defaultNChar = properties.getProperty(DEFAULT_NCHAR, "false").equalsIgnoreCase("true");
        this.databaseProductName = properties.getProperty(DATABASE_PRODUCT_NAME, "");
        this.databaseProductVersion = properties.getProperty(DATABASE_PRODUCT_VERSION, "");
        this.driverName = properties.getProperty(DRIVER_NAME, "");
        this.driverVersion = properties.getProperty(DRIVER_VERSION, "");
        this.selfKeepAlive = properties.getProperty(SELF_KEEPALIVE, "false").equalsIgnoreCase("true");
        try {
            this.selfKeepIdle = Integer.parseInt(properties.getProperty(SELF_KEEPALIVE_IDLE_TIME));
        }
        catch (NumberFormatException numberFormatException) {
            this.selfKeepIdle = 60;
        }
        try {
            this.selfKeepInterval = Integer.parseInt(properties.getProperty(SELF_KEEPALIVE_INTERVAL_TIME));
        }
        catch (NumberFormatException numberFormatException) {
            this.selfKeepInterval = 10;
        }
        try {
            this.selfKeepCount = Integer.parseInt(properties.getProperty(SELF_KEEPALIVE_MAX_TRY_COUNT));
        }
        catch (NumberFormatException numberFormatException) {
            this.selfKeepCount = 3;
        }
        this.nlsDTFormatEnabled = properties.getProperty(NLS_DATETIME_FORMAT_ENABLED, "false").equalsIgnoreCase("true");
    }

    public void update(Properties properties) {
        Object object;
        if (properties == null) {
            return;
        }
        if (properties.getProperty(DATABASENAME) != null) {
            this.databaseName = properties.getProperty(DATABASENAME);
        }
        if (properties.getProperty(DATASOURCENAME) != null) {
            this.datasourceName = properties.getProperty(DATASOURCENAME);
        }
        if (properties.getProperty(DESCRIPTION) != null) {
            this.description = properties.getProperty(DESCRIPTION);
        }
        if (properties.getProperty(USER) != null) {
            this.setUser(properties.getProperty(USER));
        }
        if (properties.getProperty(PASSWORD) != null) {
            this.password = properties.getProperty(PASSWORD);
        }
        if (properties.getProperty(NEW_PASSWORD) != null) {
            this.newPassword = properties.getProperty(NEW_PASSWORD);
        }
        if (properties.getProperty(URL) != null) {
            this.url = properties.getProperty(URL);
        }
        if (properties.getProperty(DRIVERTYPE) != null) {
            this.driverType = properties.getProperty(DRIVERTYPE, "thin");
        }
        if (properties.getProperty(NETWORKPROTOCOL) != null) {
            this.protocol = properties.getProperty(NETWORKPROTOCOL, "tcp");
        }
        String string = null;
        if (properties.getProperty(SERVERNAME) != null) {
            string = properties.getProperty(SERVERNAME, "localhost");
        }
        int n = -1;
        if (properties.getProperty(PORTNUMBER) != null) {
            object = properties.getProperty(PORTNUMBER);
            try {
                n = Integer.parseInt((String)object);
            }
            catch (Exception exception) {
                n = 8629;
            }
        }
        if (string != null && n > 0) {
            this.nodeList = new Vector();
            object = new NodeInfo(string, n);
            this.nodeList.add(object);
        }
        if ((object = properties.getProperty(FAILOVER)) != null) {
            this.failover = "ON".equalsIgnoreCase((String)object) || "SESSION".equalsIgnoreCase((String)object) ? 1 : ("CURSOR".equalsIgnoreCase((String)object) ? 3 : 0);
        }
        this.loadBalance = properties.getProperty(LOAD_BALANCE, "").equalsIgnoreCase("ON");
        if (properties.getProperty(LOAD_BALANCE) != null) {
            this.loadBalance = properties.getProperty(LOAD_BALANCE, "").equalsIgnoreCase("ON");
        }
        if (properties.getProperty(FAILOVER_RETRY_CNT) != null) {
            try {
                this.retryCount = Integer.parseInt(properties.getProperty(FAILOVER_RETRY_CNT));
                if (this.retryCount < 1) {
                    this.retryCount = 3;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.retryCount = 3;
            }
        }
        if (properties.getProperty(LOGIN_TIMEOUT) != null) {
            try {
                this.loginTimeout = Integer.parseInt(properties.getProperty(LOGIN_TIMEOUT));
            }
            catch (NumberFormatException numberFormatException) {
                this.loginTimeout = 0;
            }
        }
        if (properties.getProperty(READ_TIMEOUT) != null) {
            try {
                this.readTimeout = Integer.parseInt(properties.getProperty(READ_TIMEOUT));
            }
            catch (NumberFormatException numberFormatException) {
                this.readTimeout = 0;
            }
        }
        if (properties.getProperty(TDU) != null) {
            try {
                this.tdu = Integer.parseInt(properties.getProperty(TDU));
            }
            catch (Exception exception) {
                this.tdu = 4096;
            }
        }
        if (properties.getProperty(PROGNAME) != null) {
            this.progname = properties.getProperty(PROGNAME);
        }
        if (properties.getProperty(CHARACTERSET) != null) {
            this.charset = properties.getProperty(CHARACTERSET);
        }
        if (properties.getProperty(STATEMENT_CACHE) != null) {
            this.stmtCache = properties.getProperty(STATEMENT_CACHE, "OFF").equalsIgnoreCase("ON");
        }
        if (properties.getProperty(STATEMENT_CACHE_MAX_SIZE) != null) {
            try {
                this.stmtCacheMaxSize = Integer.parseInt(properties.getProperty(STATEMENT_CACHE_MAX_SIZE));
            }
            catch (NumberFormatException numberFormatException) {
                this.stmtCacheMaxSize = 5;
            }
        }
        if (properties.getProperty(LOB_CHUNK_MAX_SIZE) != null) {
            try {
                this.lobMaxChunkSize = Integer.parseInt(properties.getProperty(LOB_CHUNK_MAX_SIZE));
                TbLob.setMaxChunkSize(this.lobMaxChunkSize);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (properties.getProperty(INCLUDE_SYNONYMS) != null) {
            this.includeSynonyms = properties.getProperty(INCLUDE_SYNONYMS, "false").equalsIgnoreCase("true");
        }
        if (properties.getProperty(MAP_DATE_TO_TIMESTAMP) != null) {
            this.mapDateToTimestamp = properties.getProperty(MAP_DATE_TO_TIMESTAMP, "true").equalsIgnoreCase("true");
        }
        if (properties.getProperty(DEFAULT_NCHAR) != null) {
            this.defaultNChar = properties.getProperty(DEFAULT_NCHAR, "false").equalsIgnoreCase("true");
        }
        if (properties.getProperty(DATABASE_PRODUCT_NAME) != null) {
            this.databaseProductName = properties.getProperty(DATABASE_PRODUCT_NAME, "");
        }
        if (properties.getProperty(DATABASE_PRODUCT_VERSION) != null) {
            this.databaseProductVersion = properties.getProperty(DATABASE_PRODUCT_VERSION, "");
        }
        if (properties.getProperty(DRIVER_NAME) != null) {
            this.driverName = properties.getProperty(DRIVER_NAME, "");
        }
        if (properties.getProperty(DRIVER_VERSION) != null) {
            this.driverVersion = properties.getProperty(DRIVER_VERSION, "");
        }
        if (properties.getProperty(SELF_KEEPALIVE) != null) {
            this.selfKeepAlive = properties.getProperty(SELF_KEEPALIVE, "false").equalsIgnoreCase("true");
        }
        if (properties.getProperty(SELF_KEEPALIVE_IDLE_TIME) != null) {
            try {
                this.selfKeepIdle = Integer.parseInt(properties.getProperty(SELF_KEEPALIVE_IDLE_TIME));
            }
            catch (NumberFormatException numberFormatException) {
                this.selfKeepIdle = 60;
            }
        }
        if (properties.getProperty(SELF_KEEPALIVE_INTERVAL_TIME) != null) {
            try {
                this.selfKeepInterval = Integer.parseInt(properties.getProperty(SELF_KEEPALIVE_INTERVAL_TIME));
            }
            catch (NumberFormatException numberFormatException) {
                this.selfKeepInterval = 10;
            }
        }
        if (properties.getProperty(SELF_KEEPALIVE_MAX_TRY_COUNT) != null) {
            try {
                this.selfKeepCount = Integer.parseInt(properties.getProperty(SELF_KEEPALIVE_MAX_TRY_COUNT));
            }
            catch (NumberFormatException numberFormatException) {
                this.selfKeepCount = 3;
            }
        }
        if (properties.getProperty(NLS_DATETIME_FORMAT_ENABLED) != null) {
            this.nlsDTFormatEnabled = properties.getProperty(NLS_DATETIME_FORMAT_ENABLED, "false").equalsIgnoreCase("true");
        }
    }

    public void setDatabaseName(String string) {
        this.databaseName = TbCommon.getEmptyString(string, "");
    }

    public void setDatabaseProductName(String string) {
        this.databaseProductName = TbCommon.getEmptyString(string, "");
    }

    public void setDatabaseProductVersion(String string) {
        this.databaseProductVersion = TbCommon.getEmptyString(string, "");
    }

    public void setDriverName(String string) {
        this.driverName = TbCommon.getEmptyString(string, "");
    }

    public void setDriverVersion(String string) {
        this.driverVersion = TbCommon.getEmptyString(string, "");
    }

    public void setDataSourceName(String string) {
        this.datasourceName = TbCommon.getEmptyString(string, "");
    }

    public void setDescription(String string) {
        this.description = TbCommon.getEmptyString(string, "");
    }

    public void setDriverType(String string) {
        this.driverType = TbCommon.getEmptyString(string, "thin");
    }

    public void setFailover(int n) {
        this.failover = n;
    }

    public void setInternal(boolean bl) {
        this.isInternal = bl;
    }

    public void setLoadBalance(boolean bl) {
        this.loadBalance = bl;
    }

    public void setLobMaxChunkSize(int n) {
        this.lobMaxChunkSize = n;
    }

    public void setLoginTimeout(int n) {
        this.loginTimeout = n;
    }

    public void setReadTimeout(int n) {
        this.readTimeout = n;
    }

    public void setCharacterSet(String string) {
        this.charset = string;
    }

    public void setProgramName(String string) {
        this.progname = TbCommon.getEmptyString(string, "");
    }

    public void setNetworkProtocol(String string) {
        this.protocol = TbCommon.getEmptyString(string, "tcp");
    }

    public void setNodeList(Vector vector) {
        this.nodeList = vector;
    }

    public void setPassword(String string) {
        this.password = TbCommon.getEmptyString(string, "");
    }

    public void setTDU(int n) {
        this.tdu = n <= 0 ? 4096 : n;
    }

    public void setURL(String string) {
        this.url = string;
    }

    public void setUser(String string) {
        this.user = this.getUserName(TbCommon.getEmptyString(string, ""));
    }

    public void setUser(String string, boolean bl) {
        if (bl) {
            this.setUser(string);
        } else {
            this.user = TbCommon.getEmptyString(string, "");
        }
    }

    public void setXA(boolean bl) {
        this.isXA = bl;
    }

    public String getDatabaseProductName() {
        return this.databaseProductName;
    }

    public String getDatabaseProductVersion() {
        return this.databaseProductVersion;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getDriverVersion() {
        return this.driverVersion;
    }

    public int getLobMaxChunkSize() {
        return this.lobMaxChunkSize;
    }

    public boolean useSelfKeepAlive() {
        return this.selfKeepAlive;
    }

    public void setSelfKeepAlive(boolean bl) {
        this.selfKeepAlive = bl;
    }

    public int getSelfKeepIdle() {
        return this.selfKeepIdle;
    }

    public void setSelfKeepIdle(int n) {
        this.selfKeepIdle = n;
    }

    public int getSelfKeepCount() {
        return this.selfKeepCount;
    }

    public void setSelfKeepCount(int n) {
        this.selfKeepCount = n;
    }

    public int getSelfKeepInterval() {
        return this.selfKeepInterval;
    }

    public void setSelfKeepInterval(int n) {
        this.selfKeepInterval = n;
    }

    public boolean getNlsDatetimeFormatEnabled() {
        return this.nlsDTFormatEnabled;
    }

    public void setNlsDatetimeFormatEnabled(boolean bl) {
        this.nlsDTFormatEnabled = bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("ConnInfo[").append("User=").append(this.user).append("/Password=").append(this.password != null ? "********" : null).append("/URL=").append(this.url).append("/DriverType=").append(this.driverType).append("/NetworkProtocol=").append(this.protocol).append("/TDU=").append(this.tdu).append("/DatabaseName=").append(this.databaseName).append("/DataSourceName=").append(this.datasourceName).append("/Failover=").append(this.failover).append("/LoadBalance=").append(this.loadBalance).append("/Description=").append(this.description).append("/ProgramName=").append(this.progname).append("/isXA=").append(this.isXA).append("/LoginTimeout=").append(this.loginTimeout).append("/ReadTimeout=").append(this.readTimeout).append("/SelfKeepAlive=").append(this.selfKeepAlive).append("/SelfKeepIdle=").append(this.selfKeepIdle).append("/SelfKeepInterval=").append(this.selfKeepInterval).append("/SelfKeepCount=").append(this.selfKeepCount).append("/IncludeSynonyms=").append(this.includeSynonyms).append("/MapDateToTimestamp=").append(this.mapDateToTimestamp).append("/NlsDatetimeFormatEnabled=").append(this.nlsDTFormatEnabled).append("]");
        return stringBuffer.toString();
    }
}

