/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.pivot;

import com.tmax.tibero.jdbc.TbCallableStatement;
import com.tmax.tibero.jdbc.TbStatement;
import com.tmax.tibero.jdbc.msg.TbPivotInfo;
import com.tmax.tibero.pivot.TbPivotColMeta;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;

public class TbPivotMeta {
    TbPivotInfo[] pivotInfo;
    Vector pivotData;
    int[] startChunkIdx;
    int[] offset;
    int[] curChunkPos;
    HashMap colIdxMap;
    Vector[] metas;
    HashMap[] newIdxMap;
    int[] curIdx;

    public TbPivotMeta(TbStatement tbStmt) throws Exception {
        this.init(tbStmt.getPivotInfo(), tbStmt.getPivotData());
    }

    public TbPivotMeta(TbCallableStatement tbCstmt, int paramIdx) throws Exception {
        this.init(tbCstmt.getPivotInfo(paramIdx), tbCstmt.getPivotData(paramIdx));
    }

    private void init(TbPivotInfo[] pivotInfo, Vector pivotData) throws Exception {
        int i;
        this.pivotInfo = pivotInfo;
        this.pivotData = pivotData;
        if (pivotInfo == null) {
            return;
        }
        this.startChunkIdx = new int[pivotInfo.length];
        this.offset = new int[pivotInfo.length];
        this.curChunkPos = new int[pivotInfo.length];
        this.colIdxMap = new HashMap();
        int curChunkIdx = 0;
        for (i = 0; i < pivotInfo.length; ++i) {
            this.colIdxMap.put(new Integer(pivotInfo[i].colIdx), new Integer(i));
            this.startChunkIdx[i] = curChunkIdx;
            this.curChunkPos[i] = curChunkIdx;
            this.offset[i] = 0;
            curChunkIdx += pivotInfo[i].chunkCnt;
        }
        this.metas = new Vector[pivotInfo.length];
        this.newIdxMap = new HashMap[pivotInfo.length];
        this.curIdx = new int[pivotInfo.length];
        for (i = 0; i < pivotInfo.length; ++i) {
            String colName;
            this.metas[i] = new Vector();
            this.newIdxMap[i] = new HashMap();
            int j = 0;
            while ((colName = this.getNextOldColName(i)) != null) {
                this.metas[i].add(new TbPivotColMeta(j, colName, this.getOldValType(i, j)));
                ++j;
            }
            Collections.sort(this.metas[i]);
            for (j = 0; j < this.metas[i].size(); ++j) {
                TbPivotColMeta m = (TbPivotColMeta)this.metas[i].elementAt(j);
                this.newIdxMap[i].put(new Integer(m.getOldIdx()), new Integer(j));
            }
            this.curIdx[i] = 0;
        }
        pivotInfo = null;
        pivotData = null;
        this.startChunkIdx = null;
        this.offset = null;
        this.curChunkPos = null;
    }

    private int getPivotIdx(int colIdx) throws Exception {
        Integer intObj = (Integer)this.colIdxMap.get(new Integer(colIdx));
        if (intObj != null) {
            return intObj;
        }
        throw new Exception("invalid index for pivot column: " + colIdx);
    }

    private String getNextOldColName(int pivotIdx) throws Exception {
        if (this.curChunkPos[pivotIdx] == this.startChunkIdx[pivotIdx] + this.pivotInfo[pivotIdx].chunkCnt) {
            return null;
        }
        byte[] chunk = (byte[])this.pivotData.elementAt(this.curChunkPos[pivotIdx]);
        int pos = this.offset[pivotIdx];
        int colLen = 0;
        if (chunk[pos] <= 250) {
            colLen = 0xFF & chunk[pos];
            ++pos;
            int n = pivotIdx;
            this.offset[n] = this.offset[n] + (1 + colLen);
        } else if (chunk[pos] == 254) {
            colLen = (0xFF & chunk[pos + 1]) << 8;
            colLen &= 0xFF & chunk[pos + 2];
            pos += 3;
            int n = pivotIdx;
            this.offset[n] = this.offset[n] + (3 + colLen);
        } else {
            throw new Exception("rpcol length field curruption");
        }
        if (this.offset[pivotIdx] == chunk.length) {
            int n = pivotIdx;
            this.curChunkPos[n] = this.curChunkPos[n] + 1;
            this.offset[pivotIdx] = 0;
        }
        if (colLen == 0) {
            return "";
        }
        return new String(chunk, pos, colLen);
    }

    private int getOldValType(int pivotIdx, int valPos) throws Exception {
        TbPivotInfo pi = this.pivotInfo[pivotIdx];
        if (pi.valType == null) {
            throw new Exception("can't provide value type information");
        }
        int cnt = pi.valType.length;
        return pi.valType[valPos % cnt].type;
    }

    public String getNextColName(int colIdx) throws Exception {
        if (this.colIdxMap == null) {
            return null;
        }
        int pivotIdx = this.getPivotIdx(colIdx);
        if (this.curIdx[pivotIdx] == this.metas[pivotIdx].size()) {
            return null;
        }
        TbPivotColMeta meta = (TbPivotColMeta)this.metas[pivotIdx].elementAt(this.curIdx[pivotIdx]);
        int n = pivotIdx;
        this.curIdx[n] = this.curIdx[n] + 1;
        return meta.getName();
    }

    public int getValType(int colIdx, int valPos) throws Exception {
        int pivotIdx = this.getPivotIdx(colIdx);
        TbPivotColMeta meta = (TbPivotColMeta)this.metas[pivotIdx].elementAt(valPos);
        return meta.getType();
    }

    public HashMap getNewIdxMap(int colIdx) throws Exception {
        return this.newIdxMap[this.getPivotIdx(colIdx)];
    }
}

