/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.rowset;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.util.TbSQLParser;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetListener;

public abstract class TbRowSet
implements RowSet {
    protected String url;
    protected String dataSourceName;
    protected String username;
    protected String password;
    protected int isolation;
    protected String command;
    protected boolean isClosed;
    protected boolean readOnly;
    protected boolean showDeleted;
    protected int maxFieldSize;
    protected int maxRows;
    protected boolean escapeProcessing;
    protected int queryTimeout;
    protected int rowsetType;
    protected int concurrency;
    protected int fetchDirection;
    protected int fetchSize;
    protected Vector<RowSetListener> listeners;
    protected Map<String, Class<?>> typeMap;
    private Vector<Integer> matchColumnIndexes;
    private Vector<String> matchColumnNames;
    protected Vector<Object> params;
    protected SQLWarning warnings;
    protected String[] paramNames;
    protected RowSetEvent rowsetEvent;
    static final int PARAM_NSTRING = 0;
    static final int PARAM_ASCII = 1;
    static final int PARAM_BINARY = 2;
    static final int PARAM_CHARACTER = 3;
    static final int PARAM_NCHARACTER = 4;
    static final int PARAM_BLOB = 5;
    static final int PARAM_CLOB = 6;
    static final int PARAM_NCLOB = 7;

    public TbRowSet() {
        Debug.logMethod("TbRowSet", new Object[]{this});
        this.initialize();
        this.listeners = new Vector();
        this.matchColumnIndexes = new Vector(10);
        this.matchColumnNames = new Vector(10);
        this.rowsetEvent = new RowSetEvent(this);
        this.isClosed = false;
    }

    @Override
    public void addRowSetListener(RowSetListener listener) {
        Debug.logMethod("TbRowSet.addRowSetListener", new Object[]{this, listener});
        this.listeners.add(listener);
    }

    public void addWarning(SQLWarning warning) {
        Debug.logMethod("TbRowSet.addWarning", new Object[]{this, warning});
        if (this.warnings != null) {
            this.warnings.setNextWarning(warning);
        } else {
            this.warnings = warning;
        }
    }

    protected void checkMatchColumnIndexesExist() throws SQLException {
        if (this.matchColumnIndexes.size() == 0) {
            throw TbError.newSQLException(-90860);
        }
    }

    protected void checkMatchColumnNamesExist() throws SQLException {
        if (this.matchColumnNames.size() == 0) {
            throw TbError.newSQLException(-90861);
        }
    }

    private void checkParameterIndex(int parameterIndex) throws SQLException {
        if (parameterIndex < 1) {
            throw TbError.newSQLException(-90844, Integer.toString(parameterIndex));
        }
    }

    @Override
    public synchronized void clearParameters() throws SQLException {
        Debug.logMethod("TbRowSet.clearParameters", new Object[]{this});
        this.params = null;
        this.params = new Vector();
    }

    @Override
    public synchronized void clearWarnings() {
        Debug.logMethod("TbRowSet.clearWarnings", new Object[]{this});
        this.warnings = null;
    }

    @Override
    public abstract void execute() throws SQLException;

    int findParam(String paramName) throws SQLException {
        int i = 0;
        for (i = 0; i < this.paramNames.length && !this.paramNames[i].equals(paramName); ++i) {
        }
        if (i == this.paramNames.length) {
            throw TbError.newSQLException(-90845, paramName);
        }
        return i + 1;
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return this.concurrency;
    }

    @Override
    public String getDataSourceName() {
        return this.dataSourceName;
    }

    @Override
    public boolean getEscapeProcessing() {
        return this.escapeProcessing;
    }

    @Override
    public int getFetchDirection() {
        return this.fetchDirection;
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    public int[] getMatchColumnIndexes() throws SQLException {
        int[] colIndex;
        if (this.matchColumnIndexes.size() == 0 && this.matchColumnNames.size() == 0) {
            throw TbError.newSQLException(-90860);
        }
        if (this.matchColumnNames.size() > 0) {
            String[] colName = this.getMatchColumnNames();
            int len = colName.length;
            colIndex = new int[len];
            for (int i = 0; i < len; ++i) {
                colIndex[i] = this.findColumn(colName[i]);
            }
        } else {
            int len = this.matchColumnIndexes.size();
            colIndex = new int[len];
            int index = -1;
            for (int i = 0; i < len; ++i) {
                try {
                    index = this.matchColumnIndexes.get(i);
                }
                catch (Exception e) {
                    throw TbError.newSQLException(-90840, e.getMessage());
                }
                if (index <= 0) {
                    throw TbError.newSQLException(-90840);
                }
                colIndex[i] = index;
            }
        }
        return colIndex;
    }

    public String[] getMatchColumnNames() throws SQLException {
        this.checkMatchColumnNamesExist();
        int len = this.matchColumnNames.size();
        String[] colName = new String[len];
        String name = null;
        for (int i = 0; i < len; ++i) {
            try {
                name = this.matchColumnNames.get(i);
            }
            catch (Exception e) {
                throw TbError.newSQLException(-90841, e.getMessage());
            }
            if (name == null || name.equals("")) {
                throw TbError.newSQLException(-90841);
            }
            colName[i] = name;
        }
        return colName;
    }

    @Override
    public int getMaxFieldSize() {
        return this.maxFieldSize;
    }

    @Override
    public int getMaxRows() {
        return this.maxRows;
    }

    public Object[] getParams() {
        if (this.params == null) {
            return new Object[0];
        }
        return this.params.toArray();
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public boolean getShowDeleted() throws SQLException {
        return this.showDeleted;
    }

    @Override
    public int getTransactionIsolation() {
        return this.isolation;
    }

    @Override
    public int getType() {
        return this.rowsetType;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() {
        return this.typeMap;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public SQLWarning getWarnings() {
        return this.warnings;
    }

    protected void initialize() {
        this.command = null;
        this.dataSourceName = null;
        this.dataSourceName = null;
        this.escapeProcessing = true;
        this.fetchSize = 0;
        this.maxFieldSize = 0;
        this.maxRows = 0;
        this.queryTimeout = 0;
        this.readOnly = true;
        this.showDeleted = false;
        this.username = null;
        this.password = null;
        this.url = null;
        this.fetchDirection = 1002;
        this.rowsetType = 1005;
        this.concurrency = 1007;
        this.isolation = 2;
        this.params = new Vector();
        this.typeMap = new HashMap();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isShowDeleted() {
        return this.showDeleted;
    }

    protected void notifyCursorMoved() {
        Debug.logMethod("TbRowSet.notifyCursorMoved", new Object[]{this});
        Iterator<RowSetListener> i = this.listeners.iterator();
        while (i.hasNext()) {
            i.next().cursorMoved(this.rowsetEvent);
        }
    }

    protected void notifyRowChanged() {
        Debug.logMethod("TbRowSet.notifyRowChanged", new Object[]{this});
        Iterator<RowSetListener> i = this.listeners.iterator();
        while (i.hasNext()) {
            i.next().rowChanged(this.rowsetEvent);
        }
    }

    protected void notifyRowSetChanged() {
        Debug.logMethod("TbRowSet.notifyRowSetChanged", new Object[]{this});
        Iterator<RowSetListener> i = this.listeners.iterator();
        while (i.hasNext()) {
            i.next().rowSetChanged(this.rowsetEvent);
        }
    }

    @Override
    public void removeRowSetListener(RowSetListener listener) {
        Debug.logMethod("TbRowSet.removeRowSetListener", new Object[]{this, listener});
        this.listeners.remove(listener);
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        Debug.logMethod("TbRowSet.setArray", new Object[]{this, Integer.toString(i), x});
        this.checkParameterIndex(i);
        this.params.add(i - 1, x);
    }

    public void setArray(String label, Array x) throws SQLException {
        Debug.logMethod("TbRowSet.setArray", new Object[]{this, label, x});
        this.setArray(this.findParam(label), x);
    }

    @Override
    public void setAsciiStream(int i, InputStream x) throws SQLException {
        Debug.logMethod("TbRowSet.setAsciiStream", new Object[]{this, Integer.toString(i), x});
        this.checkParameterIndex(i);
        Object[] obj = new Object[]{x, new Integer(Integer.MAX_VALUE), new Integer(1)};
        this.params.add(i - 1, obj);
    }

    @Override
    public void setAsciiStream(int i, InputStream x, int len) throws SQLException {
        Debug.logMethod("TbRowSet.setAsciiStream", new Object[]{this, Integer.toString(i), x, Integer.toString(len)});
        this.checkParameterIndex(i);
        Object[] obj = new Object[]{x, new Integer(len), new Integer(1)};
        this.params.add(i - 1, obj);
    }

    @Override
    public void setAsciiStream(String label, InputStream x) throws SQLException {
        Debug.logMethod("TbRowSet.setAsciiStream", new Object[]{this, label, x});
        this.setAsciiStream(this.findParam(label), x);
    }

    @Override
    public void setAsciiStream(String label, InputStream x, int len) throws SQLException {
        Debug.logMethod("TbRowSet.setAsciiStream", new Object[]{this, label, x, Integer.toString(len)});
        this.setAsciiStream(this.findParam(label), x, len);
    }

    @Override
    public void setBigDecimal(int i, BigDecimal x) throws SQLException {
        Debug.logMethod("TbRowSet.setBigDecimal", new Object[]{this, Integer.toString(i), x});
        this.checkParameterIndex(i);
        this.params.add(i - 1, x);
    }

    @Override
    public void setBigDecimal(String label, BigDecimal x) throws SQLException {
        Debug.logMethod("TbRowSet.setBigDecimal", new Object[]{this, label, x});
        this.setBigDecimal(this.findParam(label), x);
    }

    @Override
    public void setBinaryStream(int i, InputStream x) throws SQLException {
        Debug.logMethod("TbRowSet.setBinaryStream", new Object[]{this, Integer.toString(i), x});
        this.checkParameterIndex(i);
        Object[] obj = new Object[]{x, new Integer(Integer.MAX_VALUE), new Integer(2)};
        this.params.add(i - 1, obj);
    }

    @Override
    public void setBinaryStream(int i, InputStream x, int len) throws SQLException {
        Debug.logMethod("TbRowSet.setBinaryStream", new Object[]{this, Integer.toString(i), x, Integer.toString(len)});
        this.checkParameterIndex(i);
        Object[] obj = new Object[]{x, new Integer(len), new Integer(2)};
        this.params.add(i - 1, obj);
    }

    @Override
    public void setBinaryStream(String label, InputStream x) throws SQLException {
        Debug.logMethod("TbRowSet.setBinaryStream", new Object[]{this, label, x});
        this.setBinaryStream(this.findParam(label), x);
    }

    @Override
    public void setBinaryStream(String label, InputStream x, int len) throws SQLException {
        Debug.logMethod("TbRowSet.setBinaryStream", new Object[]{this, label, x, Integer.toString(len)});
        this.setBinaryStream(this.findParam(label), x, len);
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        Debug.logMethod("TbRowSet.setBlob", new Object[]{this, Integer.toString(i), x});
        this.checkParameterIndex(i);
        this.params.add(i - 1, x);
    }

    @Override
    public void setBlob(int i, InputStream x) throws SQLException {
        Debug.logMethod("TbRowSet.setBlob", new Object[]{this, Integer.toString(i), x});
        this.checkParameterIndex(i);
        Object[] obj = new Object[]{x, new Integer(Integer.MAX_VALUE), new Integer(5)};
        this.params.add(i - 1, obj);
    }

    @Override
    public void setBlob(int i, InputStream x, long len) throws SQLException {
        Debug.logMethod("TbRowSet.setBlob", new Object[]{this, Integer.toString(i), x, Long.toString(len)});
        this.checkParameterIndex(i);
        Object[] obj = new Object[]{x, new Long(len), new Integer(5)};
        this.params.add(i - 1, obj);
    }

    @Override
    public void setBlob(String label, Blob x) throws SQLException {
        Debug.logMethod("TbRowSet.setBlob", new Object[]{this, label, x});
        this.setBlob(this.findParam(label), x);
    }

    @Override
    public void setBlob(String label, InputStream x) throws SQLException {
        Debug.logMethod("TbRowSet.setBlob", new Object[]{this, label, x});
        this.setBlob(this.findParam(label), x);
    }

    @Override
    public void setBlob(String label, InputStream x, long len) throws SQLException {
        Debug.logMethod("TbRowSet.setBlob", new Object[]{this, label, x, Long.toString(len)});
        this.setBlob(this.findParam(label), x, len);
    }

    @Override
    public void setBoolean(int i, boolean x) throws SQLException {
        Debug.logMethod("TbRowSet.setBoolean", new Object[]{this, Integer.toString(i), new Boolean(x)});
        this.checkParameterIndex(i);
        this.params.add(i - 1, x ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setBoolean(String label, boolean x) throws SQLException {
        Debug.logMethod("TbRowSet.setBoolean", new Object[]{this, label, new Boolean(x)});
        this.setBoolean(this.findParam(label), x);
    }

    @Override
    public void setByte(int i, byte x) throws SQLException {
        Debug.logMethod("TbRowSet.setByte", new Object[]{this, Integer.toString(i), Byte.toString(x)});
        this.checkParameterIndex(i);
        this.params.add(i - 1, new Byte(x));
    }

    @Override
    public void setByte(String label, byte x) throws SQLException {
        Debug.logMethod("TbRowSet.setByte", new Object[]{this, label, Byte.toString(x)});
        this.setByte(this.findParam(label), x);
    }

    @Override
    public void setBytes(int i, byte[] x) throws SQLException {
        Debug.logMethod("TbRowSet.setBytes", new Object[]{this, Integer.toString(i), x});
        this.checkParameterIndex(i);
        this.params.add(i - 1, x);
    }

    @Override
    public void setBytes(String label, byte[] x) throws SQLException {
        Debug.logMethod("TbRowSet.setBytes", new Object[]{this, label, x});
        this.setBytes(this.findParam(label), x);
    }

    @Override
    public void setCharacterStream(int i, Reader x) throws SQLException {
        Debug.logMethod("TbRowSet.setCharacterStream", new Object[]{this, Integer.toString(i), x});
        this.checkParameterIndex(i);
        Object[] obj = new Object[]{x, new Integer(Integer.MAX_VALUE), new Integer(3)};
        this.params.add(i - 1, obj);
    }

    @Override
    public void setCharacterStream(int i, Reader x, int len) throws SQLException {
        Debug.logMethod("TbRowSet.setCharacterStream", new Object[]{this, Integer.toString(i), x, Integer.toString(len)});
        this.checkParameterIndex(i);
        Object[] obj = new Object[]{x, new Integer(len), new Integer(3)};
        this.params.add(i - 1, obj);
    }

    @Override
    public void setCharacterStream(String label, Reader x) throws SQLException {
        Debug.logMethod("TbRowSet.setCharacterStream", new Object[]{this, label, x});
        this.setCharacterStream(this.findParam(label), x);
    }

    @Override
    public void setCharacterStream(String label, Reader x, int len) throws SQLException {
        Debug.logMethod("TbRowSet.setCharacterStream", new Object[]{this, label, x, Integer.toString(len)});
        this.setCharacterStream(this.findParam(label), x, len);
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        Debug.logMethod("TbRowSet.setClob", new Object[]{this, Integer.toString(i), x});
        this.checkParameterIndex(i);
        this.params.add(i - 1, x);
    }

    @Override
    public void setClob(int i, Reader x) throws SQLException {
        Debug.logMethod("TbRowSet.setClob", new Object[]{this, Integer.toString(i), x});
        this.checkParameterIndex(i);
        Object[] obj = new Object[]{x, new Integer(Integer.MAX_VALUE), new Integer(6)};
        this.params.add(i - 1, obj);
    }

    @Override
    public void setClob(int i, Reader x, long len) throws SQLException {
        Debug.logMethod("TbRowSet.setClob", new Object[]{this, Integer.toString(i), x, Long.toString(len)});
        this.checkParameterIndex(i);
        Object[] obj = new Object[]{x, new Long(len), new Integer(6)};
        this.params.add(i - 1, obj);
    }

    @Override
    public void setClob(String label, Clob x) throws SQLException {
        Debug.logMethod("TbRowSet.setClob", new Object[]{this, label, x});
        this.setClob(this.findParam(label), x);
    }

    @Override
    public void setClob(String label, Reader x) throws SQLException {
        Debug.logMethod("TbRowSet.setClob", new Object[]{this, label, x});
        this.setClob(this.findParam(label), x);
    }

    @Override
    public void setClob(String label, Reader x, long len) throws SQLException {
        Debug.logMethod("TbRowSet.setClob", new Object[]{this, label, x, Long.toString(len)});
        this.setClob(this.findParam(label), x, len);
    }

    @Override
    public void setCommand(String cmd) throws SQLException {
        Debug.logMethod("TbRowSet.setCommand", new Object[]{this, cmd});
        this.command = cmd;
        this.paramNames = TbSQLParser.getParamNames(this.command);
    }

    @Override
    public void setConcurrency(int concurrency) throws SQLException {
        Debug.logMethod("TbRowSet.setConcurrency", new Object[]{this, Integer.toString(concurrency)});
        switch (concurrency) {
            case 1007: 
            case 1008: {
                this.concurrency = concurrency;
                return;
            }
        }
        throw TbError.newSQLException(-90608);
    }

    @Override
    public void setDataSourceName(String name) throws SQLException {
        Debug.logMethod("TbRowSet.setDataSourceName", new Object[]{this, name});
        this.dataSourceName = name;
    }

    @Override
    public void setDate(int i, Date x) throws SQLException {
        Debug.logMethod("TbRowSet.setDate", new Object[]{this, Integer.toString(i), x});
        this.checkParameterIndex(i);
        this.params.add(i - 1, x);
    }

    @Override
    public void setDate(int i, Date x, Calendar cal) throws SQLException {
        Debug.logMethod("TbRowSet.setDate", new Object[]{this, Integer.toString(i), x, cal});
        this.checkParameterIndex(i);
        Object[] obj = new Object[]{x, cal};
        this.params.add(i - 1, obj);
    }

    @Override
    public void setDate(String label, Date x) throws SQLException {
        Debug.logMethod("TbRowSet.setDate", new Object[]{this, label, x});
        this.setDate(this.findParam(label), x);
    }

    @Override
    public void setDate(String label, Date x, Calendar cal) throws SQLException {
        Debug.logMethod("TbRowSet.setDate", new Object[]{this, label, x, cal});
        this.setDate(this.findParam(label), x, cal);
    }

    @Override
    public void setDouble(int i, double x) throws SQLException {
        Debug.logMethod("TbRowSet.setDouble", new Object[]{this, Integer.toString(i), Double.toString(x)});
        this.checkParameterIndex(i);
        this.params.add(i - 1, new Double(x));
    }

    @Override
    public void setDouble(String label, double x) throws SQLException {
        Debug.logMethod("TbRowSet.setDouble", new Object[]{this, label, Double.toString(x)});
        this.setDouble(this.findParam(label), x);
    }

    @Override
    public void setEscapeProcessing(boolean flag) {
        Debug.logMethod("TbRowSet.setEscapeProcessing", new Object[]{this, new Boolean(flag)});
        this.escapeProcessing = flag;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        Debug.logMethod("TbRowSet.setFetchDirection", new Object[]{this, Integer.toString(direction)});
        this.fetchDirection = direction;
    }

    @Override
    public void setFetchSize(int size) {
        Debug.logMethod("TbRowSet.setFetchSize", new Object[]{this, Integer.toString(size)});
        this.fetchSize = size;
    }

    @Override
    public void setFloat(int i, float x) throws SQLException {
        Debug.logMethod("TbRowSet.setFloat", new Object[]{this, Integer.toString(i), Float.toString(x)});
        this.checkParameterIndex(i);
        this.params.add(i - 1, new Float(x));
    }

    @Override
    public void setFloat(String label, float x) throws SQLException {
        Debug.logMethod("TbRowSet.setFloat", new Object[]{this, label, Float.toString(x)});
        this.setFloat(this.findParam(label), x);
    }

    @Override
    public void setInt(int i, int x) throws SQLException {
        Debug.logMethod("TbRowSet.setInt", new Object[]{this, Integer.toString(i), Integer.toString(x)});
        this.checkParameterIndex(i);
        this.params.add(i - 1, new Integer(x));
    }

    @Override
    public void setInt(String label, int x) throws SQLException {
        Debug.logMethod("TbRowSet.setInt", new Object[]{this, label, Integer.toString(x)});
        this.setInt(this.findParam(label), x);
    }

    @Override
    public void setLong(int i, long x) throws SQLException {
        Debug.logMethod("TbRowSet.setLong", new Object[]{this, Integer.toString(i), Long.toString(x)});
        this.checkParameterIndex(i);
        this.params.add(i - 1, new Long(x));
    }

    @Override
    public void setLong(String label, long x) throws SQLException {
        Debug.logMethod("TbRowSet.setLong", new Object[]{this, label, Long.toString(x)});
        this.setLong(this.findParam(label), x);
    }

    public void setMatchColumn(int columnIdx) throws SQLException {
        Debug.logMethod("TbRowSet.setMatchColumn", new Object[]{this, Integer.toString(columnIdx)});
        if (columnIdx <= 0) {
            throw TbError.newSQLException(-90840);
        }
        try {
            this.matchColumnIndexes.clear();
            this.matchColumnNames.clear();
            this.matchColumnIndexes.add(0, new Integer(columnIdx));
        }
        catch (Exception e) {
            throw TbError.newSQLException(-90832);
        }
    }

    public void setMatchColumn(int[] columnIndexes) throws SQLException {
        Debug.logMethod("TbRowSet.setMatchColumn", new Object[]{this, columnIndexes});
        this.matchColumnIndexes.clear();
        this.matchColumnNames.clear();
        if (columnIndexes == null) {
            throw TbError.newSQLException(-590762);
        }
        for (int i = 0; i < columnIndexes.length; ++i) {
            if (columnIndexes[i] <= 0) {
                throw TbError.newSQLException(-90840);
            }
            try {
                this.matchColumnIndexes.add(i, new Integer(columnIndexes[i]));
                continue;
            }
            catch (Exception e) {
                throw TbError.newSQLException(-90832);
            }
        }
    }

    public void setMatchColumn(String columnName) throws SQLException {
        Debug.logMethod("TbRowSet.setMatchColumn", new Object[]{this, columnName});
        if (columnName == null || columnName.equals("")) {
            throw TbError.newSQLException(-90841);
        }
        try {
            this.matchColumnIndexes.clear();
            this.matchColumnNames.clear();
            this.matchColumnNames.add(0, columnName.trim());
        }
        catch (Exception e) {
            throw TbError.newSQLException(-90833);
        }
    }

    public void setMatchColumn(String[] columnNames) throws SQLException {
        Debug.logMethod("TbRowSet.setMatchColumn", new Object[]{this, columnNames});
        this.matchColumnIndexes.clear();
        this.matchColumnNames.clear();
        if (columnNames == null) {
            throw TbError.newSQLException(-590763);
        }
        for (int i = 0; i < columnNames.length; ++i) {
            if (columnNames[i] == null || columnNames[i].equals("")) {
                throw TbError.newSQLException(-90841);
            }
            try {
                this.matchColumnNames.add(i, columnNames[i].trim());
                continue;
            }
            catch (Exception e) {
                throw TbError.newSQLException(-90833);
            }
        }
    }

    @Override
    public void setMaxFieldSize(int max) {
        Debug.logMethod("TbRowSet.setMaxFieldSize", new Object[]{this, Integer.toString(max)});
        this.maxFieldSize = max;
    }

    @Override
    public void setMaxRows(int max) {
        Debug.logMethod("TbRowSet.setMaxRows", new Object[]{this, Integer.toString(max)});
        this.maxRows = max;
    }

    @Override
    public void setNCharacterStream(int i, Reader x) throws SQLException {
        Debug.logMethod("TbRowSet.setNCharacterStream", new Object[]{this, Integer.toString(i), x});
        this.checkParameterIndex(i);
        Object[] obj = new Object[]{x, new Integer(Integer.MAX_VALUE), new Integer(4)};
        this.params.add(i - 1, obj);
    }

    @Override
    public void setNCharacterStream(int i, Reader x, long len) throws SQLException {
        Debug.logMethod("TbRowSet.setNCharacterStream", new Object[]{this, Integer.toString(i), x, Long.toString(len)});
        this.checkParameterIndex(i);
        Object[] obj = new Object[]{x, new Long(len), new Integer(4)};
        this.params.add(i - 1, obj);
    }

    @Override
    public void setNCharacterStream(String label, Reader x) throws SQLException {
        Debug.logMethod("TbRowSet.setNCharacterStream", new Object[]{this, label, x});
        this.setNCharacterStream(this.findParam(label), x);
    }

    @Override
    public void setNCharacterStream(String label, Reader x, long len) throws SQLException {
        Debug.logMethod("TbRowSet.setNCharacterStream", new Object[]{this, label, x, Long.toString(len)});
        this.setNCharacterStream(this.findParam(label), x, len);
    }

    @Override
    public void setNClob(int i, NClob x) throws SQLException {
        Debug.logMethod("TbRowSet.setNClob", new Object[]{this, Integer.toString(i), x});
        this.checkParameterIndex(i);
        this.params.add(i - 1, x);
    }

    @Override
    public void setNClob(int i, Reader x) throws SQLException {
        Debug.logMethod("TbRowSet.setNClob", new Object[]{this, Integer.toString(i), x});
        this.checkParameterIndex(i);
        Object[] obj = new Object[]{x, new Integer(Integer.MAX_VALUE), new Integer(7)};
        this.params.add(i - 1, obj);
    }

    @Override
    public void setNClob(int i, Reader x, long len) throws SQLException {
        Debug.logMethod("TbRowSet.setNClob", new Object[]{this, Integer.toString(i), x, Long.toString(len)});
        this.checkParameterIndex(i);
        Object[] obj = new Object[]{x, new Long(len), new Integer(7)};
        this.params.add(i - 1, obj);
    }

    @Override
    public void setNClob(String label, NClob x) throws SQLException {
        Debug.logMethod("TbRowSet.setNClob", new Object[]{this, label, x});
        this.setNClob(this.findParam(label), x);
    }

    @Override
    public void setNClob(String label, Reader x) throws SQLException {
        Debug.logMethod("TbRowSet.setNClob", new Object[]{this, label, x});
        this.setNClob(this.findParam(label), x);
    }

    @Override
    public void setNClob(String label, Reader x, long len) throws SQLException {
        Debug.logMethod("TbRowSet.setNClob", new Object[]{this, label, x, Long.toString(len)});
        this.setNClob(this.findParam(label), x, len);
    }

    @Override
    public void setNString(int i, String x) throws SQLException {
        Debug.logMethod("TbRowSet.setNString", new Object[]{this, Integer.toString(i), x});
        this.checkParameterIndex(i);
        Object[] obj = new Object[]{x, new Integer(0)};
        this.params.add(i - 1, obj);
    }

    @Override
    public void setNString(String label, String x) throws SQLException {
        Debug.logMethod("TbRowSet.setNString", new Object[]{this, label, x});
        this.setNString(this.findParam(label), x);
    }

    @Override
    public void setNull(int i, int sqlType) throws SQLException {
        Debug.logMethod("TbRowSet.setNull", new Object[]{this, Integer.toString(i), Integer.toString(sqlType)});
        this.checkParameterIndex(i);
        this.params.add(i - 1, null);
    }

    @Override
    public void setNull(int i, int sqlType, String typeName) throws SQLException {
        Debug.logMethod("TbRowSet.setNull", new Object[]{this, Integer.toString(i), Integer.toString(sqlType), typeName});
        this.checkParameterIndex(i);
        Object[] obj = new Object[]{new Integer(sqlType), typeName};
        this.params.add(i - 1, obj);
    }

    @Override
    public void setNull(String label, int sqlType) throws SQLException {
        Debug.logMethod("TbRowSet.setNull", new Object[]{this, label, Integer.toString(sqlType)});
        this.setNull(this.findParam(label), sqlType);
    }

    @Override
    public void setNull(String label, int sqlType, String typeName) throws SQLException {
        Debug.logMethod("TbRowSet.setNull", new Object[]{this, label, Integer.toString(sqlType), typeName});
        this.setNull(this.findParam(label), sqlType, typeName);
    }

    @Override
    public void setObject(int i, Object x) throws SQLException {
        Debug.logMethod("TbRowSet.setObject", new Object[]{this, Integer.toString(i), x});
        this.checkParameterIndex(i);
        this.params.add(i - 1, x);
    }

    @Override
    public void setObject(int i, Object x, int targetSqlType) throws SQLException {
        Debug.logMethod("TbRowSet.setObject", new Object[]{this, Integer.toString(i), x, Integer.toString(targetSqlType)});
        this.checkParameterIndex(i);
        Object[] obj = new Object[]{x, new Integer(targetSqlType)};
        this.params.add(i - 1, obj);
    }

    @Override
    public void setObject(int i, Object x, int targetSqlType, int scale) throws SQLException {
        Debug.logMethod("TbRowSet.setObject", new Object[]{this, Integer.toString(i), x, Integer.toString(targetSqlType), Integer.toString(scale)});
        this.checkParameterIndex(i);
        Object[] obj = new Object[]{x, new Integer(targetSqlType), new Integer(scale)};
        this.params.add(i - 1, obj);
    }

    @Override
    public void setObject(String label, Object x) throws SQLException {
        Debug.logMethod("TbRowSet.setObject", new Object[]{this, label, x});
        this.setObject(this.findParam(label), x);
    }

    @Override
    public void setObject(String label, Object x, int targetSqlType) throws SQLException {
        Debug.logMethod("TbRowSet.setObject", new Object[]{this, label, x, Integer.toString(targetSqlType)});
        this.setObject(this.findParam(label), x, targetSqlType);
    }

    @Override
    public void setObject(String label, Object x, int targetSqlType, int scale) throws SQLException {
        Debug.logMethod("TbRowSet.setObject", new Object[]{this, label, x, Integer.toString(targetSqlType), Integer.toString(scale)});
        this.setObject(this.findParam(label), x, targetSqlType, scale);
    }

    @Override
    public void setPassword(String pwd) {
        Debug.logMethod("TbRowSet.setPassword", new Object[]{this, pwd});
        this.password = pwd;
    }

    @Override
    public void setQueryTimeout(int seconds) {
        Debug.logMethod("TbRowSet.setQueryTimeout", new Object[]{this, Integer.toString(seconds)});
        this.queryTimeout = seconds;
    }

    @Override
    public void setReadOnly(boolean flag) {
        Debug.logMethod("TbRowSet.setReadOnly", new Object[]{this, new Boolean(flag)});
        this.readOnly = flag;
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        Debug.logMethod("TbRowSet.setRef", new Object[]{this, Integer.toString(i), x});
        this.checkParameterIndex(i);
        this.params.add(i - 1, x);
    }

    public void setRef(String label, Ref x) throws SQLException {
        Debug.logMethod("TbRowSet.setRef", new Object[]{this, label, x});
        this.setRef(this.findParam(label), x);
    }

    @Override
    public void setRowId(int i, RowId x) throws SQLException {
        Debug.logMethod("TbRowSet.setRowId", new Object[]{this, Integer.toString(i), x});
        this.checkParameterIndex(i);
        this.params.add(i - 1, x);
    }

    @Override
    public void setRowId(String label, RowId x) throws SQLException {
        Debug.logMethod("TbRowSet.setRowId", new Object[]{this, label, x});
        this.setRowId(this.findParam(label), x);
    }

    @Override
    public void setShort(int i, short x) throws SQLException {
        Debug.logMethod("TbRowSet.setShort", new Object[]{this, Integer.toString(i), Short.toString(x)});
        this.checkParameterIndex(i);
        this.params.add(i - 1, new Short(x));
    }

    @Override
    public void setShort(String label, short x) throws SQLException {
        Debug.logMethod("TbRowSet.setShort", new Object[]{this, label, Short.toString(x)});
        this.setShort(this.findParam(label), x);
    }

    public void setShowDeleted(boolean flag) throws SQLException {
        Debug.logMethod("TbRowSet.setShowDeleted", new Object[]{this, new Boolean(flag)});
        this.showDeleted = flag;
    }

    @Override
    public void setSQLXML(int i, SQLXML x) throws SQLException {
        Debug.logMethod("TbRowSet.setSQLXML", new Object[]{this, Integer.toString(i), x});
        this.checkParameterIndex(i);
        this.params.add(i - 1, x);
    }

    @Override
    public void setSQLXML(String label, SQLXML x) throws SQLException {
        Debug.logMethod("TbRowSet.setSQLXML", new Object[]{this, label, x});
        this.setSQLXML(this.findParam(label), x);
    }

    @Override
    public void setString(int i, String x) throws SQLException {
        Debug.logMethod("TbRowSet.setString", new Object[]{this, Integer.toString(i), x});
        this.checkParameterIndex(i);
        this.params.add(i - 1, x);
    }

    @Override
    public void setString(String label, String x) throws SQLException {
        Debug.logMethod("TbRowSet.setString", new Object[]{this, label, x});
        this.setString(this.findParam(label), x);
    }

    @Override
    public void setTime(int i, Time x) throws SQLException {
        Debug.logMethod("TbRowSet.setTime", new Object[]{this, Integer.toString(i), x});
        this.checkParameterIndex(i);
        this.params.add(i - 1, x);
    }

    @Override
    public void setTime(int i, Time x, Calendar cal) throws SQLException {
        this.checkParameterIndex(i);
        Debug.logMethod("TbRowSet.setTime", new Object[]{this, Integer.toString(i), x, cal});
        Object[] obj = new Object[]{x, cal};
        this.params.add(i - 1, obj);
    }

    @Override
    public void setTime(String label, Time x) throws SQLException {
        Debug.logMethod("TbRowSet.setTime", new Object[]{this, label, x});
        this.setTime(this.findParam(label), x);
    }

    @Override
    public void setTime(String label, Time x, Calendar cal) throws SQLException {
        Debug.logMethod("TbRowSet.setTime", new Object[]{this, label, x, cal});
        this.setTime(this.findParam(label), x);
    }

    @Override
    public void setTimestamp(int i, Timestamp x) throws SQLException {
        Debug.logMethod("TbRowSet.setTimestamp", new Object[]{this, Integer.toString(i), x});
        this.checkParameterIndex(i);
        this.params.add(i - 1, x);
    }

    @Override
    public void setTimestamp(int i, Timestamp x, Calendar cal) throws SQLException {
        Debug.logMethod("TbRowSet.setTimestamp", new Object[]{this, Integer.toString(i), x, cal});
        this.checkParameterIndex(i);
        Object[] obj = new Object[]{x, cal};
        this.params.add(i - 1, obj);
    }

    @Override
    public void setTimestamp(String label, Timestamp x) throws SQLException {
        Debug.logMethod("TbRowSet.setTimestamp", new Object[]{this, label, x});
        this.setTimestamp(this.findParam(label), x);
    }

    @Override
    public void setTimestamp(String label, Timestamp x, Calendar cal) throws SQLException {
        Debug.logMethod("TbRowSet.setTimestamp", new Object[]{this, label, x, cal});
        this.setTimestamp(this.findParam(label), x, cal);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        Debug.logMethod("TbRowSet.setTransactionIsolation", new Object[]{this, Integer.toString(level)});
        switch (level) {
            case 2: 
            case 8: {
                this.isolation = level;
                break;
            }
            default: {
                throw TbError.newSQLException(-90608);
            }
        }
    }

    @Override
    public void setType(int type) throws SQLException {
        Debug.logMethod("TbRowSet.setType", new Object[]{this, Integer.toString(type)});
        switch (type) {
            case 1003: 
            case 1004: 
            case 1005: {
                this.rowsetType = type;
                break;
            }
            default: {
                throw TbError.newSQLException(-90608);
            }
        }
    }

    public void setTypeMap(Map map) {
        Debug.logMethod("TbRowSet.setTypeMap", new Object[]{this, map});
        this.typeMap = map;
    }

    @Override
    public void setUrl(String url) {
        Debug.logMethod("TbRowSet.setUrl", new Object[]{this, url});
        this.url = url;
    }

    @Override
    public void setURL(int i, URL x) throws SQLException {
        Debug.logMethod("TbRowSet.setURL", new Object[]{this, Integer.toString(i), x});
        throw TbError.newSQLException(-90201);
    }

    public void setURL(String label, URL x) throws SQLException {
        Debug.logMethod("TbRowSet.setURL", new Object[]{this, label, x});
        this.setURL(this.findParam(label), x);
    }

    @Override
    public void setUsername(String name) {
        Debug.logMethod("TbRowSet.setUsername", new Object[]{this, name});
        this.username = name;
    }

    public void unsetMatchColumn(int columnIdx) throws SQLException {
        Debug.logMethod("TbRowSet.unsetMatchColumn", new Object[]{this, Integer.toString(columnIdx)});
        this.checkMatchColumnIndexesExist();
        if (columnIdx <= 0) {
            throw TbError.newSQLException(-90840);
        }
        int index = -1;
        try {
            index = this.matchColumnIndexes.get(0);
        }
        catch (Exception e) {
            throw TbError.newSQLException(-90860);
        }
        if (index != columnIdx) {
            throw TbError.newSQLException(-90866);
        }
        this.matchColumnIndexes.clear();
        this.matchColumnNames.clear();
    }

    public void unsetMatchColumn(int[] columnIndexes) throws SQLException {
        Debug.logMethod("TbRowSet.unsetMatchColumn", new Object[]{this, columnIndexes});
        this.checkMatchColumnIndexesExist();
        if (columnIndexes == null) {
            throw TbError.newSQLException(-590762);
        }
        int i = -1;
        for (int j = 0; j < columnIndexes.length; ++j) {
            if (columnIndexes[j] <= 0) {
                throw TbError.newSQLException(-90840);
            }
            try {
                i = this.matchColumnIndexes.get(j);
            }
            catch (Exception e) {
                throw TbError.newSQLException(-90860);
            }
            if (i == columnIndexes[j]) continue;
            throw TbError.newSQLException(-90866);
        }
        this.matchColumnIndexes.clear();
        this.matchColumnNames.clear();
    }

    public void unsetMatchColumn(String columnName) throws SQLException {
        Debug.logMethod("TbRowSet.unsetMatchColumn", new Object[]{this, columnName});
        this.checkMatchColumnNamesExist();
        if (columnName == null || columnName.equals("")) {
            throw TbError.newSQLException(-90841);
        }
        String name = null;
        try {
            name = this.matchColumnNames.get(0);
        }
        catch (Exception e) {
            throw TbError.newSQLException(-90861);
        }
        if (!name.equals(columnName.trim())) {
            throw TbError.newSQLException(-90867);
        }
        this.matchColumnIndexes.clear();
        this.matchColumnNames.clear();
    }

    public void unsetMatchColumn(String[] columnNames) throws SQLException {
        Debug.logMethod("TbRowSet.unsetMatchColumn", new Object[]{this, columnNames});
        this.checkMatchColumnNamesExist();
        if (columnNames == null) {
            throw TbError.newSQLException(-590763);
        }
        String name = null;
        for (int i = 0; i < columnNames.length; ++i) {
            if (columnNames[i] == null || columnNames[i].equals("")) {
                throw TbError.newSQLException(-90841);
            }
            try {
                name = this.matchColumnNames.get(i);
            }
            catch (Exception e) {
                throw TbError.newSQLException(-90861);
            }
            if (name.equals(columnNames[i])) continue;
            throw TbError.newSQLException(-90867);
        }
        this.matchColumnIndexes.clear();
        this.matchColumnNames.clear();
    }
}

