/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.rowset;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.rowset.TbWebRowSet;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import javax.sql.rowset.FilteredRowSet;
import javax.sql.rowset.Predicate;

public class TbFilteredRowSet
extends TbWebRowSet
implements FilteredRowSet {
    private static final long serialVersionUID = 8256521646635679356L;
    private Predicate predicate;
    private boolean isOnInsert;

    public TbFilteredRowSet() throws SQLException {
        Debug.logMethod("TbFilteredRowSet", new Object[]{this});
    }

    @Override
    public boolean absolute(int i) throws SQLException {
        int k;
        Debug.logMethod("TbFilteredRowSet.absolute", new Object[]{this, Integer.toString(i)});
        if (this.rowsetType == 1003) {
            throw TbError.newSQLException(-590761);
        }
        if (i == 0 || Math.abs(i) > this.rowCount) {
            return false;
        }
        int j = i >= 0 ? i : this.rowCount + i + 1;
        this.currentRowIndex = 0;
        for (k = 0; k < j && this.currentRowIndex <= this.rowCount; ++k) {
            if (this.next()) {
                continue;
            }
            return false;
        }
        if (k == j) {
            this.notifyCursorMoved();
            return true;
        }
        return false;
    }

    protected void checkAndFilterObject(int i, Object x) throws SQLException {
        if (this.predicate != null && !this.predicate.evaluate(x, i)) {
            throw TbError.newSQLException(-90864);
        }
    }

    @Override
    public Predicate getFilter() {
        return this.predicate;
    }

    @Override
    public void insertRow() throws SQLException {
        Debug.logMethod("TbFilteredRowSet.insertRow", new Object[]{this});
        this.isOnInsert = false;
        super.insertRow();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        Debug.logMethod("TbFilteredRowSet.moveToInsertRow", new Object[]{this});
        this.isOnInsert = true;
        super.moveToInsertRow();
    }

    @Override
    public boolean next() throws SQLException {
        Debug.logMethod("TbFilteredRowSet.next", new Object[]{this});
        if (this.rowCount <= 0) {
            return false;
        }
        if (this.currentRowIndex >= this.rowCount) {
            return false;
        }
        boolean flag = false;
        do {
            ++this.currentRowIndex;
            if (this.predicate != null && (this.predicate == null || !this.predicate.evaluate(this))) continue;
            flag = true;
            break;
        } while (this.currentRowIndex <= this.rowCount);
        if (flag) {
            this.notifyCursorMoved();
            return true;
        }
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        Debug.logMethod("TbFilteredRowSet.previous", new Object[]{this});
        if (this.rowsetType == 1003) {
            throw TbError.newSQLException(-590761);
        }
        if (this.rowCount <= 0) {
            return false;
        }
        if (this.currentRowIndex <= 1) {
            return false;
        }
        boolean flag = false;
        do {
            --this.currentRowIndex;
            if (this.predicate != null && (this.predicate == null || !this.predicate.evaluate(this))) continue;
            flag = true;
            break;
        } while (this.currentRowIndex >= 1);
        if (flag) {
            this.notifyCursorMoved();
            return true;
        }
        return false;
    }

    @Override
    public void setFilter(Predicate p) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.setFilter", new Object[]{this, p});
        this.predicate = p;
    }

    @Override
    public void updateArray(int i, Array x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateArray", new Object[]{this, Integer.toString(i), x});
        if (this.isOnInsert) {
            this.checkAndFilterObject(i, x);
        }
        super.updateArray(i, x);
    }

    @Override
    public void updateArray(String label, Array x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateArray", new Object[]{this, label, x});
        this.updateArray(this.findColumn(label), x);
    }

    @Override
    public void updateAsciiStream(int i, InputStream x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateAsciiStream", new Object[]{this, Integer.toString(i), x});
        if (this.isOnInsert) {
            this.checkAndFilterObject(i, x);
        }
        super.updateAsciiStream(i, x);
    }

    @Override
    public void updateAsciiStream(int i, InputStream x, int len) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateAsciiStream", new Object[]{this, Integer.toString(i), x, Integer.toString(len)});
        if (this.isOnInsert) {
            this.checkAndFilterObject(i, x);
        }
        super.updateAsciiStream(i, x, len);
    }

    @Override
    public void updateAsciiStream(int i, InputStream x, long len) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateAsciiStream", new Object[]{this, Integer.toString(i), x, Long.toString(len)});
        if (this.isOnInsert) {
            this.checkAndFilterObject(i, x);
        }
        super.updateAsciiStream(i, x, len);
    }

    @Override
    public void updateAsciiStream(String label, InputStream x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateAsciiStream", new Object[]{this, label, x});
        this.updateAsciiStream(this.findColumn(label), x);
    }

    @Override
    public void updateAsciiStream(String label, InputStream x, int len) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateAsciiStream", new Object[]{this, label, x, Integer.toString(len)});
        this.updateAsciiStream(this.findColumn(label), x, len);
    }

    @Override
    public void updateAsciiStream(String label, InputStream x, long len) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateAsciiStream", new Object[]{this, label, x, Long.toString(len)});
        this.updateAsciiStream(this.findColumn(label), x, len);
    }

    @Override
    public void updateBigDecimal(int i, BigDecimal x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateBigDecimal", new Object[]{this, Integer.toString(i), x});
        if (this.isOnInsert) {
            this.checkAndFilterObject(i, x);
        }
        super.updateBigDecimal(i, x);
    }

    @Override
    public void updateBigDecimal(String label, BigDecimal x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateBigDecimal", new Object[]{this, label, x});
        this.updateBigDecimal(this.findColumn(label), x);
    }

    @Override
    public void updateBinaryStream(int i, InputStream x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateBinaryStream", new Object[]{this, Integer.toString(i), x});
        if (this.isOnInsert) {
            this.checkAndFilterObject(i, x);
        }
        super.updateBinaryStream(i, x);
    }

    @Override
    public void updateBinaryStream(int i, InputStream x, int len) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateBinaryStream", new Object[]{this, Integer.toString(i), x, Integer.toString(len)});
        if (this.isOnInsert) {
            this.checkAndFilterObject(i, x);
        }
        super.updateBinaryStream(i, x, len);
    }

    @Override
    public void updateBinaryStream(int i, InputStream x, long len) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateBinaryStream", new Object[]{this, Integer.toString(i), x, Long.toString(len)});
        if (this.isOnInsert) {
            this.checkAndFilterObject(i, x);
        }
        super.updateBinaryStream(i, x, len);
    }

    @Override
    public void updateBinaryStream(String label, InputStream x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateBinaryStream", new Object[]{this, label, x});
        this.updateBinaryStream(this.findColumn(label), x);
    }

    @Override
    public void updateBinaryStream(String label, InputStream x, int len) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateBinaryStream", new Object[]{this, label, x, Integer.toString(len)});
        this.updateBinaryStream(this.findColumn(label), x, len);
    }

    @Override
    public void updateBinaryStream(String label, InputStream x, long len) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateBinaryStream", new Object[]{this, label, x, Long.toString(len)});
        this.updateBinaryStream(this.findColumn(label), x, len);
    }

    @Override
    public void updateBlob(int i, Blob x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateBlob", new Object[]{this, Integer.toString(i), x});
        if (this.isOnInsert) {
            this.checkAndFilterObject(i, x);
        }
        super.updateBlob(i, x);
    }

    @Override
    public void updateBlob(int i, InputStream x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateBlob", new Object[]{this, Integer.toString(i), x});
        if (this.isOnInsert) {
            this.checkAndFilterObject(i, x);
        }
        super.updateBlob(i, x);
    }

    @Override
    public void updateBlob(int i, InputStream x, long len) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateBlob", new Object[]{this, Integer.toString(i), x, Long.toString(len)});
        if (this.isOnInsert) {
            this.checkAndFilterObject(i, x);
        }
        super.updateBlob(i, x, len);
    }

    @Override
    public void updateBlob(String label, Blob x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateBlob", new Object[]{this, label, x});
        this.updateBlob(this.findColumn(label), x);
    }

    @Override
    public void updateBlob(String label, InputStream x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateBlob", new Object[]{this, label, x});
        this.updateBlob(this.findColumn(label), x);
    }

    @Override
    public void updateBlob(String label, InputStream x, long len) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateBlob", new Object[]{this, label, x, Long.toString(len)});
        this.updateBlob(this.findColumn(label), x, len);
    }

    @Override
    public void updateBoolean(int i, boolean x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateBoolean", new Object[]{this, Integer.toString(i), new Boolean(x)});
        if (this.isOnInsert) {
            this.checkAndFilterObject(i, new Boolean(x));
        }
        super.updateBoolean(i, x);
    }

    @Override
    public void updateBoolean(String label, boolean x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateBoolean", new Object[]{this, label, new Boolean(x)});
        this.updateBoolean(this.findColumn(label), x);
    }

    @Override
    public void updateByte(int i, byte x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateByte", new Object[]{this, Integer.toString(i), Byte.toString(x)});
        if (this.isOnInsert) {
            this.checkAndFilterObject(i, new Byte(x));
        }
        super.updateByte(i, x);
    }

    @Override
    public void updateByte(String label, byte x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateByte", new Object[]{this, label, Byte.toString(x)});
        this.updateByte(this.findColumn(label), x);
    }

    @Override
    public void updateBytes(int i, byte[] x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateBytes", new Object[]{this, Integer.toString(i), x});
        if (this.isOnInsert) {
            this.checkAndFilterObject(i, x);
        }
        super.updateBytes(i, x);
    }

    @Override
    public void updateBytes(String label, byte[] x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateBytes", new Object[]{this, label, x});
        this.updateBytes(this.findColumn(label), x);
    }

    @Override
    public void updateCharacterStream(int i, Reader x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateCharacterStream", new Object[]{this, Integer.toString(i), x});
        if (this.isOnInsert) {
            this.checkAndFilterObject(i, x);
        }
        super.updateCharacterStream(i, x);
    }

    @Override
    public void updateCharacterStream(int i, Reader x, int len) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateCharacterStream", new Object[]{this, Integer.toString(i), x, Integer.toString(len)});
        if (this.isOnInsert) {
            this.checkAndFilterObject(i, x);
        }
        super.updateCharacterStream(i, x, len);
    }

    @Override
    public void updateCharacterStream(int i, Reader x, long len) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateCharacterStream", new Object[]{this, Integer.toString(i), x, Long.toString(len)});
        if (this.isOnInsert) {
            this.checkAndFilterObject(i, x);
        }
        super.updateCharacterStream(i, x, len);
    }

    @Override
    public void updateCharacterStream(String label, Reader x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateCharacterStream", new Object[]{this, label, x});
        this.updateCharacterStream(this.findColumn(label), x);
    }

    @Override
    public void updateCharacterStream(String label, Reader x, int len) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateCharacterStream", new Object[]{this, label, x, Integer.toString(len)});
        this.updateCharacterStream(this.findColumn(label), x, len);
    }

    @Override
    public void updateCharacterStream(String label, Reader x, long len) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateCharacterStream", new Object[]{this, label, x, Long.toString(len)});
        this.updateCharacterStream(this.findColumn(label), x, len);
    }

    @Override
    public void updateClob(int i, Clob x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateClob", new Object[]{this, Integer.toString(i), x});
        if (this.isOnInsert) {
            this.checkAndFilterObject(i, x);
        }
        super.updateClob(i, x);
    }

    @Override
    public void updateClob(int i, Reader x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateClob", new Object[]{this, Integer.toString(i), x});
        if (this.isOnInsert) {
            this.checkAndFilterObject(i, x);
        }
        super.updateClob(i, x);
    }

    @Override
    public void updateClob(int i, Reader x, long len) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateClob", new Object[]{this, Integer.toString(i), x, Long.toString(len)});
        if (this.isOnInsert) {
            this.checkAndFilterObject(i, x);
        }
        super.updateClob(i, x, len);
    }

    @Override
    public void updateClob(String label, Clob x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateClob", new Object[]{this, label, x});
        this.updateClob(this.findColumn(label), x);
    }

    @Override
    public void updateClob(String label, Reader x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateClob", new Object[]{this, label, x});
        this.updateClob(this.findColumn(label), x);
    }

    @Override
    public void updateClob(String label, Reader x, long len) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateClob", new Object[]{this, label, x, Long.toString(len)});
        this.updateClob(this.findColumn(label), x, len);
    }

    @Override
    public void updateDate(int i, Date x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateDate", new Object[]{this, Integer.toString(i), x});
        if (this.isOnInsert) {
            this.checkAndFilterObject(i, x);
        }
        super.updateDate(i, x);
    }

    @Override
    public void updateDate(String label, Date x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateDate", new Object[]{this, label, x});
        this.updateDate(this.findColumn(label), x);
    }

    @Override
    public void updateDouble(int i, double x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateDouble", new Object[]{this, Integer.toString(i), Double.toString(x)});
        if (this.isOnInsert) {
            this.checkAndFilterObject(i, new Double(x));
        }
        super.updateDouble(i, x);
    }

    @Override
    public void updateDouble(String label, double x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateDouble", new Object[]{this, label, Double.toString(x)});
        this.updateDouble(this.findColumn(label), x);
    }

    @Override
    public void updateFloat(int i, float x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateFloat", new Object[]{this, Integer.toString(i), Float.toString(x)});
        if (this.isOnInsert) {
            this.checkAndFilterObject(i, new Float(x));
        }
        super.updateFloat(i, x);
    }

    @Override
    public void updateFloat(String label, float x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateFloat", new Object[]{this, label, Float.toString(x)});
        this.updateFloat(this.findColumn(label), x);
    }

    @Override
    public void updateInt(int i, int x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateInt", new Object[]{this, Integer.toString(i), Integer.toString(x)});
        if (this.isOnInsert) {
            this.checkAndFilterObject(i, new Integer(x));
        }
        super.updateInt(i, x);
    }

    @Override
    public void updateInt(String label, int x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateInt", new Object[]{this, label, Integer.toString(x)});
        this.updateInt(this.findColumn(label), x);
    }

    @Override
    public void updateLong(int i, long x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateLong", new Object[]{this, Integer.toString(i), Long.toString(x)});
        if (this.isOnInsert) {
            this.checkAndFilterObject(i, new Long(x));
        }
        super.updateLong(i, x);
    }

    @Override
    public void updateLong(String label, long x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateLong", new Object[]{this, label, Long.toString(x)});
        this.updateLong(this.findColumn(label), x);
    }

    @Override
    public void updateNCharacterStream(int i, Reader x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateNCharacterStream", new Object[]{this, Integer.toString(i), x});
        if (this.isOnInsert) {
            this.checkAndFilterObject(i, x);
        }
        super.updateNCharacterStream(i, x);
    }

    @Override
    public void updateNCharacterStream(int i, Reader x, long len) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateNCharacterStream", new Object[]{this, Integer.toString(i), x, Long.toString(len)});
        if (this.isOnInsert) {
            this.checkAndFilterObject(i, x);
        }
        super.updateNCharacterStream(i, x, len);
    }

    @Override
    public void updateNCharacterStream(String label, Reader x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateNCharacterStream", new Object[]{this, label, x});
        this.updateNCharacterStream(this.findColumn(label), x);
    }

    @Override
    public void updateNCharacterStream(String label, Reader x, long len) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateNCharacterStream", new Object[]{this, label, x, Long.toString(len)});
        this.updateNCharacterStream(this.findColumn(label), x, len);
    }

    @Override
    public void updateNClob(int i, NClob x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateNClob", new Object[]{this, Integer.toString(i), x});
        if (this.isOnInsert) {
            this.checkAndFilterObject(i, x);
        }
        super.updateNClob(i, x);
    }

    @Override
    public void updateNClob(int i, Reader x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateNClob", new Object[]{this, Integer.toString(i), x});
        if (this.isOnInsert) {
            this.checkAndFilterObject(i, x);
        }
        super.updateNClob(i, x);
    }

    @Override
    public void updateNClob(int i, Reader x, long len) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateNClob", new Object[]{this, Integer.toString(i), x, Long.toString(len)});
        if (this.isOnInsert) {
            this.checkAndFilterObject(i, x);
        }
        super.updateNClob(i, x, len);
    }

    @Override
    public void updateNClob(String label, NClob x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateNClob", new Object[]{this, label, x});
        this.updateNClob(this.findColumn(label), x);
    }

    @Override
    public void updateNClob(String label, Reader x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateNClob", new Object[]{this, label, x});
        this.updateNClob(this.findColumn(label), x);
    }

    @Override
    public void updateNClob(String label, Reader x, long len) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateNClob", new Object[]{this, label, x, Long.toString(len)});
        this.updateNClob(this.findColumn(label), x, len);
    }

    @Override
    public void updateNString(int i, String x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateNString", new Object[]{this, Integer.toString(i), x});
        if (this.isOnInsert) {
            this.checkAndFilterObject(i, x);
        }
        super.updateNString(i, x);
    }

    @Override
    public void updateNString(String label, String x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateNString", new Object[]{this, label, x});
        this.updateNString(this.findColumn(label), x);
    }

    @Override
    public void updateObject(int i, Object x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateObject", new Object[]{this, Integer.toString(i), x});
        if (this.isOnInsert) {
            this.checkAndFilterObject(i, x);
        }
        super.updateObject(i, x);
    }

    @Override
    public void updateObject(int i, Object x, int scale) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateObject", new Object[]{this, Integer.toString(i), x, Integer.toString(scale)});
        if (this.isOnInsert) {
            this.checkAndFilterObject(i, x);
        }
        super.updateObject(i, x, scale);
    }

    @Override
    public void updateObject(String label, Object x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateObject", new Object[]{this, label, x});
        this.updateObject(this.findColumn(label), x);
    }

    @Override
    public void updateObject(String label, Object x, int scale) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateObject", new Object[]{this, label, x, Integer.toString(scale)});
        this.updateObject(this.findColumn(label), x, scale);
    }

    @Override
    public void updateRef(int i, Ref x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateRef", new Object[]{this, Integer.toString(i), x});
        if (this.isOnInsert) {
            this.checkAndFilterObject(i, x);
        }
        super.updateRef(i, x);
    }

    @Override
    public void updateRef(String label, Ref x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateRef", new Object[]{this, label, x});
        this.updateRef(this.findColumn(label), x);
    }

    @Override
    public void updateRowId(int i, RowId x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateRowId", new Object[]{this, Integer.toString(i), x});
        if (this.isOnInsert) {
            this.checkAndFilterObject(i, x);
        }
        super.updateRowId(i, x);
    }

    @Override
    public void updateRowId(String label, RowId x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateRowId", new Object[]{this, label, x});
        this.updateRowId(this.findColumn(label), x);
    }

    @Override
    public void updateShort(int i, short x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateShort", new Object[]{this, Integer.toString(i), Short.toString(x)});
        if (this.isOnInsert) {
            this.checkAndFilterObject(i, new Short(x));
        }
        super.updateShort(i, x);
    }

    @Override
    public void updateShort(String label, short x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateShort", new Object[]{this, label, Short.toString(x)});
        this.updateShort(this.findColumn(label), x);
    }

    @Override
    public void updateSQLXML(int i, SQLXML x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateSQLXML", new Object[]{this, Integer.toString(i), x});
        if (this.isOnInsert) {
            this.checkAndFilterObject(i, x);
        }
        super.updateSQLXML(i, x);
    }

    @Override
    public void updateSQLXML(String label, SQLXML x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateSQLXML", new Object[]{this, label, x});
        this.updateSQLXML(this.findColumn(label), x);
    }

    @Override
    public void updateString(int i, String x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateString", new Object[]{this, Integer.toString(i), x});
        if (this.isOnInsert) {
            this.checkAndFilterObject(i, x);
        }
        super.updateString(i, x);
    }

    @Override
    public void updateString(String label, String x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateString", new Object[]{this, label, x});
        this.updateString(this.findColumn(label), x);
    }

    @Override
    public void updateTime(int i, Time x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateTime", new Object[]{this, Integer.toString(i), x});
        if (this.isOnInsert) {
            this.checkAndFilterObject(i, x);
        }
        super.updateTime(i, x);
    }

    @Override
    public void updateTime(String label, Time x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateTime", new Object[]{this, label, x});
        this.updateTime(this.findColumn(label), x);
    }

    @Override
    public void updateTimestamp(int i, Timestamp x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateTimestamp", new Object[]{this, Integer.toString(i), x});
        if (this.isOnInsert) {
            this.checkAndFilterObject(i, x);
        }
        super.updateTimestamp(i, x);
    }

    @Override
    public void updateTimestamp(String label, Timestamp x) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateTimestamp", new Object[]{this, label, x});
        this.updateTimestamp(this.findColumn(label), x);
    }
}

