/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.ext;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.TbPreparedStatement;
import com.tmax.tibero.jdbc.data.ParamContainer;
import com.tmax.tibero.jdbc.data.TbDate;
import com.tmax.tibero.jdbc.data.TbTimestamp;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.ext.TbLogicalConnection;
import com.tmax.tibero.jdbc.ext.TbStatementEventHandler;
import com.tmax.tibero.jdbc.msg.TbPivotInfo;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.sql.PooledConnection;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;

public class TbLogicalPreparedStatement
extends TbPreparedStatement
implements TbStatementEventHandler {
    private TbLogicalConnection logicalConn = null;
    private boolean closed = true;
    protected com.tmax.tibero.jdbc.driver.TbPreparedStatement physicalStmt = null;
    protected HashMap<StatementEventListener, StatementEventListener> stmtEventMap = null;

    public TbLogicalPreparedStatement(TbLogicalConnection tbLogicalConnection, com.tmax.tibero.jdbc.driver.TbPreparedStatement stmt) throws SQLException {
        Debug.logMethod("TbLogicalStatement", new Object[]{this, tbLogicalConnection, stmt});
        this.logicalConn = tbLogicalConnection;
        this.stmtEventMap = this.logicalConn.getStatementEventListeners();
        this.physicalStmt = stmt;
        if (stmt.isClosed()) {
            this.closed = true;
            throw TbError.newSQLException(-90658);
        }
        this.closed = false;
    }

    @Override
    public void addBatch() throws SQLException {
        Debug.logMethod("TbLogicalStatement.addBatch", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.addBatch();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        Debug.logMethod("TbLogicalStatement.addBatch", new Object[]{this, this.physicalStmt, sql});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.addBatch(sql);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void addPivotData(byte[] data) {
        if (this.physicalStmt != null) {
            this.physicalStmt.addPivotData(data);
        }
    }

    @Override
    public void cancel() throws SQLException {
        Debug.logMethod("TbLogicalStatement.cancel", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.cancel();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        Debug.logMethod("TbLogicalStatement.clearBatch", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        this.physicalStmt.clearBatch();
    }

    @Override
    public void clearParameters() throws SQLException {
        Debug.logMethod("TbLogicalStatement.clearParameters", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.clearParameters();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        Debug.logMethod("TbLogicalStatement.clearWarnings", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.clearWarnings();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void close() throws SQLException {
        Debug.logMethod("TbLogicalStatement.close", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            return;
        }
        this.closed = true;
        this.physicalStmt.resetForCache();
        this.notifyClosedEvent();
    }

    @Override
    public void closeInternal() throws SQLException {
        if (this.physicalStmt != null) {
            this.physicalStmt.closeInternal();
        }
    }

    @Override
    public boolean execute() throws SQLException {
        Debug.logMethod("TbLogicalStatement.execute", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.execute();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        Debug.logMethod("TbLogicalStatement.execute", new Object[]{this, this.physicalStmt, sql});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.execute(sql);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        Debug.logMethod("TbLogicalStatement.execute", new Object[]{this, this.physicalStmt, sql, Integer.toString(autoGeneratedKeys)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.execute(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        Debug.logMethod("TbLogicalStatement.execute", new Object[]{this, this.physicalStmt, sql, columnIndexes});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.execute(sql, columnIndexes);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        Debug.logMethod("TbLogicalStatement.execute", new Object[]{this, this.physicalStmt, sql, columnNames});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.execute(sql, columnNames);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        Debug.logMethod("TbLogicalStatement.executeBatch", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.executeBatch();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        Debug.logMethod("TbLogicalStatement.executeQuery", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.executeQuery();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        Debug.logMethod("TbLogicalStatement.executeQuery", new Object[]{this, this.physicalStmt, sql});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.executeQuery(sql);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        Debug.logMethod("TbLogicalStatement.executeUpdate", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.executeUpdate();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        Debug.logMethod("TbLogicalStatement.executeUpdate", new Object[]{this, this.physicalStmt, sql});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.executeUpdate(sql);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        Debug.logMethod("TbLogicalStatement.executeUpdate", new Object[]{this, this.physicalStmt, sql, Integer.toString(autoGeneratedKeys)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.executeUpdate(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        Debug.logMethod("TbLogicalStatement.executeUpdate", new Object[]{this, this.physicalStmt, sql, columnIndexes});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.executeUpdate(sql, columnIndexes);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        Debug.logMethod("TbLogicalStatement.executeUpdate", new Object[]{this, this.physicalStmt, sql, columnNames});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.executeUpdate(sql, columnNames);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        Debug.logMethod("TbLogicalStatement.getConnection", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        return this.logicalConn;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        Debug.logMethod("TbLogicalStatement.getFetchDirection", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getFetchDirection();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        Debug.logMethod("TbLogicalStatement.getFetchDirection", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getFetchDirection();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        Debug.logMethod("TbLogicalStatement.getGeneratedKeys", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getGeneratedKeys();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        Debug.logMethod("TbLogicalStatement.getMaxFieldSize", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getMaxFieldSize();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        Debug.logMethod("TbLogicalStatement.getMaxRows", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getMaxRows();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        Debug.logMethod("TbLogicalStatement.getMetaData", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getMetaData();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        Debug.logMethod("TbLogicalStatement.getMoreResults", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getMoreResults();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        Debug.logMethod("TbLogicalStatement.getMoreResults", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getMoreResults();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public String getOriginalSql() {
        if (this.physicalStmt != null) {
            return this.physicalStmt.getOriginalSql();
        }
        return null;
    }

    @Override
    public ParamContainer getParamContainer() {
        if (this.physicalStmt != null) {
            return this.physicalStmt.getParamContainer();
        }
        return null;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        Debug.logMethod("TbLogicalStatement.getParameterMetaData", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getParameterMetaData();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public Vector<byte[]> getPivotData() {
        if (this.physicalStmt != null) {
            return this.physicalStmt.getPivotData();
        }
        return null;
    }

    @Override
    public TbPivotInfo[] getPivotInfo() {
        if (this.physicalStmt != null) {
            return this.physicalStmt.getPivotInfo();
        }
        return null;
    }

    @Override
    public byte[] getPPID() {
        if (this.physicalStmt != null) {
            return this.physicalStmt.getPPID();
        }
        return null;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        Debug.logMethod("TbLogicalStatement.getQueryTimeout", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getQueryTimeout();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        Debug.logMethod("TbLogicalStatement.getResultSet", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getResultSet();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        Debug.logMethod("TbLogicalStatement.getResultSetConcurrency", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        return this.physicalStmt.getResultSetConcurrency();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        Debug.logMethod("TbLogicalStatement.getResultSetHoldability", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getResultSetHoldability();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        Debug.logMethod("TbLogicalStatement.getResultSetType", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getResultSetType();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public int getSqlType() {
        if (this.physicalStmt != null) {
            return this.physicalStmt.getSqlType();
        }
        return 0;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        Debug.logMethod("TbLogicalStatement.getUpdateCount", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getUpdateCount();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        Debug.logMethod("TbLogicalStatement.getWarnings", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getWarnings();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        Debug.logMethod("TbLogicalStatement.isPoolable", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.isPoolable();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        Debug.logMethod("TbLogicalStatement.isWrapperFor", new Object[]{this, this.physicalStmt, iface});
        return iface.isInstance(this);
    }

    @Override
    public void notifyClosedEvent() {
        Debug.logMethod("TbLogicalStatement.notifyClosedEvent", new Object[]{this});
        if (this.physicalStmt != null && this.stmtEventMap != null) {
            Iterator<StatementEventListener> itr = this.stmtEventMap.keySet().iterator();
            while (itr.hasNext()) {
                StatementEventListener listener = this.stmtEventMap.get(itr.next());
                listener.statementClosed(new StatementEvent((PooledConnection)((Object)this.logicalConn.getEventHandler()), this));
            }
        }
    }

    @Override
    public void notifyExceptionEvent(PreparedStatement ps, Exception e) {
        Debug.logMethod("TbLogicalStatement.notifyExceptionEvent", new Object[]{this, e});
        if (this.physicalStmt != null && this.stmtEventMap != null) {
            Iterator<StatementEventListener> itr = this.stmtEventMap.keySet().iterator();
            while (itr.hasNext()) {
                StatementEventListener listener = this.stmtEventMap.get(itr.next());
                listener.statementErrorOccurred(new StatementEvent((PooledConnection)((Object)this.logicalConn.getEventHandler()), this, (SQLException)e));
            }
        }
    }

    @Override
    public void resetForCache() {
        if (this.physicalStmt != null) {
            this.physicalStmt.resetForCache();
        }
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setArray", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setArray(parameterIndex, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setAsciiStream", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setAsciiStream(parameterIndex, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setAsciiStream", new Object[]{this, this.physicalStmt, x, Integer.toString(length)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setAsciiStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setAsciiStream", new Object[]{this, this.physicalStmt, x, Long.toString(length)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setAsciiStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setBigDecimal", new Object[]{this, this.physicalStmt, x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBigDecimal(parameterIndex, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setBinaryDouble(int i, double x) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setBinaryDouble", new Object[]{this, this.physicalStmt, Integer.toString(i), Long.toHexString(Double.doubleToLongBits(x))});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBinaryDouble(i, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setBinaryFloat(int i, float x) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setBinaryFloat", new Object[]{this, this.physicalStmt, Integer.toString(i), Long.toHexString(Float.floatToIntBits(x))});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBinaryFloat(i, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setBinaryStream", new Object[]{this, this.physicalStmt, x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBinaryStream(parameterIndex, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setBinaryStream", new Object[]{this, this.physicalStmt, x, Integer.toString(length)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBinaryStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setBinaryStream", new Object[]{this, this.physicalStmt, x, Long.toString(length)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBinaryStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setBlob", new Object[]{this, this.physicalStmt, x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBlob(parameterIndex, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream x) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setBlob", new Object[]{this, this.physicalStmt, x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBlob(parameterIndex, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream x, long length) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setBlob", new Object[]{this, this.physicalStmt, x, Long.toString(length)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBlob(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setBoolean", new Object[]{this, this.physicalStmt, new Boolean(x)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBoolean(parameterIndex, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setByte", new Object[]{this, this.physicalStmt, Byte.toString(x)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setByte(parameterIndex, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setBytes", new Object[]{this, this.physicalStmt, x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBytes(parameterIndex, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setBytes(int i, int dataType, byte[] x) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setBytes", new Object[]{this, this.physicalStmt, Integer.toString(i), Integer.toString(dataType), x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBytes(i, dataType, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setCharacterStream", new Object[]{this, this.physicalStmt, x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setCharacterStream(parameterIndex, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x, int length) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setCharacterStream", new Object[]{this, this.physicalStmt, x, Integer.toString(length)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setCharacterStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x, long length) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setCharacterStream", new Object[]{this, this.physicalStmt, x, Long.toString(length)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setCharacterStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setClob", new Object[]{this, this.physicalStmt, x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setClob(parameterIndex, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setClob(int parameterIndex, Reader x) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setClob", new Object[]{this, this.physicalStmt, x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setClob(parameterIndex, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setClob(int parameterIndex, Reader x, long length) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setClob", new Object[]{this, this.physicalStmt, x, Long.toString(length)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setClob(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setCursorName", new Object[]{this, this.physicalStmt, name});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setCursorName(name);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setDate", new Object[]{this, this.physicalStmt, x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setDate(parameterIndex, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setDate", new Object[]{this, this.physicalStmt, x, cal});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setDate(parameterIndex, x, cal);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setDouble", new Object[]{this, this.physicalStmt, Double.toString(x)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setDouble(parameterIndex, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setEscapeProcessing", new Object[]{this, this.physicalStmt, new Boolean(enable)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setEscapeProcessing(enable);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setFetchDirection", new Object[]{this, this.physicalStmt, Integer.toString(direction)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setFetchDirection(direction);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setFetchSize", new Object[]{this, this.physicalStmt, Integer.toString(rows)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setFetchSize(rows);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setFixedCHAR(int parameterIndex, String x) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setFixedCHAR", new Object[]{this, Integer.toString(parameterIndex), x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setFixedCHAR(parameterIndex, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setFloat", new Object[]{this, this.physicalStmt, Float.toString(x)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setFloat(parameterIndex, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setInt", new Object[]{this, this.physicalStmt, Integer.toString(x)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setInt(parameterIndex, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setLong", new Object[]{this, this.physicalStmt, Long.toString(x)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setLong(parameterIndex, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setMaxFieldSize", new Object[]{this, this.physicalStmt, Integer.toString(max)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setMaxFieldSize(max);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setMaxRows", new Object[]{this, this.physicalStmt, Integer.toString(max)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setMaxRows(max);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader x) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setNCharacterStream", new Object[]{this, this.physicalStmt, x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNCharacterStream(parameterIndex, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader x, long length) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setNCharacterStream", new Object[]{this, this.physicalStmt, x, Long.toString(length)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNCharacterStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setNClob(int i, Clob x) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setNClob", new Object[]{this, this.physicalStmt, Integer.toString(i), x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNClob(i, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setNClob(int parameterIndex, NClob x) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setNClob", new Object[]{this, this.physicalStmt, x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNClob(parameterIndex, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setNClob(int parameterIndex, Reader x) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setNClob", new Object[]{this, this.physicalStmt, x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNClob(parameterIndex, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setNClob(int parameterIndex, Reader x, long length) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setNClob", new Object[]{this, this.physicalStmt, x, Long.toString(length)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNClob(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setNString(int parameterIndex, String x) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setNString", new Object[]{this, this.physicalStmt, x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNString(parameterIndex, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setNull", new Object[]{this, this.physicalStmt, Integer.toString(sqlType)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNull(parameterIndex, sqlType);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setNull", new Object[]{this, this.physicalStmt, Integer.toString(sqlType), typeName});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNull(parameterIndex, sqlType, typeName);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setObject", new Object[]{this, this.physicalStmt, x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setObject(parameterIndex, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setObject", new Object[]{this, this.physicalStmt, x, Integer.toString(targetSqlType)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setObject(parameterIndex, x, targetSqlType);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setObject", new Object[]{this, this.physicalStmt, x, Integer.toString(targetSqlType), Integer.toString(scaleOrLength)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setPivotInfo(TbPivotInfo[] info) {
        if (this.physicalStmt != null) {
            this.physicalStmt.setPivotInfo(info);
        }
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setPoolable", new Object[]{this, this.physicalStmt, new Boolean(poolable)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setPoolable(poolable);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setQueryTimeout", new Object[]{this, this.physicalStmt, Integer.toString(seconds)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setQueryTimeout(seconds);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setRef", new Object[]{this, this.physicalStmt, x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setRef(parameterIndex, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setRowId", new Object[]{this, this.physicalStmt, x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setRowId(parameterIndex, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setShort", new Object[]{this, this.physicalStmt, Short.toString(x)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setShort(parameterIndex, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML x) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setSQLXML", new Object[]{this, this.physicalStmt, x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setSQLXML(parameterIndex, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setString", new Object[]{this, this.physicalStmt, x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setString(parameterIndex, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setTbDate(int i, TbDate x) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setTbDate", new Object[]{this, this.physicalStmt, Integer.toString(i), x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setTbDate(i, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setTbTimestamp(int i, TbTimestamp x) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setTbTimestamp", new Object[]{this, this.physicalStmt, Integer.toString(i), x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setTbTimestamp(i, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setTime", new Object[]{this, this.physicalStmt, x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setTime(parameterIndex, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setTime", new Object[]{this, this.physicalStmt, x, cal});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setTime(parameterIndex, x, cal);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setTimestamp", new Object[]{this, this.physicalStmt, x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setTimestamp(parameterIndex, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setTimestamp", new Object[]{this, this.physicalStmt, x, cal});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setTimestamp(parameterIndex, x, cal);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setUnicodeStream", new Object[]{this, this.physicalStmt, x, Integer.toString(length)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setUnicodeStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setURL", new Object[]{this, this.physicalStmt, x});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setURL(parameterIndex, x);
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(this.physicalStmt, e);
            throw e;
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        Debug.logMethod("TbLogicalStatement.unwrap", new Object[]{this, this.physicalStmt, iface});
        try {
            return iface.cast(this);
        }
        catch (ClassCastException e) {
            throw TbError.newSQLException(-90657);
        }
    }
}

