/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.driver;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.driver.TbTimeout;

public class TbTimeoutPollingThread
extends Thread {
    private int count;
    private long sleepMillis;
    private TbTimeout[] registeredTimeouts;

    public TbTimeoutPollingThread() {
        super("TbTimeoutPollingThread");
        Debug.logMethod("TbTimeoutPollingThread", new String[]{"TbTimeoutPollingThread"}, new Object[]{this});
        this.setDaemon(true);
        this.setPriority(10);
        this.registeredTimeouts = new TbTimeout[2];
        this.count = 0;
        this.sleepMillis = 1000L;
        this.start();
    }

    public synchronized void add(TbTimeout t) {
        Debug.logMethod("TbTimeoutPollingThread.add", new String[]{"timeout"}, new Object[]{t});
        int i = 0;
        if (this.count >= this.registeredTimeouts.length) {
            TbTimeout[] newKnownTimeout = new TbTimeout[this.registeredTimeouts.length * 4];
            System.arraycopy(this.registeredTimeouts, 0, newKnownTimeout, 0, this.registeredTimeouts.length);
            i = this.registeredTimeouts.length;
            this.registeredTimeouts = newKnownTimeout;
        }
        while (i < this.registeredTimeouts.length) {
            if (this.registeredTimeouts[i] == null) {
                this.registeredTimeouts[i] = t;
                ++this.count;
                break;
            }
            ++i;
        }
    }

    private void poll() {
        Debug.logMethod("TbTimeoutPollingThread.poll", new String[]{"TbTimeoutPolling"}, new Object[]{this});
        if (this.count > 0) {
            long now = System.currentTimeMillis();
            for (int i = 0; i < this.registeredTimeouts.length; ++i) {
                try {
                    if (this.registeredTimeouts[i] == null) continue;
                    this.registeredTimeouts[i].cancelStmtOfTimeover(now);
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
    }

    public synchronized void remove(TbTimeout t) {
        Debug.logMethod("TbTimeoutPollingThread.remove", new String[]{"timeout"}, new Object[]{t});
        for (int i = 0; i < this.registeredTimeouts.length; ++i) {
            if (this.registeredTimeouts[i] != t) continue;
            this.registeredTimeouts[i] = null;
            --this.count;
            break;
        }
    }

    @Override
    public void run() {
        Debug.logMethod("TbTimeoutPollingThread.run", new String[]{"TbTimeoutPolling"}, new Object[]{this});
        while (true) {
            try {
                Thread.sleep(this.sleepMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.poll();
        }
    }
}

