/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.driver;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.TbArrayDescriptor;
import com.tmax.tibero.jdbc.TbNClob;
import com.tmax.tibero.jdbc.TbSQLXML;
import com.tmax.tibero.jdbc.TbTypeDescriptor;
import com.tmax.tibero.jdbc.data.Column;
import com.tmax.tibero.jdbc.data.DataType;
import com.tmax.tibero.jdbc.data.DataTypeConverter;
import com.tmax.tibero.jdbc.data.Row;
import com.tmax.tibero.jdbc.data.ServerInfo;
import com.tmax.tibero.jdbc.data.TbDate;
import com.tmax.tibero.jdbc.data.TbTimestamp;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.driver.TbResultSet;
import com.tmax.tibero.jdbc.driver.TbResultSetMetaData;
import com.tmax.tibero.jdbc.driver.TbStatement;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.util.TbCommon;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public abstract class TbResultSetBase
extends TbResultSet {
    public static final int EMPTY_CURSOR_ID = -1;
    public static final int EMPTY_RSET = -2;
    private static final long CRC_POLY = 79764919L;
    protected TbStatement stmt;
    protected int csrID = -1;
    protected DataTypeConverter typeConverter;
    protected int columnCount = -1;
    protected Column[] cols;
    protected HashMap<String, Integer> columnNameMap;
    protected int beginColumnIndex = 0;
    protected int currentRowIndex = -1;
    protected int currentFetchCount = 0;
    protected int fetchDirection = 1000;
    protected int fetchSize = 50;
    protected boolean lastColumnWasNull = false;
    protected byte[] rowChunk;
    protected boolean fetchComplete = false;
    protected boolean isRsetClosed = false;
    protected boolean isSvrCsrClosed = false;
    private boolean closeStatementOnClose = false;
    private int preparedFetchCnt = 0;
    private boolean mapDateToTimestamp = true;
    private boolean foCsrEnabled = false;
    private int foECode = 0;
    protected static final long[] CRC_TBL = new long[256];

    protected TbResultSetBase(TbStatement stmt, int cursorId, int colCount, int hiddenColCount, byte[] rowChunk) throws SQLException {
        super(stmt.getRealRsetType());
        Debug.logMethod("TbResultSetBase", new Object[]{this, stmt, Integer.toString(cursorId), Integer.toString(colCount), Integer.toString(hiddenColCount)});
        this.stmt = stmt;
        this.csrID = cursorId;
        this.typeConverter = stmt.conn.getTypeConverter();
        this.columnCount = colCount + hiddenColCount;
        this.fetchDirection = stmt.getFetchDirection();
        this.fetchSize = stmt.getFetchSize();
        this.closeStatementOnClose = false;
        this.foCsrEnabled = stmt.conn.info.isFailoverCursorEnabled();
        if (stmt.getRealRsetType() != null) {
            this.beginColumnIndex = hiddenColCount + (stmt.getRealRsetType().useRowId() ? 1 : 0);
        }
        this.makeColumnMetaArray(this.columnCount);
        this.rowChunk = rowChunk;
    }

    private void buildColumnNameMap() {
        this.columnNameMap = new HashMap();
        for (int i = this.getColumnCount() - 1; i >= 0; --i) {
            this.columnNameMap.put(this.cols[i + this.beginColumnIndex].getName().toUpperCase(), new Integer(i + 1));
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    void checkColumnIndex(int index) throws SQLException {
        int columnCount = this.getColumnCount();
        if (columnCount < 0) {
            throw TbError.newSQLException(-90607);
        }
        if (index <= 0 || index > columnCount) {
            throw TbError.newSQLException(-90609);
        }
    }

    protected void checkRsetAndConnClosed() throws SQLException {
        if (this.csrID == -1) {
            throw TbError.newSQLException(-90607);
        }
        if (this.isRsetClosed) {
            throw TbError.newSQLException(-90646);
        }
        if (this.isSvrCsrClosed) {
            throw TbError.newSQLException(-90647);
        }
        if (this.stmt.conn == null || this.stmt.conn.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        if (this.foECode != 0) {
            if (this.isFoCsrEnabled() && this.foECode == -90700) {
                this.recover();
                this.addWarning(TbError.newSQLWarning(-590786));
            } else {
                int ecode = this.foECode;
                this.reset();
                this.isRsetClosed = true;
                throw TbError.newSQLException(-90646, TbError.getMsg(ecode));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SQLException {
        Debug.logMethod("TbResultSetBase.close", new Object[]{this});
        if (this.isRsetClosed) {
            return;
        }
        try {
            this.closeCursor();
        }
        catch (SQLException sqe) {
            Debug.log("TbResultSetBase.close (FAILED) : " + sqe.getMessage());
        }
        finally {
            this.reset();
            this.isRsetClosed = true;
            if (this.closeStatementOnClose) {
                try {
                    this.stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public synchronized void closeCursor() throws SQLException {
        Debug.logMethod("TbResultSetBase.closeCursor", new Object[]{this});
        if (this.isSvrCsrClosed) {
            return;
        }
        TbConnection conn = (TbConnection)this.stmt.getConnection();
        ServerInfo serverInfo = conn.getServerInfo();
        if (serverInfo != null) {
            boolean autoClosed = this.fetchComplete;
            int major = serverInfo.getProtocolMajorVersion();
            int minor = serverInfo.getProtocolMinorVersion();
            if (major > 2 || major == 2 && minor < 3) {
                autoClosed &= !this.haveLocator;
            }
            if (!(this.stmt == null || autoClosed || !conn.isPooledConnection && conn.isSessionClosed())) {
                conn.closeCursor(this, this.csrID);
                Debug.logMethod("TbResultSetBase.closeCursor[CLOSED]", new Object[]{this});
            }
        }
        conn.removeFOActiveResultSet(this);
        this.isSvrCsrClosed = true;
    }

    public void closeStatementOnClose() {
        this.closeStatementOnClose = true;
    }

    @Override
    public void deleteRow() throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    protected void fetchRowsChunk() throws SQLException {
        try {
            if (this.isFoCsrEnabled() && this.foECode == -90700) {
                this.recover();
                this.addWarning(TbError.newSQLWarning(-590786));
            } else if (this.foECode != 0) {
                int ecode = this.foECode;
                this.reset();
                this.isRsetClosed = true;
                throw TbError.newSQLException(-90646, TbError.getMsg(ecode));
            }
        }
        catch (SQLException e) {
            if (e.getErrorCode() == -90700) {
                this.recover();
                this.addWarning(TbError.newSQLWarning(-590786));
            }
            throw e;
        }
        try {
            this.stmt.fetch(this);
        }
        catch (SQLException e) {
            if (this.isFoCsrEnabled() && e.getErrorCode() == -90700) {
                this.recover();
                this.addWarning(TbError.newSQLWarning(-590786));
                this.stmt.fetch(this);
            }
            throw e;
        }
    }

    @Override
    public synchronized int findColumn(String columnName) throws SQLException {
        Debug.logMethod("TbResultSetBase.findColumn", new Object[]{this, columnName});
        return this.getColumnPosByName(columnName);
    }

    @Override
    public Array getArray(int i) throws SQLException {
        Debug.logMethod("TbResultSetBase.getArray", new Object[]{this, Integer.toString(i)});
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(i);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, i)) {
            return null;
        }
        TbTypeDescriptor desc = this.getColumnTypeDescriptor(i);
        TbArrayDescriptor adesc = desc instanceof TbArrayDescriptor ? (TbArrayDescriptor)desc : null;
        return this.typeConverter.toArray(this.getRowChunk(row, i), this.getColumnOffset(row, i), this.getColumnLength(row, i), this.getColumnDataType(i), !this.getRsetType().isScrollable(), adesc, this.stmt.conn.getTypeMap());
    }

    @Override
    public Array getArray(String label) throws SQLException {
        return this.getArray(this.findColumn(label));
    }

    @Override
    public synchronized InputStream getAsciiStream(int i) throws SQLException {
        Debug.logMethod("TbResultSetBase.getAsciiStream", new Object[]{this, Integer.toString(i)});
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(i);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, i)) {
            return null;
        }
        return this.typeConverter.toAsciiStream(this.getRowChunk(row, i), this.getColumnOffset(row, i), this.getColumnLength(row, i), this.getColumnDataType(i));
    }

    @Override
    public InputStream getAsciiStream(String label) throws SQLException {
        return this.getAsciiStream(this.findColumn(label));
    }

    public int getBeginColumnIndex() {
        return this.beginColumnIndex;
    }

    @Override
    public BigDecimal getBigDecimal(int i) throws SQLException {
        Debug.logMethod("TbResultSetBase.getBigDecimal", new Object[]{this, Integer.toString(i)});
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(i);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, i)) {
            return null;
        }
        return this.typeConverter.toBigDecimal(this.getRowChunk(row, i), this.getColumnOffset(row, i), this.getColumnLength(row, i), this.getColumnDataType(i));
    }

    @Override
    @Deprecated
    public synchronized BigDecimal getBigDecimal(int i, int scale) throws SQLException {
        return this.getBigDecimal(i);
    }

    @Override
    public BigDecimal getBigDecimal(String label) throws SQLException {
        return this.getBigDecimal(this.findColumn(label));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String label, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(label), scale);
    }

    @Override
    public synchronized InputStream getBinaryStream(int i) throws SQLException {
        Debug.logMethod("TbResultSetBase.getBinaryStream", new Object[]{this, Integer.toString(i)});
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(i);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, i)) {
            return null;
        }
        return this.typeConverter.toBinaryStream(this.getRowChunk(row, i), this.getColumnOffset(row, i), this.getColumnLength(row, i), this.getColumnDataType(i));
    }

    @Override
    public InputStream getBinaryStream(String label) throws SQLException {
        return this.getBinaryStream(this.findColumn(label));
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        Debug.logMethod("TbResultSetBase.getBlob", new Object[]{this, Integer.toString(i)});
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(i);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, i)) {
            return null;
        }
        return this.typeConverter.toBlob(this.getRowChunk(row, i), this.getColumnOffset(row, i), this.getColumnLength(row, i), this.getColumnDataType(i), !this.stmt.getRealRsetType().isScrollable());
    }

    @Override
    public Blob getBlob(String label) throws SQLException {
        return this.getBlob(this.findColumn(label));
    }

    @Override
    public synchronized boolean getBoolean(int i) throws SQLException {
        Debug.logMethod("TbResultSetBase.getBoolean", new Object[]{this, Integer.toString(i)});
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(i);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, i)) {
            return false;
        }
        return this.typeConverter.toBoolean(this.getRowChunk(row, i), this.getColumnOffset(row, i), this.getColumnLength(row, i), this.getColumnDataType(i));
    }

    @Override
    public boolean getBoolean(String label) throws SQLException {
        return this.getBoolean(this.findColumn(label));
    }

    @Override
    public synchronized byte getByte(int i) throws SQLException {
        Debug.logMethod("TbResultSetBase.getByte", new Object[]{this, Integer.toString(i)});
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(i);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, i)) {
            return 0;
        }
        return this.typeConverter.toByte(this.getRowChunk(row, i), this.getColumnOffset(row, i), this.getColumnLength(row, i), this.getColumnDataType(i));
    }

    @Override
    public byte getByte(String label) throws SQLException {
        return this.getByte(this.findColumn(label));
    }

    @Override
    public synchronized byte[] getBytes(int i) throws SQLException {
        Debug.logMethod("TbResultSetBase.getBytes", new Object[]{Integer.toString(i)});
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(i);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, i)) {
            return null;
        }
        return this.typeConverter.toBytes(this.getRowChunk(row, i), this.getColumnOffset(row, i), this.getColumnLength(row, i), this.getColumnDataType(i), !this.stmt.getRealRsetType().isScrollable());
    }

    @Override
    public synchronized int getBytes(int i, byte[] target) throws SQLException {
        Debug.logMethod("TbResultSetBase.getBytes", new Object[]{this, Integer.toString(i)});
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(i);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, i)) {
            target[0] = 0;
            return 0;
        }
        return this.typeConverter.toBytes(this.getRowChunk(row, i), this.getColumnOffset(row, i), this.getColumnLength(row, i), this.getColumnDataType(i), target);
    }

    @Override
    public byte[] getBytes(String label) throws SQLException {
        return this.getBytes(this.findColumn(label));
    }

    @Override
    public synchronized Reader getCharacterStream(int i) throws SQLException {
        Debug.logMethod("TbResultSetBase.getCharacterStream", new Object[]{this, Integer.toString(i)});
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(i);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, i)) {
            return null;
        }
        return this.typeConverter.toCharacterStream(this.getRowChunk(row, i), this.getColumnOffset(row, i), this.getColumnLength(row, i), this.getColumnDataType(i));
    }

    @Override
    public Reader getCharacterStream(String label) throws SQLException {
        return this.getCharacterStream(this.findColumn(label));
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        Debug.logMethod("TbResultSetBase.getClob", new Object[]{this, Integer.toString(i)});
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(i);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, i)) {
            return null;
        }
        return this.typeConverter.toClob(this.getRowChunk(row, i), this.getColumnOffset(row, i), this.getColumnLength(row, i), this.getColumnDataType(i), !this.stmt.getRealRsetType().isScrollable());
    }

    @Override
    public Clob getClob(String label) throws SQLException {
        return this.getClob(this.findColumn(label));
    }

    @Override
    public Column[] getCols() {
        return this.cols;
    }

    int getColumnCount() {
        return this.columnCount - this.beginColumnIndex;
    }

    @Override
    protected int getColumnDataType(int i) throws SQLException {
        this.checkColumnIndex(i);
        return this.cols[i + this.beginColumnIndex - 1].getDataType();
    }

    protected TbTypeDescriptor getColumnTypeDescriptor(int i) throws SQLException {
        this.checkColumnIndex(i);
        return this.cols[i + this.beginColumnIndex - 1].getDescriptor();
    }

    private int getColumnLength(Row row, int i) {
        return row.getColumnLength(i + this.beginColumnIndex);
    }

    @Override
    protected int getColumnMaxLength(int i) throws SQLException {
        this.checkColumnIndex(i);
        return this.cols[i + this.beginColumnIndex - 1].getMaxLength();
    }

    @Override
    protected String getColumnName(int i) throws SQLException {
        this.checkColumnIndex(i);
        return this.cols[i + this.beginColumnIndex - 1].getName();
    }

    @Override
    protected boolean getColumnNullable(int i) throws SQLException {
        this.checkColumnIndex(i);
        return this.cols[i + this.beginColumnIndex - 1].isNullable();
    }

    private int getColumnOffset(Row row, int i) {
        return row.getColumnOffset(i + this.beginColumnIndex);
    }

    private int getColumnPosByName(String columnName) throws SQLException {
        Integer colNum;
        if (this.cols == null || this.getColumnCount() == 0) {
            throw TbError.newSQLException(-90607);
        }
        if (this.columnNameMap == null) {
            this.buildColumnNameMap();
        }
        if ((colNum = this.columnNameMap.get(columnName != null ? columnName.toUpperCase() : "")) == null) {
            throw TbError.newSQLException(-90611, columnName);
        }
        return colNum;
    }

    @Override
    protected int getColumnPrecision(int i) throws SQLException {
        this.checkColumnIndex(i);
        return this.cols[i + this.beginColumnIndex - 1].getPrecision();
    }

    protected byte[] getColumnRawData(int i) throws SQLException {
        return this.getCurrentRow().getRawBytes(i + this.beginColumnIndex);
    }

    @Override
    protected int getColumnScale(int i) throws SQLException {
        this.checkColumnIndex(i);
        return this.cols[i + this.beginColumnIndex - 1].getScale();
    }

    @Override
    protected int getColumnSqlType(int i) throws SQLException {
        this.checkColumnIndex(i);
        return this.cols[i + this.beginColumnIndex - 1].getSqlType();
    }

    protected long getCurrentChunkCRC(byte[] chunk, int size, long prevCRC) {
        int tblIdx;
        long crcNum = 0L;
        for (int i = 1; i < size; ++i) {
            tblIdx = ((int)(crcNum >> 24) ^ chunk[i]) & 0xFF;
            crcNum = crcNum << 8 ^ CRC_TBL[tblIdx];
        }
        if (prevCRC != 0L) {
            byte[] tmp = new byte[]{(byte)(prevCRC >> 24 & 0xFFL), (byte)(prevCRC >> 16 & 0xFFL), (byte)(prevCRC >> 8 & 0xFFL), (byte)(prevCRC & 0xFFL)};
            for (int i = 0; i < 4; ++i) {
                tblIdx = ((int)(crcNum >> 24) ^ tmp[i]) & 0xFF;
                crcNum = crcNum << 8 ^ CRC_TBL[tblIdx];
            }
        }
        return crcNum & 0xFFFFFFFFL;
    }

    protected abstract Row getCurrentRow() throws SQLException;

    public int getCursorId() {
        return this.csrID;
    }

    @Override
    public String getCursorName() throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public synchronized Date getDate(int i) throws SQLException {
        Debug.logMethod("TbResultSetBase.getDate", new Object[]{this, Integer.toString(i)});
        return this.getDateInternal(i);
    }

    @Override
    public Date getDate(int i, Calendar cal) throws SQLException {
        Debug.logMethod("TbResultSetBase.getDate", new Object[]{this, Integer.toString(i), cal});
        Date date = this.getDateInternal(i);
        if (cal != null) {
            cal.setTime(date);
            date = (Date)cal.getTime();
        }
        return date;
    }

    @Override
    public Date getDate(String label) throws SQLException {
        return this.getDate(this.findColumn(label));
    }

    @Override
    public Date getDate(String label, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(label), cal);
    }

    private Date getDateInternal(int i) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(i);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, i)) {
            return null;
        }
        return this.typeConverter.toDate(this.getRowChunk(row, i), this.getColumnOffset(row, i), this.getColumnLength(row, i), this.getColumnDataType(i));
    }

    @Override
    public TbDate getTbDate(int i) throws SQLException {
        Debug.logMethod("TbResultSetBase.getTbDate", new Object[]{this, Integer.toString(i)});
        return this.getTbDateInternal(i);
    }

    private TbDate getTbDateInternal(int i) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(i);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, i)) {
            return null;
        }
        return this.typeConverter.toTbDate(this.getRowChunk(row, i), this.getColumnOffset(row, i), this.getColumnLength(row, i), this.getColumnDataType(i));
    }

    @Override
    public synchronized double getDouble(int i) throws SQLException {
        Debug.logMethod("TbResultSetBase.getDouble", new Object[]{this, Integer.toString(i)});
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(i);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, i)) {
            return 0.0;
        }
        return this.typeConverter.toDouble(this.getRowChunk(row, i), this.getColumnOffset(row, i), this.getColumnLength(row, i), this.getColumnDataType(i));
    }

    @Override
    public double getDouble(String label) throws SQLException {
        return this.getDouble(this.findColumn(label));
    }

    @Override
    public synchronized int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    @Override
    public synchronized int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public synchronized float getFloat(int i) throws SQLException {
        Debug.logMethod("TbResultSetBase.getFloat", new Object[]{this, Integer.toString(i)});
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(i);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, i)) {
            return 0.0f;
        }
        return this.typeConverter.toFloat(this.getRowChunk(row, i), this.getColumnOffset(row, i), this.getColumnLength(row, i), this.getColumnDataType(i));
    }

    @Override
    public float getFloat(String label) throws SQLException {
        return this.getFloat(this.findColumn(label));
    }

    @Override
    public synchronized int getInt(int i) throws SQLException {
        Debug.logMethod("TbResultSetBase.getInt", new Object[]{this, Integer.toString(i)});
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(i);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, i)) {
            return 0;
        }
        return this.typeConverter.toInt(this.getRowChunk(row, i), this.getColumnOffset(row, i), this.getColumnLength(row, i), this.getColumnDataType(i));
    }

    @Override
    public int getInt(String label) throws SQLException {
        return this.getInt(this.findColumn(label));
    }

    @Override
    public synchronized long getLong(int i) throws SQLException {
        Debug.logMethod("TbResultSetBase.getLong", new Object[]{this, Integer.toString(i)});
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(i);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, i)) {
            return 0L;
        }
        return this.typeConverter.toLong(this.getRowChunk(row, i), this.getColumnOffset(row, i), this.getColumnLength(row, i), this.getColumnDataType(i));
    }

    @Override
    public long getLong(String label) throws SQLException {
        return this.getLong(this.findColumn(label));
    }

    @Override
    public synchronized InputStream getLongByteStream(int i) throws SQLException {
        Debug.logMethod("TbResultSetBase.getLongByteStream", new Object[]{this, Integer.toString(i)});
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(i);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, i)) {
            return null;
        }
        return this.typeConverter.toLongRawStream(this.getRowChunk(row, i), this.getColumnOffset(row, i), this.getColumnLength(row, i), this.getColumnDataType(i));
    }

    public boolean getMapDateToTimestamp() {
        return this.mapDateToTimestamp;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        Debug.logMethod("TbResultSetBase.getMetaData", new Object[]{this});
        return new TbResultSetMetaData(this.cols, this.beginColumnIndex);
    }

    @Override
    public Reader getNCharacterStream(int i) throws SQLException {
        Debug.logMethod("TbResultSetBase.getNCharacterStream", new Object[]{this, Integer.toString(i)});
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(i);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, i)) {
            return null;
        }
        return this.typeConverter.toCharacterStream(this.getRowChunk(row, i), this.getColumnOffset(row, i), this.getColumnLength(row, i), this.getColumnDataType(i));
    }

    @Override
    public Reader getNCharacterStream(String label) throws SQLException {
        return this.getNCharacterStream(this.findColumn(label));
    }

    @Override
    public NClob getNClob(int i) throws SQLException {
        Debug.logMethod("TbResultSetBase.getNClob", new Object[]{this, Integer.toString(i)});
        return this.getTbNClob(i);
    }

    public TbNClob getTbNClob(int i) throws SQLException {
        Debug.logMethod("TbResultSetBase.getTbNClob", new Object[]{this, Integer.toString(i)});
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(i);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, i)) {
            return null;
        }
        return this.typeConverter.toTbNClob(this.getRowChunk(row, i), this.getColumnOffset(row, i), this.getColumnLength(row, i), this.getColumnDataType(i));
    }

    @Override
    public NClob getNClob(String label) throws SQLException {
        return this.getTbNClob(this.findColumn(label));
    }

    public TbNClob getTbNClob(String label) throws SQLException {
        return this.getTbNClob(this.findColumn(label));
    }

    @Override
    public String getNString(int i) throws SQLException {
        Debug.logMethod("TbResultSetBase.getNString", new Object[]{this, Integer.toString(i)});
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(i);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, i)) {
            return null;
        }
        return this.typeConverter.toString(this.getRowChunk(row, i), this.getColumnOffset(row, i), this.getColumnLength(row, i), this.getColumnDataType(i), this.getColumnPrecision(i), this.getColumnScale(i), !this.getRsetType().isScrollable());
    }

    @Override
    public String getNString(String label) throws SQLException {
        return this.getNString(this.findColumn(label));
    }

    @Override
    public synchronized Object getObject(int i) throws SQLException {
        Debug.logMethod("TbResultSetBase.getObject", new Object[]{this, Integer.toString(i)});
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(i);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, i)) {
            return null;
        }
        return this.typeConverter.toObject(this.getRowChunk(row, i), this.getColumnOffset(row, i), this.getColumnLength(row, i), this.getColumnDataType(i), this.getColumnSqlType(i), this.getColumnPrecision(i), this.getColumnScale(i), !this.getRsetType().isScrollable(), this.getColumnTypeDescriptor(i), null, this.stmt.conn.getTypeMap());
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        Debug.logMethod("TbResultSetBase.getObject", new Object[]{this, Integer.toString(i), map});
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(i);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, i)) {
            return null;
        }
        TbTypeDescriptor desc = this.getColumnTypeDescriptor(i);
        String typeName = null;
        Class<?> clazz = null;
        if (desc != null && (typeName = desc.getSQLTypeName()) != null && map != null) {
            clazz = map.get(typeName);
        }
        return this.typeConverter.toObject(this.getRowChunk(row, i), this.getColumnOffset(row, i), this.getColumnLength(row, i), this.getColumnDataType(i), this.getColumnSqlType(i), this.getColumnPrecision(i), this.getColumnScale(i), !this.getRsetType().isScrollable(), desc, clazz, map);
    }

    @Override
    public Object getObject(String label) throws SQLException {
        return this.getObject(this.findColumn(label));
    }

    @Override
    public Object getObject(String label, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findColumn(label), map);
    }

    public int getPreparedFetchCnt() {
        return this.preparedFetchCnt;
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public Ref getRef(String label) throws SQLException {
        return this.getRef(this.findColumn(label));
    }

    @Override
    public synchronized int getRow() throws SQLException {
        Debug.logMethod("TbResultSetBase.getRow", new Object[]{this, Integer.toString(this.currentRowIndex)});
        if (this.rowsFetchedCnt == 0 || this.currentRowIndex < 0 || this.currentRowIndex >= this.rowsFetchedCnt) {
            return 0;
        }
        return this.currentRowIndex + 1;
    }

    @Override
    public byte[] getRowChunk(int size) {
        if (this.rowChunk == null || this.rowChunk.length < size) {
            this.rowChunk = new byte[size];
        }
        return this.rowChunk;
    }

    private Object getRowChunk(Row row, int i) {
        return row.getRowChunk(i + this.beginColumnIndex);
    }

    @Override
    public RowId getRowId(int i) throws SQLException {
        Debug.logMethod("TbResultSetBase.getRowId", new Object[]{this, Integer.toString(i)});
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(i);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, i)) {
            return null;
        }
        return this.typeConverter.toRowId(this.getRowChunk(row, i), this.getColumnOffset(row, i), this.getColumnLength(row, i), this.getColumnDataType(i));
    }

    @Override
    public RowId getRowId(String label) throws SQLException {
        return this.getRowId(this.findColumn(label));
    }

    @Override
    public synchronized short getShort(int i) throws SQLException {
        Debug.logMethod("TbResultSetBase.getShort", new Object[]{this, Integer.toString(i)});
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(i);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, i)) {
            return 0;
        }
        return this.typeConverter.toShort(this.getRowChunk(row, i), this.getColumnOffset(row, i), this.getColumnLength(row, i), this.getColumnDataType(i));
    }

    @Override
    public short getShort(String label) throws SQLException {
        return this.getShort(this.findColumn(label));
    }

    @Override
    public SQLXML getSQLXML(int i) throws SQLException {
        Debug.logMethod("TbResultSetBase.getSQLXML", new Object[]{this, Integer.toString(i)});
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(i);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, i)) {
            return null;
        }
        return this.typeConverter.toSQLXML(this.getRowChunk(row, i), this.getColumnOffset(row, i), this.getColumnLength(row, i), this.getColumnDataType(i), !this.stmt.getRealRsetType().isScrollable());
    }

    @Override
    public SQLXML getSQLXML(String label) throws SQLException {
        return this.getSQLXML(this.findColumn(label));
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.stmt;
    }

    @Override
    public synchronized String getString(int i) throws SQLException {
        Object xmlObj;
        Debug.logMethod("TbResultSetBase.getString", new Object[]{this, Integer.toString(i)});
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(i);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, i)) {
            return null;
        }
        Object chunk = this.getRowChunk(row, i);
        int colOff = this.getColumnOffset(row, i);
        int colLen = this.getColumnLength(row, i);
        int colDataType = this.getColumnDataType(i);
        int colPrec = this.getColumnPrecision(i);
        int colScale = this.getColumnScale(i);
        boolean freeTmpLobOnEOF = !this.getRsetType().isScrollable();
        TbTypeDescriptor colDesc = this.getColumnTypeDescriptor(i);
        if (colDataType == 32 && colDesc != null && "00000000000000000000000000000001".equals(colDesc.getOID()) && (xmlObj = this.typeConverter.toObject(chunk, colOff, colLen, colDataType, DataType.getSqlType(colDataType), colPrec, colScale, freeTmpLobOnEOF, colDesc, TbSQLXML.class, null)) instanceof TbSQLXML) {
            return ((TbSQLXML)xmlObj).getString();
        }
        return this.typeConverter.toString(chunk, colOff, colLen, colDataType, colPrec, colScale, freeTmpLobOnEOF);
    }

    @Override
    public String getString(String label) throws SQLException {
        return this.getString(this.findColumn(label));
    }

    @Override
    public synchronized Time getTime(int i) throws SQLException {
        Debug.logMethod("TbResultSetBase.getTime", new Object[]{this, Integer.toString(i)});
        return this.getTimeInternal(i);
    }

    @Override
    public Time getTime(int i, Calendar cal) throws SQLException {
        Debug.logMethod("TbResultSetBase.getTime", new Object[]{this, Integer.toString(i), cal});
        Time time = this.getTimeInternal(i);
        if (cal != null) {
            cal.setTime(time);
            time = (Time)cal.getTime();
        }
        return time;
    }

    @Override
    public Time getTime(String label) throws SQLException {
        return this.getTime(this.findColumn(label));
    }

    @Override
    public Time getTime(String label, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(label), cal);
    }

    private Time getTimeInternal(int i) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(i);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, i)) {
            return null;
        }
        return this.typeConverter.toTime(this.getRowChunk(row, i), this.getColumnOffset(row, i), this.getColumnLength(row, i), this.getColumnDataType(i));
    }

    @Override
    public synchronized Timestamp getTimestamp(int i) throws SQLException {
        Debug.logMethod("TbResultSetBase.getTimestamp", new Object[]{this, Integer.toString(i)});
        return this.getTimestampInternal(i);
    }

    @Override
    public Timestamp getTimestamp(int i, Calendar cal) throws SQLException {
        Debug.logMethod("TbResultSetBase.getTimestamp", new Object[]{this, Integer.toString(i), cal});
        if (cal == null) {
            return this.getTimestampInternal(i);
        }
        return this.getTimestampInternal(i, cal);
    }

    @Override
    public Timestamp getTimestamp(String label) throws SQLException {
        return this.getTimestamp(this.findColumn(label));
    }

    @Override
    public Timestamp getTimestamp(String label, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(label), cal);
    }

    private Timestamp getTimestampInternal(int i) throws SQLException {
        return this.getTimestampInternal(i, null);
    }

    private Timestamp getTimestampInternal(int i, Calendar cal) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(i);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, i)) {
            return null;
        }
        return this.typeConverter.toTimestamp(this.getRowChunk(row, i), this.getColumnOffset(row, i), this.getColumnLength(row, i), this.getColumnDataType(i), cal);
    }

    @Override
    public TbTimestamp getTbTimestamp(int i) throws SQLException {
        Debug.logMethod("TbResultSetBase.getTbTimestamp", new Object[]{this, Integer.toString(i)});
        return this.getTbTimestampInternal(i);
    }

    private TbTimestamp getTbTimestampInternal(int i) throws SQLException {
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(i);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, i)) {
            return null;
        }
        return this.typeConverter.toTbTimestamp(this.getRowChunk(row, i), this.getColumnOffset(row, i), this.getColumnLength(row, i), this.getColumnDataType(i));
    }

    @Override
    @Deprecated
    public synchronized InputStream getUnicodeStream(int i) throws SQLException {
        Debug.logMethod("TbResultSetBase.getUnicodeStream", new Object[]{this, Integer.toString(i)});
        this.checkRsetAndConnClosed();
        this.checkColumnIndex(i);
        Row row = this.getCurrentRow();
        if (this.setLastColumnIsNull(row, i)) {
            return null;
        }
        return this.typeConverter.toUnicodeStream(this.getRowChunk(row, i), this.getColumnOffset(row, i), this.getColumnLength(row, i), this.getColumnDataType(i), !this.getRsetType().isScrollable());
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String label) throws SQLException {
        return this.getUnicodeStream(this.findColumn(label));
    }

    @Override
    public URL getURL(int i) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public URL getURL(String label) throws SQLException {
        return this.getURL(this.findColumn(label));
    }

    protected boolean hasNoResultReturned() throws SQLException {
        return this.rowsFetchedCnt > 0 ? false : this.fetchComplete;
    }

    @Override
    public void insertRow() throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public synchronized boolean isAfterLast() throws SQLException {
        Debug.logMethod("TbResultSetBase.isAfterLast", new Object[]{this});
        if (this.stmt.getMaxRows() != 0 && this.currentRowIndex + 1 > this.stmt.getMaxRows()) {
            return true;
        }
        return !this.hasNoResultReturned() && this.fetchComplete && this.currentRowIndex + 1 > this.rowsFetchedCnt;
    }

    @Override
    public synchronized boolean isBeforeFirst() throws SQLException {
        Debug.logMethod("TbResultSetBase.isBeforeFirst", new Object[]{this});
        return !this.hasNoResultReturned() && this.currentRowIndex < 0;
    }

    @Override
    public synchronized boolean isFirst() throws SQLException {
        Debug.logMethod("TbResultSetBase.isFirst", new Object[]{this});
        return !this.hasNoResultReturned() && this.currentRowIndex == 0;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isRsetClosed;
    }

    public boolean isFetchComplete() {
        return this.fetchComplete;
    }

    private void makeColumnMetaArray(int colCnt) {
        this.mapDateToTimestamp = this.stmt.conn.getMapDateToTimestamp();
        this.cols = new Column[colCnt];
        for (int i = 0; i < colCnt; ++i) {
            this.cols[i] = new Column(this.mapDateToTimestamp);
        }
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public synchronized boolean next() throws SQLException {
        Debug.logMethod("TbResultSetBase.next", new Object[]{this, Integer.toString(this.currentRowIndex)});
        if (this.csrID == -1) {
            throw TbError.newSQLException(-90607);
        }
        if (this.isRsetClosed) {
            throw TbError.newSQLException(-90646);
        }
        if (this.stmt.conn == null || this.stmt.conn.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        if (this.isSvrCsrClosed || this.csrID == -2) {
            return false;
        }
        this.currentRowIndex = this.currentRowIndex < 0 ? 0 : ++this.currentRowIndex;
        if (this.stmt.getMaxRows() != 0 && this.currentRowIndex >= this.stmt.getMaxRows()) {
            this.closeCursor();
            return false;
        }
        while (this.currentRowIndex >= this.rowsFetchedCnt) {
            if (this.fetchComplete) {
                return false;
            }
            this.fetchRowsChunk();
        }
        return true;
    }

    protected abstract void recover() throws SQLException;

    @Override
    public void refreshRow() throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    protected abstract void removeCurrentRow() throws SQLException;

    @Override
    protected void reset() {
        super.reset();
        if (this.columnNameMap != null) {
            this.columnNameMap.clear();
            this.columnNameMap = null;
        }
        this.stmt = null;
        this.csrID = -1;
        this.lastColumnWasNull = false;
        this.typeConverter = null;
        this.cols = null;
        this.rowChunk = null;
        this.fetchComplete = false;
        this.currentRowIndex = -1;
        this.rowsFetchedCnt = 0;
        this.fetchDirection = 1000;
        this.fetchSize = 50;
        this.isRsetClosed = false;
        this.closeStatementOnClose = false;
        this.foECode = 0;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    protected boolean isFoCsrEnabled() {
        return this.foCsrEnabled;
    }

    public void setFOECode(int code) {
        this.foECode = code;
    }

    @Override
    public synchronized void setFetchCompleted(int bitmap) {
        Debug.logMethod("TbResultSetBase.setFetchCompleted", new Object[]{this, Integer.toBinaryString(bitmap)});
        this.fetchComplete = TbCommon.getBitmapAt(0, bitmap);
    }

    @Override
    public synchronized void setFetchDirection(int direction) throws SQLException {
        Debug.logMethod("TbResultSetBase.setFetchDirection", new Object[]{this, Integer.toString(direction)});
        switch (direction) {
            case 1000: 
            case 1002: {
                this.fetchDirection = 1000;
                return;
            }
            case 1001: {
                this.fetchDirection = 1001;
                break;
            }
            default: {
                throw TbError.newSQLException(-90608);
            }
        }
    }

    @Override
    public synchronized void setFetchSize(int rows) throws SQLException {
        if (rows == 0) {
            this.fetchSize = 50;
        } else if (rows > 0) {
            this.fetchSize = rows;
        } else {
            throw TbError.newSQLException(-590735);
        }
    }

    protected boolean setLastColumnIsNull(Row currentRow, int i) throws SQLException {
        this.lastColumnWasNull = currentRow.isNull(i + this.beginColumnIndex);
        return this.lastColumnWasNull;
    }

    public void setPreparedFetchCnt(int cnt) {
        this.preparedFetchCnt = cnt;
    }

    protected void setSaveCRCEnabled(boolean enabled) {
        this.foCsrEnabled = enabled;
    }

    @Override
    public void updateArray(int i, Array x) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public void updateArray(String label, Array x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateAsciiStream(int i, InputStream x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateAsciiStream(int i, InputStream stream, int len) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateAsciiStream(int i, InputStream stream, long len) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateAsciiStream(String label, InputStream x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateAsciiStream(String label, InputStream x, int length) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateAsciiStream(String label, InputStream x, long length) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBigDecimal(int i, BigDecimal x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBigDecimal(String label, BigDecimal x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBinaryStream(int i, InputStream x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBinaryStream(int i, InputStream x, int length) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBinaryStream(int i, InputStream x, long length) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBinaryStream(String label, InputStream x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBinaryStream(String label, InputStream x, int length) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBinaryStream(String label, InputStream x, long length) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBlob(int i, Blob x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBlob(int i, InputStream x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBlob(int i, InputStream x, long length) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBlob(String label, Blob x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBlob(String label, InputStream x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBlob(String label, InputStream x, long length) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBoolean(int i, boolean x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBoolean(String label, boolean x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateByte(int i, byte x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateByte(String label, byte x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBytes(int i, byte[] x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBytes(String label, byte[] x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateCharacterStream(int i, Reader x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateCharacterStream(int i, Reader x, int length) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateCharacterStream(int i, Reader x, long length) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateCharacterStream(String label, Reader x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateCharacterStream(String label, Reader x, int length) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateCharacterStream(String label, Reader x, long length) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateClob(int i, Clob x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateClob(int i, Reader x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateClob(int i, Reader x, long length) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateClob(String label, Clob x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateClob(String label, Reader x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateClob(String label, Reader x, long length) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateDate(int i, Date x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateDate(String label, Date x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateDouble(int i, double x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateDouble(String label, double x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateFloat(int i, float x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateFloat(String label, float x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateInt(int i, int x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateInt(String label, int x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateLong(int i, long x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateLong(String label, long x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateNCharacterStream(int i, Reader x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateNCharacterStream(int i, Reader x, long length) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateNCharacterStream(String label, Reader x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateNCharacterStream(String label, Reader x, long length) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateNClob(int i, NClob x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateNClob(int i, Reader x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateNClob(int i, Reader x, long length) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateNClob(String label, NClob x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateNClob(String label, Reader x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateNClob(String label, Reader x, long length) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateNString(int i, String x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateNString(String label, String x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateNull(int i) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateNull(String label) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateObject(int i, Object x) throws SQLException {
        this.updateObject(i, x, 0);
    }

    @Override
    public void updateObject(int i, Object x, int scale) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateObject(String label, Object x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateObject(String label, Object x, int scaleOrLength) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateRef(int i, Ref x) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public void updateRow() throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateRowId(int i, RowId x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateRowId(String label, RowId x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateShort(int i, short x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateShort(String label, short x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateSQLXML(int i, SQLXML x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateSQLXML(String label, SQLXML x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateString(int i, String x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateString(String label, String x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateTime(int i, Time x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateTime(String label, Time x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateTimestamp(int i, Timestamp x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateTimestamp(String label, Timestamp x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateTbTimestamp(int i, TbTimestamp x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateTbTimestamp(String label, TbTimestamp x) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public synchronized boolean wasNull() throws SQLException {
        Debug.logMethod("TbResultSetBase.wasNull", new Object[]{this});
        return this.lastColumnWasNull;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            long tblVal = i << 24;
            for (int j = 0; j < 8; ++j) {
                if ((tblVal & 0x80000000L) > 0L) {
                    tblVal = tblVal << 1 ^ 0x4C11DB7L;
                    continue;
                }
                tblVal <<= 1;
            }
            TbResultSetBase.CRC_TBL[i] = tblVal;
        }
    }
}

