/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.driver;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.TbArray;
import com.tmax.tibero.jdbc.TbArrayDescriptor;
import com.tmax.tibero.jdbc.TbBlob;
import com.tmax.tibero.jdbc.TbClob;
import com.tmax.tibero.jdbc.TbDatabaseMetaData;
import com.tmax.tibero.jdbc.TbNClob;
import com.tmax.tibero.jdbc.TbSQLInfo;
import com.tmax.tibero.jdbc.TbSQLInfo2;
import com.tmax.tibero.jdbc.TbSQLXML;
import com.tmax.tibero.jdbc.TbStatement;
import com.tmax.tibero.jdbc.TbStruct;
import com.tmax.tibero.jdbc.TbStructDescriptor;
import com.tmax.tibero.jdbc.TbTypeDescriptor;
import com.tmax.tibero.jdbc.comm.TbBlobAccessor;
import com.tmax.tibero.jdbc.comm.TbClobAccessor;
import com.tmax.tibero.jdbc.comm.TbComm;
import com.tmax.tibero.jdbc.comm.TbCommType4;
import com.tmax.tibero.jdbc.comm.TbXAComm;
import com.tmax.tibero.jdbc.comm.TbXACommType4;
import com.tmax.tibero.jdbc.data.ConnectionInfo;
import com.tmax.tibero.jdbc.data.DataTypeConverter;
import com.tmax.tibero.jdbc.data.ExtFeatureInfo;
import com.tmax.tibero.jdbc.data.RsetType;
import com.tmax.tibero.jdbc.data.ServerInfo;
import com.tmax.tibero.jdbc.dpl.TbDirPathMetaData;
import com.tmax.tibero.jdbc.dpl.TbDirPathStream;
import com.tmax.tibero.jdbc.driver.TbCallableStatement;
import com.tmax.tibero.jdbc.driver.TbPreparedStatement;
import com.tmax.tibero.jdbc.driver.TbResultSet;
import com.tmax.tibero.jdbc.driver.TbResultSetBase;
import com.tmax.tibero.jdbc.driver.TbSavepoint;
import com.tmax.tibero.jdbc.driver.TbTimeout;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.ext.TbStatementCache;
import com.tmax.tibero.jdbc.util.TbDTFormat;
import com.tmax.tibero.jdbc.util.TbDTFormatParser;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class TbConnection
extends com.tmax.tibero.jdbc.TbConnection {
    final String _DESC_TOBJ_ID_PREFIX = "/T";
    final String _DESC_VERSION_NO_PREFIX = "/V";
    public static final String CLIENT_INFO_IDENTIFIER = "client_identifier";
    public static final String[] CLIENT_INFO_KEYS = new String[]{"client_identifier"};
    private TbComm dbComm;
    public ConnectionInfo info;
    protected boolean isPooledConnection;
    public ServerInfo serverInfo;
    private String sessKey;
    protected DataTypeConverter typeConverter;
    protected SQLWarning warnings;
    protected boolean autoCommit;
    protected boolean connClosed;
    protected boolean sessionClosed;
    protected TbDatabaseMetaData dbMetaData = null;
    protected Map<String, Class<?>> typeMap;
    protected Map<String, TbTypeDescriptor> descriptorMap;
    private String nlsDate = null;
    private String nlsTimestamp = null;
    private boolean nlsWarning = false;
    private int sessionId;
    private int serialNo;
    private int mthrPid = -1;
    private int txnMode;
    private boolean readOnly;
    protected int isolationLevel = 2;
    private TbTimeout timeout;
    private int preFetchSize = 64000;
    private TbStatementCache stmtCache = null;
    public String[] clientInfo;
    private boolean middleOfFailover;
    private boolean reconnected;
    private long waitingTime;
    private boolean checkWaitingTimer = false;
    private int maxDFRCharCount = 0;
    private int maxDFRNCharCount = 0;
    private ExtFeatureInfo efInfo;
    private TbDTFormat parsedNlsDateFormat = null;
    private TbDTFormat parsedNlsTimestampFormat = null;
    private LinkedList<TbResultSetBase> foActiveRsets;

    public void activateTimer() {
        this.checkWaitingTimer = true;
    }

    public boolean addFOActiveResultSet(TbResultSetBase rs) {
        return this.foActiveRsets.add(rs);
    }

    public void addWaitingTime(long time) {
        this.waitingTime += time;
    }

    @Override
    public void addWarning(SQLWarning warning) {
        if (this.warnings != null) {
            this.warnings.setNextWarning(warning);
        } else {
            this.warnings = warning;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SQLException {
        Debug.logMethod("TbConnection.close", new Object[]{this});
        try {
            if (this.dbComm != null) {
                this.dbComm.close();
                this.dbComm = null;
            }
            this.connClosed = true;
        }
        finally {
            this.reset();
        }
    }

    @Override
    public synchronized void closeCursor(TbResultSet rs, int cursorId) throws SQLException {
        Debug.logMethod("TbConnection.closeCursor", new String[]{"cursorId"}, new Object[]{this, Integer.toString(cursorId)});
        this.dbComm.closeCursor(rs, cursorId);
    }

    @Deprecated
    public synchronized void closeSession() throws SQLException {
        Debug.logMethod("TbConnection.closeSession", new Object[]{this});
        throw TbError.newSQLException(-90201);
    }

    @Override
    public synchronized void commit() throws SQLException {
        Debug.logMethod("TbConnection.commit", new Object[]{this});
        if (this.connClosed || this.dbComm.getStream() == null) {
            throw TbError.newSQLException(-90603);
        }
        this.dbComm.commit();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        TbArray arr = null;
        String schemaName = this.info.getUser();
        String delim = ".";
        String[] tokens = typeName.split("[delim]{1}");
        if (tokens.length != 1) {
            if (tokens.length == 2) {
                schemaName = tokens[0];
                typeName = tokens[1];
            } else {
                throw TbError.newSQLException(-90649);
            }
        }
        String sqlTypeName = schemaName + delim + typeName;
        TbArrayDescriptor desc = TbArrayDescriptor.lookupUdtMeta(schemaName, typeName, this);
        arr = new TbArray(desc, this, elements);
        return arr;
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.createTbBlob();
    }

    @Override
    public TbBlob createTbBlob() throws SQLException {
        Debug.logMethod("TbConnection.createTbBlob", new Object[]{this});
        byte[] locator = this.getBlobAccessor().createTemporaryBlob();
        return new TbBlob(this, locator, false);
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.createTbClob();
    }

    @Override
    public TbClob createTbClob() throws SQLException {
        Debug.logMethod("TbConnection.createTbClob", new Object[]{this});
        byte[] locator = this.getClobAccessor().createTemporaryClob();
        return new TbClob(this, locator, false);
    }

    @Override
    public TbDirPathStream createDirPathStream(TbDirPathMetaData dirPathMetaData) throws SQLException {
        Debug.logMethod("TbConnection.createDirPathStream", new Object[]{this, dirPathMetaData});
        return new TbDirPathStream(this, dirPathMetaData);
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.createTbNClob();
    }

    @Override
    public TbNClob createTbNClob() throws SQLException {
        Debug.logMethod("TbConnection.createTbNClob", new Object[]{this});
        byte[] locator = this.getClobAccessor().createTemporaryNClob();
        return new TbNClob(this, locator, false);
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        Debug.logMethod("TbConnection.createSQLXML", new Object[]{this});
        return new TbSQLXML(this);
    }

    @Override
    public synchronized Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    @Override
    public synchronized Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        TbStatement stmt;
        Debug.logMethod("TbConnection.createStatement", new Object[]{new Integer(resultSetType), new Integer(resultSetConcurrency)});
        if (this.connClosed) {
            throw TbError.newSQLException(-90603);
        }
        if (this.stmtCache != null && (stmt = this.stmtCache.get(null, 0, RsetType.getRsetType(resultSetType, resultSetConcurrency))) != null) {
            return stmt;
        }
        return new com.tmax.tibero.jdbc.driver.TbStatement(this, resultSetType, resultSetConcurrency, this.preFetchSize);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        TbStatement stmt;
        Debug.logMethod("TbConnection.createStatement", new Object[]{new Integer(resultSetType), new Integer(resultSetConcurrency), new Integer(resultSetHoldability)});
        if (this.connClosed) {
            throw TbError.newSQLException(-90603);
        }
        if (resultSetHoldability != this.getHoldability()) {
            this.addWarning(TbError.newSQLWarning(-90660));
        }
        if (this.stmtCache != null && (stmt = this.stmtCache.get(null, 0, RsetType.getRsetType(resultSetType, resultSetConcurrency))) != null) {
            return stmt;
        }
        stmt = new com.tmax.tibero.jdbc.driver.TbStatement(this, resultSetType, resultSetConcurrency, this.preFetchSize);
        return stmt;
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        String schemaName = this.info.getUser();
        String delim = ".";
        String[] tokens = typeName.split("[" + delim + "]{1}");
        if (tokens.length != 1) {
            if (tokens.length == 2) {
                schemaName = tokens[0];
                typeName = tokens[1];
            } else {
                throw TbError.newSQLException(-90649);
            }
        }
        TbStructDescriptor desc = TbStructDescriptor.lookupUdtMeta(schemaName, typeName, this);
        TbStruct struct = new TbStruct(desc, this, attributes);
        return struct;
    }

    public void disableStmtCache() {
        this.info.setStmtCache(false);
    }

    void disallowGlobalTxnMode(int errorCode) throws SQLException {
        if (this.txnMode == 2) {
            throw TbError.newSQLException(errorCode);
        }
    }

    public void enableStmtCache() {
        this.info.setStmtCache(true);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    public TbBlobAccessor getBlobAccessor() {
        return (TbBlobAccessor)((Object)this.dbComm);
    }

    @Override
    public String getCatalog() throws SQLException {
        return null;
    }

    public boolean getIncludeSynonyms() {
        return this.info.getIncludeSynonyms();
    }

    public boolean getMapDateToTimestamp() {
        return this.info.getMapDateToTimestamp();
    }

    public void setIncludeSynonyms(boolean flag) {
        this.info.setIncludeSynonyms(flag);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        Debug.logMethod("TbConnection.getClientInfo", new Object[]{this});
        if (this.clientInfo == null) {
            return null;
        }
        Properties prop = new Properties();
        for (int i = 0; i < CLIENT_INFO_KEYS.length; ++i) {
            prop.put(CLIENT_INFO_KEYS[i], this.clientInfo[i]);
        }
        return prop;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        Debug.logMethod("TbConnection.getClientInfo", new Object[]{this, name});
        if (this.clientInfo == null) {
            return null;
        }
        for (int i = 0; i < CLIENT_INFO_KEYS.length; ++i) {
            if (!CLIENT_INFO_KEYS[i].equals(name)) continue;
            return this.clientInfo[i];
        }
        return null;
    }

    public TbClobAccessor getClobAccessor() {
        return (TbClobAccessor)((Object)this.dbComm);
    }

    public int getDefaultRowPrefetch() {
        return this.preFetchSize;
    }

    public List<TbResultSetBase> getFOActiveRSetList() {
        return this.foActiveRsets;
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    @Override
    public TbSQLInfo getLastExecutedSqlinfo() throws SQLException {
        return this.dbComm.getLastExecutedSqlinfo();
    }

    public TbSQLInfo2 getLastExecutedSqlinfo2() throws SQLException {
        return this.dbComm.getLastExecutedSqlinfo2();
    }

    public int getMaxDFRCharCount() {
        return this.maxDFRCharCount;
    }

    public int getMaxDFRNCharCount() {
        return this.maxDFRNCharCount;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        Debug.logMethod("TbConnection.getMetaData", new Object[]{this});
        if (this.connClosed) {
            throw TbError.newSQLException(-90603);
        }
        this.dbMetaData = new TbDatabaseMetaData(this);
        return this.dbMetaData;
    }

    public int getMthrPid() {
        return this.mthrPid;
    }

    @Override
    public String getNlsDate() {
        return this.nlsDate;
    }

    @Override
    public String getNlsTimestamp() {
        return this.nlsTimestamp;
    }

    @Override
    public int getSerialNo() {
        return this.serialNo;
    }

    @Override
    public int getServerCharSet() {
        return this.serverInfo.getServerCharSet();
    }

    @Override
    public ServerInfo getServerInfo() {
        return this.serverInfo;
    }

    public String getSessKey() {
        return this.sessKey;
    }

    @Override
    public int getServerNCharSet() {
        return this.serverInfo.getServerNCharSet();
    }

    @Override
    public int getSessionId() {
        return this.sessionId;
    }

    public TbStatementCache getStmtCache() {
        return this.stmtCache;
    }

    public TbComm getTbComm() {
        return this.dbComm;
    }

    public TbXAComm getTbXAComm() {
        return (TbXAComm)((Object)this.dbComm);
    }

    public TbTimeout getTimeout() throws SQLException {
        if (this.timeout == null) {
            this.timeout = TbTimeout.newTimeout();
        }
        return this.timeout;
    }

    @Override
    public synchronized int getTransactionIsolation() throws SQLException {
        return this.isolationLevel;
    }

    public int getTxnMode() {
        return this.txnMode;
    }

    public DataTypeConverter getTypeConverter() {
        return this.typeConverter;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.typeMap;
    }

    public long getWaitingTime() {
        return this.waitingTime;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    public boolean isActivatedTimer() {
        return this.checkWaitingTimer;
    }

    @Override
    public boolean isClosed() {
        return this.connClosed;
    }

    public boolean isMiddleOfFailover() {
        return this.middleOfFailover;
    }

    @Override
    public boolean isPooledConnection() {
        return this.isPooledConnection;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.readOnly;
    }

    public boolean isReconnected() {
        return this.reconnected;
    }

    @Override
    public boolean isSessionClosed() {
        return this.sessionClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(int timeout) throws SQLException {
        Debug.logMethod("TbConnection.isValid", new String[]{"TbConnection", "timeout"}, new Object[]{this, Integer.toString(timeout)});
        if (this.isClosed() || this.dbComm == null) {
            return false;
        }
        if (timeout == 0) {
            try {
                this.dbComm.ping();
            }
            catch (SQLException e) {
                return false;
            }
            return true;
        }
        Statement statement = null;
        statement = this.createStatement();
        ((com.tmax.tibero.jdbc.driver.TbStatement)statement).setQueryTimeout(timeout);
        try {
            statement.execute("SELECT 1 FROM DUAL");
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
        return true;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        Debug.logMethod("TbConnection.isWrapperFor", new Object[]{iface});
        return iface.isInstance(this);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return null;
    }

    public void openConnection(ConnectionInfo infos, boolean logonWithNewPassword) throws SQLException {
        String driverType;
        Debug.logMethod("TbConnection.openConnection", new String[]{"TbConnection", "ConnectionInfo", "logonWithNewPassword"}, new Object[]{this, infos, logonWithNewPassword});
        this.reuse();
        if (!this.middleOfFailover) {
            this.typeMap = new HashMap();
            this.descriptorMap = new HashMap<String, TbTypeDescriptor>();
            TbTypeDescriptor.genPredefUDTDescs(this);
            this.foActiveRsets = new LinkedList();
        }
        this.info = (ConnectionInfo)infos.clone();
        this.typeConverter = new DataTypeConverter(this);
        if (this.info.isStmtCache()) {
            this.stmtCache = new TbStatementCache(this.info.getStmtCacheMaxSize());
        }
        if ((driverType = this.info.getDriverType()).equals("thin")) {
            this.dbComm = this.info.isXA() ? new TbXACommType4(this) : new TbCommType4(this);
        } else {
            throw TbError.newSQLException(-590723, driverType);
        }
        this.dbComm.createStream();
        this.dbComm.getStream().setSelfKeepAliveEnabled(false);
        if (this.info.isInternal()) {
            this.dbComm.describeConnectInfo();
            this.dbComm.describeSessInfo();
            this.setAutoCommit(false);
        } else {
            try {
                this.dbComm.logon(logonWithNewPassword);
            }
            catch (SQLException e) {
                if (!this.sessionClosed && !this.connClosed) {
                    Debug.log("Reconnected successfully and ignore exception: [" + e.getErrorCode() + "] " + e.getMessage());
                    return;
                }
                throw e;
            }
        }
        this.dbComm.getStream().setSelfKeepAliveEnabled(this.info.useSelfKeepAlive());
        this.dbComm.getStream().setSoTimeout(this.info.getReadTimeout());
        this.sessionClosed = false;
        this.connClosed = false;
        this.efInfo = new ExtFeatureInfo(this);
        if (this.middleOfFailover) {
            this.reconnected = true;
        }
    }

    @Deprecated
    public void openSession() throws SQLException {
        Debug.logMethod("TbConnection.openSession", new Object[]{this});
        throw TbError.newSQLException(-90201);
    }

    @Override
    public synchronized CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1003, 1007);
    }

    @Override
    public synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        TbStatement stmt;
        Debug.logMethod("TbConnection.prepareCall", new Object[]{sql, new Integer(resultSetType), new Integer(resultSetConcurrency)});
        if (this.connClosed) {
            throw TbError.newSQLException(-90603);
        }
        if (this.stmtCache != null && (stmt = this.stmtCache.get(sql, 2, RsetType.getRsetType(resultSetType, resultSetConcurrency))) instanceof TbCallableStatement) {
            return (TbCallableStatement)stmt;
        }
        return new TbCallableStatement(this, sql, resultSetType, resultSetConcurrency, this.preFetchSize);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        TbStatement stmt;
        Debug.logMethod("TbConnection.prepareCall", new Object[]{sql, new Integer(resultSetType), new Integer(resultSetConcurrency), new Integer(resultSetHoldability)});
        if (this.connClosed) {
            throw TbError.newSQLException(-90603);
        }
        if (this.stmtCache != null && (stmt = this.stmtCache.get(sql, 2, RsetType.getRsetType(resultSetType, resultSetConcurrency))) instanceof TbCallableStatement) {
            return (TbCallableStatement)stmt;
        }
        if (resultSetHoldability != this.getHoldability()) {
            this.addWarning(TbError.newSQLWarning(-90660));
        }
        return new TbCallableStatement(this, sql, resultSetType, resultSetConcurrency, this.preFetchSize);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007, false);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, boolean forcePrepare) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007, forcePrepare);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        TbPreparedStatement pstmt = (TbPreparedStatement)this.prepareStatement(sql);
        if (36 == pstmt.getSqlType()) {
            pstmt.setReturnAutoGeneratedKeys(autoGeneratedKeys == 1);
        }
        return pstmt;
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int rsetType, int rsetConcurrency) throws SQLException {
        return this.prepareStatement(sql, rsetType, rsetConcurrency, false);
    }

    public synchronized PreparedStatement prepareStatement(String sql, int rsetType, int rsetConcurrency, boolean forcePrepare) throws SQLException {
        TbStatement stmt;
        Debug.logMethod("TbConnection.prepareStatement", new Object[]{sql, new Integer(rsetType), new Integer(rsetConcurrency)});
        if (this.connClosed) {
            throw TbError.newSQLException(-90603);
        }
        if (this.stmtCache != null && (stmt = this.stmtCache.get(sql, 1, RsetType.getRsetType(rsetType, rsetConcurrency))) instanceof TbPreparedStatement) {
            return (TbPreparedStatement)stmt;
        }
        return new TbPreparedStatement(this, sql, rsetType, rsetConcurrency, this.preFetchSize, forcePrepare);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int rsetType, int rsetConcurrency, int rsetHoldability) throws SQLException {
        TbStatement stmt;
        Debug.logMethod("TbConnection.prepareStatement", new Object[]{sql, new Integer(rsetType), new Integer(rsetConcurrency), new Integer(rsetHoldability)});
        if (this.connClosed) {
            throw TbError.newSQLException(-90603);
        }
        if (this.stmtCache != null && (stmt = this.stmtCache.get(sql, 1, RsetType.getRsetType(rsetType, rsetConcurrency))) instanceof TbPreparedStatement) {
            return (TbPreparedStatement)stmt;
        }
        if (rsetHoldability != this.getHoldability()) {
            this.addWarning(TbError.newSQLWarning(-90660));
        }
        return new TbPreparedStatement(this, sql, rsetType, rsetConcurrency, this.preFetchSize, false);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        TbPreparedStatement pstmt;
        if (columnIndexes == null || columnIndexes.length == 0) {
            TbError.newSQLException(-590732);
        }
        if (36 == (pstmt = (TbPreparedStatement)this.prepareStatement(sql)).getSqlType()) {
            pstmt.setReturnAutoGeneratedKeys(true);
            pstmt.setAutoGenKeyArr(columnIndexes);
        }
        return pstmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        TbPreparedStatement pstmt;
        if (columnNames == null || columnNames.length == 0) {
            TbError.newSQLException(-590732);
        }
        if (36 == (pstmt = (TbPreparedStatement)this.prepareStatement(sql)).getSqlType()) {
            pstmt.setReturnAutoGeneratedKeys(true);
            pstmt.setAutoGenKeyArr(columnNames);
        }
        return pstmt;
    }

    public void reconnect(boolean middleOfFailover) {
        if (this.info.isFailoverSessionEnabled()) {
            Debug.log("TbStream.reconnect (BEGIN)");
            boolean autoCommit = true;
            ConnectionInfo oldInfo = this.info;
            if (!middleOfFailover) {
                this.setMiddleOfFailover(true);
            }
            try {
                autoCommit = this.getAutoCommit();
                this.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            try {
                this.openConnection(oldInfo, false);
                this.setAutoCommit(autoCommit);
                Debug.log("TbStream.reconnect (RECONNECTED)");
            }
            catch (SQLException e) {
                if (!this.isReconnected()) {
                    Debug.log("TbStream.reconnect (FAILED TO RECONNECT): " + e.getMessage());
                    try {
                        this.close();
                    }
                    catch (SQLException se) {}
                }
                Debug.log("TbStream.reconnect (RECONNECTED)");
                try {
                    this.setAutoCommit(autoCommit);
                }
                catch (SQLException se) {
                    // empty catch block
                }
                this.setReconnected(false);
            }
            this.setMiddleOfFailover(middleOfFailover);
        } else {
            try {
                this.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        Debug.logMethod("TbConnection.releaseSavepoint", null, new Object[0]);
        throw TbError.newSQLException(-90201);
    }

    public boolean removeFOActiveResultSet(TbResultSetBase rs) {
        return this.foActiveRsets.remove(rs);
    }

    public void reset() {
        this.info = null;
        this.serverInfo = null;
        this.sessKey = null;
        this.warnings = null;
        this.dbMetaData = null;
        this.autoCommit = true;
        this.sessionClosed = true;
        this.txnMode = 0;
        this.readOnly = false;
        this.isolationLevel = 2;
        this.nlsDate = null;
        this.nlsTimestamp = null;
        this.preFetchSize = 64000;
        this.clientInfo = null;
        this.reconnected = false;
        this.efInfo = null;
        if (this.typeConverter != null) {
            this.typeConverter.reset();
            this.typeConverter = null;
        }
        if (this.stmtCache != null) {
            this.stmtCache.clear();
            this.stmtCache = null;
        }
        if (!this.isMiddleOfFailover()) {
            this.typeMap = null;
            this.descriptorMap = null;
        }
    }

    @Override
    public synchronized void resetSession() throws SQLException {
        if (this.serverInfo != null) {
            int major = this.serverInfo.getProtocolMajorVersion();
            int minor = this.serverInfo.getProtocolMinorVersion();
            if (major > 2 || major == 2 && minor > 1) {
                Debug.logMethod("TbConnection.resetSession", null, new Object[0]);
                this.dbComm.resetSession();
            }
        }
    }

    public void reuse() {
        this.warnings = null;
        this.autoCommit = true;
        this.sessionClosed = true;
        this.txnMode = 0;
        this.readOnly = false;
        this.isolationLevel = 2;
        this.preFetchSize = 64000;
        this.clientInfo = null;
        this.reconnected = false;
        if (this.typeMap != null) {
            this.typeMap.clear();
        }
        if (this.descriptorMap != null) {
            this.descriptorMap.clear();
        }
    }

    @Override
    public synchronized void rollback() throws SQLException {
        Debug.logMethod("TbConnection.rollback", null, new Object[0]);
        if (this.connClosed || this.dbComm.getStream() == null) {
            throw TbError.newSQLException(-90603);
        }
        this.dbComm.rollback();
    }

    @Override
    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        Debug.logMethod("TbConnection.rollback", null, new Object[0]);
        if (this.connClosed || this.dbComm.getStream() == null) {
            throw TbError.newSQLException(-90603);
        }
        if (this.autoCommit) {
            throw TbError.newSQLException(-90601);
        }
        this.dbComm.rollback((TbSavepoint)savepoint);
    }

    @Override
    public synchronized void setAutoCommit(boolean flag) throws SQLException {
        Debug.logMethod("TbConnection.setAutoCommit", new String[]{"AutoCommit"}, new Object[]{new Boolean(flag)});
        if (this.connClosed) {
            throw TbError.newSQLException(-90603);
        }
        this.autoCommit = this.info.isInternal() ? false : flag;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
    }

    @Override
    public synchronized void setClientInfo(Properties prop) throws SQLClientInfoException {
        Debug.logMethod("TbConnection.setClientInfo", new Object[]{this, prop});
        if (this.clientInfo == null) {
            this.clientInfo = new String[CLIENT_INFO_KEYS.length];
        }
        for (int i = 0; i < CLIENT_INFO_KEYS.length; ++i) {
            this.clientInfo[i] = (String)prop.get(CLIENT_INFO_KEYS[i]);
        }
        this.dbComm.setClientInfo(this.clientInfo);
    }

    @Override
    public synchronized void setClientInfo(String name, String value) throws SQLClientInfoException {
        Debug.logMethod("TbConnection.setClientInfo", new Object[]{this, name, value});
        if (this.clientInfo == null) {
            this.clientInfo = new String[CLIENT_INFO_KEYS.length];
        }
        for (int i = 0; i < CLIENT_INFO_KEYS.length; ++i) {
            if (!CLIENT_INFO_KEYS[i].equals(name)) continue;
            this.clientInfo[i] = value;
        }
        this.dbComm.setClientInfo(this.clientInfo);
    }

    public void setClosed(boolean flag) {
        this.connClosed = flag;
    }

    public void setDefaultRowPrefetch(int fetchSize) {
        this.preFetchSize = fetchSize;
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        switch (holdability) {
            case 1: {
                return;
            }
            case 2: {
                throw TbError.newSQLException(-90660);
            }
        }
        throw TbError.newSQLException(-90608);
    }

    public void setMaxDFRCharCount() {
        int maxBytesPerChar = this.typeConverter.getMaxBytesPerChar();
        if (maxBytesPerChar == 1) {
            maxBytesPerChar = 2;
        }
        this.maxDFRCharCount = 65532 / maxBytesPerChar;
        int maxBytesPerNChar = this.typeConverter.getMaxBytesPerNChar();
        if (maxBytesPerNChar == 1) {
            maxBytesPerNChar = 2;
        }
        this.maxDFRNCharCount = 65532 / maxBytesPerNChar;
    }

    public void setMiddleOfFailover(boolean flag) {
        this.middleOfFailover = flag;
    }

    public void setMthrPid(int mpid) {
        this.mthrPid = mpid;
    }

    public void setNLSDate(String nlsdate) {
        this.nlsDate = nlsdate;
        try {
            this.parsedNlsDateFormat = TbDTFormatParser.parse(this.nlsDate);
        }
        catch (SQLWarning w) {
            this.addWarning(w);
            this.parsedNlsDateFormat = null;
        }
    }

    public void setNLSTimestamp(String nlsts) {
        this.nlsTimestamp = nlsts;
        try {
            this.parsedNlsTimestampFormat = TbDTFormatParser.parse(this.nlsTimestamp);
        }
        catch (SQLWarning w) {
            this.addWarning(w);
            this.parsedNlsTimestampFormat = null;
        }
    }

    public boolean isNLSWarning() {
        return this.nlsWarning;
    }

    public void setNLSWarning(boolean flag) {
        this.nlsWarning = flag;
    }

    public void setPooledConnection(boolean flag) {
        this.isPooledConnection = flag;
    }

    @Override
    public void setReadOnly(boolean flag) throws SQLException {
        this.readOnly = flag;
    }

    public void setReconnected(boolean flag) {
        this.reconnected = flag;
    }

    @Override
    public synchronized Savepoint setSavepoint() throws SQLException {
        if (this.connClosed) {
            throw TbError.newSQLException(-90603);
        }
        TbSavepoint savepoint = new TbSavepoint();
        this.dbComm.setSavePoint(savepoint);
        return savepoint;
    }

    @Override
    public synchronized Savepoint setSavepoint(String name) throws SQLException {
        if (this.connClosed) {
            throw TbError.newSQLException(-90603);
        }
        TbSavepoint savepoint = new TbSavepoint(name);
        this.dbComm.setSavePoint(savepoint);
        return savepoint;
    }

    public void setSerialNo(int sno) {
        this.serialNo = sno;
    }

    public void setServerInfo(ServerInfo info) {
        this.serverInfo = info;
    }

    public void setSessKey(String sessKey) {
        this.sessKey = sessKey;
    }

    public void setSessionId(int sessid) {
        this.sessionId = sessid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setTransactionIsolation(int level) throws SQLException {
        Debug.logMethod("TbConnection.setTransactionIsolation", new String[]{"TransactionLevel"}, new Object[]{new Integer(level)});
        if (level != 2 && level != 8) {
            throw TbError.newSQLException(-590722);
        }
        Statement stmt = null;
        try {
            stmt = this.createStatement();
            if (level == 8) {
                stmt.execute("alter session set isolation_level=serializable");
            } else {
                stmt.execute("alter session set isolation_level=read committed");
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
        this.isolationLevel = level;
    }

    public void setTxnMode(int mode) {
        this.txnMode = mode;
    }

    @Override
    public synchronized void setTypeMap(Map<String, Class<?>> typemap) throws SQLException {
        this.typeMap = typemap;
    }

    public void switchTxnMode(int fromMode, int toMode) {
        if (this.txnMode == fromMode) {
            this.txnMode = toMode;
        }
    }

    public synchronized void putDescriptor(String name, TbTypeDescriptor desc) throws SQLException {
        if (name == null || desc == null) {
            throw TbError.newSQLException(-590713);
        }
        if (this.descriptorMap == null) {
            this.descriptorMap = new HashMap<String, TbTypeDescriptor>();
        }
        int tobjID = desc.getTobjID();
        int versionNo = desc.getVersionNo();
        String key = name + "/T" + tobjID + "/V" + versionNo;
        this.descriptorMap.put(key, desc);
        if (TbTypeDescriptor.preDefinedOIDList.contains(name) || TbTypeDescriptor.preDefinedTypeNameList.contains(name)) {
            this.descriptorMap.put(name, desc);
        }
    }

    public synchronized Object getDescriptor(String name) throws SQLException {
        if (name == null) {
            throw TbError.newSQLException(-590713);
        }
        if (this.descriptorMap == null) {
            return null;
        }
        return this.descriptorMap.get(name);
    }

    public ExtFeatureInfo getExtFeatureInfo() throws SQLException {
        if (this.connClosed) {
            throw TbError.newSQLException(-90603);
        }
        return this.efInfo;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        Debug.logMethod("TbConnection.unwrap", new Object[]{iface});
        try {
            return iface.cast(this);
        }
        catch (ClassCastException e) {
            throw TbError.newSQLException(-90657);
        }
    }

    public TbDTFormat getParsedNlsDateFormat() {
        return this.parsedNlsDateFormat;
    }

    public TbDTFormat getParsedNlsTimestampFormat() {
        return this.parsedNlsTimestampFormat;
    }
}

