/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.dpl.binder;

import com.tmax.tibero.jdbc.TbDatabaseMetaData;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.data.StreamBuffer;
import com.tmax.tibero.jdbc.dpl.TbDirPathStream;
import com.tmax.tibero.jdbc.dpl.binder.DPLBinder;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class DPLLongStreamBinder
extends DPLBinder {
    @Override
    public void bind(TbConnection conn, TbDirPathStream stream, TbStreamDataWriter writer, int paramIndex, int length) throws SQLException {
        InputStream inputStream = stream.getParamStream(paramIndex);
        StreamBuffer buf = writer.getStreamBuf();
        String clientCharSet = stream.getDPLMetaData().getClientCharSet();
        String svrCharSet = ((TbDatabaseMetaData)conn.getMetaData()).getServerCharSet();
        byte[] byteBuf = new byte[16384];
        int readBufferBytes = 0;
        int readBytes = 0;
        int writeByteCnt = 0;
        int offset = 0;
        int availableBytes = 0;
        int unReadBytes = 0;
        try {
            if (buf.getRemained() <= 4) {
                stream.dirPathLoadStream(writer, 0);
            }
            writer.writeInt(0, 4);
            while (length >= 0) {
                readBytes = length > 16384 ? 16384 : length;
                readBufferBytes = inputStream.read(byteBuf, 0, readBytes);
                if (readBufferBytes <= 0) {
                    if (writeByteCnt > 0) {
                        writer.reWriteInt(buf.getCurDataSize() - writeByteCnt - 4, writeByteCnt, 4);
                        writer.writePaddingDPL(writeByteCnt);
                    }
                    return;
                }
                String tempStr = new String(byteBuf, 0, readBufferBytes, clientCharSet);
                byte[] convBuf = tempStr.getBytes(svrCharSet);
                offset = 0;
                while ((unReadBytes = convBuf.length - offset) > (availableBytes = buf.getRemained())) {
                    writer.writeBytes(convBuf, offset, availableBytes);
                    offset += availableBytes;
                    writer.reWriteInt(buf.getCurDataSize() - (writeByteCnt += availableBytes) - 4, writeByteCnt, 4);
                    writer.writePaddingDPL(writeByteCnt);
                    stream.dirPathLoadStream(writer, 1);
                    writeByteCnt = 0;
                    writer.writeInt(0, 4);
                }
                writer.writeBytes(convBuf, offset, unReadBytes);
                writeByteCnt += unReadBytes;
                offset += unReadBytes;
                length -= readBufferBytes;
            }
        }
        catch (IOException e) {
            throw TbError.newSQLException(-90202, e.getMessage());
        }
    }
}

