/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import com.tmax.tibero.jdbc.err.TbError;
import java.sql.SQLException;

public class UnicodeCharToByteConverter {
    protected boolean subMode = true;
    protected byte[] subBytes = new byte[]{63};
    int originalByteOrder;
    boolean usesMark;

    public UnicodeCharToByteConverter(int i, boolean flag) {
        this.originalByteOrder = i;
        this.usesMark = flag;
    }

    public int convCharArr(char[] ac, int i, int j, byte[] abyte0, int k, int l) throws SQLException {
        boolean usesMark = false;
        boolean markWritten = false;
        boolean byteOrder = true;
        if (i >= j) {
            return 0;
        }
        int i1 = i;
        int j1 = k;
        int k1 = l - 2;
        if (usesMark && !markWritten) {
            if (j1 > k1) {
                throw TbError.newSQLException(-590744, j1 + " > " + k1);
            }
            if (byteOrder) {
                abyte0[j1++] = -2;
                abyte0[j1++] = -1;
            } else {
                abyte0[j1++] = -1;
                abyte0[j1++] = -2;
            }
            markWritten = true;
        }
        if (byteOrder) {
            while (i1 < j) {
                if (j1 > k1) {
                    throw TbError.newSQLException(-590744, j1 + " > " + k1);
                }
                char c = ac[i1++];
                abyte0[j1++] = (byte)(c >> 8);
                abyte0[j1++] = (byte)(c & 0xFF);
            }
        } else {
            while (i1 < j) {
                if (j1 > k1) {
                    throw TbError.newSQLException(-590744, j1 + " > " + k1);
                }
                char c1 = ac[i1++];
                abyte0[j1++] = (byte)(c1 & 0xFF);
                abyte0[j1++] = (byte)(c1 >> 8);
            }
        }
        return j1 - k;
    }

    public int convString(String ac, int i, int j, byte[] abyte0, int k, int l) throws SQLException {
        boolean usesMark = false;
        boolean markWritten = false;
        boolean byteOrder = true;
        if (i >= j) {
            return 0;
        }
        int i1 = i;
        int j1 = k;
        int k1 = l - 2;
        if (usesMark && !markWritten) {
            if (j1 > k1) {
                throw TbError.newSQLException(-590744, j1 + " > " + k1);
            }
            if (byteOrder) {
                abyte0[j1++] = -2;
                abyte0[j1++] = -1;
            } else {
                abyte0[j1++] = -1;
                abyte0[j1++] = -2;
            }
            markWritten = true;
        }
        if (byteOrder) {
            while (i1 < j) {
                if (j1 > k1) {
                    throw TbError.newSQLException(-590744, j1 + " > " + k1);
                }
                char c = ac.charAt(i1++);
                abyte0[j1++] = (byte)(c >> 8);
                abyte0[j1++] = (byte)(c & 0xFF);
            }
        } else {
            while (i1 < j) {
                if (j1 > k1) {
                    throw TbError.newSQLException(-590744, j1 + " > " + k1);
                }
                char c1 = ac.charAt(i1++);
                abyte0[j1++] = (byte)(c1 & 0xFF);
                abyte0[j1++] = (byte)(c1 >> 8);
            }
        }
        return j1 - k;
    }

    public int getMaxBytesPerChar() {
        return 4;
    }
}

