/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import com.tmax.tibero.jdbc.data.charset.CharsetDecoder;
import com.tmax.tibero.jdbc.data.charset.SJISByteToCharConverter;
import com.tmax.tibero.jdbc.err.TbError;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;

public class SJISDecoder
implements CharsetDecoder {
    private SJISByteToCharConverter conv = new SJISByteToCharConverter();

    @Override
    public int bytesToChars(byte[] srcBytes, int srcStart, int srcLen, char[] destChars, int destStart, int destLen) throws SQLException {
        return this.conv.convert(srcBytes, srcStart, srcStart + srcLen, destChars, destStart, destStart + destLen);
    }

    @Override
    public String bytesToString(byte[] srcBytes, int srcStart, int srcLen) throws SQLException {
        try {
            return new String(srcBytes, srcStart, srcLen, "Shift_JIS");
        }
        catch (UnsupportedEncodingException e) {
            throw TbError.newSQLException(-590714);
        }
    }

    @Override
    public String bytesToString(byte[] srcBytes) throws SQLException {
        return this.bytesToString(srcBytes, 0, srcBytes.length);
    }

    @Override
    public int fixedBytesToChars(byte[] srcBytes, int srcStart, int srcLen, char[] destChars, int destStart, int destLen) throws SQLException {
        return 0;
    }

    @Override
    public String fixedBytesToString(byte[] srcBytes, int srcStart, int srcLen) throws SQLException {
        return null;
    }

    @Override
    public String fixedBytesToString(byte[] srcBytes) throws SQLException {
        return null;
    }
}

