/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import com.tmax.tibero.jdbc.data.charset.Big5ByteToCharConverter;
import com.tmax.tibero.jdbc.data.charset.HKSCS2001ByteToCharConverter;
import com.tmax.tibero.jdbc.data.charset.MS950ExtByteToCharConverter;
import com.tmax.tibero.jdbc.err.TbError;
import java.sql.SQLException;

public class MS950ByteToCharConverter {
    private HKSCS2001ByteToCharConverter hkscs2001converter;
    private Big5ByteToCharConverter big5Converter;
    private MS950ExtByteToCharConverter ms950ExtConverter;
    protected boolean subMode = true;
    protected char[] subChars = new char[]{'?'};
    private static final char[] CP950_TO_UNICODE_PAGEA1 = new char[]{'\u3000', '\uff0c', '\u3001', '\u3002', '\uff0e', '\u2027', '\uff1b', '\uff1a', '\uff1f', '\uff01', '\ufe30', '\u2026', '\u2025', '\ufe50', '\ufe51', '\ufe52', '\u00b7', '\ufe54', '\ufe55', '\ufe56', '\ufe57', '\uff5c', '\u2013', '\ufe31', '\u2014', '\ufe33', '\u2574', '\ufe34', '\ufe4f', '\uff08', '\uff09', '\ufe35', '\ufe36', '\uff5b', '\uff5d', '\ufe37', '\ufe38', '\u3014', '\u3015', '\ufe39', '\ufe3a', '\u3010', '\u3011', '\ufe3b', '\ufe3c', '\u300a', '\u300b', '\ufe3d', '\ufe3e', '\u3008', '\u3009', '\ufe3f', '\ufe40', '\u300c', '\u300d', '\ufe41', '\ufe42', '\u300e', '\u300f', '\ufe43', '\ufe44', '\ufe59', '\ufe5a', '\ufe5b', '\ufe5c', '\ufe5d', '\ufe5e', '\u2018', '\u2019', '\u201c', '\u201d', '\u301d', '\u301e', '\u2035', '\u2032', '\uff03', '\uff06', '\uff0a', '\u203b', '\u00a7', '\u3003', '\u25cb', '\u25cf', '\u25b3', '\u25b2', '\u25ce', '\u2606', '\u2605', '\u25c7', '\u25c6', '\u25a1', '\u25a0', '\u25bd', '\u25bc', '\u32a3', '\u2105', '\u00af', '\uffe3', '\uff3f', '\u02cd', '\ufe49', '\ufe4a', '\ufe4d', '\ufe4e', '\ufe4b', '\ufe4c', '\ufe5f', '\ufe60', '\ufe61', '\uff0b', '\uff0d', '\u00d7', '\u00f7', '\u00b1', '\u221a', '\uff1c', '\uff1e', '\uff1d', '\u2266', '\u2267', '\u2260', '\u221e', '\u2252', '\u2261', '\ufe62', '\ufe63', '\ufe64', '\ufe65', '\ufe66', '\uff5e', '\u2229', '\u222a', '\u22a5', '\u2220', '\u221f', '\u22bf', '\u33d2', '\u33d1', '\u222b', '\u222e', '\u2235', '\u2234', '\u2640', '\u2642', '\u2295', '\u2299', '\u2191', '\u2193', '\u2190', '\u2192', '\u2196', '\u2197', '\u2199', '\u2198', '\u2225', '\u2223', '\uff0f', '\uff3c', '\u2215', '\ufe68', '\uff04', '\uffe5', '\u3012', '\uffe0', '\uffe1', '\uff05', '\uff20', '\u2103', '\u2109', '\ufe69', '\ufe6a', '\ufe6b', '\u33d5', '\u339c', '\u339d', '\u339e', '\u33ce', '\u33a1', '\u338e', '\u338f', '\u33c4', '\u00b0', '\u5159', '\u515b', '\u515e', '\u515d', '\u5161', '\u5163', '\u55e7', '\u74e9', '\u7cce', '\u2581', '\u2582', '\u2583', '\u2584', '\u2585', '\u2586', '\u2587', '\u2588', '\u258f', '\u258e', '\u258d', '\u258c', '\u258b', '\u258a', '\u2589', '\u253c', '\u2534', '\u252c', '\u2524', '\u251c', '\u2594', '\u2500', '\u2502', '\u2595', '\u250c', '\u2510', '\u2514', '\u2518', '\u256d', '\u256e', '\u2570', '\u256f', '\u2550', '\u255e', '\u256a', '\u2561', '\u25e2', '\u25e3', '\u25e5', '\u25e4', '\u2571', '\u2572', '\u2573', '\uff10', '\uff11', '\uff12', '\uff13', '\uff14', '\uff15', '\uff16', '\uff17', '\uff18', '\uff19', '\u2160', '\u2161', '\u2162', '\u2163', '\u2164', '\u2165', '\u2166', '\u2167', '\u2168', '\u2169', '\u3021', '\u3022', '\u3023', '\u3024', '\u3025', '\u3026', '\u3027', '\u3028', '\u3029', '\u5341', '\u5344', '\u5345', '\uff21', '\uff22', '\uff23', '\uff24', '\uff25', '\uff26', '\uff27', '\uff28', '\uff29', '\uff2a', '\uff2b', '\uff2c', '\uff2d', '\uff2e', '\uff2f', '\uff30', '\uff31', '\uff32', '\uff33', '\uff34', '\uff35', '\uff36', '\uff37', '\uff38', '\uff39', '\uff3a', '\uff41', '\uff42', '\uff43', '\uff44', '\uff45', '\uff46', '\uff47', '\uff48', '\uff49', '\uff4a', '\uff4b', '\uff4c', '\uff4d', '\uff4e', '\uff4f', '\uff50', '\uff51', '\uff52', '\uff53', '\uff54', '\uff55', '\uff56'};

    public MS950ByteToCharConverter() {
        this.hkscs2001converter = new HKSCS2001ByteToCharConverter();
        this.big5Converter = new Big5ByteToCharConverter();
        this.ms950ExtConverter = new MS950ExtByteToCharConverter();
    }

    private void decodeUCharToUCS2(char[] buf, int offset, int wc) {
        boolean high = false;
        byte low = (byte)wc;
        buf[offset] = (char)(high ? 1 : 0);
        buf[offset++] = (char)low;
    }

    private void decodeUShortToUCS2(char[] buf, int offset, int wc) {
        byte high = (byte)(wc >> 8);
        byte low = (byte)(wc & 0xFF);
        buf[offset] = (char)high;
        buf[offset++] = (char)low;
    }

    public int convert(byte[] src, int srcStartOffset, int srcEndOffset, char[] dest, int destStartOffset, int destEndOffset) throws SQLException {
        int srcLen = srcEndOffset - srcStartOffset;
        int destLen = destEndOffset - destStartOffset;
        byte c2 = 0;
        int i = srcStartOffset;
        int j = destStartOffset;
        while (i < srcStartOffset + srcLen && j < destStartOffset + destLen) {
            int rc;
            byte c1 = src[i];
            if ((c1 & 0xFF) < 128) {
                this.decodeUCharToUCS2(dest, j, c1);
                ++j;
                ++i;
                continue;
            }
            if ((byte)c1 == -116) {
                c2 = src[i + 1];
                rc = this.hkscs2001converter.convert(c1, c2, dest, j);
                if (rc == 0) {
                    i += 2;
                    ++j;
                    continue;
                }
                if (rc == 2) {
                    i += 2;
                    j += 2;
                    continue;
                }
            }
            if ((c1 & 0xFF) == 249 && (rc = this.ms950ExtConverter.convert(c1, c2 = src[i + 1], dest, j)) == 0) {
                i += 2;
                ++j;
                continue;
            }
            if ((byte)c1 >= -127 && (byte)c1 < -1) {
                int n;
                int wc;
                c2 = src[i + 1];
                if (((byte)c2 < 64 || (byte)c2 >= 127) && ((byte)c2 < -95 || (byte)c2 >= -1)) continue;
                if (c1 >= -95) {
                    int index;
                    if (c1 < -93 && (wc = CP950_TO_UNICODE_PAGEA1[index = 157 * ((byte)c1 - -95) + (((char)c2 & 0xFF) - (byte)(n = (char)c2 >= '\u00a1' ? 98 : 64))]) != 65533) {
                        dest[j++] = (char)wc;
                        i += 2;
                        continue;
                    }
                    if (((byte)c1 != -58 || (char)c2 < '\u00a1') && (byte)c1 != -57 && (rc = this.big5Converter.convert(c1, c2, dest, j)) == 0) {
                        i += 2;
                        ++j;
                        continue;
                    }
                    if ((byte)c1 == -93 && (byte)c2 == -31) {
                        dest[j++] = 8364;
                        i += 2;
                        continue;
                    }
                    if (c1 < 250) continue;
                    n = (char)c2 >= '\u00a1' ? 98 : 64;
                    wc = 57344 + 157 * ((byte)c1 - -6) + (((char)c2 & 0xFF) - (byte)n);
                    dest[j++] = (char)wc;
                    i += 2;
                    continue;
                }
                int k = (char)c1 >= '\u008e' ? 56088 : 61112;
                n = (char)c2 >= '\u00a1' ? 98 : 64;
                wc = k + 157 * ((byte)c1 - -127) + (((char)c2 & 0xFF) - (byte)n);
                dest[j++] = (char)wc;
                i += 2;
                continue;
            }
            if (this.subMode) {
                dest[j++] = this.subChars[0];
                continue;
            }
            throw TbError.newSQLException(-590742, (int)c1);
        }
        return j - destStartOffset;
    }
}

