/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

public class HKSCS2001CharToByteConverter {
    private static final char[] HKSCS2001_TO_CHARSET = new char[]{'\u8c4b', '\u8c56', '\u8c44', '\u8caa', '\u8c5d', '\u8cc3', '\u8c60', '\u8ccb', '\u8cc4', '\u8c58', '\u8c49', '\u8cd2', '\u8c72', '\u8c6f', '\u8c73', '\u8c70', '\u8c40', '\u8c71', '\u8c5b', '\u8c68', '\u8c75', '\u8ccc', '\u8c77', '\u8c78', '\u8cc5', '\u8cac', '\u8cd9', '\u8c48', '\u8cd4', '\u8c7a', '\u8c7b', '\u8c7c', '\u8c4d', '\u8c7e', '\u8c52', '\u8cca', '\u8ca2', '\u8ca3', '\u8c5e', '\u8ca5', '\u8c41', '\u8c67', '\u8c47', '\u8c51', '\u8ca7', '\u8ca9', '\u8c53', '\u8c5a', '\u8cad', '\u8c6b', '\u8c6e', '\u8c59', '\u8c63', '\u8cb1', '\u8cb2', '\u8cb3', '\u8c76', '\u8cdc', '\u8cb4', '\u8cd0', '\u8cb5', '\u8cbd', '\u8cb6', '\u8cce', '\u8c61', '\u8c45', '\u8cb8', '\u8cae', '\u8cba', '\u8c4f', '\u8cbc', '\u8c50', '\u8cbf', '\u8c6a', '\u8c66', '\u8cc9', '\u8cbe', '\u8c43', '\u8c6d', '\u8c74', '\u8cb7', '\u8cb9', '\u8cbb', '\u8cc0', '\u8cd7', '\u8cd8', '\u8cda', '\u8cc2', '\u8c57', '\u8c79', '\u8c69', '\u8c7d', '\u8c54', '\u8ca1', '\u8ca4', '\u8c46', '\u8ca8', '\u8ccf', '\u8cab', '\u8c4a', '\u8cb0', '\u8caf', '\u8c4c', '\u8cd5', '\u8cd3', '\u8cd6', '\u8cd1', '\u8c5c', '\u8c6c', '\u8c4e', '\u8c65', '\u8cc1', '\u8c64', '\u8c42', '\u8c55', '\u8c5f'};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE35 = new char[][]{{'\u0000', '\u0000'}, {'\u0000', '\u0000'}, {'\u0000', '\u0000'}, {'\u0000', '\u0000'}, {'\u0000', '\u0000'}, {'\u0000', '\u0200'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE3C = new char[][]{{'\u0001', '\u0000'}, {'\u0001', '\u0000'}, {'\u0001', '\u0000'}, {'\u0001', '\u0000'}, {'\u0001', '\u0000'}, {'\u0001', '\u0000'}, {'\u0001', '\u0000'}, {'\u0001', '\u0000'}, {'\u0001', '\u0800'}, {'\u0002', '\u0000'}, {'\u0002', '\u0000'}, {'\u0002', '\u0000'}, {'\u0002', '\u0000'}, {'\u0002', '\u0000'}, {'\u0002', '\u0000'}, {'\u0002', '\u0000'}, {'\u0002', '\u0000'}, {'\u0002', '\u0000'}, {'\u0002', '\u0000'}, {'\u0002', '\u0000'}, {'\u0002', '\u0000'}, {'\u0002', '\u0000'}, {'\u0002', '\u0000'}, {'\u0002', '\u0000'}, {'\u0002', '\u0000'}, {'\u0002', '\u0000'}, {'\u0002', '\u0000'}, {'\u0002', '\u0000'}, {'\u0002', '\u0200'}, {'\u0003', '\u0000'}, {'\u0003', '\u0000'}, {'\u0003', '\u0000'}, {'\u0003', '\u0000'}, {'\u0003', '\u0000'}, {'\u0003', '\u0000'}, {'\u0003', '\u0000'}, {'\u0003', '\u0000'}, {'\u0003', '\u0000'}, {'\u0003', '\u0000'}, {'\u0003', '\u0000'}, {'\u0003', '\u0000'}, {'\u0003', '\u0000'}, {'\u0003', '\u0000'}, {'\u0003', '\u0000'}, {'\u0003', '\u0000'}, {'\u0003', '\u0800'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE40 = new char[][]{{'\u0004', '\u0200'}, {'\u0005', '\u0000'}, {'\u0005', '\u0000'}, {'\u0005', '\u0000'}, {'\u0005', '\u0000'}, {'\u0005', '\u0000'}, {'\u0005', '\u0000'}, {'\u0005', '\u0002'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE42 = new char[][]{{'\u0006', '\u0000'}, {'\u0006', '\u0000'}, {'\u0006', '\b'}, {'\u0007', '\u0000'}, {'\u0007', '\u0000'}, {'\u0007', '\u0000'}, {'\u0007', '\u0000'}, {'\u0007', '@'}, {'\b', '\u0000'}, {'\b', '\u0000'}, {'\b', '\u0004'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE4B = new char[][]{{'\t', '\u0000'}, {'\t', '\u0001'}, {'\n', '\u0001'}, {'\u000b', '\u0000'}, {'\u000b', '\u0000'}, {'\u000b', '\u0000'}, {'\u000b', '\u0000'}, {'\u000b', '\u0000'}, {'\u000b', '\u0000'}, {'\u000b', '\u0000'}, {'\u000b', '\u0000'}, {'\u000b', '\u0000'}, {'\u000b', '\u0000'}, {'\u000b', '\u0000'}, {'\u000b', '\u0000'}, {'\u000b', '\u0000'}, {'\u000b', '\u0000'}, {'\u000b', '\u0000'}, {'\u000b', '\u0000'}, {'\u000b', '\u0000'}, {'\u000b', '\u0000'}, {'\u000b', '\u0000'}, {'\u000b', '\u0000'}, {'\u000b', '\u0000'}, {'\u000b', '\u0002'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE4E = new char[][]{{'\f', '\u0000'}, {'\f', '\u0000'}, {'\f', '\u8000'}, {'\r', '\u0000'}, {'\r', '\u0000'}, {'\r', '\u0000'}, {'\r', '\u0000'}, {'\r', '\u0000'}, {'\r', '\u0000'}, {'\r', '\u0000'}, {'\r', '\b'}, {'\u000e', '\u0000'}, {'\u000e', '\u0000'}, {'\u000e', '\u0000'}, {'\u000e', '\u0000'}, {'\u000e', '\u0000'}, {'\u000e', '\u0000'}, {'\u000e', '\u0080'}, {'\u000f', '\u0000'}, {'\u000f', '\u0000'}, {'\u000f', '\u0000'}, {'\u000f', '\u0000'}, {'\u000f', '\u0000'}, {'\u000f', '\u0000'}, {'\u000f', '\u0000'}, {'\u000f', '\u0000'}, {'\u000f', '\u0000'}, {'\u000f', '\u0000'}, {'\u000f', '\u0000'}, {'\u000f', '\u0000'}, {'\u000f', '\u0000'}, {'\u000f', '\u0001'}, {'\u0010', '\u0000'}, {'\u0010', '\u0000'}, {'\u0010', '\u0000'}, {'\u0010', '\u0800'}, {'\u0011', '\u0000'}, {'\u0011', '\u0000'}, {'\u0011', '\u0000'}, {'\u0011', '\u0000'}, {'\u0011', '\u0000'}, {'\u0011', '\u0000'}, {'\u0011', '\u0000'}, {'\u0011', '\u1000'}, {'\u0012', '\u0000'}, {'\u0012', '\u0000'}, {'\u0012', '\u0000'}, {'\u0012', '\u0000'}, {'\u0012', '\u0000'}, {'\u0012', '\u0000'}, {'\u0012', '\u0000'}, {'\u0012', '\u0000'}, {'\u0012', '\u0000'}, {'\u0012', '\u0000'}, {'\u0012', '\u0000'}, {'\u0012', '\u0000'}, {'\u0012', '\u0000'}, {'\u0012', '\u0000'}, {'\u0012', '\u4000'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE53 = new char[][]{{'\u0013', '\u0000'}, {'\u0013', '\u0000'}, {'\u0013', '\u0010'}, {'\u0014', '\u0000'}, {'\u0014', '\u0000'}, {'\u0014', '\u0000'}, {'\u0014', '\u0000'}, {'\u0014', '\u0000'}, {'\u0014', '\u0000'}, {'\u0014', '\u0000'}, {'\u0014', '\u0000'}, {'\u0014', '\u0000'}, {'\u0014', '\u0000'}, {'\u0014', '\u0000'}, {'\u0014', '\u0000'}, {'\u0014', '\u0000'}, {'\u0014', '\u0000'}, {'\u0014', '\u0000'}, {'\u0014', '\u0000'}, {'\u0014', '\u0010'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE57 = new char[][]{{'\u0015', '\u0000'}, {'\u0015', '\u0000'}, {'\u0015', '\u0000'}, {'\u0015', '\u2000'}, {'\u0016', '\u0000'}, {'\u0016', '\u0000'}, {'\u0016', '\u0000'}, {'\u0016', '\u0000'}, {'\u0016', '\u0000'}, {'\u0016', '\u0000'}, {'\u0016', '\u0000'}, {'\u0016', '\u0000'}, {'\u0016', '\u0000'}, {'\u0016', '\u0000'}, {'\u0016', '\u0000'}, {'\u0016', '\u0000'}, {'\u0016', '\u0000'}, {'\u0016', '\u0000'}, {'\u0016', '\u0000'}, {'\u0016', '\u0000'}, {'\u0016', '\u0000'}, {'\u0016', '\u0000'}, {'\u0016', '\u0000'}, {'\u0016', '\u0000'}, {'\u0016', '\u0000'}, {'\u0016', '\u0004'}, {'\u0017', '\u0000'}, {'\u0017', '\u0000'}, {'\u0017', '\u0000'}, {'\u0017', '\u0001'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE5A = new char[][]{{'\u0018', '\u0000'}, {'\u0018', '\u0400'}, {'\u0019', '\u0000'}, {'\u0019', '\u0000'}, {'\u0019', '\u0000'}, {'\u0019', '\u0000'}, {'\u0019', '\u0000'}, {'\u0019', '\u0000'}, {'\u0019', '\u0000'}, {'\u0019', '\u0000'}, {'\u0019', '\u0000'}, {'\u0019', '\u0000'}, {'\u0019', '\u0000'}, {'\u0019', '\u0000'}, {'\u0019', '\u0000'}, {'\u0019', '\u0000'}, {'\u0019', '\u0000'}, {'\u0019', ' '}, {'\u001a', '\u0000'}, {'\u001a', '\u0000'}, {'\u001a', '\u0000'}, {'\u001a', '\u0000'}, {'\u001a', '\u0000'}, {'\u001a', '\u0000'}, {'\u001a', '\u0000'}, {'\u001a', '@'}, {'\u001b', '\u0000'}, {'\u001b', '\u0000'}, {'\u001b', '\u0000'}, {'\u001b', '\u0000'}, {'\u001b', '\u0000'}, {'\u001b', '\u0000'}, {'\u001b', '\u0000'}, {'\u001b', '\u0000'}, {'\u001b', '\u0000'}, {'\u001b', '\u0000'}, {'\u001b', '\u0000'}, {'\u001b', '\u0000'}, {'\u001b', '\u0000'}, {'\u001b', '\u0000'}, {'\u001b', '\u0000'}, {'\u001b', '\u0000'}, {'\u001b', '\u0000'}, {'\u001b', '\u0000'}, {'\u001b', '\u0000'}, {'\u001b', '\u0000'}, {'\u001b', '\u0000'}, {'\u001b', ' '}, {'\u001c', '\u0000'}, {'\u001c', '\u0000'}, {'\u001c', '\u0000'}, {'\u001c', '\u0000'}, {'\u001c', '\u0000'}, {'\u001c', '\u0000'}, {'\u001c', '\u0000'}, {'\u001c', '\u0800'}, {'\u001d', '\u0000'}, {'\u001d', '\u0000'}, {'\u001d', '\u0000'}, {'\u001d', '\u0000'}, {'\u001d', '\u0000'}, {'\u001d', '\u0000'}, {'\u001d', '\u0000'}, {'\u001d', '\u0000'}, {'\u001d', '\u0000'}, {'\u001d', '\u0000'}, {'\u001d', '\u0000'}, {'\u001d', '\u0000'}, {'\u001d', '\u0000'}, {'\u001d', '\u0000'}, {'\u001d', '\u0000'}, {'\u001d', '\u0000'}, {'\u001d', '\u0000'}, {'\u001d', '\u0204'}, {'\u001f', '\u0000'}, {'\u001f', '\u0000'}, {'\u001f', '\u0000'}, {'\u001f', '\u0000'}, {'\u001f', '\u0000'}, {'\u001f', '\u0000'}, {'\u001f', '\u0000'}, {'\u001f', '\u0000'}, {'\u001f', '\u0000'}, {'\u001f', '\u0000'}, {'\u001f', '\u0000'}, {'\u001f', '\u0000'}, {'\u001f', '\u0000'}, {'\u001f', '\u0000'}, {'\u001f', '\u0000'}, {'\u001f', '\u0000'}, {'\u001f', '\u0000'}, {'\u001f', '\u0000'}, {'\u001f', '\u0004'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE61 = new char[][]{{' ', '\u0000'}, {' ', '\u0000'}, {' ', '\u0004'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE65 = new char[][]{{'!', '\u0000'}, {'!', '\u0000'}, {'!', '\u0000'}, {'!', '\u0000'}, {'!', '\u0000'}, {'!', '\u0000'}, {'!', '\u0000'}, {'!', '\u0000'}, {'!', '\u0800'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE67 = new char[][]{{'\"', '\u0000'}, {'\"', '\u0200'}, {'#', '\u0000'}, {'#', '\u0000'}, {'#', '\u0000'}, {'#', '\u0000'}, {'#', '\u0800'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE69 = new char[][]{{'$', '\u0000'}, {'$', '\u0200'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\b'}, {'&', '\u0000'}, {'&', '\b'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE6C = new char[][]{{'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u8000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u4000'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE70 = new char[][]{{')', '\u0000'}, {')', '\u0000'}, {')', '\u0000'}, {')', '\u0000'}, {')', '\u2000'}, {'*', '\u0000'}, {'*', '\u0000'}, {'*', '\u0080'}, {'+', '\u0000'}, {'+', '\u0000'}, {'+', '\u0000'}, {'+', '\u0000'}, {'+', '\u0000'}, {'+', '\u0000'}, {'+', '\u0000'}, {'+', '\u0000'}, {'+', '\u0000'}, {'+', '\u0000'}, {'+', '\u0000'}, {'+', '\u0000'}, {'+', '\u0000'}, {'+', '\u0000'}, {'+', '\u0000'}, {'+', '\u0000'}, {'+', '\u0000'}, {'+', '\u0002'}, {',', '\u0000'}, {',', '\u0000'}, {',', '\u0000'}, {',', '\u0000'}, {',', '\u0000'}, {',', '\u0000'}, {',', '\u0001'}, {'-', '\u0000'}, {'-', '\u0000'}, {'-', '\u0000'}, {'-', '\u0000'}, {'-', '\u0000'}, {'-', '\u0000'}, {'-', '\u0000'}, {'-', '\u0000'}, {'-', '\u0000'}, {'-', '\u0000'}, {'-', '\u0000'}, {'-', '\u0000'}, {'-', '\u0000'}, {'-', '\u0000'}, {'-', '\u0000'}, {'-', '\u0000'}, {'-', '\u0000'}, {'-', '\u0000'}, {'-', '\u0000'}, {'-', '\u0000'}, {'-', '\u0000'}, {'-', '\u0000'}, {'-', '\u0000'}, {'-', '\u1000'}, {'.', '\u0000'}, {'.', '\u0000'}, {'.', '\u0400'}, {'/', '\u0000'}, {'/', '\u0000'}, {'/', '\u0000'}, {'/', '\u0000'}, {'/', '\u0004'}, {'0', '\u0000'}, {'0', '\u0000'}, {'0', '\u0000'}, {'0', '\u0000'}, {'0', '\u0000'}, {'0', '\u0000'}, {'0', '\u0000'}, {'0', '\u0000'}, {'0', '\u0000'}, {'0', '\u0000'}, {'0', '\u0200'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE76 = new char[][]{{'1', '\u0000'}, {'1', '\u0000'}, {'1', '\u0000'}, {'1', '\u0000'}, {'1', '\u0000'}, {'1', '\u0000'}, {'1', '\u0000'}, {'1', '\u0000'}, {'1', '\u0000'}, {'1', '\u0000'}, {'1', '\u0000'}, {'1', '\u0000'}, {'1', '\u0000'}, {'1', '\u0200'}, {'2', '\u0000'}, {'2', '\u0000'}, {'2', '\u0000'}, {'2', '\u0000'}, {'2', '\u0000'}, {'2', '\u0000'}, {'2', '\u0000'}, {'2', '\u0000'}, {'2', '\u0000'}, {'2', '\u0000'}, {'2', '\u0000'}, {'2', '\u0000'}, {'2', '\u0000'}, {'2', '\u0000'}, {'2', '\u0000'}, {'2', '\u2000'}, {'3', '\u0000'}, {'3', '\u0000'}, {'3', '\u0000'}, {'3', '\u0000'}, {'3', '\u0000'}, {'3', '\u0000'}, {'3', '\u0000'}, {'3', '\u0000'}, {'3', '\u0000'}, {'3', '\u0000'}, {'3', '\u0000'}, {'3', '\u0000'}, {'3', '\u0000'}, {'3', '\u0000'}, {'3', '\u0000'}, {'3', '\u0000'}, {'3', '\u0010'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE7A = new char[][]{{'4', '\u0000'}, {'4', '\u0000'}, {'4', '\u0400'}, {'5', '\u0000'}, {'5', '\u0000'}, {'5', '\u0000'}, {'5', '\u0000'}, {'5', '\u0000'}, {'5', '\u0000'}, {'5', '\b'}, {'6', '\u0000'}, {'6', '\u0000'}, {'6', '\u0000'}, {'6', '\u0000'}, {'6', '\u0000'}, {'6', '\u0000'}, {'6', '\u0000'}, {'6', '\u0000'}, {'6', '\u0000'}, {'6', '\u0000'}, {'6', '\u0000'}, {'6', '\u0000'}, {'6', '\u0000'}, {'6', '\u0000'}, {'6', '\u0000'}, {'6', '\u0000'}, {'6', '\u0000'}, {'6', '\u0000'}, {'6', '\u0000'}, {'6', '\u0000'}, {'6', '\u1000'}, {'7', '\u0000'}, {'7', '\u0000'}, {'7', '\u0000'}, {'7', '\u0000'}, {'7', '\u0000'}, {'7', '\u0000'}, {'7', '\u0000'}, {'7', '\u0000'}, {'7', '\u0000'}, {'7', '\u0000'}, {'7', '\u0000'}, {'7', '\u0000'}, {'7', '\u0000'}, {'7', '\b'}, {'8', '\u0000'}, {'8', '\u0000'}, {'8', '\u0000'}, {'8', '\u0000'}, {'8', '\u0000'}, {'8', '\u0000'}, {'8', '\u0000'}, {'8', '\u0000'}, {'8', '\u0000'}, {'8', '\u0000'}, {'8', '\u0000'}, {'8', '\u0800'}, {'9', '\u0000'}, {'9', '\u0000'}, {'9', '\u0000'}, {'9', '\u0000'}, {'9', '\u0000'}, {'9', '\u0000'}, {'9', '\u0000'}, {'9', '\u0000'}, {'9', '\u0000'}, {'9', '\u0000'}, {'9', '\u0000'}, {'9', '\u0000'}, {'9', '\u0800'}, {':', '\u1000'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE82 = new char[][]{{';', '\u0000'}, {';', '\u0000'}, {';', '\u0000'}, {';', '\u0000'}, {';', '\u0000'}, {';', '\u0000'}, {';', '\u0000'}, {';', '\u0000'}, {';', '\u0000'}, {';', '\u0000'}, {';', '\u0000'}, {';', '\u8000'}, {'<', '\u0000'}, {'<', '\u0000'}, {'<', '\u0000'}, {'<', '\u0100'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE85 = new char[][]{{'=', '\u0000'}, {'=', '\u0000'}, {'=', '\u0000'}, {'=', '\u0000'}, {'=', '\u0000'}, {'=', '\u8000'}, {'>', '\u0000'}, {'>', '\u0000'}, {'>', '\u0000'}, {'>', '\u0080'}, {'?', '\u0000'}, {'?', '\u0000'}, {'?', '\u0000'}, {'?', '@'}, {'@', '\u0000'}, {'@', '\u0000'}, {'@', '\u8000'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE88 = new char[][]{{'A', '\u0000'}, {'A', '\u0000'}, {'A', '\u0000'}, {'A', '\u0000'}, {'A', '\u0000'}, {'A', '\u0000'}, {'A', '\u0000'}, {'A', '\u0000'}, {'A', '\u8000'}, {'B', '\u0001'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE8B = new char[][]{{'C', '\u0000'}, {'C', '\u0000'}, {'C', '\u0000'}, {'C', '\u0000'}, {'C', '\u0000'}, {'C', '\u0000'}, {'C', '\u0000'}, {'C', '\u0000'}, {'C', '\b'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE8E = new char[][]{{'D', '\u0000'}, {'D', '\u0000'}, {'D', '\u0000'}, {'D', '\u0000'}, {'D', '\u0000'}, {'D', '\u0000'}, {'D', '\u0000'}, {'D', '\u0000'}, {'D', '\u0000'}, {'D', '\u0000'}, {'D', '\u0000'}, {'D', '\u0200'}, {'E', '\u0000'}, {'E', '\u0000'}, {'E', '\u0000'}, {'E', '\u0000'}, {'E', '\u0000'}, {'E', '\u0000'}, {'E', '\u0000'}, {'E', '\u0000'}, {'E', '\u0000'}, {'E', '\u0000'}, {'E', '\u0000'}, {'E', '\u0000'}, {'E', '\u0000'}, {'E', '\u0000'}, {'E', '\u0080'}, {'F', '\u0000'}, {'F', '\u8000'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE91 = new char[][]{{'G', '\u0000'}, {'G', '\u0000'}, {'G', '\u0000'}, {'G', '\u0000'}, {'G', '\u0000'}, {'G', '\u0000'}, {'G', '\u0000'}, {'G', '\u0000'}, {'G', '\u0000'}, {'G', '\u0000'}, {'G', '\u0000'}, {'G', '\u0000'}, {'G', '\u0000'}, {'G', '\u0000'}, {'G', '\u0000'}, {'G', '@'}, {'H', '\u0000'}, {'H', '\u0000'}, {'H', '\u0002'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0010'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE97 = new char[][]{{'J', '\u0000'}, {'J', '\u0000'}, {'J', '\u0000'}, {'J', '\u0000'}, {'J', '\u0000'}, {'J', ' '}, {'K', '\u0000'}, {'K', '\u0000'}, {'K', '\u0000'}, {'K', '\u0000'}, {'K', '\u0000'}, {'K', '\u0000'}, {'K', '\u0000'}, {'K', '\u0000'}, {'K', '\u0000'}, {'K', '\u0000'}, {'K', '\u0000'}, {'K', '\u0000'}, {'K', '\u0000'}, {'K', '\u0000'}, {'K', '\u0000'}, {'K', '\u0000'}, {'K', '\u0100'}, {'L', '\u0000'}, {'L', '\u0000'}, {'L', '\u0000'}, {'L', '\u0000'}, {'L', '\u0000'}, {'L', '\u0000'}, {'L', '\u0000'}, {'L', '\u0000'}, {'L', '\u0000'}, {'L', '\u0000'}, {'L', '\u0000'}, {'L', '\u0000'}, {'L', '\u0000'}, {'L', '\u0000'}, {'L', '\u0000'}, {'L', '\u0000'}, {'L', '\u0000'}, {'L', '\u0000'}, {'L', '\u0000'}, {'L', '\u0000'}, {'L', '\u0000'}, {'L', '\u0000'}, {'L', '\u0000'}, {'L', '\u0001'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE9F = new char[][]{{'M', '\u0000'}, {'M', '\u0000'}, {'M', '\u0000'}, {'M', '\u0000'}, {'M', '\u0000'}, {'M', '\u0000'}, {'M', '\u0000'}, {'M', '\u0000'}, {'M', '\u0000'}, {'M', '\u0000'}, {'M', '\uffc0'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE214 = new char[][]{{'W', '\u0000'}, {'W', '\u0000'}, {'W', '\u0000'}, {'W', '\u8000'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE219 = new char[][]{{'X', '\u0000'}, {'X', '\u0000'}, {'X', '\u0000'}, {'X', '\u0000'}, {'X', '\u0000'}, {'X', '\u0000'}, {'X', '\u0000'}, {'X', '\u0000'}, {'X', '\u0001'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE21D = new char[][]{{'Y', '\u0000'}, {'Y', '\u0000'}, {'Y', '\u0000'}, {'Y', '\u0000'}, {'Y', '\u0000'}, {'Y', '\u0000'}, {'Y', '\u0000'}, {'Y', '\u0000'}, {'Y', '\u0000'}, {'Y', '\u0000'}, {'Y', '\u0000'}, {'Y', '@'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE220 = new char[][]{{'Z', '\u0000'}, {'Z', '\u0000'}, {'Z', '\u0000'}, {'Z', '\u0000'}, {'Z', '\u0000'}, {'Z', '\u0000'}, {'Z', '\u0000'}, {'Z', '\u4000'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE227 = new char[][]{{'[', '\u0000'}, {'[', '\u0004'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE232 = new char[][]{{'\\', '\u0000'}, {'\\', '\u0000'}, {'\\', '\u0000'}, {'\\', '\u0000'}, {'\\', '\u0000'}, {'\\', '\u0000'}, {'\\', '\u0000'}, {'\\', '\u0000'}, {'\\', '\u0002'}, {']', '\u0000'}, {']', '\u0000'}, {']', '\u0000'}, {']', '\u0000'}, {']', '\u0000'}, {']', '\u0000'}, {']', '\u0000'}, {']', '\u0000'}, {']', '\u0000'}, {']', '\u0000'}, {']', '\u0000'}, {']', '\u0000'}, {']', '\u0000'}, {']', '\u0000'}, {']', '\u0000'}, {']', '\u0000'}, {']', '\u0000'}, {']', '\u0000'}, {']', '\u0000'}, {']', '\u0000'}, {']', '\u0000'}, {']', '\u0000'}, {']', '\u0200'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE23C = new char[][]{{'^', '\u0000'}, {'^', '\u0000'}, {'^', '\u0000'}, {'^', '\u0000'}, {'^', '\u0000'}, {'^', '\u0000'}, {'^', '\b'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE241 = new char[][]{{'_', '\u0000'}, {'_', '\u0000'}, {'_', '\u0000'}, {'_', '\u0000'}, {'_', '\u4000'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE245 = new char[][]{{'`', ' '}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE249 = new char[][]{{'a', '\u0000'}, {'a', '\u0000'}, {'a', '\u0000'}, {'a', '\u0000'}, {'a', '\u0000'}, {'a', '\u0000'}, {'a', '\u0000'}, {'a', '\u0800'}, {'b', '\u0000'}, {'b', '\u0000'}, {'b', '\u0000'}, {'b', '\u0000'}, {'b', '\u0000'}, {'b', '\u0000'}, {'b', '\u0000'}, {'b', '\u0000'}, {'b', '\u0000'}, {'b', '\b'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE251 = new char[][]{{'c', '\u0000'}, {'c', '\u0000'}, {'c', '\u0000'}, {'c', '\u0000'}, {'c', '\u0000'}, {'c', '\u0000'}, {'c', '\u0000'}, {'c', '\u0000'}, {'c', '\u0000'}, {'c', '\u0000'}, {'c', '\u0000'}, {'c', '\u0000'}, {'c', '\u2000'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE256 = new char[][]{{'d', '\u0000'}, {'d', '\u0000'}, {'d', '\u0000'}, {'d', '\u0000'}, {'d', '\u0000'}, {'d', '\u0000'}, {'d', '\u0000'}, {'d', '\u0000'}, {'d', '\u0000'}, {'d', ' '}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE25C = new char[][]{{'e', '\u0000'}, {'e', '\u0000'}, {'e', '\u0000'}, {'e', '\u0000'}, {'e', '\u0000'}, {'e', '\u0000'}, {'e', '\u0000'}, {'e', '\u0000'}, {'e', '\u0000'}, {'e', '\u0000'}, {'e', '\u0010'}, {'f', '\u0000'}, {'f', '\u0000'}, {'f', '\u0000'}, {'f', '\u0000'}, {'f', '\u0000'}, {'f', '\u0000'}, {'f', '\u0000'}, {'f', '\u0000'}, {'f', '\u0001'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE26B = new char[][]{{'g', '\u0000'}, {'g', ' '}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE26D = new char[][]{{'h', '\u0000'}, {'h', '\u0000'}, {'h', '\u0000'}, {'h', '\u0000'}, {'h', '\u0000'}, {'h', '\u0000'}, {'h', '\u0000'}, {'h', '\u0010'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE26F = new char[][]{{'i', '\u0000'}, {'i', '\u0000'}, {'i', '\u0000'}, {'i', '\u0000'}, {'i', '\u0000'}, {'i', '\u0000'}, {'i', '\u0000'}, {'i', '\u0000'}, {'i', '\u0000'}, {'i', '\u0000'}, {'i', '\u0000'}, {'i', '\u4000'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE271 = new char[][]{{'j', '\u2000'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE287 = new char[][]{{'k', '\u8000'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE289 = new char[][]{{'l', '\u0000'}, {'l', '\u0000'}, {'l', '\u0000'}, {'l', '\u0000'}, {'l', '\u0000'}, {'l', '\u0000'}, {'l', '\u0000'}, {'l', '\u0000'}, {'l', '\u0000'}, {'l', '\u0000'}, {'l', '\u0000'}, {'l', '\u0000'}, {'l', '\u0000'}, {'l', '\u0000'}, {'l', '\b'}, {'m', '\u0000'}, {'m', '\u0000'}, {'m', '\u0000'}, {'m', '\u0000'}, {'m', '\u0004'}, {'n', '\u0000'}, {'n', '\u0000'}, {'n', '\u0000'}, {'n', '\u0000'}, {'n', '\u0000'}, {'n', '\u0000'}, {'n', '\u0000'}, {'n', '\u0000'}, {'n', '\u0000'}, {'n', '\u0000'}, {'n', '\u0400'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE28D = new char[][]{{'o', '\u0000'}, {'o', '\u0000'}, {'o', '\u0000'}, {'o', '\u0000'}, {'o', '\u0000'}, {'o', '\u0000'}, {'o', '\u0000'}, {'o', '\u0000'}, {'o', '\u0000'}, {'o', '\u0000'}, {'o', '\u0000'}, {'o', '\u0200'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE299 = new char[][]{{'p', '\u0000'}, {'p', '\u0000'}, {'p', '\u0000'}, {'p', '\u0000'}, {'p', '\u0080'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE29C = new char[][]{{'q', '\u0000'}, {'q', '\u0000'}, {'q', '\u0000'}, {'q', '\u0000'}, {'q', '\u0000'}, {'q', '\u0000'}, {'q', '\u0000'}, {'q', '\b'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE2A1 = new char[][]{{'r', '\u0080'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0400'}};
    protected boolean subMode = true;
    protected byte[] subBytes = new byte[]{63};

    public int getMaxBytesPerChar() {
        return 2;
    }

    public int convert(int wc, byte[] dest, int destOffset) {
        int i;
        int used;
        char[] summary = null;
        if (wc < 40704) {
            if (wc < 26880) {
                if (wc >= 13568 && wc < 13664) {
                    summary = HKSCS2001_TO_UNICODE_PAGE35[(wc >> 4) - 848];
                } else if (wc >= 15360 && wc < 16096) {
                    summary = HKSCS2001_TO_UNICODE_PAGE3C[(wc >> 4) - 960];
                } else if (wc >= 16384 && wc < 16512) {
                    summary = HKSCS2001_TO_UNICODE_PAGE40[(wc >> 4) - 1024];
                } else if (wc >= 16896 && wc < 17072) {
                    summary = HKSCS2001_TO_UNICODE_PAGE42[(wc >> 4) - 1056];
                } else if (wc >= 19200 && wc < 19600) {
                    summary = HKSCS2001_TO_UNICODE_PAGE4B[(wc >> 4) - 1200];
                } else if (wc >= 19968 && wc < 20912) {
                    summary = HKSCS2001_TO_UNICODE_PAGE4E[(wc >> 4) - 1248];
                } else if (wc >= 21248 && wc < 21568) {
                    summary = HKSCS2001_TO_UNICODE_PAGE53[(wc >> 4) - 1328];
                } else if (wc >= 22272 && wc < 22752) {
                    summary = HKSCS2001_TO_UNICODE_PAGE57[(wc >> 4) - 1392];
                } else if (wc >= 23040 && wc < 24528) {
                    summary = HKSCS2001_TO_UNICODE_PAGE5A[(wc >> 4) - 1440];
                } else if (wc >= 24832 && wc < 24880) {
                    summary = HKSCS2001_TO_UNICODE_PAGE61[(wc >> 4) - 1552];
                } else if (wc >= 25856 && wc < 26000) {
                    summary = HKSCS2001_TO_UNICODE_PAGE65[(wc >> 4) - 1616];
                } else if (wc >= 26368 && wc < 26480) {
                    summary = HKSCS2001_TO_UNICODE_PAGE67[(wc >> 4) - 1648];
                }
            } else if (wc >= 26880 && wc < 27248) {
                summary = HKSCS2001_TO_UNICODE_PAGE69[(wc >> 4) - 1680];
            } else if (wc >= 27648 && wc < 28160) {
                summary = HKSCS2001_TO_UNICODE_PAGE6C[(wc >> 4) - 1728];
            } else if (wc >= 28672 && wc < 29888) {
                summary = HKSCS2001_TO_UNICODE_PAGE70[(wc >> 4) - 1792];
            } else if (wc >= 30208 && wc < 30960) {
                summary = HKSCS2001_TO_UNICODE_PAGE76[(wc >> 4) - 1888];
            } else if (wc >= 31232 && wc < 32368) {
                summary = HKSCS2001_TO_UNICODE_PAGE7A[(wc >> 4) - 1952];
            } else if (wc >= 33280 && wc < 33536) {
                summary = HKSCS2001_TO_UNICODE_PAGE82[(wc >> 4) - 2080];
            } else if (wc >= 34048 && wc < 34320) {
                summary = HKSCS2001_TO_UNICODE_PAGE85[(wc >> 4) - 2128];
            } else if (wc >= 34816 && wc < 34976) {
                summary = HKSCS2001_TO_UNICODE_PAGE88[(wc >> 4) - 2176];
            } else if (wc >= 35584 && wc < 35728) {
                summary = HKSCS2001_TO_UNICODE_PAGE8B[(wc >> 4) - 2224];
            } else if (wc >= 36352 && wc < 36816) {
                summary = HKSCS2001_TO_UNICODE_PAGE8E[(wc >> 4) - 2272];
            } else if (wc >= 37120 && wc < 37888) {
                summary = HKSCS2001_TO_UNICODE_PAGE91[(wc >> 4) - 2320];
            } else if (wc >= 38656 && wc < 39408) {
                summary = HKSCS2001_TO_UNICODE_PAGE97[(wc >> 4) - 2416];
            }
        } else if (wc < 153088) {
            if (wc >= 40704 && wc < 40880) {
                summary = HKSCS2001_TO_UNICODE_PAGE9F[(wc >> 4) - 2544];
            } else if (wc >= 136192 && wc < 136256) {
                summary = HKSCS2001_TO_UNICODE_PAGE214[(wc >> 4) - 8512];
            } else if (wc >= 137472 && wc < 137616) {
                summary = HKSCS2001_TO_UNICODE_PAGE219[(wc >> 4) - 8592];
            } else if (wc >= 138496 && wc < 138688) {
                summary = HKSCS2001_TO_UNICODE_PAGE21D[(wc >> 4) - 8656];
            } else if (wc >= 139264 && wc < 139392) {
                summary = HKSCS2001_TO_UNICODE_PAGE220[(wc >> 4) - 8704];
            } else if (wc >= 141056 && wc < 141088) {
                summary = HKSCS2001_TO_UNICODE_PAGE227[(wc >> 4) - 8816];
            } else if (wc >= 143872 && wc < 144384) {
                summary = HKSCS2001_TO_UNICODE_PAGE232[(wc >> 4) - 8992];
            } else if (wc >= 146432 && wc < 146544) {
                summary = HKSCS2001_TO_UNICODE_PAGE23C[(wc >> 4) - 9152];
            } else if (wc >= 147712 && wc < 147792) {
                summary = HKSCS2001_TO_UNICODE_PAGE241[(wc >> 4) - 9232];
            } else if (wc >= 148736 && wc < 148752) {
                summary = HKSCS2001_TO_UNICODE_PAGE245[(wc >> 4) - 9296];
            } else if (wc >= 149760 && wc < 150048) {
                summary = HKSCS2001_TO_UNICODE_PAGE249[(wc >> 4) - 9360];
            } else if (wc >= 151808 && wc < 152016) {
                summary = HKSCS2001_TO_UNICODE_PAGE251[(wc >> 4) - 9488];
            }
        } else if (wc >= 153088 && wc < 153248) {
            summary = HKSCS2001_TO_UNICODE_PAGE256[(wc >> 4) - 9568];
        } else if (wc >= 154624 && wc < 154944) {
            summary = HKSCS2001_TO_UNICODE_PAGE25C[(wc >> 4) - 9664];
        } else if (wc >= 158464 && wc < 158496) {
            summary = HKSCS2001_TO_UNICODE_PAGE26B[(wc >> 4) - 9904];
        } else if (wc >= 158976 && wc < 159104) {
            summary = HKSCS2001_TO_UNICODE_PAGE26D[(wc >> 4) - 9936];
        } else if (wc >= 159488 && wc < 159680) {
            summary = HKSCS2001_TO_UNICODE_PAGE26F[(wc >> 4) - 9968];
        } else if (wc >= 160000 && wc < 160016) {
            summary = HKSCS2001_TO_UNICODE_PAGE271[(wc >> 4) - 10000];
        } else if (wc >= 165632 && wc < 165648) {
            summary = HKSCS2001_TO_UNICODE_PAGE287[(wc >> 4) - 10352];
        } else if (wc >= 166144 && wc < 166640) {
            summary = HKSCS2001_TO_UNICODE_PAGE289[(wc >> 4) - 10384];
        } else if (wc >= 167168 && wc < 167360) {
            summary = HKSCS2001_TO_UNICODE_PAGE28D[(wc >> 4) - 10448];
        } else if (wc >= 170240 && wc < 170320) {
            summary = HKSCS2001_TO_UNICODE_PAGE299[(wc >> 4) - 10640];
        } else if (wc >= 171008 && wc < 171136) {
            summary = HKSCS2001_TO_UNICODE_PAGE29C[(wc >> 4) - 10688];
        } else if (wc >= 172288 && wc < 172736) {
            summary = HKSCS2001_TO_UNICODE_PAGE2A1[(wc >> 4) - 10768];
        }
        if (summary != null && ((used = summary[1]) & 1 << (i = wc & 0xF)) != 0) {
            used &= (1 << i) - 1;
            used = (used & 0x5555) + ((used & 0xAAAA) >> 1);
            used = (used & 0x3333) + ((used & 0xCCCC) >> 2);
            used = (used & 0xF0F) + ((used & 0xF0F0) >> 4);
            used = (used & 0xFF) + (used >> 8);
            char c = HKSCS2001_TO_CHARSET[summary[0] + used];
            dest[destOffset] = (byte)(c >> 8);
            dest[destOffset + 1] = (byte)(c & 0xFF);
            return 0;
        }
        return -1;
    }
}

