/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import com.tmax.tibero.jdbc.data.charset.EUCJPCharToByteConverter;
import com.tmax.tibero.jdbc.data.charset.JIS0201CharToByteConverter;
import com.tmax.tibero.jdbc.data.charset.JIS0208CharToByteConverter;
import com.tmax.tibero.jdbc.data.charset.JIS0212CharToByteConverter;
import com.tmax.tibero.jdbc.data.charset.JIS0213ByteToCharConverter;
import com.tmax.tibero.jdbc.data.charset.JIS0213CharToByteConverter;
import com.tmax.tibero.jdbc.err.TbError;
import java.sql.SQLException;

public class EUCJPTILDECharToByteConverter
extends JIS0208CharToByteConverter {
    private JIS0201CharToByteConverter JIS0201cb = new JIS0201CharToByteConverter();
    private JIS0212CharToByteConverter JIS0212cb = new JIS0212CharToByteConverter();
    short[] JIS0208Index1 = super.getIndex1();
    String[] JIS0208Index2 = super.getIndex2();
    final int MAX_BYTE_SIZE = 3;
    static final int[][] EUC_JISX0213__COMP_TABLE_DATA = EUCJPCharToByteConverter.EUC_JISX0213__COMP_TABLE_DATA;
    static final int[] EUC_JISX0213__COMBINED_UNICODE_TABLE = EUCJPCharToByteConverter.EUC_JISX0213__COMBINED_UNICODE_TABLE;

    @Override
    public boolean canConvert(char srcChar) throws SQLException {
        byte[] encodedBytes = new byte[3];
        return this.convSingleByte(srcChar, encodedBytes) != 0 || this.convDoubleByte(srcChar) != 0;
    }

    @Override
    protected int convDoubleByte(char ch) throws SQLException {
        if (ch == '\u301c' || ch == '\uff5e') {
            int upper = 161;
            int low = 193;
            return upper << 8 | low;
        }
        if (ch == '\u2015') {
            ch = (char)8212;
        }
        try {
            int offset = this.JIS0208Index1[(ch & 0xFF00) >> 8] << 8;
            int r = this.JIS0208Index2[offset >> 12].charAt((offset & 0xFFF) + (ch & 0xFF));
            if (r != 0) {
                return r + 32896;
            }
            r = this.JIS0212cb.convDoubleByte(ch);
            if (r == 0) {
                return r;
            }
            return r + 0x8F8080;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw TbError.newSQLException(-590743, e.getMessage());
        }
    }

    @Override
    public int getMaxBytesPerChar() {
        return 3;
    }

    @Override
    protected int convSingleByte(char srcChar, byte[] destBytes) {
        if (srcChar == '\u0000') {
            destBytes[0] = 0;
            return 1;
        }
        byte b = this.JIS0201cb.getNative(srcChar);
        if (b == 0) {
            return 0;
        }
        if (b > 0 && b < 128) {
            destBytes[0] = b;
            return 1;
        }
        destBytes[0] = -114;
        destBytes[1] = b;
        return 2;
    }

    @Override
    public int convCharArr(char[] ac, int i, int j, byte[] outputBuf, int k, int l) throws SQLException {
        int charOff = 0;
        int byteOff = 0;
        byte[] tmpBuf = new byte[3];
        byteOff = k;
        int prevUcsInt = 0;
        int ucsInt = 0;
        int prevOutputSize = 0;
        int[] cjkBData = JIS0213CharToByteConverter.JISX0213__CJK_EXT_B_DATA;
        for (charOff = i; charOff < j; ++charOff) {
            char targetChar = ac[charOff];
            int outputSize = this.convSingleByte(targetChar, tmpBuf);
            prevUcsInt = ucsInt;
            ucsInt = this.parse(targetChar, ac, charOff, j);
            if ((ucsInt & 0xFFFF0000) >> 16 == 2) {
                for (int cIdx = 0; cIdx < cjkBData.length; ++cIdx) {
                    if (cjkBData[cIdx] != ucsInt) continue;
                    int val = EUCJPCharToByteConverter.EUC_JISX0213__CJK_EXT_B_TABLE[cIdx];
                    if (val > 65535) {
                        tmpBuf[0] = (byte)((val & 0xFF0000) >> 16);
                        tmpBuf[1] = (byte)((val & 0xFF00) >> 8);
                        tmpBuf[2] = (byte)(val & 0xFF);
                        outputSize = 3;
                    } else {
                        tmpBuf[0] = (byte)((val & 0xFF00) >> 8);
                        tmpBuf[1] = (byte)(val & 0xFF);
                        outputSize = 2;
                    }
                    ++charOff;
                }
            }
            if (outputSize == 0) {
                int nativeCode = this.convDoubleByte(targetChar);
                if (nativeCode != 0) {
                    if (nativeCode == 9415105 && j - charOff > 1 && ac[charOff + 1] == '\u0300') {
                        tmpBuf[0] = -85;
                        tmpBuf[1] = -60;
                        outputSize = 2;
                        ++charOff;
                    } else if ((nativeCode & 0xFF0000) == 0) {
                        tmpBuf[0] = (byte)((nativeCode & 0xFF00) >> 8);
                        tmpBuf[1] = (byte)(nativeCode & 0xFF);
                        outputSize = 2;
                    } else {
                        tmpBuf[0] = -113;
                        tmpBuf[1] = (byte)((nativeCode & 0xFF00) >> 8);
                        tmpBuf[2] = (byte)(nativeCode & 0xFF);
                        outputSize = 3;
                    }
                } else {
                    if (prevUcsInt > 0) {
                        int retCode = 0;
                        int combUcs = prevUcsInt << 16 | ucsInt;
                        int[][] comb = JIS0213ByteToCharConverter.JISX0213_TO_UCS__COMBINING;
                        for (int combTblIdx = 0; combTblIdx < comb.length; ++combTblIdx) {
                            if (combUcs != (comb[combTblIdx][0] << 16 | comb[combTblIdx][1])) continue;
                            retCode = EUC_JISX0213__COMBINED_UNICODE_TABLE[combTblIdx];
                            break;
                        }
                        if (retCode > 0) {
                            outputBuf[byteOff - prevOutputSize] = (byte)(retCode >> 8 & 0xFF | 0x80);
                            outputBuf[byteOff - prevOutputSize + 1] = (byte)(retCode & 0xFF | 0x80);
                            byteOff -= prevOutputSize - 2;
                            continue;
                        }
                    }
                    if ((nativeCode = JIS0213CharToByteConverter.convFromUCS4(ucsInt)) != 0) {
                        int len;
                        int idx;
                        if (nativeCode == 741) {
                            idx = 1;
                            len = 0;
                        } else if (nativeCode == 745) {
                            idx = 1;
                            len = 1;
                        } else if (nativeCode == 768) {
                            idx = 2;
                            len = 5;
                        } else if (nativeCode == 769) {
                            idx = 7;
                            len = 4;
                        } else if (nativeCode == 12442) {
                            idx = 11;
                            len = 14;
                        } else {
                            idx = 0;
                            len = -1;
                        }
                        int jch = nativeCode | 0x8080;
                        while (len > 0 && EUC_JISX0213__COMP_TABLE_DATA[idx][0] != jch) {
                            ++idx;
                            --len;
                        }
                        if (len > 0) {
                            jch = EUC_JISX0213__COMP_TABLE_DATA[idx][1];
                            tmpBuf[0] = (byte)(jch >> 8 & 0xFF);
                            tmpBuf[1] = (byte)(jch & 0xFF);
                            outputSize += 2;
                        } else if ((nativeCode & 0x8000) != 0) {
                            tmpBuf[0] = -113;
                            tmpBuf[1] = (byte)(nativeCode >> 8 & 0xFF | 0x80);
                            tmpBuf[2] = (byte)(nativeCode & 0xFF | 0x80);
                            outputSize = 3;
                        } else {
                            tmpBuf[0] = (byte)(nativeCode >> 8 & 0xFF | 0x80);
                            tmpBuf[1] = (byte)(nativeCode & 0xFF | 0x80);
                            outputSize = 2;
                        }
                    } else {
                        throw TbError.newSQLException(-590714, "unknown character");
                    }
                }
            }
            prevOutputSize = outputSize;
            if (l - byteOff < outputSize) {
                throw TbError.newSQLException(-590714, "Conversion buffer overflow");
            }
            for (int idx2 = 0; idx2 < outputSize; ++idx2) {
                outputBuf[byteOff++] = tmpBuf[idx2];
            }
        }
        return byteOff - k;
    }
}

