/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import com.tmax.tibero.jdbc.err.TbError;
import java.sql.SQLException;

public class CharToByteDoubleByte {
    protected static final char MIN_HIGH = '\ud800';
    protected static final char MAX_HIGH = '\udbff';
    protected static final char MIN_LOW = '\udc00';
    protected static final char MAX_LOW = '\udfff';
    protected static final char MIN = '\ud800';
    protected static final char MAX = '\udfff';
    protected boolean subMode = true;
    protected byte[] subBytes = new byte[]{63};
    protected short[] index1;
    protected String[] index2;
    protected final int MAX_BYTE_SIZE = 2;

    public boolean canConvert(char c) throws SQLException {
        byte[] abyte0 = new byte[2];
        if (c == '\u0000' || this.convSingleByte(c, abyte0) != 0) {
            return true;
        }
        return this.convDoubleByte(c) != 0;
    }

    private void checkOverflow(int currrentOffset, int increase, int totalLength) throws SQLException {
        if (currrentOffset + increase > totalLength) {
            throw TbError.newSQLException(-590744, currrentOffset + " + " + increase + " > " + totalLength);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public int convCharArr(char[] srcCharArr, int srcStart, int srcLen, byte[] destByteArr, int destStart, int destLen) throws SQLException {
        int charOff = 0;
        int byteOff = 0;
        char highHalfZoneCode = '\u0000';
        byte[] outputBytes = new byte[2];
        charOff = srcStart;
        byteOff = destStart;
        if (highHalfZoneCode != '\u0000') {
            highHalfZoneCode = '\u0000';
            if (!this.subMode) {
                if (srcCharArr[srcStart] < '\udc00') throw TbError.newSQLException(-590743, (int)srcCharArr[srcStart]);
                if (srcCharArr[srcStart] > '\udfff') throw TbError.newSQLException(-590743, (int)srcCharArr[srcStart]);
                throw TbError.newSQLException(-590742, (int)srcCharArr[srcStart]);
            }
            int i1 = this.subBytes.length;
            this.checkOverflow(byteOff, i1, destLen);
            for (int k1 = 0; k1 < this.subBytes.length; ++k1) {
                destByteArr[byteOff++] = this.subBytes[k1];
            }
            ++charOff;
        }
        while (charOff < srcLen) {
            int j1;
            int byte1 = 1;
            byte[] tmpBuf = outputBytes;
            char c1 = srcCharArr[charOff];
            if (c1 >= '\ud800' && c1 <= '\udbff') {
                if (charOff + 1 >= srcLen) {
                    highHalfZoneCode = c1;
                    return byteOff - destStart;
                }
                c1 = srcCharArr[charOff + 1];
                if (!this.subMode) {
                    if (c1 < '\udc00') throw TbError.newSQLException(-590743, (int)c1);
                    if (c1 > '\udfff') throw TbError.newSQLException(-590743, (int)c1);
                    throw TbError.newSQLException(-590742, (int)c1);
                }
                tmpBuf = this.subBytes;
                j1 = this.subBytes.length;
                byte1 = 2;
            } else if (c1 >= '\udc00' && c1 <= '\udfff') {
                if (!this.subMode) throw TbError.newSQLException(-590743, (int)c1);
                tmpBuf = this.subBytes;
                j1 = this.subBytes.length;
            } else {
                j1 = this.convSingleByte(c1, tmpBuf);
                if (j1 == 0) {
                    int l1 = this.convDoubleByte(c1);
                    if (l1 != 0) {
                        tmpBuf[0] = (byte)((l1 & 0xFF00) >> 8);
                        tmpBuf[1] = (byte)(l1 & 0xFF);
                        j1 = 2;
                    } else {
                        if (!this.subMode) throw TbError.newSQLException(-590742, (int)c1);
                        tmpBuf = this.subBytes;
                        j1 = this.subBytes.length;
                    }
                }
            }
            this.checkOverflow(byteOff, j1, destLen);
            for (int i2 = 0; i2 < j1; ++i2) {
                destByteArr[byteOff++] = tmpBuf[i2];
            }
            charOff += byte1;
        }
        return byteOff - destStart;
    }

    protected int convSingleByte(char c, byte[] abyte0) {
        if (c < '\u0080') {
            abyte0[0] = (byte)(c & 0x7F);
            return 1;
        }
        return 0;
    }

    protected int convSingleByte(char c) {
        return c < '\u0080' ? 1 : 0;
    }

    public int convString(String srcStr, int srcCharOffset, int srcCharEndOffset, byte[] destByteBuf, int destByteOffset, int destBufSize) throws SQLException {
        return this.convCharArr(srcStr.toCharArray(), srcCharOffset, srcCharEndOffset, destByteBuf, destByteOffset, destBufSize);
    }

    public short[] getIndex1() {
        return this.index1;
    }

    public String[] getIndex2() {
        return this.index2;
    }

    public int getMaxBytesPerChar() {
        return 2;
    }

    protected int convDoubleByte(char c) throws SQLException {
        try {
            int i = this.index1[(c & 0xFF00) >> 8] << 8;
            return this.index2[i >> 12].charAt((i & 0xFFF) + (c & 0xFF));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw TbError.newSQLException(-590743, e.getMessage());
        }
    }

    protected int parse(char c, char[] inputArray, int offset, int length) throws SQLException {
        if (this.isHigh(c)) {
            if (length - offset < 2) {
                throw TbError.newSQLException(-590714, "Malformed input");
            }
            char nextChar = inputArray[offset + 1];
            if (this.isLow(nextChar)) {
                return this.toUCS4(c, nextChar);
            }
            throw TbError.newSQLException(-590714, "Malformed input");
        }
        if (this.isLow(c)) {
            throw TbError.newSQLException(-590714, "Malformed input");
        }
        return c;
    }

    private boolean isHigh(int c) {
        return 55296 <= c && c <= 56319;
    }

    private boolean isLow(int c) {
        return 56320 <= c && c <= 57343;
    }

    public int toUCS4(char c, char d) {
        return ((c & 0x3FF) << 10 | d & 0x3FF) + 65536;
    }
}

