/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

public class ServerInfo {
    public static final int LITTLE_ENDIAN = 0;
    public static final int BIG_ENDIAN = 1;
    public static final int NANOBASE_SVR = 1;
    private int protocolMajorVersion = -1;
    private int protocolMinorVersion = -1;
    private int serverCharset = -1;
    private int serverNCharset = -1;
    private int serverEndian = -1;
    private int tbMajorVersion = -1;
    private int tbMinorVersion = -1;
    private String tbProductName;
    private String tbProductVersion;
    private int serverIsNanobase = -1;
    private boolean objBindAvailable = false;

    public ServerInfo(int charset, int endian) {
        this.serverCharset = charset;
        this.serverEndian = endian;
    }

    public ServerInfo(int charset, int ncharset, int endian, int isNanobase, int tbMajor, int tbMinor, String productName, String productVersion, int protocolMajor, int protocolMinor) {
        this.serverCharset = charset;
        this.serverNCharset = ncharset;
        this.serverEndian = endian;
        this.serverIsNanobase = isNanobase;
        this.tbMajorVersion = tbMajor;
        this.tbMinorVersion = tbMinor;
        this.tbProductName = productName;
        this.tbProductVersion = productVersion;
        this.protocolMajorVersion = protocolMajor;
        this.protocolMinorVersion = protocolMinor;
        this.objBindAvailable = this.protocolMajorVersion >= 2 && this.protocolMinorVersion >= 15;
    }

    public boolean getObjBindAvailable() {
        return this.objBindAvailable;
    }

    public int getProtocolMajorVersion() {
        return this.protocolMajorVersion;
    }

    public int getProtocolMinorVersion() {
        return this.protocolMinorVersion;
    }

    public int getServerCharSet() {
        return this.serverCharset;
    }

    public int getServerEndian() {
        return this.serverEndian;
    }

    public int getServerIsNanobase() {
        return this.serverIsNanobase;
    }

    public int getServerNCharSet() {
        return this.serverNCharset;
    }

    public int getTbMajor() {
        return this.tbMajorVersion;
    }

    public int getTbMinor() {
        return this.tbMinorVersion;
    }

    public String getTbProductName() {
        return this.tbProductName;
    }

    public String getTbProductVersion() {
        return this.tbProductVersion;
    }

    public void setProtocolMajorVersion(int protocolMajorVersion) {
        this.protocolMajorVersion = protocolMajorVersion;
    }

    public void setProtocolMinorVersion(int protocolMinorVersion) {
        this.protocolMinorVersion = protocolMinorVersion;
    }

    public void setServerCharSet(int charset) {
        this.serverCharset = charset;
    }

    public void setServerEndian(int endian) {
        this.serverEndian = endian;
    }

    public void setServerIsNanobase(int isNanobase) {
        this.serverIsNanobase = isNanobase;
    }

    public void setServerNCharSet(int ncharset) {
        this.serverNCharset = ncharset;
    }

    public void setTbMajor(int tbMajor) {
        this.tbMajorVersion = tbMajor;
    }

    public void setTbMinor(int tbMinor) {
        this.tbMinorVersion = tbMinor;
    }

    public void setTbProductName(String name) {
        this.tbProductName = name;
    }

    public void setTbProductVersion(String version) {
        this.tbProductVersion = version;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(192);
        sb.append("ServerInfo[ProductName=").append(this.tbProductName).append("/ProductVersion=").append(this.tbProductVersion).append("/MajorVer=").append(this.tbMajorVersion).append("/MinorVer=").append(this.tbMinorVersion).append("/ProtocolMajor=").append(this.protocolMajorVersion).append("/ProtocolMinor=").append(this.protocolMinorVersion).append("/CharSet=").append(this.serverCharset).append("/NCharSet=").append(this.serverNCharset).append("/isNanobase=").append(this.serverIsNanobase).append("]");
        return sb.toString();
    }
}

